/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.service.impl;

import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionConfNode;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionDevNode;
import com.huawei.ism.tool.scaleout.expansion.entity.report.ExecuteResult;
import com.huawei.ism.tool.scaleout.expansion.entity.report.ExpansionDevice;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ReportParam;
import com.huawei.ism.tool.scaleout.expansion.enumeration.ExpansionNodeConfType;
import com.huawei.ism.tool.scaleout.expansion.report.TreeViewResultBuilder;
import com.huawei.ism.tool.scaleout.expansion.service.IReportService;
import com.huawei.ism.tool.scaleout.expansion.task.ExpansionTask;
import com.huawei.ism.tool.scaleout.expansion.task.ItemTask;
import com.huawei.ism.tool.scaleout.expansion.task.StepTask;
import com.huawei.ism.tool.scaleout.expansion.task.TaskManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ReportServiceImpl
implements IReportService {
    private final DevNodeManager devNodeManager = DevNodeManager.INS;
    private final TaskManager taskManager = TaskManager.INS;

    @Override
    public void export(ReportParam reportParam) {
        ExpansionDevice expansionDevice = this.initResultDevice(reportParam);
        TreeViewResultBuilder treeViewResultBuilder = new TreeViewResultBuilder();
        treeViewResultBuilder.builtReport(expansionDevice, reportParam.getResultDir());
    }

    private ExpansionDevice initResultDevice(ReportParam reportParam) {
        ExpansionDevNode expansionDevNode = this.devNodeManager.findDevNode(reportParam.getDeviceSn());
        ExpansionTask expansionTask = this.taskManager.findTask(reportParam.getTaskId());
        return ExpansionDevice.builder().taskId(reportParam.getTaskId()).devNode(expansionDevNode.getOriDevNode()).executeResults(this.getExecuteResults(reportParam.getTaskId())).newNode(this.getNewNodes(reportParam.getDeviceSn())).zookeeperNode(this.getZookperNodes(reportParam.getDeviceSn())).metaDiskType(this.getMetaDiskType(reportParam.getDeviceSn())).executeTime(StringUtils.millls2FormatString((long)(expansionTask.getEndTime().getTime() - expansionTask.getBeginTime().getTime()))).build();
    }

    private String getMetaDiskType(String deviceSn) {
        return this.devNodeManager.getControlClusterInfo(deviceSn).getNodeInfo().stream().map(nodeInfo -> nodeInfo.getDiskInfo().getDiskType()).findFirst().orElse("");
    }

    private List<ExpansionConfNode> getZookperNodes(String deviceSn) {
        List<ExpansionConfNode> expansionConfNodes = this.devNodeManager.getExpansionConfs(deviceSn);
        return expansionConfNodes.stream().filter(node -> node.getExpansionType() == ExpansionNodeConfType.IN_CONTROL_CLUSTER.getCode()).collect(Collectors.toList());
    }

    private List<ExpansionConfNode> getNewNodes(String deviceSn) {
        List<ExpansionConfNode> expansionConfNodes = this.devNodeManager.getExpansionConfs(deviceSn);
        return expansionConfNodes.stream().filter(node -> node.getExpansionType() == ExpansionNodeConfType.PLAN_EXPANSION.getCode()).collect(Collectors.toList());
    }

    private List<ExecuteResult> getExecuteResults(String taskId) {
        ExpansionTask expansionTask = this.taskManager.findTask(taskId);
        return expansionTask.getChildren().stream().map(step -> (StepTask)step).map(this::buildItem4Step).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ExecuteResult> buildItem4Step(StepTask stepTask) {
        return this.getStepItems(stepTask).stream().filter(itemTask -> !itemTask.isWaited()).map(itemTask -> this.buildExecuteResult(stepTask, (ItemTask)itemTask)).collect(Collectors.toList());
    }

    private ExecuteResult buildExecuteResult(StepTask stepTask, ItemTask itemTask) {
        return ExecuteResult.builder().itemId(itemTask.getConf().getId()).itemName(itemTask.getConf().getName()).description(itemTask.getConf().getDescription()).oriInfo(itemTask.getPyItem().getResult().getOriginInfo()).oriDumpPath(itemTask.getPyItem().getResult().getOriDumpPath()).errorInfo(itemTask.getPyItem().getResult().getErrInfo()).parentItemId(stepTask.getConf().getId()).parentItemName(stepTask.getConf().getName()).status(itemTask.isSuccess() ? 0 : 1).build();
    }

    private List<ItemTask> getStepItems(StepTask stepTask) {
        return stepTask.getChildren().stream().map(item -> (ItemTask)item).map(this::getItems).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private List<ItemTask> getItems(ItemTask itemTask) {
        if (CollectionUtil.isEmpty(itemTask.getChildren())) {
            return Collections.singletonList(itemTask);
        }
        return itemTask.getChildren().stream().map(item -> (ItemTask)item).collect(Collectors.toList());
    }
}

