/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.service.impl;

import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ItemIndexReq;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.ItemVO;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.StepVO;
import com.huawei.ism.tool.scaleout.expansion.entity.vo.TaskVO;
import com.huawei.ism.tool.scaleout.expansion.exception.task.TaskAlreadyExistsException;
import com.huawei.ism.tool.scaleout.expansion.exception.task.TaskNotConfigException;
import com.huawei.ism.tool.scaleout.expansion.service.ITaskService;
import com.huawei.ism.tool.scaleout.expansion.task.AbstractTask;
import com.huawei.ism.tool.scaleout.expansion.task.ExpansionTask;
import com.huawei.ism.tool.scaleout.expansion.task.ItemTask;
import com.huawei.ism.tool.scaleout.expansion.task.StepTask;
import com.huawei.ism.tool.scaleout.expansion.task.TaskFactory;
import com.huawei.ism.tool.scaleout.expansion.task.TaskManager;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements ITaskService {
    private final TaskManager taskManager = TaskManager.INS;
    private final TaskFactory taskFactory = TaskFactory.INS;
    private final DevNodeManager devNodeManager = DevNodeManager.INS;

    @Override
    public TaskVO queryTask(String taskId) {
        return new TaskVO(this.getTaskManager().findTask(taskId));
    }

    @Override
    public List<StepVO> queryTaskSteps(String taskId) {
        return this.getTaskManager().findTask(taskId).getChildren().stream().map(StepTask.class::cast).map(StepVO::new).collect(Collectors.toList());
    }

    @Override
    public List<ItemVO> queryStepItems(String taskId, String stepId) {
        return this.getTaskManager().findTask(taskId).getChildren().stream().map(StepTask.class::cast).filter(step -> Objects.equals(step.getConf().getId(), stepId)).findFirst().map(AbstractTask::getChildren).map(itemTasks -> itemTasks.stream().map(ItemTask.class::cast).map(ItemVO::new).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public String startTask(String deviceSn) {
        if (this.getTaskManager().hasRunningTask()) {
            throw new TaskAlreadyExistsException("has exist expansion task is running");
        }
        if (!this.devNodeManager.findDevNode(deviceSn).isAlreadyConfig()) {
            throw new TaskNotConfigException(String.format(Locale.ENGLISH, "device %s not config", deviceSn));
        }
        ExpansionTask expansionTask = this.getTaskFactory().initExpansionTask(deviceSn);
        this.getTaskManager().submitTask(expansionTask, AbstractTask::execute);
        return expansionTask.getTaskId();
    }

    @Override
    public List<String> queryTaskIds(String deviceSn) {
        return this.getTaskManager().queryTaskIds(deviceSn);
    }

    @Override
    public void continueTask(String taskId) {
        this.getTaskManager().submitTask(this.getTaskManager().findTask(taskId), AbstractTask::continueExecute);
    }

    @Override
    public void retryTask(ItemIndexReq itemIndexInfo) {
        this.getTaskManager().submitTask(this.getTaskManager().findTask(itemIndexInfo.getTaskId()), itemIndexInfo, AbstractTask::retry);
    }

    @Override
    public void rollback(ItemIndexReq itemIndexInfo) {
        this.getTaskManager().submitTask(this.getTaskManager().findTask(itemIndexInfo.getTaskId()), itemIndexInfo, AbstractTask::rollback);
    }

    private boolean hasExistNotCompleteTask(String deviceSn) {
        return this.getTaskManager().isDeviceExistNotCompleteTask(deviceSn);
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory;
    }
}

