/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.task;

import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.scaleout.expansion.common.TaskContext;
import com.huawei.ism.tool.scaleout.expansion.entity.config.BasicTaskConf;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionDevNode;
import com.huawei.ism.tool.scaleout.expansion.entity.pyitem.PyItem;
import com.huawei.ism.tool.scaleout.expansion.entity.pyitem.PyItemResult;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ItemIndexReq;
import com.huawei.ism.tool.scaleout.expansion.enumeration.TaskStatus;
import com.huawei.ism.tool.scaleout.expansion.exception.task.TaskNotExistsException;
import com.huawei.ism.tool.scaleout.expansion.task.ITask;
import com.huawei.ism.tool.scaleout.expansion.util.BusinessStringUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask
extends Observable
implements Observer,
ITask {
    private static final Logger log = LoggerFactory.getLogger(AbstractTask.class);
    protected final TaskContext taskContext = TaskContext.INS;
    protected String taskId;
    protected ExpansionDevNode expansionDevNode;
    protected TaskStatus status = TaskStatus.WAITED;
    protected String errMsg;
    protected List<? extends AbstractTask> children;
    protected double progress = 0.0;
    protected int curChildIndex = 0;
    protected BasicTaskConf conf;
    private Date beginTime;
    private Date endTime;

    @Override
    public boolean execute() {
        if (!this.isWaited() && !this.isRollbackSuccess()) {
            return false;
        }
        return this.doExecute();
    }

    @Override
    public boolean continueExecute() {
        if (!this.isPaused()) {
            return false;
        }
        if (!this.getCurChildTask().continueExecute()) {
            return false;
        }
        ++this.curChildIndex;
        return this.doExecute();
    }

    @Override
    public boolean retry(ItemIndexReq itemIndexInfo) {
        if (!this.isFailed() && !this.isRollbackSuccess()) {
            return false;
        }
        String childId = this.getIndexChildId(itemIndexInfo);
        if (StringUtils.isNULLStr((String)childId) || CollectionUtil.isEmpty(this.children)) {
            this.initAllChildren();
            return this.execute();
        }
        AbstractTask childTask = this.findChildTaskById(childId);
        if (!childTask.retry(itemIndexInfo)) {
            return false;
        }
        this.curChildIndex = this.findChildIndexById(childId) + 1;
        return this.doExecute();
    }

    @Override
    public boolean rollback(ItemIndexReq itemIndexInfo) {
        if (!this.isFailed()) {
            return false;
        }
        if (StringUtils.isNULLStr((String)this.getIndexChildId(itemIndexInfo))) {
            return this.conf.isSupportRollback() && this.doRollBack(this.findFailedChildIndex(), itemIndexInfo);
        }
        return this.findChildTaskById(this.getIndexChildId(itemIndexInfo)).rollback(itemIndexInfo);
    }

    protected boolean doExecute() {
        for (int index = this.curChildIndex; index < this.children.size(); ++index) {
            this.curChildIndex = index;
            AbstractTask child = this.children.get(index);
            if (!child.execute()) {
                log.error("sub task {} stop, task {} stop.", (Object)child.conf.getId(), (Object)this.taskId);
                return !this.conf.isFailedStop();
            }
            if (!this.conf.isNeedConfirm() || index != this.children.size() - 1) continue;
            log.info("{} need confirm to continue, task pause.", (Object)this.conf.getId());
            this.changeStatus(TaskStatus.PAUSED);
            return false;
        }
        return true;
    }

    protected boolean doRollBack(int beginIndex, ItemIndexReq itemIndexInfo) {
        for (int index = beginIndex; index >= 0; --index) {
            AbstractTask child = this.children.get(index);
            if (child.rollback(itemIndexInfo)) continue;
            return false;
        }
        this.changeStatus(TaskStatus.RUNNING);
        return this.doRollBackFinally();
    }

    private boolean doRollBackFinally() {
        if (StringUtils.isNULLStr((String)this.conf.getRollbackFinallyScript())) {
            this.changeStatus(TaskStatus.ROLLBACK_SUCCESS);
            return true;
        }
        String rollbackScriptPath = BusinessStringUtil.generatePackageScriptPath(this.expansionDevNode.getProduct(), this.conf.getRollbackFinallyScript());
        PyItemResult result = this.executeEnvScript(rollbackScriptPath, this.conf.getId());
        if (!result.isSuccess()) {
            this.setStatus(TaskStatus.ROLLBACK_FAILED);
            this.setErrMsg(result.getErrInfo());
            this.notifyObservers();
            this.setEndTime(new Date());
            return false;
        }
        this.setEndTime(new Date());
        this.changeStatus(TaskStatus.ROLLBACK_SUCCESS);
        return true;
    }

    protected void changeStatus(TaskStatus taskStatus) {
        this.status = taskStatus;
        this.notifyObservers();
    }

    protected PyItemResult executeEnvScript(String scriptPath, String itemId) {
        PyItem pyItem = PyItem.builder().itemId(itemId).executeMethod("do_check").scriptPath(scriptPath).jythonExecuter(this.taskContext.getJythonExecuter()).build();
        return pyItem.execute(this.taskContext.getTaskEnvMap().get(this.taskId));
    }

    protected void initAllChildren() {
        this.curChildIndex = 0;
        this.children.forEach(AbstractTask::init);
    }

    protected void init() {
        this.initAllChildren();
        this.curChildIndex = 0;
        this.beginTime = null;
        this.endTime = null;
        this.errMsg = "";
        this.status = TaskStatus.WAITED;
    }

    public boolean isFinished() {
        return this.isSuccess() || this.isFailed();
    }

    public boolean isSuccess() {
        return Arrays.asList(TaskStatus.SUCCESS, TaskStatus.NOT_INVOLVED, TaskStatus.IGNORED).contains((Object)this.status);
    }

    public boolean isFailed() {
        return Arrays.asList(TaskStatus.FAILED, TaskStatus.ROLLBACK_FAILED).contains((Object)this.status);
    }

    public boolean isRunning() {
        return Arrays.asList(TaskStatus.RUNNING, TaskStatus.ROLLBACK_ING).contains((Object)this.status);
    }

    public boolean isWaited() {
        return this.status == TaskStatus.WAITED;
    }

    public boolean isPaused() {
        return this.status == TaskStatus.PAUSED;
    }

    public boolean isRollbackSuccess() {
        return this.status == TaskStatus.ROLLBACK_SUCCESS;
    }

    protected void updateProgress() {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        this.progress = this.children.stream().mapToDouble(AbstractTask::getProgress).sum() / (double)this.children.size();
    }

    protected void updateErrMsg() {
        String errChildNames = this.children.stream().filter(AbstractTask::isFailed).map(child -> child.conf.getName()).collect(Collectors.joining(","));
        this.errMsg = StringUtils.isNULLStr((String)errChildNames) ? "" : ResourceUtil.getStringWithParams((String)"sub.child.task.failed.msg", (Object[])new Object[]{errChildNames});
    }

    protected void updateStatus() {
        if (this.children == null) {
            return;
        }
        if (this.children.stream().allMatch(AbstractTask::isSuccess)) {
            this.status = TaskStatus.SUCCESS;
            return;
        }
        if (this.children.stream().anyMatch(AbstractTask::isFailed)) {
            this.status = TaskStatus.FAILED;
            return;
        }
        if (this.children.stream().anyMatch(AbstractTask::isRunning)) {
            this.status = TaskStatus.RUNNING;
            return;
        }
        if (this.children.stream().allMatch(AbstractTask::isWaited)) {
            this.status = TaskStatus.WAITED;
            return;
        }
        if (this.children.stream().allMatch(task -> task.isSuccess() || task.isWaited())) {
            this.status = TaskStatus.RUNNING;
            return;
        }
        if (this.children.stream().anyMatch(AbstractTask::isPaused)) {
            this.status = TaskStatus.PAUSED;
            return;
        }
        if (this.children.stream().allMatch(task -> task.isWaited() || task.isRollbackSuccess())) {
            this.status = TaskStatus.ROLLBACK_SUCCESS;
            return;
        }
        if (this.children.stream().allMatch(task -> task.isWaited() || task.isRollbackSuccess() || task.isSuccess())) {
            this.status = TaskStatus.FAILED;
            return;
        }
    }

    protected abstract String getIndexChildId(ItemIndexReq var1);

    protected AbstractTask getCurChildTask() {
        return this.children.get(this.curChildIndex);
    }

    private AbstractTask findChildTaskById(String id) {
        return this.children.stream().filter(task -> task.conf.getId().equals(id)).findFirst().orElseThrow(() -> new TaskNotExistsException("task not exist, task id: " + id));
    }

    private int findChildIndexById(String id) {
        for (int index = 0; index < this.children.size(); ++index) {
            AbstractTask task = this.children.get(index);
            if (!task.conf.getId().equals(id)) continue;
            return index;
        }
        return 0;
    }

    protected int findFailedChildIndex() {
        return this.children.stream().filter(AbstractTask::isFailed).map(this.children::indexOf).findFirst().orElse(0);
    }

    @Override
    public void update(Observable obs, Object arg) {
        this.updateProgress();
        this.updateStatus();
        this.updateErrMsg();
        this.updateTime();
        this.notifyObservers();
    }

    private void updateTime() {
        this.children.stream().findFirst().ifPresent(child -> {
            this.beginTime = child.getBeginTime();
        });
        this.endTime = this.getCurChildTask().getEndTime();
    }

    @Override
    public void notifyObservers() {
        this.setChanged();
        super.notifyObservers();
    }

    public String getBeginTimeStr() {
        return BusinessStringUtil.getStrDate(this.beginTime);
    }

    public String getEndTimeStr() {
        return BusinessStringUtil.getStrDate(this.endTime);
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public ExpansionDevNode getExpansionDevNode() {
        return this.expansionDevNode;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public List<? extends AbstractTask> getChildren() {
        return this.children;
    }

    public double getProgress() {
        return this.progress;
    }

    public int getCurChildIndex() {
        return this.curChildIndex;
    }

    public BasicTaskConf getConf() {
        return this.conf;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setExpansionDevNode(ExpansionDevNode expansionDevNode) {
        this.expansionDevNode = expansionDevNode;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setChildren(List<? extends AbstractTask> children) {
        this.children = children;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setCurChildIndex(int curChildIndex) {
        this.curChildIndex = curChildIndex;
    }

    public void setConf(BasicTaskConf conf) {
        this.conf = conf;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
}

