/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.task;

import com.huawei.ism.tool.scaleout.expansion.entity.config.ExpansionTaskConfig;
import com.huawei.ism.tool.scaleout.expansion.entity.config.StepTaskConfig;
import com.huawei.ism.tool.scaleout.expansion.entity.pyitem.PyItemResult;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ItemIndexReq;
import com.huawei.ism.tool.scaleout.expansion.enumeration.TaskStatus;
import com.huawei.ism.tool.scaleout.expansion.task.AbstractTask;
import com.huawei.ism.tool.scaleout.expansion.task.StepTask;
import com.huawei.ism.tool.scaleout.expansion.util.BusinessStringUtil;

public class ExpansionTask
extends AbstractTask {
    @Override
    protected String getIndexChildId(ItemIndexReq itemIndexReq) {
        return itemIndexReq.getStepId();
    }

    public boolean executeFinally() {
        String finallyScript = BusinessStringUtil.generatePackageScriptPath(this.getExpansionDevNode().getProduct(), ((ExpansionTaskConfig)this.conf).getFinallyScript());
        PyItemResult result = this.executeEnvScript(finallyScript, ((ExpansionTaskConfig)this.conf).getFinallyScript());
        return result.isSuccess();
    }

    @Override
    public void updateStatus() {
        super.updateStatus();
        this.refreshDevNodeStatus();
    }

    public void refreshDevNodeStatus() {
        this.expansionDevNode.setExpansionDevNodeStatus(this.status);
        this.expansionDevNode.setAllowModifyTactics(this.judgeTaskCanConfig());
    }

    private boolean judgeTaskCanConfig() {
        if (this.status == TaskStatus.ALREADY_CONFIG || this.status == TaskStatus.WAIT_CONFIG || this.isSuccess()) {
            return true;
        }
        if (this.status == TaskStatus.FAILED) {
            return this.evalTaskFailed() && this.otherTaskWaited();
        }
        return false;
    }

    private boolean evalTaskFailed() {
        return this.getChildren().stream().map(StepTask.class::cast).filter(stepTask -> ((StepTaskConfig)stepTask.getConf()).isEval()).anyMatch(AbstractTask::isFailed);
    }

    private boolean otherTaskWaited() {
        return this.getChildren().stream().map(StepTask.class::cast).filter(stepTask -> !((StepTaskConfig)stepTask.getConf()).isEval()).allMatch(AbstractTask::isWaited);
    }
}

