/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.task;

import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.scaleout.expansion.entity.pyitem.PyItem;
import com.huawei.ism.tool.scaleout.expansion.entity.pyitem.PyItemResult;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ItemIndexReq;
import com.huawei.ism.tool.scaleout.expansion.enumeration.PyItemStatus;
import com.huawei.ism.tool.scaleout.expansion.enumeration.TaskStatus;
import com.huawei.ism.tool.scaleout.expansion.task.AbstractTask;
import com.huawei.ism.tool.service.rest.service.device.IgnoreService;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTask
extends AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(ItemTask.class);
    private static final EnumMap<PyItemStatus, TaskStatus> EXECUTE_STATUS_MAP = new EnumMap<PyItemStatus, TaskStatus>(PyItemStatus.class){
        {
            this.put(PyItemStatus.NOT_PASS, TaskStatus.FAILED);
            this.put(PyItemStatus.PASS, TaskStatus.SUCCESS);
            this.put(PyItemStatus.NOT_INVOLVED, TaskStatus.NOT_INVOLVED);
        }
    };
    private static final EnumMap<PyItemStatus, TaskStatus> ROLLBACK_STATUS_MAP = new EnumMap<PyItemStatus, TaskStatus>(PyItemStatus.class){
        {
            this.put(PyItemStatus.PASS, TaskStatus.ROLLBACK_SUCCESS);
            this.put(PyItemStatus.NOT_PASS, TaskStatus.ROLLBACK_FAILED);
            this.put(PyItemStatus.NOT_INVOLVED, TaskStatus.NOT_INVOLVED);
        }
    };
    PyItem pyItem;
    IgnoreService ignoreService = IgnoreService.getInstance();

    @Override
    public boolean execute() {
        return CollectionUtil.isEmpty((Collection)this.children) ? this.executePyItem() : super.doExecute();
    }

    @Override
    public boolean continueExecute() {
        if (this.children.isEmpty()) {
            this.setStatus(TaskStatus.SUCCESS);
            this.notifyObservers();
            return true;
        }
        return super.continueExecute();
    }

    @Override
    protected String getIndexChildId(ItemIndexReq itemIndexReq) {
        return itemIndexReq.getSubItemId();
    }

    @Override
    public boolean rollback(ItemIndexReq itemIndexInfo) {
        if (this.children.isEmpty()) {
            return this.conf.isSupportRollback() && this.rollbackPyItem();
        }
        return super.rollback(itemIndexInfo);
    }

    private boolean executePyItem() {
        try {
            this.progress = 0.0;
            this.setBeginTime(new Date());
            this.setEndTime(null);
            if (this.ignoreService.canIgnoreItem(this.getModuleKey(), this.conf.getId())) {
                log.info("ignore {} item {}, do nothing and success.", (Object)this.getModuleKey(), (Object)this.conf.getId());
                this.changeStatus(TaskStatus.SUCCESS);
                boolean bl = true;
                return bl;
            }
            this.changeStatus(TaskStatus.RUNNING);
            PyItemResult result = this.pyItem.execute(this.taskContext.getTaskEnvMap().get(this.taskId));
            this.changeStatus(this.transPyItem2TaskStatus(result.getItemStatus()));
            if (!result.isSuccess()) {
                this.ignoreService.addNoPassItem(this.getModuleKey(), this.conf.getId());
                if (this.conf.isNeedConfirm()) {
                    this.changeStatus(TaskStatus.PAUSED);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = !this.conf.isFailedStop();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.progress = 100.0;
            this.setEndTime(new Date());
            this.notifyObservers();
        }
    }

    private boolean rollbackPyItem() {
        try {
            this.progress = 0.0;
            this.setBeginTime(new Date());
            this.setEndTime(null);
            this.changeStatus(TaskStatus.ROLLBACK_ING);
            PyItemResult result = this.pyItem.rollback(this.taskContext.getTaskEnvMap().get(this.taskId));
            this.changeStatus(this.transPyItem2TaskStatus4Rollback(result.getItemStatus()));
            boolean bl = result.isSuccess();
            return bl;
        }
        finally {
            this.progress = 100.0;
            this.setEndTime(new Date());
            this.notifyObservers();
        }
    }

    private TaskStatus transPyItem2TaskStatus(PyItemStatus pyItemStatus) {
        return EXECUTE_STATUS_MAP.getOrDefault((Object)pyItemStatus, TaskStatus.FAILED);
    }

    private TaskStatus transPyItem2TaskStatus4Rollback(PyItemStatus pyItemStatus) {
        return ROLLBACK_STATUS_MAP.getOrDefault((Object)pyItemStatus, TaskStatus.ROLLBACK_FAILED);
    }

    private String getModuleKey() {
        return this.taskContext.getTaskEnvMap().get(this.taskId).getCluster().getIp();
    }

    public PyItem getPyItem() {
        return this.pyItem;
    }

    public void setPyItem(PyItem pyItem) {
        this.pyItem = pyItem;
    }
}

