/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.task;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.enums.FsmRole;
import com.huawei.ism.tool.scaleout.expansion.common.Context;
import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.common.TaskContext;
import com.huawei.ism.tool.scaleout.expansion.entity.config.ExpansionTaskConfig;
import com.huawei.ism.tool.scaleout.expansion.entity.config.ItemTaskConfig;
import com.huawei.ism.tool.scaleout.expansion.entity.config.StepTaskConfig;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionConfNode;
import com.huawei.ism.tool.scaleout.expansion.entity.devnode.ExpansionDevNode;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Module;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Product;
import com.huawei.ism.tool.scaleout.expansion.entity.pyitem.PyItem;
import com.huawei.ism.tool.scaleout.expansion.enumeration.ExpansionNodeConfType;
import com.huawei.ism.tool.scaleout.expansion.enumeration.ModuleEnum;
import com.huawei.ism.tool.scaleout.expansion.exception.product.NoMatchModuleException;
import com.huawei.ism.tool.scaleout.expansion.task.ExpansionTask;
import com.huawei.ism.tool.scaleout.expansion.task.ItemTask;
import com.huawei.ism.tool.scaleout.expansion.task.StepTask;
import com.huawei.ism.tool.scaleout.expansion.task.TaskEnv;
import com.huawei.ism.tool.scaleout.expansion.util.BusinessStringUtil;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Observer;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;

public class TaskFactory {
    public static final TaskFactory INS = new TaskFactory();
    private final DevNodeManager devNodeManager = DevNodeManager.INS;
    private final Context context = Context.INS;
    private final TaskContext taskContext = TaskContext.INS;

    public ExpansionTask initExpansionTask(@NotNull String deviceSn) {
        String taskId = BusinessStringUtil.generateTaskId(deviceSn);
        this.initTaskContext(taskId, deviceSn);
        return this.buildExpansionTask(deviceSn, this.findMatchTaskConfig(deviceSn), taskId);
    }

    private void initTaskContext(String taskId, String deviceSn) {
        this.taskContext.getTaskEnvMap().put(taskId, this.buildTaskEnv(taskId, deviceSn));
    }

    private TaskEnv buildTaskEnv(String taskId, String deviceSn) {
        ExpansionDevNode expansionDevNode = this.getDevNodeManager().findDevNode(deviceSn);
        TaskEnv env = new TaskEnv();
        env.setTaskId(taskId);
        env.setCluster(expansionDevNode.getOriDevNode());
        env.setOmmPassword(expansionDevNode.isOmmAuthPass() ? expansionDevNode.getOmmAuthInfo().getPassword() : "");
        env.setExpansionConfNodes(this.getPlanExpansionNode(deviceSn));
        this.getFsmMasterClusterNode(expansionDevNode).ifPresent(env::setMasterFsmClusterNode);
        env.setClusterNodeMap(this.getClusterNodeMap(expansionDevNode));
        env.setNoRootClusterNodeMap(this.getNoRootClusterNodeMap(expansionDevNode));
        return env;
    }

    private List<ExpansionConfNode> getPlanExpansionNode(String deviceSn) {
        if (!this.getDevNodeManager().isExistConfNodes(deviceSn)) {
            return Collections.emptyList();
        }
        return this.getDevNodeManager().getExpansionConfs(deviceSn).stream().filter(confNode -> confNode.getExpansionType() == ExpansionNodeConfType.PLAN_EXPANSION.getCode()).collect(Collectors.toList());
    }

    private Optional<DevNode> getFsmMasterClusterNode(ExpansionDevNode expansionDevNode) {
        return expansionDevNode.getBusinessDevice().getAuthClusterNodes().stream().filter(authClusterNode -> authClusterNode.getNode().getFsmRole() == FsmRole.ACTIVE).map(arg_0 -> ((BusinessDeviceUtil)BusinessDeviceUtil.INS).buildOsNode(arg_0)).findFirst();
    }

    private Map<String, DevNode> getClusterNodeMap(ExpansionDevNode expansionDevNode) {
        return expansionDevNode.getBusinessDevice().getAuthClusterNodes().stream().map(arg_0 -> ((BusinessDeviceUtil)BusinessDeviceUtil.INS).buildOsNode(arg_0)).collect(Collectors.toMap(DevNode::getIp, osDevNode -> osDevNode, (ip1, ip2) -> ip1));
    }

    private Map<String, DevNode> getNoRootClusterNodeMap(ExpansionDevNode expansionDevNode) {
        return expansionDevNode.getBusinessDevice().getAuthClusterNodes().stream().filter(authClusterNode -> authClusterNode.getOsRootUser() != null).map(arg_0 -> ((BusinessDeviceUtil)BusinessDeviceUtil.INS).buildOsNode(arg_0)).peek(osNode -> osNode.setRootUser(null)).collect(Collectors.toMap(DevNode::getIp, osDevNode -> osDevNode, (ip1, ip2) -> ip1));
    }

    private ExpansionTask buildExpansionTask(String deviceSn, ExpansionTaskConfig expansionTaskConfig, String taskId) {
        ExpansionTask expansionTask = new ExpansionTask();
        expansionTask.setTaskId(taskId);
        expansionTask.setConf(expansionTaskConfig);
        expansionTask.setChildren(this.buildStepTasks(deviceSn, expansionTaskConfig.getSteps(), expansionTask));
        expansionTask.setExpansionDevNode(this.getDevNodeManager().findDevNode(deviceSn));
        return expansionTask;
    }

    private List<StepTask> buildStepTasks(String deviceSn, List<StepTaskConfig> stepConfs, ExpansionTask expansionTask) {
        ExpansionDevNode expansionDevNode = this.getDevNodeManager().findDevNode(deviceSn);
        List matchStepTaskConfs = stepConfs.stream().filter(stepTaskConfig -> expansionDevNode.getExpansionStrategies().contains(stepTaskConfig.getId())).map(this::copyStepTaskConfig).collect(Collectors.toList());
        if (matchStepTaskConfs.size() == 1) {
            ((StepTaskConfig)matchStepTaskConfs.get(0)).setNeedConfirm(false);
        }
        return matchStepTaskConfs.stream().map(stepTaskConfig -> this.buildStepTask(deviceSn, (StepTaskConfig)stepTaskConfig, expansionTask.getTaskId())).peek(stepTask -> stepTask.addObserver(expansionTask)).collect(Collectors.toList());
    }

    private StepTaskConfig copyStepTaskConfig(StepTaskConfig stepTaskConfig) {
        StepTaskConfig targetStepTaskConf = new StepTaskConfig();
        BeanUtils.copyProperties((Object)stepTaskConfig, (Object)targetStepTaskConf);
        return targetStepTaskConf;
    }

    private StepTask buildStepTask(String deviceSn, StepTaskConfig stepTaskConfig, String taskId) {
        StepTask stepTask = new StepTask();
        stepTask.setTaskId(taskId);
        stepTask.setConf(stepTaskConfig);
        stepTask.setExpansionDevNode(this.getDevNodeManager().findDevNode(deviceSn));
        stepTask.setChildren(this.buildItemTasks(deviceSn, stepTaskConfig.getItems(), taskId, stepTask));
        return stepTask;
    }

    private List<ItemTask> buildItemTasks(String deviceSn, List<ItemTaskConfig> itemConfs, String taskId, Observer obs) {
        return itemConfs.stream().map(itemTaskConfig -> this.buildItemTask(deviceSn, (ItemTaskConfig)itemTaskConfig, taskId)).peek(itemTask -> itemTask.addObserver(obs)).collect(Collectors.toList());
    }

    private ItemTask buildItemTask(String deviceSn, ItemTaskConfig itemTaskConfig, String taskId) {
        ItemTask itemTask = new ItemTask();
        itemTask.setTaskId(taskId);
        itemTask.setConf(itemTaskConfig);
        itemTask.setExpansionDevNode(this.getDevNodeManager().findDevNode(deviceSn));
        itemTask.setChildren(this.buildItemTasks(deviceSn, itemTaskConfig.getSubItems(), taskId, itemTask));
        itemTask.setPyItem(this.buildPyItem(itemTaskConfig, deviceSn));
        return itemTask;
    }

    private PyItem buildPyItem(ItemTaskConfig itemTaskConfig, String deviceSn) {
        return PyItem.builder().itemId(itemTaskConfig.getId()).taskConf(itemTaskConfig).jythonExecuter(this.taskContext.getJythonExecuter()).executeMethod(itemTaskConfig.getMethod()).rollbackMethod(itemTaskConfig.getRollbackMethod()).scriptPath(this.initScriptPath(itemTaskConfig, deviceSn)).build();
    }

    private String initScriptPath(ItemTaskConfig itemTaskConfig, String deviceSn) {
        Product product = this.getDevNodeManager().findDevNode(deviceSn).getProduct();
        return BusinessStringUtil.generatePackageScriptPath(product, itemTaskConfig.getId());
    }

    private ExpansionTaskConfig findMatchTaskConfig(String deviceSn) {
        Product product = this.getDevNodeManager().findDevNode(deviceSn).getProduct();
        return this.findExpansionTaskConfig(product, this.context.getModule());
    }

    private ExpansionTaskConfig findExpansionTaskConfig(Product product, ModuleEnum moduleEnum) {
        return product.getSupportModules().stream().filter(module -> Objects.equals(module.getId(), moduleEnum.getName())).map(Module::getExpansionTaskConfig).findFirst().orElseThrow(() -> new NoMatchModuleException(String.format(Locale.ENGLISH, "cant match %s module", moduleEnum.getName())));
    }

    private TaskFactory() {
    }

    public DevNodeManager getDevNodeManager() {
        return this.devNodeManager;
    }
}

