/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.task;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.huawei.ism.tool.scaleout.expansion.common.ResourceConstants;
import com.huawei.ism.tool.scaleout.expansion.common.TaskContext;
import com.huawei.ism.tool.scaleout.expansion.entity.request.ItemIndexReq;
import com.huawei.ism.tool.scaleout.expansion.enumeration.TaskStatus;
import com.huawei.ism.tool.scaleout.expansion.exception.task.TaskNotExistsException;
import com.huawei.ism.tool.scaleout.expansion.task.AbstractTask;
import com.huawei.ism.tool.scaleout.expansion.task.ExpansionTask;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    public static final TaskManager INS = new TaskManager();
    private static final List<TaskStatus> CAN_MODIFY_STATUS_LIST = Arrays.asList(TaskStatus.WAIT_CONFIG, TaskStatus.ALREADY_CONFIG);
    private Map<String, ExpansionTask> taskMap = new HashMap<String, ExpansionTask>();
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("expansion-task-%d").build());
    private final TaskContext taskContext = TaskContext.INS;

    public ExpansionTask findTask(String taskId) {
        if (!this.taskMap.containsKey(taskId)) {
            throw new TaskNotExistsException(String.format(Locale.ENGLISH, "task %s not exist.", taskId));
        }
        return this.taskMap.get(taskId);
    }

    public boolean isDeviceExistNotCompleteTask(String deviceSn) {
        return this.taskMap.values().stream().filter(task -> !task.isSuccess()).anyMatch(task -> Objects.equals(task.getExpansionDevNode().getId(), deviceSn));
    }

    public List<String> queryTaskIds(String deviceSn) {
        return this.taskMap.values().stream().filter(task -> Objects.equals(task.getExpansionDevNode().getId(), deviceSn)).sorted(Comparator.comparing(AbstractTask::getBeginTime).reversed()).map(AbstractTask::getTaskId).collect(Collectors.toList());
    }

    public CompletableFuture<Void> submitTask(ExpansionTask expansionTask, Consumer<ExpansionTask> consumer) {
        log.info("submit task {}", (Object)expansionTask.getTaskId());
        this.taskMap.putIfAbsent(expansionTask.getTaskId(), expansionTask);
        return ((CompletableFuture)CompletableFuture.runAsync(() -> consumer.accept(expansionTask), this.executorService).whenComplete((ret, ex) -> this.taskFinalHandle(expansionTask))).exceptionally(ex -> this.taskExceptionHandle((Throwable)ex, expansionTask));
    }

    public CompletableFuture<Void> submitTask(ExpansionTask expansionTask, ItemIndexReq itemIndexInfo, BiConsumer<ExpansionTask, ItemIndexReq> biConsumer) {
        log.info("submit task {}", (Object)expansionTask.getTaskId());
        this.taskMap.putIfAbsent(expansionTask.getTaskId(), expansionTask);
        return ((CompletableFuture)CompletableFuture.runAsync(() -> biConsumer.accept(expansionTask, itemIndexInfo), this.executorService).whenComplete((ret, ex) -> this.taskFinalHandle(expansionTask))).exceptionally(ex -> this.taskExceptionHandle((Throwable)ex, expansionTask));
    }

    public boolean hasRunningTask() {
        return this.taskMap.values().stream().anyMatch(AbstractTask::isRunning);
    }

    public boolean hasBeenRunTask(String deviceSn) {
        return this.taskMap.values().stream().filter(task -> task.getExpansionDevNode().getId().equals(deviceSn)).anyMatch(task -> !this.isTaskInConfig((ExpansionTask)task));
    }

    private boolean isTaskInConfig(ExpansionTask expansionTask) {
        return expansionTask.getStatus() == TaskStatus.ALREADY_CONFIG || expansionTask.getStatus() == TaskStatus.WAIT_CONFIG;
    }

    public void shutdown() {
        this.taskMap.values().stream().filter(this::isTaskNeedClean).forEach(ExpansionTask::executeFinally);
    }

    private boolean isTaskNeedClean(ExpansionTask expansionTask) {
        return !expansionTask.isSuccess() || !expansionTask.isWaited();
    }

    private void taskFinalHandle(ExpansionTask task) {
        if (task.isSuccess()) {
            task.executeFinally();
        }
        this.releaseConn(task);
    }

    private Void taskExceptionHandle(Throwable ex, ExpansionTask expansionTask) {
        log.error("task {} finish with ex", (Object)expansionTask.getTaskId(), (Object)ex);
        expansionTask.setStatus(TaskStatus.FAILED);
        expansionTask.setErrMsg(ResourceConstants.UNEXPECTED_ERROR_MSG);
        expansionTask.refreshDevNodeStatus();
        return null;
    }

    private void releaseConn(ExpansionTask task) {
        this.taskContext.getTaskEnvMap().get(task.getTaskId()).releaseConn();
    }

    private TaskManager() {
    }
}

