/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.util;

import com.huawei.ism.tool.scaleout.expansion.entity.product.Product;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

public final class BusinessStringUtil {
    public static String generatePackageScriptPath(Product product, String itemKey) {
        return String.join((CharSequence)File.separator, product.getProductRootPath(), "item", itemKey + ".py");
    }

    public static String getDependFilePath(Product product, String fileNameWithSuffix) {
        return String.join((CharSequence)File.separator, product.getProductRootPath(), "res", "dependFile", fileNameWithSuffix);
    }

    public static String generateTaskId(String deviceSn) {
        return String.format(Locale.ENGLISH, "%s_%s", deviceSn, System.currentTimeMillis());
    }

    public static String getStrDate(Date date) {
        if (Objects.isNull(date)) {
            return "--";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.setTimeZone(TimeZone.getDefault());
        return formatter.format(date);
    }

    private BusinessStringUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

