/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.scaleout.expansion.util;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.scaleout.expansion.common.Context;
import com.huawei.ism.tool.scaleout.expansion.common.DevNodeManager;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Module;
import com.huawei.ism.tool.scaleout.expansion.entity.product.Product;
import com.huawei.ism.tool.scaleout.expansion.util.BusinessStringUtil;
import java.io.File;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptUtils {
    private static final Logger log = LoggerFactory.getLogger(ScriptUtils.class);
    public static final ScriptUtils INS = new ScriptUtils();
    private DevNodeManager devNodeManager = DevNodeManager.INS;
    private Context context = Context.INS;

    public File getExpandFile(DevNode devNode) {
        Product product = this.getDevNodeManager().findDevNode(devNode.getDeviceSerialNumber()).getProduct();
        return product.getSupportModules().stream().filter(module -> module.getId().equals(this.getContext().getModule().getName())).findFirst().map(Module::getDependFile).map(fileName -> new File(BusinessStringUtil.getDependFilePath(product, fileName))).orElse(null);
    }

    public String getExpandFileNameWithoutSuffix(DevNode devNode) {
        File dependFile = this.getExpandFile(devNode);
        if (Objects.nonNull(dependFile) && dependFile.exists()) {
            return dependFile.getName().substring(0, dependFile.getName().lastIndexOf("."));
        }
        return "";
    }

    private ScriptUtils() {
    }

    public DevNodeManager getDevNodeManager() {
        return this.devNodeManager;
    }

    public Context getContext() {
        return this.context;
    }
}

