/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.array;

import com.huawei.baize.base.cast.CastUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public final class ArrayDistinctUtils {
    private ArrayDistinctUtils() {
    }

    public static int[] distinct(int[] intArray) {
        Objects.requireNonNull(intArray);
        return IntStream.of(intArray).distinct().toArray();
    }

    public static double[] distinct(double[] doubleArray) {
        Objects.requireNonNull(doubleArray);
        return DoubleStream.of(doubleArray).distinct().toArray();
    }

    public static long[] distinct(long[] longArray) {
        Objects.requireNonNull(longArray);
        return LongStream.of(longArray).distinct().toArray();
    }

    public static float[] distinct(float[] floatArray) {
        Objects.requireNonNull(floatArray);
        Float[] floats = (Float[])Stream.of(ArrayUtils.toObject((float[])floatArray)).distinct().toArray(Float[]::new);
        return ArrayUtils.toPrimitive((Float[])floats);
    }

    public static char[] distinct(char[] charArray) {
        Objects.requireNonNull(charArray);
        Character[] characters = (Character[])Arrays.stream(ArrayUtils.toObject((char[])charArray)).distinct().toArray(Character[]::new);
        return ArrayUtils.toPrimitive((Character[])characters);
    }

    public static short[] distinct(short[] shortArray) {
        Objects.requireNonNull(shortArray);
        Short[] shorts = (Short[])Stream.of(ArrayUtils.toObject((short[])shortArray)).distinct().toArray(Short[]::new);
        return ArrayUtils.toPrimitive((Short[])shorts);
    }

    public static byte[] distinct(byte[] byteArray) {
        Objects.requireNonNull(byteArray);
        Byte[] bytes = (Byte[])Stream.of(ArrayUtils.toObject((byte[])byteArray)).distinct().toArray(Byte[]::new);
        return ArrayUtils.toPrimitive((Byte[])bytes);
    }

    public static boolean[] distinct(boolean[] booleanArray) {
        Objects.requireNonNull(booleanArray);
        Boolean[] booleans = (Boolean[])Stream.of(ArrayUtils.toObject((boolean[])booleanArray)).distinct().toArray(Boolean[]::new);
        return ArrayUtils.toPrimitive((Boolean[])booleans);
    }

    public static <T> T[] distinct(T[] object) {
        Objects.requireNonNull(object);
        return CastUtils.castArray(Stream.of(object).distinct().toArray());
    }
}

