/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.array;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.common.Conditions;
import com.huawei.baize.base.function.TripleConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

public class Matrix<T> {
    private final List<List<T>> data;

    public Matrix() {
        this.data = new ArrayList<List<T>>();
    }

    public Matrix(int rowSize) {
        this.data = new ArrayList<List<T>>(rowSize);
    }

    public Matrix<T> addRow(List<T> row) {
        this.data.add(row);
        return this;
    }

    public Matrix<T> addRow(T[] row) {
        this.data.add(Arrays.asList(row));
        return this;
    }

    public int row() {
        return this.data.size();
    }

    public int column() {
        return this.data.get(0).size();
    }

    public Stream<T> getRowStream(int rowIdx) {
        Conditions.requireArgument(rowIdx < this.row());
        return this.data.get(rowIdx).stream();
    }

    public List<T> getColumn(int columnIdx) {
        Conditions.requireArgument(columnIdx < this.column(), "{},{}", columnIdx, this.column());
        return this.data.stream().map(row -> row.get(columnIdx)).collect(Collectors.toList());
    }

    public T get(int rowIdx, int colIdx) {
        Conditions.requireArgument(rowIdx < this.row(), "{},{}", rowIdx, this.row());
        Conditions.requireArgument(colIdx < this.column(), "{},{}", colIdx, this.column());
        return this.data.get(rowIdx).get(colIdx);
    }

    public void foreach(TripleConsumer<T, Integer, Integer> consumer) {
        int row = this.row();
        int col = this.column();
        for (int i = 0; i < row; ++i) {
            List<T> array = this.data.get(i);
            for (int j = 0; j < col; ++j) {
                consumer.accept(array.get(j), i, j);
            }
        }
    }

    public Matrix<T> shear(@NotNull List<Integer> rowInclusive, @NotNull List<Integer> colExclusive) {
        Conditions.requireArgument(CollectionUtils.isNotEmpty(rowInclusive));
        Matrix<T> matrix1 = new Matrix<T>(rowInclusive.size());
        for (int i = 0; i < this.row(); ++i) {
            int idd = i;
            if (!rowInclusive.stream().anyMatch(idx -> idx == idd)) continue;
            matrix1.addRow(this.data.get(i));
        }
        Matrix matrix2 = new Matrix(rowInclusive.size());
        for (int i = 0; i < matrix1.row(); ++i) {
            List<T> list1 = matrix1.data.get(i);
            ArrayList<T> list2 = new ArrayList<T>();
            for (int j = 0; j < matrix1.column(); ++j) {
                int idd = j;
                if (!colExclusive.stream().anyMatch(idx -> idx != idd)) continue;
                list2.add(list1.get(j));
            }
            matrix2.addRow(list2);
        }
        return matrix2;
    }

    public Matrix<T> shearColumn(int colExclusiveIdx) {
        Conditions.requireArgument(colExclusiveIdx < this.column());
        Matrix matrix1 = new Matrix(this.row());
        for (int i = 0; i < this.row(); ++i) {
            List<T> list1 = this.data.get(i);
            ArrayList<T> list2 = new ArrayList<T>();
            for (int j = 0; j < this.column(); ++j) {
                if (j == colExclusiveIdx) continue;
                list2.add(list1.get(j));
            }
            matrix1.addRow(list2);
        }
        return matrix1;
    }

    public Matrix<T> subMatrix(@NotNull List<Integer> rowInclusive) {
        Matrix<T> matrix1 = new Matrix<T>();
        for (int i = 0; i < this.row(); ++i) {
            int idd = i;
            if (!rowInclusive.stream().anyMatch(idx -> idx == idd)) continue;
            matrix1.addRow(this.data.get(i));
        }
        return matrix1;
    }

    public Matrix(List<List<T>> data) {
        this.data = data;
    }
}

