/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.cast;

import com.huawei.baize.base.common.Conditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CastUtils {
    private CastUtils() {
    }

    public static <T> T cast(Object obj) {
        Conditions.requireArgument(obj != null);
        return (T)obj;
    }

    public static <T> T[] castArray(Object obj) {
        Conditions.requireArgument(obj != null);
        Conditions.requireArgument(obj.getClass().isArray());
        return (Object[])CastUtils.cast(obj);
    }

    public static <T> List<T> castList(Object obj) {
        Conditions.requireArgument(obj != null);
        Conditions.requireArgument(obj instanceof List);
        return (List)CastUtils.cast(obj);
    }

    public static <K, V> Map<K, V> castMap(Object obj) {
        Conditions.requireArgument(obj != null);
        Conditions.requireArgument(obj instanceof Map);
        return (Map)CastUtils.cast(obj);
    }

    public static <T> T[][] castArray2Dim(Object obj) {
        Conditions.requireArgument(obj != null);
        Conditions.requireArgument(obj.getClass().isArray());
        return (Object[][])CastUtils.cast(obj);
    }

    public static <T> List<T> castNewList(Object obj, Class<T> tClass) {
        Conditions.requireArgument(obj != null);
        Conditions.requireArgument(tClass != null);
        Conditions.requireArgument(obj instanceof List);
        ArrayList<T> list = new ArrayList<T>();
        for (Object o : (List)obj) {
            list.add(tClass.cast(o));
        }
        return list;
    }

    public static <K, V> Map<K, V> castNewMap(Object obj, Class<K> kClass, Class<V> vClass) {
        Conditions.requireArgument(obj != null);
        Conditions.requireArgument(kClass != null);
        Conditions.requireArgument(vClass != null);
        Conditions.requireArgument(obj instanceof Map);
        HashMap<K, V> result = new HashMap<K, V>();
        Map map = (Map)obj;
        for (Map.Entry entry : map.entrySet()) {
            result.put(kClass.cast(entry.getKey()), vClass.cast(entry.getValue()));
        }
        return result;
    }
}

