/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.collection;

import com.huawei.baize.base.common.Conditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class CollectionConvertUtils {
    private CollectionConvertUtils() {
    }

    public static <R> Set<R> listToUnmodifiableSet(List<R> elements) {
        Conditions.requireArgument(elements != null, "");
        return Collections.unmodifiableSet(CollectionConvertUtils.listToSet(elements));
    }

    public static <T, R> Set<R> listToUnmodifiableSet(List<T> elements, Function<T, R> function) {
        return Collections.unmodifiableSet(CollectionConvertUtils.listToSet(elements, function));
    }

    public static <R> Set<R> listToSet(List<R> elements) {
        return new HashSet<R>(elements);
    }

    public static <T, R> Set<R> listToSet(List<T> elements, Function<T, R> function) {
        return elements.stream().map(function).collect(Collectors.toSet());
    }

    public static <R> List<R> setToUnmodifiableList(Set<R> elements) {
        return Collections.unmodifiableList(CollectionConvertUtils.setToList(elements));
    }

    public static <T, R> List<R> setToUnmodifiableList(Set<T> elements, Function<T, R> function) {
        return Collections.unmodifiableList(CollectionConvertUtils.setToList(elements, function));
    }

    public static <R> List<R> setToList(Set<R> elements) {
        return new ArrayList<R>(elements);
    }

    public static <T, R> List<R> setToList(Set<T> elements, Function<T, R> function) {
        return elements.stream().map(function).collect(Collectors.toList());
    }
}

