/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.collection;

import com.huawei.baize.base.cast.CastUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionFilterUtils {
    private static final Logger log = LoggerFactory.getLogger(CollectionFilterUtils.class);

    private CollectionFilterUtils() {
    }

    public static <T> T findOne(Collection<T> collection, T element) {
        return collection.stream().filter(ii -> ii.equals(element)).findFirst().orElse(null);
    }

    public static <T> List<T> findAnyByIndexs(Collection<T> collection, int ... indexs) {
        ArrayList result = new ArrayList();
        int size = collection.size();
        if (collection instanceof List) {
            List list = (List)collection;
            Arrays.stream(indexs).forEach(index -> result.add(index < 0 ? list.get(size + index) : list.get(index)));
        } else {
            Arrays.stream(indexs).forEach(index -> result.add(CastUtils.cast(index < 0 ? collection.toArray()[size + index] : collection.toArray()[index])));
        }
        return result;
    }
}

