/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.collection;

import com.huawei.baize.base.cast.CastUtils;
import com.huawei.baize.base.comparator.PinyinComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class CollectionSortUtils {
    private CollectionSortUtils() {
    }

    public static <T> List<T> sortByNoModify(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(comparator);
        return list;
    }

    public static <T> List<T> sortByModify(List<T> list, Comparator<? super T> comparator) {
        list.sort(comparator);
        return list;
    }

    public static List<String> sortNoModifyByPinyin(Collection<String> collection) {
        return CollectionSortUtils.sortByNoModify(collection, new PinyinComparator());
    }

    public static List<String> sortModifyByPinyin(List<String> list) {
        return CollectionSortUtils.sortByModify(list, new PinyinComparator());
    }

    public static <K, V> Map<K, V> sortByMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map);
        return result;
    }

    public static <K, V> Map<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        list.sort(comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> Map<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return CollectionSortUtils.sortToMap(map.entrySet(), comparator);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        list.sort((o1, o2) -> {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1 instanceof Comparable) {
                return ((Comparable)CastUtils.cast(v1)).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        });
        return list;
    }
}

