/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.collection.tree;

import com.huawei.baize.base.annotations.NotNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeNode {
    private static final int PREFIX = 3;
    @NonNull
    private final String id;
    private final List<TreeNode> children = new ArrayList<TreeNode>();
    private int level = 1;
    private TreeNode parent;

    boolean isRoot() {
        return this.parent == null;
    }

    boolean isLeaf() {
        return !this.hasChild();
    }

    boolean hasChild() {
        return CollectionUtils.isNotEmpty(this.children);
    }

    Iterator<TreeNode> getChildrenIterator() {
        return this.children.iterator();
    }

    public void insertTo(@NotNull TreeNode father) {
        this.parent = father;
        this.level = father.level + 1;
        father.children.add(this);
    }

    public void remove() {
        Objects.requireNonNull(this.parent, "parent is null");
        this.parent.children.remove(this);
        this.parent = null;
        this.level = 0;
    }

    public String getChildrenName() {
        return this.children.stream().map(TreeNode::getId).collect(Collectors.joining(",", "{", "}"));
    }

    public String getPrefix() {
        int cnt = this.level * 3;
        return StringUtils.repeat((String)" ", (int)cnt) + "|" + StringUtils.repeat((String)" -", (int)this.level) + ">";
    }

    public String getsuffix() {
        return this.getChildrenName();
    }

    public TreeNode(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreeNode)) {
            return false;
        }
        TreeNode other = (TreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreeNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "TreeNode(id=" + this.getId() + ", children=" + this.children + ", level=" + this.level + ", parent=" + this.parent + ")";
    }

    protected TreeNode(@NonNull String id, int level, TreeNode parent) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.level = level;
        this.parent = parent;
    }

    @NonNull
    public String getId() {
        return this.id;
    }
}

