/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.common.Conditions;
import org.apache.commons.lang3.math.NumberUtils;

public final class ChineseNumberUtils {
    private static final String[] CHINESE_DIGITAL = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] CHINESE_DECIMAL_UNITS = new String[]{"", "\u5341", "\u767e", "\u5343"};
    private static final String[] CHINESE_SECTION_UNITS = new String[]{"", "\u4e07", "\u4ebf", "\u4e07\u4ebf", "\u4ebf\u4ebf"};
    private static final int DECIMAL_RATIO = 10;
    private static final int SECTION_RATIO = 10000;
    private static final int ONE_THOUSAND = 1000;
    private static final int THOUSANDS_MAX = 9999;
    private static final int THOUSANDS_MIN = -9999;

    private ChineseNumberUtils() {
    }

    public static String number2Chinese(long number) {
        if (number < 0L) {
            return '\u8d1f' + ChineseNumberUtils.positiveNumber2Chinese(number * (long)NumberUtils.INTEGER_MINUS_ONE.intValue());
        }
        return number == 0L ? "\u96f6" : ChineseNumberUtils.positiveNumber2Chinese(number);
    }

    public static String thousandsNumber2Chinese(int thousandsNum) {
        Conditions.requireArgument(thousandsNum >= -9999 && thousandsNum <= 9999, "number must be in [-9999,9999]");
        if (thousandsNum < 0) {
            return '\u8d1f' + ChineseNumberUtils.thousandsNumber2ReverseChinese(thousandsNum * NumberUtils.INTEGER_MINUS_ONE).reverse().toString();
        }
        return thousandsNum == 0 ? "\u96f6" : ChineseNumberUtils.thousandsNumber2ReverseChinese(thousandsNum).reverse().toString();
    }

    public static String positiveNumber2Chinese(long positiveNumber) {
        Conditions.requireArgument(positiveNumber > 0L);
        StringBuilder chinese = new StringBuilder();
        int unitPos = 0;
        long calcNum = positiveNumber;
        while (calcNum > 0L) {
            int section = (int)(calcNum % 10000L);
            chinese.append(section != 0 ? CHINESE_SECTION_UNITS[unitPos] : "");
            chinese.append((CharSequence)ChineseNumberUtils.thousandsNumber2ReverseChinese(section));
            chinese.append(unitPos == 0 && section < 1000 ? Character.valueOf('\u96f6') : "");
            calcNum /= 10000L;
            ++unitPos;
        }
        return chinese.reverse().toString();
    }

    private static StringBuilder thousandsNumber2ReverseChinese(int thousandsNo) {
        StringBuilder chineseBuilder = new StringBuilder();
        int unitPos = 0;
        int calcNum = thousandsNo;
        while (calcNum > 0) {
            if (calcNum % 10 != 0) {
                chineseBuilder.append(CHINESE_DECIMAL_UNITS[unitPos]).append(CHINESE_DIGITAL[calcNum % 10]);
            } else if (chineseBuilder.length() > 0 && chineseBuilder.charAt(chineseBuilder.length() - 1) != '\u96f6') {
                chineseBuilder.append('\u96f6');
            }
            calcNum /= 10;
            ++unitPos;
        }
        return chineseBuilder;
    }
}

