/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class Classifier {
    private Classifier() {
    }

    public static <T> List<T> getColour(@NotNull List<T> list) {
        return Classifier.getColourStatistics(list).stream().map(Color::getType).collect(Collectors.toList());
    }

    public static <T> List<T> getColour(@NotNull T[] array) {
        return Classifier.getColourStatistics(array).stream().map(Color::getType).collect(Collectors.toList());
    }

    public static <T> List<Color<T>> getColourStatistics(@NotNull List<T> list) {
        HashMap<T, Color> colors = new HashMap<T, Color>();
        for (int i = 0; i < list.size(); ++i) {
            Color color2 = (Color)colors.get(list.get(i));
            if (color2 != null) {
                color2.addIndex(i);
                continue;
            }
            colors.put(list.get(i), ((Color)new Color<T>(list.get(i))).addIndex(i));
        }
        return colors.values().stream().peek(color -> ((Color)color).flush(list.size())).collect(Collectors.toList());
    }

    public static <T> List<Color<T>> getColourStatistics(@NotNull T[] array) {
        return Classifier.getColourStatistics(Arrays.asList(array));
    }

    public static class Color<T> {
        @NonNull
        private T type;
        private List<Integer> indexs = new ArrayList<Integer>();
        private double ratio;

        Color(T type, List<Integer> indexs, int total) {
            this.type = type;
            this.indexs = indexs;
            this.ratio = MathUtils.quotient(indexs.size(), total);
        }

        private Color<T> addIndex(int idx) {
            this.indexs.add(idx);
            return this;
        }

        private void flush(int total) {
            this.ratio = MathUtils.quotient(this.indexs.size(), total);
        }

        public Color(@NonNull T type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @NonNull
        public T getType() {
            return this.type;
        }

        public List<Integer> getIndexs() {
            return this.indexs;
        }

        public double getRatio() {
            return this.ratio;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Color)) {
                return false;
            }
            Color other = (Color)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$type = this.getType();
            T other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<Integer> this$indexs = this.getIndexs();
            List<Integer> other$indexs = other.getIndexs();
            if (this$indexs == null ? other$indexs != null : !((Object)this$indexs).equals(other$indexs)) {
                return false;
            }
            return Double.compare(this.getRatio(), other.getRatio()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Color;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<Integer> $indexs = this.getIndexs();
            result = result * 59 + ($indexs == null ? 43 : ((Object)$indexs).hashCode());
            long $ratio = Double.doubleToLongBits(this.getRatio());
            result = result * 59 + (int)($ratio >>> 32 ^ $ratio);
            return result;
        }
    }
}

