/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.common.Conditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class DiscreteObjectSets {
    private DiscreteObjectSets() {
    }

    public static <T> List<List<T>> combinationAll(T[] array, int target, Function<T, Integer> get) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((Object[])array));
        Arrays.sort(array, Comparator.comparing(get));
        ArrayList subset = new ArrayList();
        ArrayList<List<T>> res = new ArrayList<List<T>>();
        DiscreteObjectSets.recursionFind(new Input<T>(array, 0, target, get), subset, res);
        return res;
    }

    public static <T> List<List<T>> combinationListMin(T[] array, int target, Function<T, Integer> get) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            throw new IllegalArgumentException("\u4f20\u5165\u6570\u7ec4\u4e3a\u7a7a");
        }
        Arrays.sort(array, Comparator.comparing(get));
        List<List<T>> res = new ArrayList<List<T>>();
        T[] sortedArray = DiscreteObjectSets.filterLessTargetArray(array, target, get);
        Input<T> input = new Input<T>(sortedArray, 0, target, get);
        for (int i = 1; i < array.length + 1 && !CollectionUtils.isNotEmpty(res = DiscreteObjectSets.combinationFixSize(input, i)); ++i) {
        }
        return res;
    }

    public static <T> List<List<T>> combinationListMax(T[] array, int target, Function<T, Integer> get) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            throw new IllegalArgumentException("\u4f20\u5165\u6570\u7ec4\u4e3a\u7a7a");
        }
        Arrays.sort(array, Comparator.comparing(get));
        T[] sortedArray = DiscreteObjectSets.filterLessTargetArray(array, target, get);
        List<List<T>> res = new ArrayList<List<T>>();
        Input<T> input = new Input<T>(sortedArray, 0, target, get);
        for (int i = array.length; i > 0 && !CollectionUtils.isNotEmpty(res = DiscreteObjectSets.combinationFixSize(input, i)); --i) {
        }
        return res;
    }

    private static <T> T[] filterLessTargetArray(T[] array, int target, Function<T, Integer> get) {
        int index;
        for (index = 0; index < array.length && get.apply(array[index]) <= target; ++index) {
        }
        return Arrays.copyOf(array, index);
    }

    private static <T> List<List<T>> combinationFixSize(Input<T> input, int fixSize) {
        if (ArrayUtils.isEmpty((Object[])((Input)input).sortedArray)) {
            return Collections.emptyList();
        }
        ArrayList<List<T>> res = new ArrayList<List<T>>();
        DiscreteObjectSets.findCombination(input, new LimitedList(fixSize, ((Input)input).get), res);
        return res;
    }

    private static <T> void recursionFind(Input<T> input, List<T> subset, List<List<T>> res) {
        int tmpI;
        if (((Input)input).target == 0) {
            res.add(new ArrayList<T>(subset));
            return;
        }
        for (int i = ((Input)input).startIdx; i < ((Input)input).sortedArray.length && (tmpI = ((Input)input).getValue(i).intValue()) <= ((Input)input).target; ++i) {
            subset.add(((Input)input).sortedArray[i]);
            Input<Object> newInput = new Input<Object>(((Input)input).sortedArray, i + 1, ((Input)input).target - tmpI, ((Input)input).get);
            DiscreteObjectSets.recursionFind(newInput, subset, res);
            subset.remove(subset.size() - 1);
        }
    }

    private static <T> void findCombination(Input<T> input, LimitedList<T> limitedList, List<List<T>> list) {
        int curVal;
        if (((LimitedList)limitedList).isMatch(((Input)input).target)) {
            list.add(new ArrayList(((LimitedList)limitedList).sub));
            return;
        }
        if (((LimitedList)limitedList).isFull()) {
            return;
        }
        for (int j = ((Input)input).startIdx; !(j >= ((Input)input).sortedArray.length || (curVal = ((Input)input).getValue(j).intValue()) + ((LimitedList)limitedList).sum > ((Input)input).target || curVal + ((LimitedList)limitedList).sum == ((Input)input).target && ((LimitedList)limitedList).isMoreOneLess()); ++j) {
            if (((LimitedList)limitedList).isOneLess() && curVal + ((LimitedList)limitedList).sum != ((Input)input).target) continue;
            ((LimitedList)limitedList).add(((Input)input).sortedArray[j]);
            Input<Object> newInput = new Input<Object>(((Input)input).sortedArray, j + 1, ((Input)input).target, ((Input)input).get);
            DiscreteObjectSets.findCombination(newInput, limitedList, list);
            ((LimitedList)limitedList).remove(((LimitedList)limitedList).sub.size() - 1);
        }
    }

    private static final class LimitedList<T> {
        private final List<T> sub = new ArrayList<T>();
        private final int size;
        private final Function<T, Integer> get;
        private int sum;

        private LimitedList(int size, Function<T, Integer> get) {
            this.size = size;
            this.sum = 0;
            this.get = get;
        }

        private void add(T ele) {
            this.sub.add(ele);
            this.sum += this.get.apply(ele).intValue();
        }

        private void remove(int index) {
            this.sum -= this.get.apply(this.sub.get(index)).intValue();
            this.sub.remove(index);
        }

        private boolean isMatch(int target) {
            return this.sum == target && this.isFull();
        }

        private boolean isFull() {
            return CollectionUtils.size(this.sub) == this.size;
        }

        private boolean isOneLess() {
            return this.size == CollectionUtils.size(this.sub) + 1;
        }

        private boolean isMoreOneLess() {
            return this.size > CollectionUtils.size(this.sub) + 1;
        }
    }

    private static final class Input<T> {
        private final T[] sortedArray;
        private final int startIdx;
        private final int target;
        private final Function<T, Integer> get;

        private Integer getValue(int index) {
            return this.get.apply(this.sortedArray[index]);
        }

        public Input(T[] sortedArray, int startIdx, int target, Function<T, Integer> get) {
            this.sortedArray = sortedArray;
            this.startIdx = startIdx;
            this.target = target;
            this.get = get;
        }
    }
}

