/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.common.Conditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class DiscreteSets {
    private DiscreteSets() {
    }

    public static int min(@NotNull int[] set) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])set));
        return Arrays.stream(set).min().getAsInt();
    }

    public static Integer min(@NotNull int[] data, int startIndex, int endIndex) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])data));
        Conditions.requireArgument(startIndex >= 0);
        Conditions.requireArgument(endIndex > startIndex);
        return DiscreteSets.min(Arrays.copyOfRange(data, startIndex, endIndex));
    }

    public static Integer minWithEnd(@NotNull int[] data, int startIndex, int endIndex) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])data));
        Conditions.requireArgument(startIndex >= 0);
        Conditions.requireArgument(endIndex > startIndex);
        return DiscreteSets.min(Arrays.copyOfRange(data, startIndex, endIndex + 1));
    }

    public static int max(@NotNull int[] set) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])set));
        return Arrays.stream(set).max().getAsInt();
    }

    public static Integer max(@NotNull int[] data, int startIndex, int endIndex) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])data));
        Conditions.requireArgument(startIndex >= 0);
        Conditions.requireArgument(endIndex > startIndex);
        return DiscreteSets.max(Arrays.copyOfRange(data, startIndex, endIndex));
    }

    public static Integer maxWithEnd(@NotNull int[] data, int startIndex, int endIndex) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])data));
        Conditions.requireArgument(startIndex >= 0);
        Conditions.requireArgument(endIndex > startIndex);
        return DiscreteSets.max(Arrays.copyOfRange(data, startIndex, endIndex + 1));
    }

    public static int maxUndulate(@NotNull int[] data) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])data));
        int maxValue = DiscreteSets.max(data);
        int minValue = DiscreteSets.min(data);
        return maxValue - minValue;
    }

    public static int maxUndulate(@NotNull int[] data, int startIndex, int endIndex) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])data));
        Conditions.requireArgument(startIndex >= 0);
        Conditions.requireArgument(endIndex > startIndex);
        int maxValue = DiscreteSets.max(data, startIndex, endIndex);
        int minValue = DiscreteSets.min(data, startIndex, endIndex);
        return maxValue - minValue;
    }

    public static int maxUndulateWithEnd(@NotNull int[] data, int startIndex, int endIndex) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])data));
        Conditions.requireArgument(startIndex >= 0);
        Conditions.requireArgument(endIndex > startIndex);
        int maxValue = DiscreteSets.maxWithEnd(data, startIndex, endIndex);
        int minValue = DiscreteSets.minWithEnd(data, startIndex, endIndex);
        return maxValue - minValue;
    }

    public static List<List<Integer>> combinationAll(int[] array, int target) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((int[])array));
        Arrays.sort(array);
        ArrayList<Integer> subset = new ArrayList<Integer>();
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>();
        DiscreteSets.recursionFind(array, subset, 0, target, res);
        return res;
    }

    public static List<List<Integer>> combinationFixSize(int[] input, int target, int fixSize) {
        return DiscreteSets.combinationFixSize(ArrayUtils.toObject((int[])input), target, fixSize);
    }

    private static List<List<Integer>> combinationFixSize(Integer[] input, int target, int fixSize) {
        if (ArrayUtils.isEmpty((Object[])input)) {
            throw new IllegalArgumentException("\u4f20\u5165\u6570\u7ec4\u4e3a\u7a7a");
        }
        ArrayList<List<Integer>> res = new ArrayList<List<Integer>>();
        DiscreteSets.findCombination(input, new LimitedList(fixSize), 0, target, res);
        return res;
    }

    public static List<List<Integer>> combinationListMin(int[] array, int target) {
        if (ArrayUtils.isEmpty((int[])array)) {
            throw new IllegalArgumentException("\u4f20\u5165\u6570\u7ec4\u4e3a\u7a7a");
        }
        Arrays.sort(array);
        List<List<Integer>> res = new ArrayList<List<Integer>>();
        Integer[] input = (Integer[])IntStream.of(array).filter(ele -> ele < target).boxed().toArray(Integer[]::new);
        for (int i = 1; i < array.length + 1 && !CollectionUtils.isNotEmpty(res = DiscreteSets.combinationFixSize(input, target, i)); ++i) {
        }
        return res;
    }

    public static List<List<Integer>> combinationListMax(int[] array, int target) {
        if (ArrayUtils.isEmpty((int[])array)) {
            throw new IllegalArgumentException("\u4f20\u5165\u6570\u7ec4\u4e3a\u7a7a");
        }
        Arrays.sort(array);
        Integer[] input = (Integer[])IntStream.of(array).filter(ele -> ele < target).boxed().toArray(Integer[]::new);
        List<List<Integer>> res = new ArrayList<List<Integer>>();
        for (int i = array.length; i > 0 && !CollectionUtils.isNotEmpty(res = DiscreteSets.combinationFixSize(input, target, i)); --i) {
        }
        return res;
    }

    private static void recursionFind(int[] array, List<Integer> subset, int startIndex, int target, List<List<Integer>> res) {
        if (target == 0) {
            res.add(new ArrayList<Integer>(subset));
            return;
        }
        for (int i = startIndex; i < array.length && array[i] <= target; ++i) {
            subset.add(array[i]);
            DiscreteSets.recursionFind(array, subset, i + 1, target - array[i], res);
            subset.remove(subset.size() - 1);
        }
    }

    private static void findCombination(Integer[] input, LimitedList limitedList, int startIdx, int target, List<List<Integer>> list) {
        if (limitedList.isMatch(target)) {
            list.add(new ArrayList(limitedList.sub));
            return;
        }
        if (limitedList.isFull()) {
            return;
        }
        for (int j = startIdx; !(j >= input.length || input[j] + limitedList.sum > target || input[j] + limitedList.sum == target && limitedList.isMoreOneLess()); ++j) {
            if (limitedList.isOneLess() && input[j] + limitedList.sum != target) continue;
            limitedList.add(input[j]);
            DiscreteSets.findCombination(input, limitedList, j + 1, target, list);
            limitedList.remove(input[j]);
        }
    }

    private static final class LimitedList {
        private final List<Integer> sub = new ArrayList<Integer>();
        private final int size;
        private int sum;

        private LimitedList(int size) {
            this.size = size;
            this.sum = 0;
        }

        private void add(Integer ele) {
            this.sub.add(ele);
            this.sum += ele.intValue();
        }

        private void remove(Integer ele) {
            this.sub.remove(ele);
            this.sum -= ele.intValue();
        }

        private boolean isMatch(int target) {
            return this.sum == target && this.isFull();
        }

        private boolean isFull() {
            return CollectionUtils.size(this.sub) == this.size;
        }

        private boolean isOneLess() {
            return this.size == CollectionUtils.size(this.sub) + 1;
        }

        private boolean isMoreOneLess() {
            return this.size > CollectionUtils.size(this.sub) + 1;
        }
    }
}

