/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import org.apache.commons.lang3.StringUtils;

public final class NumberValidationUtils {
    private NumberValidationUtils() {
    }

    public static boolean isValueBetween(String value, int minValue, int maxValue) {
        try {
            int intValue = Integer.parseInt(value);
            return intValue >= minValue && intValue <= maxValue;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValueBetween(String value, double minValue, double maxValue) {
        try {
            double doubleValue = Double.parseDouble(value);
            return Double.compare(doubleValue, minValue) >= 0 && Double.compare(doubleValue, maxValue) <= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isOptionalValueBetween(String value, int minValue, int maxValue) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        return NumberValidationUtils.isValueBetween(value, minValue, maxValue);
    }
}

