/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.common.Conditions;
import com.huawei.baize.base.math.Section;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public final class SectionUtils {
    private SectionUtils() {
    }

    public static Section buildSection(double min, double max) {
        return new Section(min, true, max, true);
    }

    public static Section buildSectionEI(double min, double max) {
        return new Section(min, false, max, true);
    }

    public static Section buildSectionIE(double min, double max) {
        return new Section(min, true, max, false);
    }

    public static Section buildSectionEE(double min, double max) {
        return new Section(min, false, max, false);
    }

    public static boolean isBetween(Section section, double value) {
        return section.isBetween(value);
    }

    public static boolean isOverlap(Section section1, Section section2) {
        return Section.isOverlap(section1, section2);
    }

    public static List<Section> merge(@NotNull List<Section> sections) {
        Conditions.requireArgument(CollectionUtils.isNotEmpty(sections));
        return SectionUtils.mergeSortedSections(SectionUtils.sortSectionsByMin(sections));
    }

    public static List<Section> insert(@NotNull List<Section> sections, Section section) {
        sections.add(section);
        return SectionUtils.merge(sections);
    }

    private static List<Section> sortSectionsByMin(List<Section> sections) {
        return sections.stream().sorted(Comparator.comparing(Section::getMin)).collect(Collectors.toList());
    }

    private static List<Section> mergeSortedSections(List<Section> sortedSections) {
        LinkedList<Section> mergedSections = new LinkedList<Section>();
        Section lastSection = sortedSections.get(0);
        for (Section currSection : sortedSections) {
            if (SectionUtils.isOverlap(lastSection, currSection)) {
                lastSection = Section.merge(lastSection, currSection);
                continue;
            }
            mergedSections.add(lastSection);
            lastSection = currSection;
        }
        mergedSections.add(lastSection);
        return mergedSections;
    }
}

