/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math.calculator;

import com.huawei.baize.base.math.calculator.CalculatorProcessor;
import java.util.List;
import java.util.Map;

public final class Calculator {
    private Calculator() {
    }

    public static String calculate(String express) {
        CalculatorProcessor calculator = new CalculatorProcessor();
        String op = Calculator.preProcess(express, calculator.keys, calculator.hashMap);
        return calculator.calculate(op);
    }

    public static long calculateToLong(String express) {
        CalculatorProcessor calculator = new CalculatorProcessor();
        String op = Calculator.preProcess(express, calculator.keys, calculator.hashMap);
        return calculator.calculateToLong(op);
    }

    private static String preProcess(String express, List<String> keys, Map<String, String> hashMap) {
        String op = Calculator.replaceInlineStr(express, keys, hashMap);
        op = op.replaceAll("\\s*", "");
        op = op.replace("(int)", String.valueOf('#'));
        return op;
    }

    private static String replaceInlineStr(String express, List<String> keys, Map<String, String> hashMap) {
        int leftIndex = express.indexOf(34);
        if (leftIndex == -1) {
            return express;
        }
        String otherExp = express.substring(leftIndex + 1);
        int rightIndex = Calculator.findRealRightIndex(otherExp);
        if (rightIndex == -1) {
            throw new IllegalArgumentException("operator is wrong.");
        }
        String preExp = express.substring(0, leftIndex);
        String inlineStr = otherExp.substring(0, rightIndex);
        String nextExp = otherExp.substring(rightIndex + 1);
        String key = keys.isEmpty() ? Calculator.generateNextKey("") : Calculator.generateNextKey(keys.get(keys.size() - 1));
        keys.add(key);
        hashMap.put(key, inlineStr);
        return Calculator.replaceInlineStr(preExp + key + nextExp, keys, hashMap);
    }

    private static int findRealRightIndex(String str) {
        for (int index = 0; index < str.length(); ++index) {
            if (str.charAt(index) != '\"' || index != 0 && str.charAt(index - 1) == '\\') continue;
            return index;
        }
        return -1;
    }

    private static String generateNextKey(String key) {
        return key.isEmpty() ? "a" : String.valueOf((char)(key.charAt(0) + '\u0001'));
    }
}

