/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math.calculator;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

final class LogicOperation {
    private static final LogicOperation[][] LOGIC_OPS = new LogicOperation[][]{{new LogicOperation("&&", Boolean::logicalAnd)}, {new LogicOperation("||", Boolean::logicalOr)}};
    static final List<String> LOGIC_OPERS = Arrays.stream(LOGIC_OPS).flatMap(Arrays::stream).map(LogicOperation::getOper).collect(Collectors.toList());
    private String oper;
    private BiFunction<Boolean, Boolean, Boolean> calc;

    static void calculate(List<String> ops, List<Object> bools) {
        if (CollectionUtils.containsAny(ops, LOGIC_OPERS)) {
            for (LogicOperation[] opers : LOGIC_OPS) {
                int i = 0;
                while (i < ops.size()) {
                    String curOp = ops.get(i);
                    if (Arrays.stream(opers).map(LogicOperation::getOper).anyMatch(oper -> oper.equals(curOp))) {
                        LogicOperation.calcLogicSet(ops, bools, i);
                        continue;
                    }
                    ++i;
                }
            }
        }
    }

    private static void calcLogicSet(List<String> ops, List<Object> obs, int i) {
        String oper = ops.remove(i);
        Boolean lValue = (Boolean)obs.remove(i);
        Boolean rValue = (Boolean)obs.remove(i);
        Boolean result = LogicOperation.cale(lValue, rValue, oper);
        obs.add(i, result);
    }

    private static Boolean cale(Boolean lvalue, Boolean rValue, String op) {
        return Arrays.stream(LOGIC_OPS).flatMap(Arrays::stream).filter(ob -> ob.getOper().equals(op)).findAny().map(ob -> ob.getCalc().apply(lvalue, rValue)).orElseThrow(() -> new IllegalArgumentException("not support: " + op));
    }

    public String getOper() {
        return this.oper;
    }

    public BiFunction<Boolean, Boolean, Boolean> getCalc() {
        return this.calc;
    }

    public LogicOperation(String oper, BiFunction<Boolean, Boolean, Boolean> calc) {
        this.oper = oper;
        this.calc = calc;
    }
}

