/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.regex;

import com.huawei.baize.base.regex.MatchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class RegexMatchUtils {
    private RegexMatchUtils() {
    }

    public static MatchResult firstMatch(String regex, String text) {
        Objects.requireNonNull(regex);
        Objects.requireNonNull(text);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        if (matcher.groupCount() > 0 && matcher.find()) {
            ArrayList<String> res = new ArrayList<String>(matcher.groupCount());
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                res.add(matcher.group(i));
            }
            return new MatchResult(res);
        }
        return new MatchResult(Collections.emptyList());
    }

    public static List<MatchResult> allMatch(String regex, String text) {
        Objects.requireNonNull(regex);
        Objects.requireNonNull(text);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        if (matcher.groupCount() > 0) {
            ArrayList<MatchResult> result = new ArrayList<MatchResult>();
            while (matcher.find()) {
                ArrayList<String> res = new ArrayList<String>(matcher.groupCount());
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    res.add(matcher.group(i));
                }
                result.add(new MatchResult(res));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static boolean contains(String regex, String text) {
        if (StringUtils.isEmpty((CharSequence)regex) || StringUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    public static boolean matches(String regex, String text) {
        if (StringUtils.isEmpty((CharSequence)regex) || StringUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        return Pattern.matches(regex, text);
    }

    public static boolean matches(Pattern regexPattern, String text) {
        if (regexPattern == null || StringUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        return regexPattern.matcher(text).matches();
    }
}

