/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import com.huawei.baize.base.common.Conditions;
import com.huawei.baize.base.math.DigitUtils;
import com.huawei.baize.base.string.StringCheckUtils;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

final class StringHexConvertHelper {
    private static final int TWO = 2;
    private static final int FOUR = 4;
    private static final int NINE = 9;
    private static final int TEN = 10;
    private static final int FIFTEEN = 15;
    private static final int HEX_HIGH = 240;
    private static final int HEX_LOW = 15;

    private StringHexConvertHelper() {
    }

    static String hexStrToStr(String hexStr) throws ParseException {
        Objects.requireNonNull(hexStr);
        Conditions.requireArgument(DigitUtils.isHex(hexStr), "The hexadecimal string is not Hex.");
        String str = new String(StringHexConvertHelper.hexStrToByteArr(hexStr), StandardCharsets.UTF_8);
        if (!StringCheckUtils.isPrintable(str)) {
            throw new ParseException("The hexadecimal string is parsed into unprintable character.", 0);
        }
        return str;
    }

    static String strToHexStr(String str) {
        Objects.requireNonNull(str);
        Conditions.requireArgument(StringCheckUtils.isPrintable(str), "The string contains unprintable character.");
        return StringHexConvertHelper.byteArrToHexStr(str.getBytes(StandardCharsets.UTF_8));
    }

    static byte[] hexStrToByteArr(String hexStr) {
        Objects.requireNonNull(hexStr);
        Conditions.requireArgument(DigitUtils.isHex(hexStr), "The hexadecimal string is not Hex.");
        byte[] data = hexStr.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[data.length >> 1];
        int index = 0;
        int i = 0;
        while (index < data.length / 2) {
            bytes[index++] = (byte)(StringHexConvertHelper.toDecByte(data[i]) << 4 & 0xF0 | StringHexConvertHelper.toDecByte(data[i + 1]));
            i += 2;
        }
        return bytes;
    }

    private static byte toDecByte(byte hexBt) {
        byte bt = hexBt >= 48 && hexBt <= 57 ? (byte)(hexBt - 48) : (hexBt >= 97 && hexBt <= 102 ? (byte)(hexBt - 97 + 10) : (hexBt >= 65 && hexBt <= 70 ? (byte)(hexBt - 65 + 10) : (byte)0));
        return bt;
    }

    static String byteArrToHexStr(byte[] bytes) {
        Conditions.requireArgument(ArrayUtils.isNotEmpty((byte[])bytes), "The byte array must not be null.");
        byte[] data = new byte[bytes.length << 1];
        int index = 0;
        for (byte bt : bytes) {
            data[index++] = StringHexConvertHelper.toHexByte((byte)((bt & 0xF0) >> 4));
            data[index++] = StringHexConvertHelper.toHexByte((byte)(bt & 0xF));
        }
        return new String(data, StandardCharsets.UTF_8);
    }

    private static byte toHexByte(byte decBt) {
        if (decBt >= 0 && decBt <= 9) {
            return (byte)(decBt + 48);
        }
        if (decBt >= 10 && decBt <= 15) {
            return (byte)(decBt + 65 - 10);
        }
        return 36;
    }
}

