/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import com.huawei.baize.base.common.Conditions;
import com.huawei.baize.base.string.StringBuilderHelper;
import com.huawei.baize.base.string.StringSliceUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public final class StringVarCalcUtils {
    private static final int MAX_PARAM = 256;
    private static final ThreadLocal<IndiceArrayBuffer> BUFFER = new ThreadLocal();

    private StringVarCalcUtils() {
    }

    public static <T> String replaceVars(String input, String leftHolder, String rightHolder, Map<String, T> valuesMap, Function<T, String> remappingFunction) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(leftHolder);
        Objects.requireNonNull(rightHolder);
        Objects.requireNonNull(valuesMap);
        Objects.requireNonNull(remappingFunction);
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)leftHolder));
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)rightHolder));
        if (StringUtils.isBlank((CharSequence)input)) {
            return input;
        }
        Indice[] indices = StringVarCalcUtils.getHolderIndiceBuffer();
        int holderCount = StringVarCalcUtils.scanHolders(input, leftHolder, rightHolder, indices);
        if (holderCount == 0) {
            return input;
        }
        return StringVarCalcUtils.replace(input, holderCount, indices, valuesMap, remappingFunction);
    }

    public static <T> Map<String, String> calcSliceVars(String input, String leftHolder, String rightHolder, Map<String, T> valuesMap, Function<T, String> remappingFunction) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(leftHolder);
        Objects.requireNonNull(rightHolder);
        Objects.requireNonNull(valuesMap);
        Objects.requireNonNull(remappingFunction);
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)leftHolder));
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)rightHolder));
        if (StringUtils.isBlank((CharSequence)input)) {
            return Collections.emptyMap();
        }
        Indice[] indices = StringVarCalcUtils.getHolderIndiceBuffer();
        int holderCount = StringVarCalcUtils.scanHolders(input, leftHolder, rightHolder, indices);
        if (holderCount == 0) {
            return Collections.emptyMap();
        }
        return StringVarCalcUtils.calcSlice(input, holderCount, indices, valuesMap, remappingFunction);
    }

    private static <T> String replace(String input, int holderCount, Indice[] indices, Map<String, T> valuesMap, Function<T, String> remappingFunction) {
        StringBuilder sb = StringBuilderHelper.getStringBuilder();
        int prevHolderLocation = 0;
        for (int i = 0; i < holderCount; ++i) {
            Indice indice = indices[i];
            sb.append(input, prevHolderLocation, indice.startIndex);
            String value = remappingFunction.apply(valuesMap.get(indice.var));
            sb.append(value == null ? "" : value);
            prevHolderLocation = indice.endIndex;
        }
        sb.append(input, prevHolderLocation, input.length());
        return sb.toString();
    }

    private static <T> Map<String, String> calcSlice(String input, int holderCount, Indice[] indices, Map<String, T> valuesMap, Function<T, String> remappingFunction) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < holderCount; ++i) {
            Indice indice = indices[i];
            String varExpr = indice.varExpr;
            int start = input.indexOf(91, indice.endIndex);
            if (start != indice.endIndex) continue;
            int end = input.indexOf(93, indice.endIndex);
            String scale = StringUtils.substring((String)input, (int)start, (int)(end + 1));
            if (StringUtils.isBlank((CharSequence)scale)) break;
            String varVal = remappingFunction.apply(valuesMap.get(indice.var));
            String result = varVal == null ? null : StringSliceUtils.slice(varVal, scale);
            map.put(varExpr + scale, result);
        }
        return map;
    }

    private static Indice[] getHolderIndiceBuffer() {
        IndiceArrayBuffer indiceArrayBuffer = BUFFER.get();
        if (indiceArrayBuffer == null) {
            BUFFER.set(new IndiceArrayBuffer(256));
            indiceArrayBuffer = BUFFER.get();
        }
        return indiceArrayBuffer.getIndices();
    }

    private static int scanHolders(String input, String leftHolder, String rightHolder, Indice[] indices) {
        int totalLen = input.length();
        int leftHolderLen = leftHolder.length();
        int rightHolderLen = rightHolder.length();
        int holderCount = 0;
        for (int idx = 0; idx < totalLen; ++idx) {
            int endIndex;
            char curChar = input.charAt(idx);
            if (curChar != leftHolder.charAt(0) || !StringVarCalcUtils.matchRemainingHolder(input, idx + 1, leftHolder) || (endIndex = StringVarCalcUtils.findRightHolder(input, idx + leftHolderLen, rightHolder)) == -1) continue;
            if (indices[holderCount] == null) {
                indices[holderCount] = new Indice();
            }
            indices[holderCount].startIndex = idx;
            indices[holderCount].endIndex = endIndex;
            indices[holderCount].var = input.substring(idx + leftHolderLen, endIndex - rightHolderLen);
            indices[holderCount].varExpr = leftHolder + indices[holderCount].var + rightHolder;
            ++holderCount;
            idx = endIndex - 1;
        }
        return holderCount;
    }

    private static int findRightHolder(String input, int startIndex, String rightHolder) {
        int inputLen = input.length();
        int rightHolderLen = rightHolder.length();
        for (int i = startIndex; i < inputLen; ++i) {
            char curChar = input.charAt(i);
            if (curChar != rightHolder.charAt(0) || !StringVarCalcUtils.matchRemainingHolder(input, i + 1, rightHolder)) continue;
            return i + rightHolderLen;
        }
        return -1;
    }

    private static boolean matchRemainingHolder(String input, int startIndex, String holder) {
        int idx;
        int remainingHolderLen = holder.length() - 1;
        if (remainingHolderLen == 0) {
            return true;
        }
        if (startIndex + remainingHolderLen > input.length()) {
            return false;
        }
        for (idx = 0; idx < remainingHolderLen && input.charAt(startIndex + idx) == holder.charAt(idx + 1); ++idx) {
        }
        return idx == remainingHolderLen;
    }

    private static class Indice {
        private int startIndex;
        private int endIndex;
        private String var;
        private String varExpr;

        private Indice() {
        }
    }

    private static class IndiceArrayBuffer {
        private final Indice[] indices;

        IndiceArrayBuffer(int len) {
            this.indices = new Indice[len];
        }

        Indice[] getIndices() {
            return this.indices;
        }
    }
}

