/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.utils;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.channel.config.entity.InternetParams;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.https.entity.HttpProxy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetInfoKeeper {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternetInfoKeeper.class);
    private static final InternetInfoKeeper INSTANCE = new InternetInfoKeeper();
    private static final String IS_USE_PROXY = "channel.internet.proxy.isUse";
    private static final String PROXY_SERVER = "channel.internet.proxy.server";
    private static final String PROXY_TYPE = "channel.internet.proxy.type";
    private static final String PROXY_PORT = "channel.internet.proxy.port";
    private static final String PROXY_ACCOUNT = "channel.internet.proxy.account";
    private static final String PROXY_PASSSTR = "channel.internet.proxy.password";
    private static final String PROXY_FILE_NAME = "callhome_internet_proxy.properties";
    private InternetParams internetParams = null;
    private Properties internetPro = null;
    private final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternetInfoKeeper() {
        Object object = this.lock = new Object();
        synchronized (object) {
            this.initInternetInfo();
        }
    }

    public static InternetInfoKeeper getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInternetInfo() {
        this.internetParams = new InternetParams();
        this.internetPro = new Properties();
        File setupFile = this.retrieveFile();
        if (null == setupFile) {
            LOGGER.error("get cert key file failed.");
            return;
        }
        BufferedInputStream is = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(setupFile);
            is = new BufferedInputStream(fileInputStream);
            this.internetPro.load(is);
            this.internetParams.setUseProxy(HttpsPropUtils.parseBoolean(this.internetPro, IS_USE_PROXY, false));
            HttpProxy httpProxy = new HttpProxy();
            httpProxy.setType(this.getProxyType(HttpsPropUtils.parseString(this.internetPro, PROXY_TYPE, "")));
            httpProxy.setHost(HttpsPropUtils.parseString(this.internetPro, PROXY_SERVER, ""));
            httpProxy.setPort(HttpsPropUtils.parsePort(this.internetPro, PROXY_PORT));
            httpProxy.setUserName(HttpsPropUtils.parseString(this.internetPro, PROXY_ACCOUNT, ""));
            String proxyPwd = HttpsPropUtils.parseString(this.internetPro, PROXY_PASSSTR, "");
            httpProxy.setPassword(AESEncrypt.decrypt((String)proxyPwd));
            this.internetParams.setHttpProxy(httpProxy);
            this.internetPro.clear();
        }
        catch (IOException e) {
            try {
                LOGGER.error("create alarm setup file stream error! IOException");
                this.internetPro.clear();
            }
            catch (Throwable throwable) {
                this.internetPro.clear();
                StreamUtils.closeResource(null, is);
                StreamUtils.closeResource(null, (Closeable)fileInputStream);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)is);
            StreamUtils.closeResource(null, (Closeable)fileInputStream);
            return;
        }
        StreamUtils.closeResource(null, (Closeable)is);
        StreamUtils.closeResource(null, (Closeable)fileInputStream);
    }

    private HttpProxy.ProxyType getProxyType(String proxyTypestr) {
        for (HttpProxy.ProxyType proxyType : HttpProxy.ProxyType.values()) {
            if (!proxyType.name().equals(proxyTypestr)) continue;
            return proxyType;
        }
        return HttpProxy.ProxyType.HTTP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveInternetParams(InternetParams internetParam) {
        File internetFile = this.retrieveFile();
        if (internetFile == null) {
            return false;
        }
        BufferedOutputStream out = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(internetFile);
            out = new BufferedOutputStream(fileOutputStream);
            if (null != this.internetPro) {
                this.internetPro.setProperty(IS_USE_PROXY, String.valueOf(internetParam.isUseProxy()));
                HttpProxy httpProxy = internetParam.getHttpProxy();
                this.internetPro.setProperty(PROXY_TYPE, httpProxy.getType().name());
                this.internetPro.setProperty(PROXY_SERVER, httpProxy.getHost());
                this.internetPro.setProperty(PROXY_PORT, String.valueOf(httpProxy.getPort()));
                this.internetPro.setProperty(PROXY_ACCOUNT, httpProxy.getUserName());
                String encryptProxyStr = AESEncrypt.encrypt((String)httpProxy.getPassword());
                if (StringUtils.isNULLStr((String)encryptProxyStr)) {
                    encryptProxyStr = "";
                }
                this.internetPro.setProperty(PROXY_PASSSTR, encryptProxyStr);
                this.internetPro.store(out, "");
            }
            if (null != this.internetPro) {
                this.internetPro.clear();
            }
        }
        catch (IOException e) {
            boolean bl;
            block9: {
                try {
                    LOGGER.error("open alarm setup file outputstream failed!IOException");
                    bl = false;
                    if (null == this.internetPro) break block9;
                    this.internetPro.clear();
                }
                catch (Throwable throwable) {
                    if (null != this.internetPro) {
                        this.internetPro.clear();
                    }
                    StreamUtils.closeResource(out, out);
                    StreamUtils.closeResource((Flushable)fileOutputStream, (Closeable)fileOutputStream);
                    throw throwable;
                }
            }
            StreamUtils.closeResource((Flushable)out, (Closeable)out);
            StreamUtils.closeResource((Flushable)fileOutputStream, (Closeable)fileOutputStream);
            return bl;
        }
        StreamUtils.closeResource((Flushable)out, (Closeable)out);
        StreamUtils.closeResource((Flushable)fileOutputStream, (Closeable)fileOutputStream);
        this.internetParams = internetParam;
        return true;
    }

    private File retrieveFile() {
        try {
            String filePath = this.getInterInfoFilePath();
            if (StringUtils.isNULLStr((String)filePath)) {
                return null;
            }
            File setFile = new File(filePath);
            if (setFile.exists()) {
                return setFile;
            }
            boolean result = false;
            if (!setFile.getParentFile().exists() && !(result = setFile.getParentFile().mkdirs())) {
                return null;
            }
            result = setFile.createNewFile();
            if (result) {
                return setFile;
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.error("retrieve alarm setup file failed! IOException");
            return null;
        }
    }

    private String getInterInfoFilePath() throws IOException {
        File curWorkPath = HttpsPropUtils.getCurrWorkPath();
        if (null == curWorkPath) {
            return null;
        }
        String filePath = new StringBuffer().append(curWorkPath.getCanonicalPath()).append(File.separator).append("tmp").append(File.separator).append(PROXY_FILE_NAME).toString();
        return filePath;
    }

    public InternetParams getInternetParams() {
        return this.internetParams;
    }

    public boolean isNonProxy(String url) {
        if (null == this.internetParams || !this.internetParams.isUseProxy() || this.internetParams.getHttpProxy() == null) {
            return false;
        }
        String nonProxyServer = HttpsPropUtils.getPropValue("channel.internet.proxy.nonProxyServer", null);
        String hostname = this.internetParams.getHttpProxy().getHost();
        boolean isHostMatch = InternetInfoKeeper.isMatch(hostname, nonProxyServer);
        String nonProxyHosts = HttpsPropUtils.getPropValue("channel.internet.proxy.nonProxyHosts", null);
        return isHostMatch && InternetInfoKeeper.isMatch(url, nonProxyHosts);
    }

    private static boolean isMatch(String url, String matchFor) {
        String[] nphArr = null;
        if (!StringUtils.isNULLObjectOrNullStr((String)matchFor)) {
            nphArr = matchFor.split(":");
        }
        if (nphArr == null || nphArr.length == 0) {
            return false;
        }
        for (String nph : nphArr) {
            String tmp = nph;
            int idx = tmp.indexOf(42);
            if (idx != -1) {
                tmp = tmp.substring(idx + 1);
            }
            if (url.indexOf(tmp) == -1) continue;
            return true;
        }
        return false;
    }
}

