/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.constants;

import com.huawei.netcareinsidesdk.utils.LanguageManager;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum RiskLevelEnum {
    LOW(0, "Low", "\u4f4e\u98ce\u9669"),
    MID(1, "Medium", "\u4e2d\u98ce\u9669"),
    HIGH(2, "High", "\u9ad8\u98ce\u9669");

    private Integer riskCode;
    private String riskEn;
    private String riskCn;

    private RiskLevelEnum(Integer riskCode, String riskEn, String riskCn) {
        this.riskCode = riskCode;
        this.riskEn = riskEn;
        this.riskCn = riskCn;
    }

    public static Integer getRiskCodeByEn(String riskEn) {
        for (RiskLevelEnum riskLevelEnum : RiskLevelEnum.values()) {
            if (!StringUtils.equals((CharSequence)riskLevelEnum.riskEn, (CharSequence)riskEn)) continue;
            return riskLevelEnum.riskCode;
        }
        return null;
    }

    public static String getRiskCnByCode(Integer riskCode) {
        for (RiskLevelEnum riskLevelEnum : RiskLevelEnum.values()) {
            if (riskLevelEnum.riskCode.equals(riskCode) && LanguageManager.isEnglish()) {
                return riskLevelEnum.riskEn;
            }
            if (!riskLevelEnum.riskCode.equals(riskCode) || LanguageManager.isEnglish()) continue;
            return riskLevelEnum.riskCn;
        }
        return null;
    }

    public static RiskLevelEnum getRiskEnumByCode(Integer riskCode) {
        if (Objects.isNull(riskCode)) {
            return null;
        }
        for (RiskLevelEnum riskLevelEnum : RiskLevelEnum.values()) {
            if (!riskLevelEnum.riskCode.equals(riskCode)) continue;
            return riskLevelEnum;
        }
        return null;
    }

    public Integer getRiskCode() {
        return this.riskCode;
    }

    public String getRiskEn() {
        return this.riskEn;
    }

    public String getRiskCn() {
        return this.riskCn;
    }
}

