/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.schedule;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.ScheduleTaskBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.dao.EngineeringCommissioningNesMapper;
import com.huawei.netcareinsidesdk.dao.ScheduleTaskDao;
import com.huawei.netcareinsidesdk.dao.SysConfigDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dto.InterceptLogDto;
import com.huawei.netcareinsidesdk.swingservice.NELoginSwingService;
import com.huawei.netcareinsidesdk.utils.CommonDataDeal;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableScheduling
public class CommonScheduleTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonScheduleTask.class);
    private static Map<String, String> agingTableMap = new HashMap<String, String>();
    private static List<String> agingTableList;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private EngineeringCommissioningNesMapper nesMapper;
    @Autowired
    private ScheduleTaskDao scheduleTaskDao;
    @Autowired
    private NELoginSwingService neLoginService;
    @Autowired
    private SysConfigDao sysConfigDao;
    @Autowired
    private CommonDataDeal commonDataDeal;

    @Scheduled(cron="0 */30 * * * ?")
    public void scheduleReportInterceptLog() {
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        if (!hasConnectedClient.get("isConnected").booleanValue()) {
            LOGGER.info("scheduleReportInterceptLog start.");
            List<ScheduleTaskBo> scheduleTaskBoList = this.scheduleTaskDao.queryByModuleName("interceptLog");
            if (!CollectionUtils.isEmpty(scheduleTaskBoList)) {
                ArrayList<InterceptLogDto> logList = new ArrayList<InterceptLogDto>();
                int infoId = 1;
                for (ScheduleTaskBo scheduleTaskBo2 : scheduleTaskBoList) {
                    InterceptLogDto interceptLogDto = (InterceptLogDto)JSONObject.parseObject((String)scheduleTaskBo2.getParam(), InterceptLogDto.class);
                    interceptLogDto.setInfoId(String.valueOf(infoId));
                    scheduleTaskBo2.setAdditionalField(String.valueOf(infoId));
                    logList.add(interceptLogDto);
                    ++infoId;
                }
                List<String> failedIds = this.neLoginService.reportLogToNetCare(logList, new ArrayList<ScheduleTaskBo>());
                ArrayList<Integer> successIds = new ArrayList<Integer>();
                ArrayList<ScheduleTaskBo> failedTaskList = new ArrayList<ScheduleTaskBo>();
                scheduleTaskBoList.forEach(scheduleTaskBo -> {
                    if (failedIds.contains(scheduleTaskBo.getAdditionalField())) {
                        scheduleTaskBo.setUploadNum(scheduleTaskBo.getUploadNum() + 1);
                        scheduleTaskBo.setUploadTime(DateUtil.getUtcDate(new Date()));
                        failedTaskList.add((ScheduleTaskBo)scheduleTaskBo);
                    } else {
                        successIds.add(scheduleTaskBo.getId());
                    }
                });
                if (!CollectionUtils.isEmpty(successIds)) {
                    this.scheduleTaskDao.batchDelete(successIds);
                    LOGGER.info("Report {} log success, batchDelete Scheduled Task end", (Object)successIds.size());
                }
                if (!CollectionUtils.isEmpty(failedTaskList)) {
                    this.scheduleTaskDao.batchUpdate(failedTaskList);
                    LOGGER.info("Report {} log failed, batchUpdate Scheduled Task end", (Object)failedTaskList.size());
                }
            }
            LOGGER.info("scheduleReportInterceptLog end.");
        }
    }

    @Scheduled(fixedDelay=10000L)
    public void syncTaskStatus() {
        LOGGER.info("SyncTaskStatus.syncTaskStatus start.");
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        if (hasConnectedClient.get("isConnected").booleanValue() || hasConnectedClient.get("isTelnet").booleanValue()) {
            LOGGER.info("Connected to the front-end processor/iNet client successfully.");
            UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
            if (Objects.isNull(userAuthenticateInfoBo)) {
                LOGGER.error("The current effective user does not exist!");
                return;
            }
            this.commonDataDeal.synTaskStatusFromClient(userAuthenticateInfoBo);
        }
        LOGGER.info("SyncTaskStatus.syncTaskStatus end.");
    }

    @Scheduled(cron="0 0 6 1 * ?")
    public void agingTableData() {
        LOGGER.info("CommonScheduleTask agingTableData start.");
        Date agingDate = this.agingDate();
        LOGGER.info("agingTableData agingDate: {}", (Object)agingDate);
        List<String> taskIdList = this.taskInfoDao.queryAgingTaskIdList(agingDate);
        LOGGER.info("agingTableData taskIdList: {}", (Object)JSONObject.toJSONString(taskIdList));
        if (!CollectionUtils.isEmpty(taskIdList)) {
            for (String string : agingTableList) {
                this.sysConfigDao.deleteAgingDataByTaskId(string, taskIdList);
            }
        }
        for (Map.Entry entry : agingTableMap.entrySet()) {
            this.sysConfigDao.deleteAgingDateByTime(agingDate, (String)entry.getKey(), (String)entry.getValue());
        }
        LOGGER.info("CommonScheduleTask agingTableData end.");
    }

    private Date agingDate() {
        String agingDay = this.sysConfigDao.querySysConfig("agingDay");
        LOGGER.info("agingDay:{}", (Object)agingDay);
        long time = (long)(Integer.parseInt(agingDay) * 24 * 60 * 60) * 1000L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = simpleDateFormat.format(new Date(System.currentTimeMillis() - time));
        return DateUtil.stringToDate(format, "yyyy-MM-dd HH:mm:ss");
    }

    static {
        agingTableMap.put("T_OPERATION_RECORD ", "OPERATE_TIME");
        agingTableList = Arrays.asList("T_TASK_INFO", "T_TASK_SUBTYPE_INFO", "T_ACCOUNT_LOGIN_CHECK_RECORD", "T_CRT_SCHEME_COMMAND_INFO", "T_DATACOM_NETWORK_TIED_INTERCEPT_RECORD", "T_DOT_INFO", "T_ENGINEERING_COMMISSIONING_NES", "T_HIGH_RISK_INTERCEPT_RECORD", "T_TASK_ACCOUNT_BOUND", "T_VERIFY_CODE_RECORD");
    }
}

