/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.service.command.impl;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.BlockListMenuInfoBo;
import com.huawei.netcareinsidesdk.bo.CommandBo;
import com.huawei.netcareinsidesdk.bo.CrtSchemeCommandInfoBo;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.HighRiskCommandInfoBo;
import com.huawei.netcareinsidesdk.bo.HighRiskFullCommandBo;
import com.huawei.netcareinsidesdk.bo.HighRiskInterceptRecordBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.TaskSubtypeBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.WhiteListCommandInfoBo;
import com.huawei.netcareinsidesdk.bo.WhiteListMenuInfoBo;
import com.huawei.netcareinsidesdk.constants.CommandTypeEnum;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.InitManageControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.InsidePolicyEnum;
import com.huawei.netcareinsidesdk.constants.InterceptPolicyEnum;
import com.huawei.netcareinsidesdk.constants.OperatePermissionEnum;
import com.huawei.netcareinsidesdk.constants.PostInterceptModeEnum;
import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.constants.TaskSubtypeEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.BlockListMenuInfoDao;
import com.huawei.netcareinsidesdk.dao.CrtSchemeCommandInfoMapper;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.HighRiskCommandInfoDao;
import com.huawei.netcareinsidesdk.dao.HighRiskFullCommandDao;
import com.huawei.netcareinsidesdk.dao.HighRiskInterceptRecordDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.TaskSubtypeDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.WhiteListCommandInfoDao;
import com.huawei.netcareinsidesdk.dao.WhiteListMenuInfoDao;
import com.huawei.netcareinsidesdk.service.command.CommandServiceForSdk;
import com.huawei.netcareinsidesdk.swing.pageService.CommonTipsPage;
import com.huawei.netcareinsidesdk.swing.pageService.HighRiskUnlockPage;
import com.huawei.netcareinsidesdk.swing.pageService.WorkOrderDelayErrorPage;
import com.huawei.netcareinsidesdk.swing.pageService.WorkOrderDelayPage;
import com.huawei.netcareinsidesdk.swing.pageService.WorkOrderErrorPage;
import com.huawei.netcareinsidesdk.swingservice.CommandSwingService;
import com.huawei.netcareinsidesdk.utils.CommonDataDeal;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.HighRiskInterceptRecordQueryVo;
import com.huawei.netcareinsidesdk.vo.InterceptCommandVo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommandServiceForSdkImpl
implements CommandServiceForSdk {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandServiceForSdkImpl.class);
    private String taskOldId = "";
    private String taskId = "";
    private static List<HighRiskCommandInfoBo> highRiskCommandInfoBos = new ArrayList<HighRiskCommandInfoBo>();
    private static List<WhiteListCommandInfoBo> whiteListCommandInfoBos = new ArrayList<WhiteListCommandInfoBo>();
    private static List<BlockListMenuInfoBo> blockMenuListCache = new ArrayList<BlockListMenuInfoBo>();
    private static List<WhiteListMenuInfoBo> whiteMenuListCache = new ArrayList<WhiteListMenuInfoBo>();
    @Autowired
    private HighRiskCommandInfoDao highRiskCommandInfoDao;
    @Autowired
    private HighRiskInterceptRecordDao highRiskInterceptRecordDao;
    @Autowired
    private WhiteListCommandInfoDao whiteListCommandInfoDao;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TaskSubtypeDao subtypeDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private HighRiskFullCommandDao fullCommandForSdkDao;
    @Autowired
    private CrtSchemeCommandInfoMapper crtSchemeCommandInfoMapper;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private HighRiskUnlockPage highRiskUnlockPage;
    @Autowired
    private WorkOrderErrorPage workOrderErrorPage;
    @Autowired
    private WorkOrderDelayPage workOrderDelayPage;
    @Autowired
    private WorkOrderDelayErrorPage workOrderDelayErrorPage;
    @Autowired
    private CommandSwingService commandSwingService;
    @Autowired
    private BlockListMenuInfoDao blockListMenuInfoDao;
    @Autowired
    private WhiteListMenuInfoDao whiteListMenuInfoDao;
    @Autowired
    private DeviceInfoDao deviceInfoDao;
    @Autowired
    private CommonTipsPage commonTipsPage;
    @Autowired
    private CommonDataDeal commonDataDeal;

    @Override
    public Result checkCommandExecute(CommandBo commandBo) {
        LOGGER.info("CommandServiceForSdkImpl checkCommandExecute start {}", (Object)JSONObject.toJSONString((Object)commandBo));
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (ObjectUtils.isEmpty((Object)userAuthenticateInfoBo)) {
            return Result.fail(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorMessage());
        }
        if (this.commonDataDeal.isExpired(userAuthenticateInfoBo)) {
            LOGGER.error(ErrorCodeEnum.USER_INFO_EXPIRED_ERROR.getErrorMessage());
            return Result.fail(ErrorCodeEnum.USER_INFO_EXPIRED_ERROR.getErrorCode(), ErrorCodeEnum.USER_INFO_EXPIRED_ERROR.getErrorMessage());
        }
        Result checkResult = this.checkUserPermission(commandBo, userAuthenticateInfoBo);
        if (checkResult != null) {
            return checkResult;
        }
        if (StringUtils.isNotEmpty((CharSequence)userAuthenticateInfoBo.getInitManageControlPolicy()) && !InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode().equals(userAuthenticateInfoBo.getInitManageControlPolicy())) {
            LOGGER.info("userAuthenticateInfoBo getInitManageControlPolicy is {}.", (Object)userAuthenticateInfoBo.getInitManageControlPolicy());
            return this.putResult("0", "", "");
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(null, userAuthenticateInfoBo.getLoginAccount());
        if (ObjectUtils.isEmpty((Object)taskInfoBo)) {
            LOGGER.error(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorMessage());
            return Result.fail(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorMessage());
        }
        Result result = this.checkTaskIsOrNotExpire(taskInfoBo);
        if (Objects.nonNull(result)) {
            return result;
        }
        Result returnResult = this.checkIsOrNotCrtFutureTask(taskInfoBo);
        if (Objects.nonNull(returnResult)) {
            return returnResult;
        }
        this.updateCommandCache(commandBo, userAuthenticateInfoBo, taskInfoBo);
        if (CollectionUtils.isEmpty(commandBo.getCommand()) || StringUtils.isEmpty((CharSequence)taskInfoBo.getInterceptPolicy()) || InterceptPolicyEnum.NO_INTERCEPT.getValue().equals(taskInfoBo.getInterceptPolicy())) {
            LOGGER.info("CommandServiceForSdkImpl getInterceptPolicy {}.", (Object)InterceptPolicyEnum.NO_INTERCEPT.getValue());
            return this.putResult("0", "", "");
        }
        return this.getResult(commandBo, userAuthenticateInfoBo, taskInfoBo);
    }

    private Result checkUserPermission(CommandBo commandBo, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        if (StringUtils.isNotBlank((CharSequence)commandBo.getCommandTypeEnum().getType()) && commandBo.getCommandTypeEnum() == CommandTypeEnum.MENUS && StringUtils.equals((CharSequence)userAuthenticateInfoBo.getOperatePermission(), (CharSequence)OperatePermissionEnum.SELECT.getValueEn())) {
            int count = this.blockListMenuInfoDao.queryCommandCountByHighRiskMenu(commandBo.getCommand());
            if (count > 0) {
                LOGGER.info("{} no permission to operation.", commandBo.getCommand());
                this.commonTipsPage.commonTipsPage(ToolMainFrameManager.getInstance().getCurMainFrame(), "OPERATE_PERMISSION_FAILED");
                return this.putResult("4", "Your account has only the query permission and cannot use this menu.", "");
            }
            LOGGER.info("blockListMenuInfo Does not contain {}. select permission, bypass the menu.", commandBo.getCommand());
            return this.putResult("0", "", "");
        }
        return null;
    }

    private void updateCommandCache(CommandBo commandBo, UserAuthenticateInfoBo userAuthenticateInfoBo, TaskInfoBo taskInfoBo) {
        if (StringUtils.equals((CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), (CharSequence)taskInfoBo.getTaskType()) && Objects.isNull(this.subtypeDao.queryTaskSubtype(taskInfoBo.getTaskId())) && DateUtil.getUtcDate(new Date()).after(taskInfoBo.getOperationPreparationTime()) && DateUtil.getUtcDate(new Date()).before(taskInfoBo.getTaskStartTime())) {
            this.setOperationPreparationPolicy(userAuthenticateInfoBo, taskInfoBo);
        }
        if (commandBo.getCommandTypeEnum() == CommandTypeEnum.MENUS) {
            this.initializeMenuCache(userAuthenticateInfoBo, taskInfoBo);
        } else {
            this.initializeCommandCache(userAuthenticateInfoBo, taskInfoBo);
        }
        this.taskOldId = taskInfoBo.getTaskId();
        LOGGER.info("CommandServiceForSdkImpl checkCommandExecute {}.", (Object)taskInfoBo.getTaskId());
    }

    private void setOperationPreparationPolicy(UserAuthenticateInfoBo userAuthenticateInfoBo, TaskInfoBo taskInfoBo) {
        String insidePolicy = userAuthenticateInfoBo.getOperationPreparationInsidePolicy();
        if (Objects.nonNull(insidePolicy)) {
            taskInfoBo.setInterceptPolicy(InsidePolicyEnum.getPolicyByCode(insidePolicy).getInterceptPolicyEnum().getValue());
            RiskLevelEnum riskLevelEnum = InsidePolicyEnum.getPolicyByCode(insidePolicy).getRiskLevelEnum();
            taskInfoBo.setRiskLevel(Objects.isNull((Object)riskLevelEnum) ? null : riskLevelEnum.getRiskCode());
        } else {
            taskInfoBo.setInterceptPolicy(InterceptPolicyEnum.BLOCKLIST.getValue());
        }
    }

    @Override
    public Result queryCommandExecute(String guid) {
        LOGGER.info("CommandServiceForSdkImpl guid {}.", (Object)guid);
        HighRiskInterceptRecordBo recordBo = this.highRiskInterceptRecordDao.queryHighRiskInterceptRecordByGuid(guid);
        LOGGER.info("CommandServiceForSdkImpl highRiskInterceptRecordBos {}.", (Object)JSONObject.toJSONString((Object)recordBo));
        ArrayList commandVos = new ArrayList();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("resultCode", "0");
        if (Objects.nonNull(recordBo)) {
            List inputCommands = JSONObject.parseArray((String)recordBo.getInputCommand(), String.class);
            inputCommands.forEach(command -> {
                InterceptCommandVo interceptCommandVo = new InterceptCommandVo();
                interceptCommandVo.setInputCommand((String)command);
                interceptCommandVo.setPostInterceptMode(recordBo.getPostInterceptMode());
                commandVos.add(interceptCommandVo);
            });
            LOGGER.info("CommandServiceForSdkImpl commandVos {}.", (Object)JSONObject.toJSONString(commandVos));
            result.put("resultMessage", commandVos);
            return Result.success(result);
        }
        LOGGER.info("CommandServiceForSdkImpl commandVos {}.", (Object)JSONObject.toJSONString(commandVos));
        result.put("resultMessage", commandVos);
        return Result.success(result);
    }

    @Override
    public Result queryInterceptionOperation(String guid) {
        LOGGER.info("queryInterceptionOperation guid {}.", (Object)guid);
        if (StringUtils.isBlank((CharSequence)guid)) {
            return Result.fail(ErrorCodeEnum.PARAM_CAN_NOT_EMPTY.getErrorCode(), ErrorCodeEnum.PARAM_CAN_NOT_EMPTY.getErrorMessage());
        }
        HighRiskInterceptRecordBo recordBo = this.highRiskInterceptRecordDao.queryHighRiskInterceptRecordByGuid(guid);
        if (ObjectUtils.isEmpty((Object)recordBo)) {
            LOGGER.error("The highRiskInterceptRecord data is empty for {}.", (Object)guid);
            return Result.fail(ErrorCodeEnum.INTERCEPTION_OPERATION_RECORD_ERROR.getErrorCode(), ErrorCodeEnum.INTERCEPTION_OPERATION_RECORD_ERROR.getErrorMessage());
        }
        LOGGER.info("queryInterceptionOperation highRiskInterceptRecordBos {}.", (Object)JSONObject.toJSONString((Object)recordBo));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("closeType", recordBo.getPostInterceptMode());
        result.put("guid", guid);
        return Result.success(result);
    }

    private Result checkIsOrNotCrtFutureTask(TaskInfoBo curTaskInfo) {
        TaskSubtypeBo taskSubtypeBo;
        if (DateUtil.getUtcDate(new Date()).before(curTaskInfo.getTaskStartTime()) && ObjectUtils.isNotEmpty((Object)(taskSubtypeBo = this.subtypeDao.queryTaskSubtype(curTaskInfo.getTaskId()))) && TaskSubtypeEnum.EASY_CRT_TYPE.getCode().equals(taskSubtypeBo.getTaskSubtype())) {
            this.workOrderErrorPage.drawCrtTaskError();
            return this.putResult("2", "Order execution time is not reached?taskId=" + curTaskInfo.getTaskId(), "");
        }
        return null;
    }

    private Result checkTaskIsOrNotExpire(TaskInfoBo taskInfoBo) {
        LOGGER.info("Start checkTaskIsOrNotExpire");
        if (DateUtil.getUtcDate(new Date()).after(taskInfoBo.getTaskEndTime())) {
            if (!StringUtils.equals((CharSequence)taskInfoBo.getTaskObtainMode(), (CharSequence)"\u672c\u5730\u81ea\u5efa") && StringUtils.equalsIgnoreCase((CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeEn(), (CharSequence)taskInfoBo.getTaskType()) && (Objects.isNull(taskInfoBo.getDelayNum()) || taskInfoBo.getDelayNum() < 2)) {
                Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
                this.taskDelayPage(taskInfoBo, hasConnectedClient.get("isConnected"));
                LOGGER.info("NetworkChange task {} need to delay.", (Object)taskInfoBo.getTaskId());
                return this.putResult("3", "The page for work order delay is displayed.", "");
            }
            this.workOrderDelayErrorPage.drawError();
            return this.putResult("2", "Work Order Expired?taskId=" + taskInfoBo.getTaskId(), "");
        }
        LOGGER.info("End checkTaskIsOrNotExpire");
        return null;
    }

    private void taskDelayPage(TaskInfoBo taskInfoBo, boolean isConnected) {
        if (isConnected) {
            this.workOrderDelayPage.drawWorkOrderDelayOnlinePage(taskInfoBo.getTaskId());
        } else {
            this.workOrderDelayPage.drawWorkOrderDelayOfflinePage(taskInfoBo.getTaskId());
        }
    }

    private Result getResult(CommandBo commandBo, UserAuthenticateInfoBo userAuthenticateInfoBo, TaskInfoBo taskInfoBo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Result checkResult = commandBo.getCommandTypeEnum() == CommandTypeEnum.MENUS ? this.checkMenu(commandBo, taskInfoBo) : this.checkCommand(commandBo, userAuthenticateInfoBo, taskInfoBo, result);
        if (checkResult != null) {
            return checkResult;
        }
        List<String> commands = this.highRiskInterceptRecordDao.queryUnlockCommands(taskInfoBo.getTaskId(), PostInterceptModeEnum.UNLOCK.getValue());
        HashSet hashSet = new HashSet();
        if (!commands.isEmpty()) {
            commands.forEach(comm -> commandBo.getCommand().forEach(command -> {
                if (comm.contains((CharSequence)command)) {
                    hashSet.add(command);
                }
            }));
        }
        result.put("resultCode", "0");
        result.put("resultMessage", hashSet);
        return Result.success(result);
    }

    private Result checkCommand(CommandBo commandBo, UserAuthenticateInfoBo userAuthenticateInfoBo, TaskInfoBo taskInfoBo, HashMap<String, Object> result) {
        String guid = UUID.randomUUID().toString();
        int num = 0;
        if (InterceptPolicyEnum.BLOCKLIST.getValue().equals(taskInfoBo.getInterceptPolicy()) && (num = this.checkCommandHighRiskCommand(commandBo.getCommand(), taskInfoBo, guid, userAuthenticateInfoBo.getLoginAccount())) > 0) {
            result.put("resultCode", "1");
            result.put("resultMessage", "The page for black command interception policy is displayed.");
            HighRiskInterceptRecordBo highRiskIntercept = this.getHighRiskInterceptRecordVos(guid);
            List inputCommands = JSONObject.parseArray((String)highRiskIntercept.getInputCommand(), String.class);
            List fullCommands = JSONObject.parseArray((String)highRiskIntercept.getFullCommand(), String.class);
            this.highRiskUnlockPage.getHighRiskUnlockFrame(false, false, String.join((CharSequence)",", inputCommands), String.join((CharSequence)",", fullCommands), guid);
            result.put("guid", guid);
            return Result.success(result);
        }
        if (InterceptPolicyEnum.WHITELIST.getValue().equals(taskInfoBo.getInterceptPolicy())) {
            ArrayList<String> inputCommand = new ArrayList<String>();
            ArrayList<String> fullCommand = new ArrayList<String>();
            ArrayList<String> regex = new ArrayList<String>();
            for (String command : commandBo.getCommand()) {
                num = this.checkCommandWhiteListCommand(command);
                if (num != 0) continue;
                inputCommand.add(command);
                fullCommand.add(command);
                regex.add("^" + command + "$");
            }
            if (inputCommand.size() > 0) {
                HighRiskInterceptRecordBo recordBo = new HighRiskInterceptRecordBo();
                this.insertHighRiskInterceptRecord(recordBo, taskInfoBo, guid);
                this.addParamsHighRiskInterceptRecordBo(recordBo, inputCommand, fullCommand, regex, userAuthenticateInfoBo.getLoginAccount());
                recordBo.setInterceptType("true");
                recordBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
                this.highRiskInterceptRecordDao.insertHighRiskInterceptRecord(recordBo);
                result.put("resultCode", "1");
                result.put("resultMessage", "The page for white command interception policy is displayed.");
                HighRiskInterceptRecordBo interceptRecordBo = this.getHighRiskInterceptRecordVos(guid);
                List inputCommands = JSONObject.parseArray((String)interceptRecordBo.getInputCommand(), String.class);
                this.highRiskUnlockPage.getHighRiskUnlockFrame(false, true, String.join((CharSequence)",", inputCommands), "", guid);
                result.put("guid", guid);
                return Result.success(result);
            }
        }
        return null;
    }

    private Result checkMenu(CommandBo commandBo, TaskInfoBo taskInfoBo) {
        String guid = UUID.randomUUID().toString();
        ArrayList<String> interceptCodes = new ArrayList<String>();
        ArrayList<String> interceptMenus = new ArrayList<String>();
        List<String> inputCodeList = commandBo.getCommand();
        if (InterceptPolicyEnum.BLOCKLIST.getValue().equals(taskInfoBo.getInterceptPolicy())) {
            for (BlockListMenuInfoBo blockListMenuInfoBo : blockMenuListCache) {
                String menuCode = blockListMenuInfoBo.getMenuCode();
                if (!inputCodeList.contains(menuCode)) continue;
                interceptCodes.add(menuCode);
                this.translateMenusName(interceptMenus, blockListMenuInfoBo);
            }
            if (interceptCodes.size() > 0) {
                this.insertMenuInterceptRecord(taskInfoBo, interceptCodes, interceptMenus, guid, false);
                this.highRiskUnlockPage.getHighRiskUnlockFrame(true, false, String.join((CharSequence)",", interceptMenus), null, guid);
                return this.putResult("1", "The page for block menu interception policy is displayed", guid);
            }
        } else {
            this.checkWhiteMenu(interceptCodes, inputCodeList);
            if (interceptCodes.size() > 0) {
                this.insertMenuInterceptRecord(taskInfoBo, interceptCodes, null, guid, true);
                this.highRiskUnlockPage.getHighRiskUnlockFrame(true, true, String.join((CharSequence)",", interceptCodes), null, guid);
                return this.putResult("1", "The page for white menu interception policy is displayed.", guid);
            }
        }
        return null;
    }

    private void translateMenusName(List<String> interceptMenus, BlockListMenuInfoBo blockListMenuInfoBo) {
        if (LanguageManager.isEnglish()) {
            interceptMenus.add(blockListMenuInfoBo.getMenuEn());
        } else {
            interceptMenus.add(blockListMenuInfoBo.getMenuCn());
        }
    }

    private void checkWhiteMenu(List<String> interceptCodes, List<String> inputCodeList) {
        for (String inputCode : inputCodeList) {
            boolean isWhiteMenu = false;
            for (WhiteListMenuInfoBo whiteListMenuInfoBo : whiteMenuListCache) {
                if (!inputCode.trim().equals(whiteListMenuInfoBo.getMenuCode())) continue;
                isWhiteMenu = true;
                break;
            }
            if (isWhiteMenu) continue;
            interceptCodes.add(inputCode);
        }
    }

    private void insertMenuInterceptRecord(TaskInfoBo taskInfoBo, List<String> interceptCodes, List<String> interceptMenus, String guid, Boolean isWhite) {
        HighRiskInterceptRecordBo menuInterceptRecord = new HighRiskInterceptRecordBo();
        menuInterceptRecord.setInputCommand(Objects.nonNull(interceptMenus) ? JSONObject.toJSONString(interceptMenus) : JSONObject.toJSONString(interceptCodes));
        menuInterceptRecord.setFullCommand(JSONObject.toJSONString(interceptCodes));
        menuInterceptRecord.setInterceptTime(DateUtil.getUtcDate(new Date()));
        menuInterceptRecord.setGuid(guid);
        menuInterceptRecord.setTaskId(taskInfoBo.getTaskId());
        menuInterceptRecord.setAccount(taskInfoBo.getTaskExecutor());
        menuInterceptRecord.setOperator(taskInfoBo.getTaskExecutor());
        menuInterceptRecord.setInterceptType(isWhite.toString());
        menuInterceptRecord.setCommandType(CommandTypeEnum.MENUS.getType());
        this.highRiskInterceptRecordDao.insertHighRiskInterceptRecord(menuInterceptRecord);
    }

    private HighRiskInterceptRecordBo getHighRiskInterceptRecordVos(String guid) {
        HighRiskInterceptRecordQueryVo highRiskInterceptRecordQueryVo = new HighRiskInterceptRecordQueryVo();
        highRiskInterceptRecordQueryVo.setGuid(guid);
        return this.commandSwingService.queryHighRiskInterceptCommandInfo(highRiskInterceptRecordQueryVo);
    }

    private void initializeCommandCache(UserAuthenticateInfoBo userAuthenticateInfoBo, TaskInfoBo taskInfo) {
        if (ObjectUtils.isNotEmpty((Object)taskInfo)) {
            this.taskId = taskInfo.getTaskId();
            LOGGER.info("Initializing the taskId is {}. Initializing the taskOldId is {}.", (Object)this.taskId, (Object)this.taskOldId);
        }
        if (!this.taskId.equals(this.taskOldId)) {
            highRiskCommandInfoBos = null;
            whiteListCommandInfoBos = null;
            this.fullCommandForSdkDao.deleteFullCommand();
            LOGGER.info("Initializing the whiteListCommandInfoBos and whiteListCommandInfoBos are null. Clearing Data in Temporary Tables.");
        }
        if (ObjectUtils.isEmpty(highRiskCommandInfoBos)) {
            LOGGER.info("Initializing the blocklist start.");
            highRiskCommandInfoBos = this.highRiskCommandInfoDao.queryHighRiskCommandInfoByUser(userAuthenticateInfoBo.getLoginAccount(), taskInfo.getRiskLevel());
            LOGGER.info("Initializing the blocklist end, size is {}.", (Object)highRiskCommandInfoBos.size());
        }
        if (ObjectUtils.isEmpty(whiteListCommandInfoBos)) {
            LOGGER.info("Initializing the trustlist start");
            whiteListCommandInfoBos = this.whiteListCommandInfoDao.queryWhiteListCommandInfoByUser(userAuthenticateInfoBo.getLoginAccount(), taskInfo.getRiskLevel());
            LOGGER.info("Initializing the trustlist end, size is {}.", (Object)whiteListCommandInfoBos.size());
        }
        this.removeHighRiskFullCommand(userAuthenticateInfoBo);
    }

    private void initializeMenuCache(UserAuthenticateInfoBo userInfo, TaskInfoBo taskInfo) {
        this.taskId = taskInfo.getTaskId();
        LOGGER.info("Enter initializingBlockAndWhiteMenuList, taskId is {}, taskOldId is {}", (Object)this.taskId, (Object)this.taskOldId);
        DeviceIdInfoBo deviceIdInfoBo = this.deviceInfoDao.queryDeviceInfo(this.getWindowsAccount());
        if (CollectionUtils.isEmpty(blockMenuListCache) || !this.taskId.equals(this.taskOldId)) {
            blockMenuListCache = this.blockListMenuInfoDao.queryBlockListMenuInfoByUser(userInfo.getLoginAccount(), taskInfo.getRiskLevel(), deviceIdInfoBo.getDeviceId(), deviceIdInfoBo.getToolVersion());
            whiteMenuListCache = this.whiteListMenuInfoDao.queryWhiteListMenuInfoByUser(userInfo.getLoginAccount(), taskInfo.getRiskLevel(), deviceIdInfoBo.getDeviceId(), deviceIdInfoBo.getToolVersion());
            LOGGER.info("initializingBlockAndWhiteMenuList(), refresh cache end.");
            this.fullCommandForSdkDao.deleteFullCommand();
        } else {
            this.removeUnlockMenuCode(userInfo);
        }
        LOGGER.info("initializingBlockAndWhiteMenuList end.");
    }

    private void removeHighRiskFullCommand(UserAuthenticateInfoBo userAuthenticateInfoBo) {
        List<HighRiskFullCommandBo> trustFullCommandBos;
        LOGGER.info("The removeHighRiskFullCommand start.");
        List<HighRiskFullCommandBo> blockFullCommandBos = this.fullCommandForSdkDao.queryHighRiskFullCommand("false");
        if (ObjectUtils.isNotEmpty(blockFullCommandBos) && blockFullCommandBos.size() > 0) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            this.checkHighRiskInfo(blockFullCommandBos, ids);
            this.fullCommandForSdkDao.deleteHighRiskFullCommandById(ids);
        }
        if (ObjectUtils.isNotEmpty(trustFullCommandBos = this.fullCommandForSdkDao.queryHighRiskFullCommand("true")) && trustFullCommandBos.size() > 0) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (int i = 0; i < trustFullCommandBos.size(); ++i) {
                String fullCommand = trustFullCommandBos.get(i).getFullCommand();
                Integer id = trustFullCommandBos.get(i).getId();
                WhiteListCommandInfoBo whiteListCommandInfoBo = new WhiteListCommandInfoBo();
                BeanUtils.copyProperties((Object)userAuthenticateInfoBo, (Object)whiteListCommandInfoBo);
                whiteListCommandInfoBo.setId(whiteListCommandInfoBos.size() + 1);
                whiteListCommandInfoBo.setFullCommand(fullCommand);
                whiteListCommandInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
                whiteListCommandInfoBo.setCommandRegex("^" + fullCommand + "$");
                whiteListCommandInfoBos.add(whiteListCommandInfoBo);
                ids.add(id);
            }
            this.fullCommandForSdkDao.deleteHighRiskFullCommandById(ids);
        }
        LOGGER.info("The removeHighRiskFullCommand end.");
    }

    private void removeUnlockMenuCode(UserAuthenticateInfoBo userAuthenticateInfoBo) {
        List<HighRiskFullCommandBo> unLockWhiteMenus;
        LOGGER.info("removeUnlockMenuCode start.");
        List<HighRiskFullCommandBo> unLockBlockMenus = this.fullCommandForSdkDao.queryHighRiskFullCommand(Boolean.FALSE.toString());
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty(unLockBlockMenus)) {
            this.removeUnLockBlockMenus(unLockBlockMenus, ids);
        }
        if (!CollectionUtils.isEmpty(unLockWhiteMenus = this.fullCommandForSdkDao.queryHighRiskFullCommand(Boolean.TRUE.toString()))) {
            for (HighRiskFullCommandBo unLockWhiteMenu : unLockWhiteMenus) {
                String unLockMenuCode = unLockWhiteMenu.getFullCommand();
                Integer id = unLockWhiteMenu.getId();
                WhiteListMenuInfoBo whiteListMenuInfoBo = new WhiteListMenuInfoBo();
                whiteListMenuInfoBo.setMenuCode(unLockMenuCode);
                whiteListMenuInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
                whiteMenuListCache.add(whiteListMenuInfoBo);
                ids.add(id);
            }
        }
        if (ids.size() > 0) {
            this.fullCommandForSdkDao.deleteHighRiskFullCommandById(ids);
        }
        LOGGER.info("removeUnlockMenuCode end.");
    }

    private void removeUnLockBlockMenus(List<HighRiskFullCommandBo> unLockBlockMenus, List<Integer> ids) {
        for (HighRiskFullCommandBo unLockBlockMenu : unLockBlockMenus) {
            String unLockMenuCode = unLockBlockMenu.getFullCommand();
            Integer id = unLockBlockMenu.getId();
            for (int j = blockMenuListCache.size() - 1; j >= 0; --j) {
                if (!unLockMenuCode.equals(blockMenuListCache.get(j).getMenuCode())) continue;
                blockMenuListCache.remove(j);
            }
            ids.add(id);
        }
        if (CollectionUtils.isEmpty(blockMenuListCache)) {
            BlockListMenuInfoBo blockListMenuInfoBo = new BlockListMenuInfoBo();
            blockListMenuInfoBo.setMenuCode("xxxxxxx");
            blockMenuListCache.add(blockListMenuInfoBo);
        }
    }

    private void checkHighRiskInfo(List<HighRiskFullCommandBo> blockFullCommandBos, List<Integer> ids) {
        for (int i = 0; i < blockFullCommandBos.size(); ++i) {
            String fullCommand = blockFullCommandBos.get(i).getFullCommand();
            Integer id = blockFullCommandBos.get(i).getId();
            for (int j = highRiskCommandInfoBos.size() - 1; j >= 0; --j) {
                if (!fullCommand.equals(highRiskCommandInfoBos.get(j).getFullCommand())) continue;
                highRiskCommandInfoBos.remove(j);
            }
            ids.add(id);
        }
        if (CollectionUtils.isEmpty(highRiskCommandInfoBos)) {
            HighRiskCommandInfoBo highRiskCommandInfoBo = new HighRiskCommandInfoBo();
            highRiskCommandInfoBo.setFullCommand("xxxxxxx");
            highRiskCommandInfoBo.setCommandRegex("xxxxxxx");
            highRiskCommandInfoBos.add(highRiskCommandInfoBo);
        }
    }

    private Result putResult(String resultCode, String resultMessage, String guid) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("resultCode", resultCode);
        result.put("resultMessage", resultMessage);
        result.put("guid", guid);
        return Result.success(result);
    }

    private int checkCommandHighRiskCommand(List<String> commands, TaskInfoBo taskInfoBo, String guid, String operator) {
        int num = 0;
        this.removeCommandsForCrtSchemeCommand(commands, taskInfoBo);
        ArrayList<String> inputCommand = new ArrayList<String>();
        ArrayList<String> fullCommand = new ArrayList<String>();
        ArrayList<String> regex = new ArrayList<String>();
        block2: for (String command : commands) {
            for (HighRiskCommandInfoBo highRiskCommandInfoBo : highRiskCommandInfoBos) {
                boolean riskFlag = false;
                try {
                    Pattern pattern = Pattern.compile(highRiskCommandInfoBo.getCommandRegex(), 2);
                    Matcher isMatch = pattern.matcher(command);
                    riskFlag = isMatch.matches();
                }
                catch (PatternSyntaxException except) {
                    LOGGER.error("HighRisk-command matches regex {} exception", (Object)highRiskCommandInfoBo.getCommandRegex());
                    continue;
                }
                if (!riskFlag) continue;
                inputCommand.add(command);
                fullCommand.add(highRiskCommandInfoBo.getFullCommand());
                regex.add(highRiskCommandInfoBo.getCommandRegex());
                ++num;
                LOGGER.info("The inputCommand is {}.", (Object)command);
                continue block2;
            }
        }
        if (num > 0) {
            HighRiskInterceptRecordBo interceptRecordBo = new HighRiskInterceptRecordBo();
            this.insertHighRiskInterceptRecord(interceptRecordBo, taskInfoBo, guid);
            this.addParamsHighRiskInterceptRecordBo(interceptRecordBo, inputCommand, fullCommand, regex, operator);
            interceptRecordBo.setInterceptType("false");
            this.highRiskInterceptRecordDao.insertHighRiskInterceptRecord(interceptRecordBo);
        }
        return num;
    }

    private void removeCommandsForCrtSchemeCommand(List<String> commands, TaskInfoBo taskInfoBo) {
        List<CrtSchemeCommandInfoBo> crtSchemeCommandInfoBos = this.crtSchemeCommandInfoMapper.queryCrtSchemeCommandInfo(taskInfoBo.getTaskId());
        crtSchemeCommandInfoBos.stream().forEach(crtSchemeCommandInfoBo -> {
            if (commands.contains(crtSchemeCommandInfoBo.getSchemeCommand())) {
                commands.remove(crtSchemeCommandInfoBo.getSchemeCommand());
            }
        });
    }

    private void addParamsHighRiskInterceptRecordBo(HighRiskInterceptRecordBo interceptRecordBo, List<String> inputCommand, List<String> fullCommand, List<String> regex, String operator) {
        interceptRecordBo.setInputCommand(JSONObject.toJSONString(inputCommand));
        interceptRecordBo.setFullCommand(JSONObject.toJSONString(fullCommand));
        interceptRecordBo.setCommandRegex(JSONObject.toJSONString(regex));
        interceptRecordBo.setOperator(operator);
        interceptRecordBo.setCommandType(CommandTypeEnum.COMMANDS.getType());
    }

    private int checkCommandWhiteListCommand(String command) {
        int num = 0;
        for (WhiteListCommandInfoBo whiteListCommandInfoBo : whiteListCommandInfoBos) {
            try {
                Pattern pattern = Pattern.compile(whiteListCommandInfoBo.getCommandRegex(), 2);
                Matcher isMatch = pattern.matcher(command);
                boolean whiteFlag = isMatch.matches();
                if (!whiteFlag) continue;
                ++num;
                LOGGER.info("CommandServiceForSdkImpl checkCommandWhiteListCommand command match {}.", (Object)command);
            }
            catch (PatternSyntaxException except) {
                LOGGER.error("HighRisk-command matches regex {} exception", (Object)whiteListCommandInfoBo.getCommandRegex());
            }
        }
        return num;
    }

    private void insertHighRiskInterceptRecord(HighRiskInterceptRecordBo interceptRecordBo, TaskInfoBo taskInfoBo, String guid) {
        interceptRecordBo.setAccount(taskInfoBo.getTaskExecutor());
        interceptRecordBo.setInterceptTime(DateUtil.getUtcDate(new Date()));
        interceptRecordBo.setGuid(guid);
        interceptRecordBo.setTaskId(taskInfoBo.getTaskId());
        LOGGER.info("CommandServiceForSdkImpl createGuid guid {}.", (Object)guid);
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }
}

