/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.service.init.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.huawei.netcareinsidesdk.bo.DeviceIdInfoBo;
import com.huawei.netcareinsidesdk.bo.FeatureOperationRecordBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.VerifyCodeRecordBo;
import com.huawei.netcareinsidesdk.bo.stm.FeatureInfo;
import com.huawei.netcareinsidesdk.bo.stm.StmInfoBo;
import com.huawei.netcareinsidesdk.constants.CommonConstants;
import com.huawei.netcareinsidesdk.constants.DatacomNetworkTiedPolicyEnum;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.InitManageControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.InsidePolicyEnum;
import com.huawei.netcareinsidesdk.constants.InterceptPolicyEnum;
import com.huawei.netcareinsidesdk.constants.OperatePermissionEnum;
import com.huawei.netcareinsidesdk.constants.TaskStatusNameEnum;
import com.huawei.netcareinsidesdk.dao.DeviceInfoDao;
import com.huawei.netcareinsidesdk.dao.FeatureOperationRecordDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.service.init.InitServiceForSdk;
import com.huawei.netcareinsidesdk.swing.pageService.InitStmInfoPage;
import com.huawei.netcareinsidesdk.utils.CmsSignUtils;
import com.huawei.netcareinsidesdk.utils.CommonDataDeal;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.OfflineAuthUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.RsaUtil;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.utils.VerifyCodeUtil;
import com.huawei.us.common.file.UsFileSafeUtils;
import com.huawei.us.common.file.UsFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InitServiceForSdkImpl
implements InitServiceForSdk {
    private static final Logger logger = LoggerFactory.getLogger(InitServiceForSdkImpl.class);
    private static List<String> ids = new ArrayList<String>();
    private static boolean isTelnet = false;
    private static final int HEX_PLATFORM_VERSION_LENGTH = 5;
    private static final int HEX_CUSTOM_SYSTEM_VERSION_LENGTH = 7;
    @Autowired
    private FeatureOperationRecordDao featureOperationRecordDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private DeviceInfoDao deviceIdInfoDao;
    @Autowired
    private InitStmInfoPage initStmInfoPage;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private CommonDataDeal commonDataDeal;
    @Autowired
    private VerifyCodeUtil verifyCodeUtil;
    @Autowired
    private OfflineAuthUtil offlineAuthUtil;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    private static final int SUCCESS = 0;
    private static final int FAIL = 1;

    @Override
    public synchronized Result reportStmInfoAndInitialization(StmInfoBo stmInfo, boolean isControlled) {
        logger.info("Enter reportStmInfoAndInitialization.");
        Result checkOfflineAuthUserResult = this.checkOfflineAuthUser();
        if (checkOfflineAuthUserResult != null) {
            return checkOfflineAuthUserResult;
        }
        Result checkResult = this.checkRequiredParam(stmInfo, isControlled);
        if (checkResult != null) {
            return checkResult;
        }
        DeviceIdInfoBo deviceIdInfoBo = this.initDeviceInfo(stmInfo.getToolId(), stmInfo.getEsn(), stmInfo.getVersionId());
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        boolean isConnected = hasConnectedClient.get("isConnected");
        isTelnet = hasConnectedClient.get("isTelnet");
        logger.info("reportStmInfoAndInitialization, isConnected {} | telnetIp {}", (Object)isConnected, (Object)isTelnet);
        if (isControlled) {
            if (isConnected || isTelnet) {
                Map<String, String> controlPolicyMap = this.commonDataDeal.queryControlPolicyForClient(deviceIdInfoBo);
                String netCareRoleCode = controlPolicyMap.get("netCareRoleCode");
                if (StringUtils.isNotBlank((CharSequence)netCareRoleCode)) {
                    deviceIdInfoBo.setNetCareRoleCode(netCareRoleCode);
                    this.deviceIdInfoDao.updateDeviceInfo(deviceIdInfoBo);
                }
                return this.joinQrParamsOnClient(stmInfo, deviceIdInfoBo, controlPolicyMap, isConnected, isControlled);
            }
            return this.joinQrParamsOnOffline(stmInfo, deviceIdInfoBo);
        }
        return this.joinNoControlAppQrParams(stmInfo, deviceIdInfoBo, isConnected, isControlled);
    }

    @Override
    public Result checkVerifyCodeForTool(String verifyCode) {
        logger.info("checkVerifyCodeForTool start.");
        if (StringUtils.isBlank((CharSequence)verifyCode) || verifyCode.length() != 6) {
            logger.error("required param [verifyCode] is invalid.");
            return Result.fail(ErrorCodeEnum.PARAM_IS_INVALID.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.PARAM_IS_INVALID.getErrorCode(), Collections.singletonList("verifyCode")));
        }
        List<VerifyCodeRecordBo> codes = this.verifyCodeUtil.getCodeCache();
        Result checkCodeResult = this.checkCode(codes);
        if (checkCodeResult != null) {
            return checkCodeResult;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (codes.size() == 4) {
            logger.info("checkVerifyCodeForTool certify verify.");
            return this.certifyVerify(verifyCode, codes, resultMap);
        }
        logger.info("checkVerifyCodeForTool policy verify.");
        boolean isPass = false;
        String verifyCodeType = null;
        for (VerifyCodeRecordBo codeBo : codes) {
            if (!StringUtils.equals((CharSequence)verifyCode, (CharSequence)codeBo.getVerifyCode())) continue;
            isPass = true;
            verifyCodeType = codeBo.getVerifyCodeType();
            break;
        }
        if (isPass) {
            logger.info("checkVerifyCodeForTool, verify success, verifyCodeType {}", verifyCodeType);
            if (Objects.nonNull(ids) && !ids.isEmpty()) {
                logger.info("delete featureOperationRecordInfo is {}", (Object)JSONObject.toJSONString(ids));
                this.featureOperationRecordDao.deleteFeatureOperationRecordInfoByIds(ids);
            }
            return this.getPassResult(resultMap, verifyCodeType);
        }
        logger.error("checkVerifyCodeForTool, verify fail.");
        HashMap<String, String> checkResultMap = new HashMap<String, String>();
        this.verifyCodeUtil.verifyFailNumCheck(this.getWindowsAccount(), checkResultMap);
        return Result.fail((String)checkResultMap.get("errorCode"), (String)checkResultMap.get("errorMsg"));
    }

    private Result getPassResult(Map<String, String> resultMap, String verifyCodeType) {
        this.verifyCodeUtil.clearAccountCache(this.getWindowsAccount());
        this.verifyCodeUtil.clearCodeCache();
        UserAuthenticateInfoBo curUser = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        String[] split = verifyCodeType.split("-");
        String controlPolicy = split[0];
        String netCareRoleCode = split[1];
        DeviceIdInfoBo deviceIdInfoBo = new DeviceIdInfoBo();
        deviceIdInfoBo.setWindowsAccount(this.getWindowsAccount());
        deviceIdInfoBo.setNetCareRoleCode(netCareRoleCode);
        this.deviceIdInfoDao.updateDeviceInfo(deviceIdInfoBo);
        if (StringUtils.equals((CharSequence)InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode(), (CharSequence)controlPolicy)) {
            return this.controlVerify(resultMap, controlPolicy, curUser);
        }
        return this.noControlVerify(controlPolicy, curUser);
    }

    private String getFeatureOperationRecord(Boolean isTelnet) {
        logger.info("getFeatureOperationRecord start.");
        List<FeatureOperationRecordBo> featureOperationRecordBos = this.featureOperationRecordDao.queryAllFeatureOperationRecordInfo();
        String featureOperationRecord = "";
        if (Objects.nonNull(featureOperationRecordBos) && !featureOperationRecordBos.isEmpty()) {
            List<FeatureOperationRecordBo> operationRecordBos = isTelnet != false ? featureOperationRecordBos : featureOperationRecordBos.subList(0, Math.min(featureOperationRecordBos.size(), 5));
            FeatureOperationRecordBo featureOperationRecordBo = operationRecordBos.get(0);
            Date createTime = DateUtil.getLocalDate(featureOperationRecordBo.getCreateTime());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(createTime.getTime() / 1000L).append("@");
            for (FeatureOperationRecordBo recordBo : operationRecordBos) {
                stringBuilder.append(recordBo.getFeatureCode()).append(":").append(recordBo.getFeatureRecordTimes());
                if (recordBo.getServiceVolume() != null && recordBo.getServiceVolume() > 0) {
                    stringBuilder.append("-").append(recordBo.getServiceVolume());
                }
                stringBuilder.append(",");
            }
            featureOperationRecord = String.valueOf(stringBuilder.deleteCharAt(stringBuilder.length() - 1));
            ids = operationRecordBos.stream().map(FeatureOperationRecordBo::getFeatureCode).collect(Collectors.toList());
        }
        logger.info("getFeatureOperationRecord end.");
        return featureOperationRecord;
    }

    private Result checkCode(List<VerifyCodeRecordBo> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Result.fail(ErrorCodeEnum.NO_VERIFY_CODE.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.NO_VERIFY_CODE.getErrorCode()));
        }
        String errMsg = this.verifyCodeUtil.verifyPreCheck(this.getWindowsAccount());
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            return Result.fail(ErrorCodeEnum.ACCOUNT_LOCKED_VERIFY.getErrorCode(), errMsg);
        }
        errMsg = this.verifyCodeUtil.checkActivePeriod(codes.get(0));
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            return Result.fail(errMsg, this.internationalizeUtil.getMessage(errMsg));
        }
        return null;
    }

    @Override
    public synchronized Result importOfflineBypassFile(String filePath, String esn, String toolName) {
        logger.info("importOfflineBypassFile start");
        String account = this.getWindowsAccount();
        Map<String, String> checkResultMap = this.offlineAuthUtil.checkAccountValidity(account);
        if (!CollectionUtils.isEmpty(checkResultMap)) {
            logger.error("importOfflineBypassFile check account failed.");
            return Result.fail(checkResultMap.get("errorCode"), checkResultMap.get("errorMsg"));
        }
        Result checkResult = this.checkOfflineBypassFile(filePath, esn, toolName);
        return this.offlineAuthUtil.getCheckTimesResult(checkResult, account);
    }

    private Result checkOfflineBypassFile(String filePath, String esn, String toolName) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{filePath, esn, toolName})) {
            logger.error("required param [filePath, esn, toolName] is invalid.");
            return Result.fail(ErrorCodeEnum.PARAM_IS_INVALID.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.PARAM_IS_INVALID.getErrorCode(), Collections.singletonList("[filePath, esn, toolName]")));
        }
        Properties properties = new Properties();
        Result result = this.readPropertiesFile(filePath, properties);
        if (result != null) {
            return result;
        }
        if (!this.isSignSuccess(properties)) {
            logger.error("The offline authentication file is damaged or tampered with. Please apply again!");
            return Result.fail(ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.VERIFY_SIGN_FAILED.getErrorCode()));
        }
        if (!this.isSameEsn(esn, properties.getProperty("esn")) || !StringUtils.equals((CharSequence)toolName, (CharSequence)properties.getProperty("toolName"))) {
            logger.error("The entered ESN or ToolName is different from the offline authentication file.");
            return Result.fail(ErrorCodeEnum.INFO_INCONSISTENT.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.INFO_INCONSISTENT.getErrorCode()));
        }
        String expirationTime = properties.getProperty("expirationTime");
        if (DateUtil.formatDateToStr(new Date(), "yyyy-MM-dd").compareTo(expirationTime) >= 0) {
            logger.error("The offline authentication file has expired. Please apply for a new file.");
            return Result.fail(ErrorCodeEnum.EXPIRED_FILE.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.EXPIRED_FILE.getErrorCode()));
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        this.createDefaultUser(InitManageControlPolicyEnum.NOCONTROL_AND_NOSCAN.getDataCode(), expirationTime, null, OperatePermissionEnum.OPERATE.getValueEn(), resultMap);
        this.createDefaultTask(this.userAuthenticateInfoDao.queryActiveStatusUserInfo());
        resultMap.put("expirationTime", expirationTime);
        logger.info("importOfflineBypassFile success!");
        return Result.success(resultMap);
    }

    private boolean isSameEsn(String paramEsn, String parseEsn) {
        logger.info("isSameEsn, paramEsn {}, parseEsn {}", (Object)paramEsn, (Object)parseEsn);
        int minLen = 12;
        if (StringUtils.isBlank((CharSequence)paramEsn) || StringUtils.isBlank((CharSequence)parseEsn) || paramEsn.length() <= minLen || parseEsn.length() <= minLen) {
            return false;
        }
        String paramEsnSub = paramEsn.substring(0, paramEsn.length() - minLen);
        String parseEsnSub = parseEsn.substring(0, parseEsn.length() - minLen);
        logger.info("isSameEsn, paramEsnSub {}, parseEsnSub {}", (Object)paramEsnSub, (Object)parseEsnSub);
        return StringUtils.equals((CharSequence)parseEsnSub, (CharSequence)paramEsnSub);
    }

    private boolean isSignSuccess(Properties properties) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{properties.getProperty("toolName"), properties.getProperty("esn"), properties.getProperty("expirationTime"), properties.getProperty("sign")})) {
            logger.info("The offline authentication file parameter cannot be empty.");
            return false;
        }
        String esnAndExpirationTime = properties.getProperty("toolName") + properties.getProperty("esn") + properties.getProperty("expirationTime");
        String sign = properties.getProperty("sign");
        boolean signResult = false;
        try {
            byte[] decode = Base64.getDecoder().decode(sign);
            String publicKey = PropertyUtil.getString("publicKeyToSign");
            signResult = CmsSignUtils.verifySignature(RsaUtil.getPublicKey(publicKey), esnAndExpirationTime, decode);
        }
        catch (IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException ex) {
            logger.error("Offline Authentication File Signature verification failed.");
        }
        return signResult;
    }

    @Override
    public Result pushFeatureOperationRecord(FeatureInfo featureInfo) {
        logger.info("pushFeatureOperationRecord start.");
        UserAuthenticateInfoBo authenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.nonNull(authenticateInfoBo) && StringUtils.equals((CharSequence)authenticateInfoBo.getLoginAccountName(), (CharSequence)"Offline AuthUser")) {
            logger.info("Offline authentication users cannot report feature data.");
            return Result.fail(ErrorCodeEnum.OFFLINE_AUTH_USER_FEATURE_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.OFFLINE_AUTH_USER_FEATURE_ERROR.getErrorCode()));
        }
        FeatureOperationRecordBo featureOperationRecordBo = this.featureOperationRecordDao.queryFeatureOperationRecordInfoByFeatureId(featureInfo.getFeatureId().replaceAll("^0+", ""));
        FeatureOperationRecordBo recordBo = new FeatureOperationRecordBo();
        if (Objects.isNull(featureOperationRecordBo)) {
            recordBo.setFeatureRecordTimes(NumberUtils.INTEGER_ONE);
            recordBo.setFeatureCode(featureInfo.getFeatureId().replaceAll("^0+", ""));
            if (featureInfo.getServiceVolume() == null) {
                recordBo.setServiceVolume(NumberUtils.INTEGER_ZERO);
            } else {
                recordBo.setServiceVolume(featureInfo.getServiceVolume());
            }
            recordBo.setCreateTime(DateUtil.getUtcDate(new Date()));
            logger.info("insert feature operation record info {}.", (Object)featureInfo.getFeatureId());
            this.featureOperationRecordDao.insertFeatureOperationRecordInfo(recordBo);
        } else {
            recordBo.setFeatureRecordTimes(featureOperationRecordBo.getFeatureRecordTimes() + NumberUtils.INTEGER_ONE);
            recordBo.setFeatureCode(featureInfo.getFeatureId().replaceAll("^0+", ""));
            if (featureInfo.getServiceVolume() != null) {
                recordBo.setServiceVolume(featureOperationRecordBo.getServiceVolume() + featureInfo.getServiceVolume());
            }
            recordBo.setFeatureOperateTime(DateUtil.getUtcDate(new Date()));
            logger.info("update feature operation record info {}.", (Object)featureInfo.getFeatureId());
            this.featureOperationRecordDao.updateFeatureOperationRecordInfo(recordBo);
        }
        logger.info("pushFeatureOperationRecord end.");
        return Result.success();
    }

    @Override
    public Result queryUserInfo() {
        JSONObject resultMap = new JSONObject();
        UserAuthenticateInfoBo userInfo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userInfo)) {
            logger.info("This userAuthenticateInfo is abnormal. The userAuthenticateInfo is empty.");
            resultMap.put("hasUserInfo", (Object)false);
            return Result.success(resultMap);
        }
        DeviceIdInfoBo deviceIdInfoBo = this.deviceIdInfoDao.queryDeviceInfo(this.getWindowsAccount());
        if (Objects.isNull(deviceIdInfoBo) || StringUtils.isBlank((CharSequence)deviceIdInfoBo.getNetCareRoleCode())) {
            resultMap.put("roleCode", (Object)"");
        } else {
            resultMap.put("roleCode", (Object)deviceIdInfoBo.getNetCareRoleCode());
        }
        resultMap.put("hasUserInfo", (Object)true);
        resultMap.put("isOfflineAuthUser", (Object)StringUtils.equals((CharSequence)userInfo.getLoginAccountName(), (CharSequence)"Offline AuthUser"));
        resultMap.put("expirationTime", (Object)(StringUtils.isNotBlank((CharSequence)userInfo.getExpirationTime()) ? userInfo.getExpirationTime() : ""));
        resultMap.put("isExpired", (Object)this.commonDataDeal.isExpired(userInfo));
        resultMap.put("isOperatePermission", (Object)(!StringUtils.equals((CharSequence)userInfo.getOperatePermission(), (CharSequence)OperatePermissionEnum.SELECT.getValueEn()) ? 1 : 0));
        String controlPolicy = userInfo.getInitManageControlPolicy();
        resultMap.put("isControlled", (Object)(Objects.isNull(controlPolicy) || StringUtils.equals((CharSequence)controlPolicy, (CharSequence)InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode()) ? 1 : 0));
        logger.info("queryUserInfo {}", (Object)JSONObject.toJSONString((Object)resultMap));
        return Result.success(resultMap);
    }

    @Override
    public Result deleteInitInfo() {
        logger.info("ON Deployment deleteInitInfo start.");
        this.userAuthenticateInfoDao.deleteUserAuthenticateInfo(null);
        logger.info("ON Deployment deleteInitInfo end.");
        return Result.success();
    }

    private Result readPropertiesFile(String filePath, Properties properties) {
        String safeFilePath = UsFileSafeUtils.getSafeFilePath((String)filePath);
        String checkFileResult = UsFileUtils.checkFile((String)filePath, (String)"offline", (long)CommonConstants.MAX_FILE_SIZE);
        if (!StringUtils.equals((CharSequence)checkFileResult, (CharSequence)NumberUtils.BYTE_ZERO.toString())) {
            logger.error("Failed to verify the format of the Offline Authentication File.");
            return Result.fail(ErrorCodeEnum.FILE_FORMAT_INCORRECT.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.FILE_FORMAT_INCORRECT.getErrorCode()));
        }
        try (FileInputStream fileInputStream = UsFileUtils.getFileInputStream((File)UsFileUtils.getFile((String)safeFilePath));){
            properties.load(fileInputStream);
        }
        catch (IOException exception) {
            logger.error("readPropertiesFile IOException.");
            return Result.fail(ErrorCodeEnum.GET_FILE_EXCEPTION.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.GET_FILE_EXCEPTION.getErrorCode()));
        }
        return null;
    }

    private void createDefaultUser(String initManageControlPolicy, String expirationTime, String site, String operatePermission, Map<String, String> resultMap) {
        logger.info("Start createDefaultUser.");
        UserAuthenticateInfoBo curUser = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.nonNull(curUser) && Objects.isNull(expirationTime)) {
            UserAuthenticateInfoBo authenticateInfoBo = new UserAuthenticateInfoBo();
            authenticateInfoBo.setId(curUser.getId());
            authenticateInfoBo.setInitManageControlPolicy(initManageControlPolicy);
            authenticateInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
            authenticateInfoBo.setSite(site);
            authenticateInfoBo.setOperatePermission(operatePermission);
            this.userAuthenticateInfoDao.updateUserAuthenticateInfo(authenticateInfoBo);
            logger.info("createDefaultUser, updateComponentPolicyForSdk success.");
            return;
        }
        DeviceIdInfoBo deviceIdInfoBo = this.deviceIdInfoDao.queryDeviceInfo(this.getWindowsAccount());
        UserAuthenticateInfoBo defaultUser = new UserAuthenticateInfoBo();
        defaultUser.setWindowsAccount(this.getWindowsAccount());
        defaultUser.setLoginAccount("Default User");
        defaultUser.setLoginAccountName("Default User");
        defaultUser.setEsn(Objects.nonNull(deviceIdInfoBo) ? deviceIdInfoBo.getEsn() : null);
        defaultUser.setDeviceId(Objects.nonNull(deviceIdInfoBo) ? deviceIdInfoBo.getDeviceId() : null);
        defaultUser.setNotStructuralComponentPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        defaultUser.setStructuralComponentPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        defaultUser.setDatacomNetworkTiedPolicy(DatacomNetworkTiedPolicyEnum.NO_INTERCEPT.getValueEn());
        defaultUser.setOperationPreparationInsidePolicy(InsidePolicyEnum.NO_INTERCEPT.getCode());
        defaultUser.setCurStatus(0);
        defaultUser.setAuthValidatePeriod("9999");
        if (Objects.nonNull(expirationTime)) {
            this.calculateExpirationTime(expirationTime, resultMap, defaultUser);
            defaultUser.setExpirationTime(expirationTime);
        }
        defaultUser.setCreateTime(DateUtil.getUtcDate(new Date()));
        defaultUser.setUpdateTime(DateUtil.getUtcDate(new Date()));
        defaultUser.setOperator("Default User");
        defaultUser.setIsDefaultUser("0");
        defaultUser.setInitManageControlPolicy(initManageControlPolicy);
        defaultUser.setSite(site);
        this.userAuthenticateInfoDao.deleteUserAuthenticateInfo(null);
        this.userAuthenticateInfoDao.insertUserAuthenticateInfo(defaultUser);
        logger.info("End createDefaultUser.");
    }

    private void calculateExpirationTime(String expirationTime, Map<String, String> resultMap, UserAuthenticateInfoBo userAuthenticateInfoBo) {
        userAuthenticateInfoBo.setLoginAccountName("Offline AuthUser");
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date expirationDate = sdf.parse(expirationTime);
            String curDateStr = sdf.format(new Date());
            Date curDate = sdf.parse(curDateStr);
            long expirationMills = expirationDate.getTime() - curDate.getTime();
            long dayNum = expirationMills / 86400000L;
            resultMap.put("remainTime", Long.toString(dayNum));
            userAuthenticateInfoBo.setAuthValidatePeriod(Long.toString(dayNum));
        }
        catch (ParseException e) {
            logger.error("calculateExpirationTime, ParseException.");
            userAuthenticateInfoBo.setAuthValidatePeriod("180");
            resultMap.put("remainTime", "180");
        }
    }

    private void createDefaultTask(UserAuthenticateInfoBo userAuthenticateInfoBo) {
        TaskInfoBo taskInfo;
        logger.info("Start createDefaultTask");
        TaskInfoBo taskInfoBo = new TaskInfoBo();
        taskInfoBo.setTaskId("defaultTask");
        taskInfoBo.setTaskName("Default Task");
        taskInfoBo.setTaskType("query");
        taskInfoBo.setTaskExecutor("Default User");
        taskInfoBo.setTaskExecutorName("Default User");
        taskInfoBo.setInterceptPolicy(InterceptPolicyEnum.NO_INTERCEPT.getValue());
        taskInfoBo.setTaskStartTime(DateUtil.getUtcDate(new Date()));
        taskInfoBo.setTaskEndTime(DateUtil.addMonth(DateUtil.getUtcDate(new Date()), 360));
        taskInfoBo.setOperator("Default User");
        taskInfoBo.setIsCurTask(true);
        taskInfoBo.setTaskStatus(TaskStatusNameEnum.ONGOING.getCode());
        if (Objects.nonNull(userAuthenticateInfoBo)) {
            taskInfoBo.setTaskExecutor(userAuthenticateInfoBo.getLoginAccount());
            taskInfoBo.setTaskExecutorName(userAuthenticateInfoBo.getLoginAccountName());
            taskInfoBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
        }
        if (Objects.nonNull(taskInfo = this.taskInfoDao.queryTaskInfoByTaskId(taskInfoBo.getTaskId()))) {
            this.taskInfoDao.updateTask(taskInfoBo);
            logger.info("Update TaskInfo success.");
        } else {
            this.taskInfoDao.deleteTaskInfo(null);
            logger.info("delete no-default task success.");
            taskInfoBo.setCreateTime(DateUtil.getUtcDate(new Date()));
            this.taskInfoDao.insertTaskInfo(taskInfoBo);
            logger.info("Insert TaskInfo success.");
        }
        this.taskInfoDao.setOtherTask(taskInfoBo.getTaskId(), null);
        logger.info("End createDefaultTask");
    }

    private DeviceIdInfoBo initDeviceInfo(String deviceId, String esn, String toolVersion) {
        String windowsAccount = this.getWindowsAccount();
        DeviceIdInfoBo deviceIdInfoBo = this.deviceIdInfoDao.queryDeviceInfo(this.getWindowsAccount());
        if (deviceIdInfoBo == null) {
            logger.info("Query device id info null.");
            deviceIdInfoBo = new DeviceIdInfoBo();
            deviceIdInfoBo.setDeviceId(deviceId);
            deviceIdInfoBo.setEsn(esn);
            deviceIdInfoBo.setWindowsAccount(windowsAccount);
            deviceIdInfoBo.setToolVersion(toolVersion);
            this.deviceIdInfoDao.insertDeviceInfo(deviceIdInfoBo);
            logger.info("Insert device info success.");
        } else if (!(deviceIdInfoBo.getDeviceId().equals(deviceId) && deviceIdInfoBo.getEsn().equals(esn) && Objects.equals(deviceIdInfoBo.getToolVersion(), toolVersion))) {
            deviceIdInfoBo.setDeviceId(deviceId);
            deviceIdInfoBo.setEsn(esn);
            deviceIdInfoBo.setToolVersion(toolVersion);
            this.deviceIdInfoDao.updateDeviceInfo(deviceIdInfoBo);
            logger.info("Update device info success.");
        }
        if (StringUtils.isNotBlank((CharSequence)deviceIdInfoBo.getDeviceId()) && StringUtils.containsWhitespace((CharSequence)deviceIdInfoBo.getDeviceId())) {
            deviceIdInfoBo.setDeviceId(deviceIdInfoBo.getDeviceId().replaceAll(" ", "%20"));
        }
        return deviceIdInfoBo;
    }

    private int sendStmInfoToClient(StmInfoBo stmInfo, boolean isConnected) {
        JSONObject resultMessage;
        logger.info("sendStmInfoToClient start.");
        if (StringUtils.isBlank((CharSequence)stmInfo.getVersionId())) {
            logger.info("versionId is empty, no need to report stm info.");
            return 0;
        }
        if (!isConnected) {
            logger.info("NetCare Client is not connected, and data is not reported.");
            return 1;
        }
        if (StringUtils.isNotBlank((CharSequence)stmInfo.getToolId()) && StringUtils.containsWhitespace((CharSequence)stmInfo.getToolId())) {
            stmInfo.setToolId(stmInfo.getToolId().replaceAll(" ", "%20"));
        }
        String faceCheckUrl = PropertyUtil.getString("reportStmInfoFromClientUri");
        RequestData requestData = new RequestData();
        requestData.setUrl(faceCheckUrl);
        requestData.setType("POST");
        String stmInfoJsonObject = JSONObject.toJSONString((Object)stmInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        JSONObject jsonObject = JSONObject.parseObject((String)stmInfoJsonObject);
        jsonObject.put("featureOperationRecord", (Object)this.getFeatureOperationRecord(Boolean.TRUE));
        requestData.setParam(jsonObject);
        try {
            resultMessage = HttpUtil.sendRest(requestData);
        }
        catch (Exception exception) {
            logger.error("The sendStmInfoToClient error.");
            return 1;
        }
        if (ObjectUtils.isNotEmpty((Object)resultMessage) && StringUtils.equals((CharSequence)String.valueOf(0), (CharSequence)resultMessage.getString("code")) && StringUtils.equals((CharSequence)Boolean.TRUE.toString(), (CharSequence)resultMessage.getString("data"))) {
            logger.info("The sendStmInfoToClient success message {}.", (Object)resultMessage.toJSONString());
            if (Objects.nonNull(ids) && !ids.isEmpty()) {
                logger.info("delete featureOperationRecordInfo is {}", (Object)JSONObject.toJSONString(ids));
                this.featureOperationRecordDao.deleteFeatureOperationRecordInfoByIds(ids);
            }
            return 0;
        }
        if (ObjectUtils.isNotEmpty((Object)resultMessage)) {
            logger.info("The sendStmInfoToClient failed message {}.", (Object)resultMessage.toJSONString());
        }
        return 1;
    }

    private String getWindowsAccount() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    private Result noControlVerify(String verifyCodeType, UserAuthenticateInfoBo curUser) {
        String site = null;
        if (StringUtils.equals((CharSequence)verifyCodeType, (CharSequence)"1")) {
            site = "China";
        } else if (StringUtils.equals((CharSequence)verifyCodeType, (CharSequence)"3")) {
            site = "Germany";
            verifyCodeType = "1";
        }
        if (Objects.isNull(curUser)) {
            logger.info("noControlVerify, The current user is empty.");
            this.createDefaultUser(verifyCodeType, null, site, OperatePermissionEnum.OPERATE.getValueEn(), null);
            this.createDefaultTask(null);
        } else {
            logger.info("noControlVerify, The current user is not empty.");
            UserAuthenticateInfoBo userAuthenticateInfoBo = new UserAuthenticateInfoBo();
            userAuthenticateInfoBo.setInitManageControlPolicy(verifyCodeType);
            userAuthenticateInfoBo.setLoginAccount(curUser.getLoginAccount());
            if (StringUtils.isBlank((CharSequence)curUser.getSite())) {
                userAuthenticateInfoBo.setSite(site);
            }
            userAuthenticateInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
            this.userAuthenticateInfoDao.updateUserControlPolicy(userAuthenticateInfoBo);
            this.createDefaultTask(curUser);
        }
        return Result.success();
    }

    private Result controlVerify(Map<String, String> resultMap, String verifyCodeType, UserAuthenticateInfoBo curUser) {
        TaskInfoBo taskInfoBo = new TaskInfoBo();
        taskInfoBo.setTaskId("defaultTask");
        this.taskInfoDao.deleteTaskInfoByTaskId(taskInfoBo);
        if (Objects.nonNull(curUser) && !StringUtils.equals((CharSequence)curUser.getLoginAccount(), (CharSequence)"Default User")) {
            logger.info("The current user is not empty and is not the default user.");
            if (this.commonDataDeal.isExpired(curUser)) {
                logger.info("curUser isExpired.");
                return this.importPackage(resultMap);
            }
            UserAuthenticateInfoBo userAuthenticateInfoBo = new UserAuthenticateInfoBo();
            userAuthenticateInfoBo.setInitManageControlPolicy(verifyCodeType);
            userAuthenticateInfoBo.setLoginAccount(curUser.getLoginAccount());
            userAuthenticateInfoBo.setUpdateTime(DateUtil.getUtcDate(new Date()));
            this.userAuthenticateInfoDao.updateUserControlPolicy(userAuthenticateInfoBo);
            return Result.success();
        }
        return this.importPackage(resultMap);
    }

    private Result importPackage(Map<String, String> resultMap) {
        resultMap.put("resultCode", "1");
        resultMap.put("resultMessage", "Import initPackage");
        String guid = UUID.randomUUID().toString();
        resultMap.put("guid", guid);
        this.initStmInfoPage.drawImportPackage(guid);
        return Result.success(resultMap);
    }

    private Result certifyVerify(String verifyCode, List<VerifyCodeRecordBo> codes, Map<String, String> resultMap) {
        boolean isVerifyPass = false;
        String verifyCodeType = null;
        for (VerifyCodeRecordBo verify : codes) {
            if (!StringUtils.equals((CharSequence)verifyCode, (CharSequence)verify.getVerifyCode())) continue;
            isVerifyPass = true;
            verifyCodeType = verify.getVerifyCodeType();
            break;
        }
        if (!isVerifyPass) {
            logger.error("checkVerifyCodeForTool, verify fail.");
            HashMap<String, String> checkResultMap = new HashMap<String, String>();
            this.verifyCodeUtil.verifyFailNumCheck(this.getWindowsAccount(), checkResultMap);
            return Result.fail((String)checkResultMap.get("errorCode"), (String)checkResultMap.get("errorMsg"));
        }
        logger.info("checkVerifyCodeForTool, verify success.");
        this.verifyCodeUtil.clearAccountCache(this.getWindowsAccount());
        if (Objects.nonNull(ids) && !ids.isEmpty()) {
            logger.info("delete featureOperationRecordInfo is {}", (Object)JSONObject.toJSONString(ids));
            this.featureOperationRecordDao.deleteFeatureOperationRecordInfoByIds(ids);
        }
        this.verifyCodeUtil.clearCodeCache();
        if (Objects.nonNull(verifyCodeType) && StringUtils.equals((CharSequence)verifyCodeType, (CharSequence)"-1")) {
            return this.importPackage(resultMap);
        }
        return Result.success();
    }

    private Result joinNoControlAppQrParams(StmInfoBo stmInfo, DeviceIdInfoBo deviceIdInfoBo, boolean isConnected, boolean isControlled) {
        UserAuthenticateInfoBo curUser = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        int sendStmReturnCode = this.sendStmInfoToClient(stmInfo, isConnected);
        StringBuilder verifyCode = new StringBuilder();
        ArrayList<VerifyCodeRecordBo> codeList = new ArrayList<VerifyCodeRecordBo>();
        for (int i = 0; i < 4; ++i) {
            String code = this.verifyCodeUtil.generalVerifyCode(6);
            VerifyCodeRecordBo verifyCodeRecordBo = this.buildVerifyCodeBo(code, deviceIdInfoBo, "\u767b\u5f55\u8ba4\u8bc1", null);
            codeList.add(verifyCodeRecordBo);
            verifyCode.append(code).append("#");
        }
        this.verifyCodeUtil.addCodeCache(codeList);
        return this.joinQRInfo(stmInfo, deviceIdInfoBo, curUser, new int[]{sendStmReturnCode, 0, isConnected ? 0 : 1, isControlled ? 0 : 1}, verifyCode.toString());
    }

    private Result joinQrParamsOnOffline(StmInfoBo stmInfo, DeviceIdInfoBo deviceIdInfoBo) {
        UserAuthenticateInfoBo curUser = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        StringBuilder params = this.joinStmParams(curUser, deviceIdInfoBo, stmInfo, true);
        int codeNum = InitServiceForSdkImpl.getVerifyCodeNum(curUser, params);
        StringBuilder verifyCode = new StringBuilder();
        ArrayList<VerifyCodeRecordBo> codeList = new ArrayList<VerifyCodeRecordBo>();
        for (int i = 0; i < codeNum; ++i) {
            String code = this.verifyCodeUtil.generalVerifyCode(6);
            String verifyCodeType = this.getVerifyCodeType(i);
            VerifyCodeRecordBo verifyCodeRecordBo = this.buildVerifyCodeBo(code, deviceIdInfoBo, "\u7ba1\u63a7\u7b56\u7565", verifyCodeType);
            codeList.add(verifyCodeRecordBo);
            verifyCode.append(code).append("#");
        }
        this.verifyCodeUtil.addCodeCache(codeList);
        String codeAndAccount = verifyCode.substring(0, verifyCode.length() - 1);
        if (Objects.nonNull(curUser) && !StringUtils.equals((CharSequence)curUser.getLoginAccount(), (CharSequence)"Default User") && !this.commonDataDeal.isExpired(curUser)) {
            codeAndAccount = codeAndAccount + "@" + curUser.getLoginAccount();
            if (Objects.nonNull(curUser.getIsPublicOmTerminal()) && curUser.getIsPublicOmTerminal().booleanValue()) {
                codeAndAccount = codeAndAccount + "@noCheckAccount";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)stmInfo.getVersionId())) {
            codeAndAccount = codeAndAccount + "@version=" + stmInfo.getVersionId();
        }
        String site = Objects.nonNull(curUser) ? curUser.getSite() : "";
        codeAndAccount = codeAndAccount + "@site=" + site + "@deviceId=" + deviceIdInfoBo.getDeviceId();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            String encryptStr = URLEncoder.encode(RsaUtil.encrypt(codeAndAccount, PropertyUtil.getString("pubkeyByEncrypt")), "UTF-8");
            String qrInfo = PropertyUtil.getScanQrUrl("toolInitializationUrl", Objects.nonNull(curUser) ? curUser.getSite() : null) + "?" + params + "&verify=" + encryptStr;
            resultMap.put("resultCode", "1");
            resultMap.put("resultMessage", qrInfo);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException ex) {
            logger.error("joinQrParamsOnOffline encrypt error {}", (Object)ex.getMessage());
            return Result.fail(ErrorCodeEnum.ENCRYPT_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.ENCRYPT_ERROR.getErrorCode()));
        }
        return Result.success(resultMap);
    }

    private String getVerifyCodeType(int index) {
        if (index <= 3) {
            return "0-" + index;
        }
        if (index <= 7) {
            return "1-" + index % 4;
        }
        if (index <= 11) {
            return "2-" + index % 4;
        }
        if (index <= 15) {
            return "3-" + index % 4;
        }
        return null;
    }

    private static int getVerifyCodeNum(UserAuthenticateInfoBo curUser, StringBuilder params) {
        int codeNum = 12;
        if (Objects.nonNull(curUser) && StringUtils.equals((CharSequence)curUser.getInitManageControlPolicy(), (CharSequence)InitManageControlPolicyEnum.NOCONTROL_AND_NOSCAN.getDataCode())) {
            codeNum = 4;
            params.append("&isImport=N").append("&sr=Y");
        }
        if (codeNum == 12 && (Objects.isNull(curUser) || StringUtils.isBlank((CharSequence)curUser.getSite()))) {
            codeNum = 16;
        }
        return codeNum;
    }

    private StringBuilder joinStmParams(UserAuthenticateInfoBo curUser, DeviceIdInfoBo deviceIdInfoBo, StmInfoBo stmInfo, boolean isJoinStm) {
        StringBuilder params = new StringBuilder();
        params.append("esn=").append(stmInfo.getEsn()).append("&lang=").append(LanguageManager.getInstance().getCurLanguage());
        if (Objects.nonNull(curUser) && !StringUtils.equals((CharSequence)curUser.getLoginAccount(), (CharSequence)"Default User") && Objects.nonNull(curUser.getIsPublicOmTerminal())) {
            params.append("&isPublic=").append(curUser.getIsPublicOmTerminal());
        }
        if (isJoinStm && StringUtils.isNotBlank((CharSequence)stmInfo.getVersionId())) {
            params.append("&certDate=").append(Optional.ofNullable(stmInfo.getCertDate()).orElse("")).append("&offeringId=").append(Optional.ofNullable(stmInfo.getOfferingId()).orElse("")).append("&installTime=").append(stmInfo.getInstallTime()).append("&country=").append(Optional.ofNullable(stmInfo.getCountry()).orElse("")).append("&region=").append(Optional.ofNullable(stmInfo.getRegion()).orElse("")).append("&province=").append(Optional.ofNullable(stmInfo.getProvince()).orElse("")).append("&city=").append(Optional.ofNullable(stmInfo.getCity()).orElse("")).append("&ft=").append(this.getFeatureOperationRecord(Boolean.FALSE));
        }
        return params;
    }

    private VerifyCodeRecordBo buildVerifyCodeBo(String verifyCode, DeviceIdInfoBo deviceIdInfoBo, String verifyType, String verifyCodeType) {
        VerifyCodeRecordBo codeRecordBo = new VerifyCodeRecordBo();
        codeRecordBo.setVerifyType(verifyType);
        codeRecordBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        codeRecordBo.setVerifyCode(verifyCode);
        codeRecordBo.setAccount(deviceIdInfoBo.getWindowsAccount());
        codeRecordBo.setActivePeriod("30");
        codeRecordBo.setVerifyStatus(2);
        codeRecordBo.setOperator(deviceIdInfoBo.getWindowsAccount());
        codeRecordBo.setVerifyCodeType(verifyCodeType);
        return codeRecordBo;
    }

    private StringBuilder joinQrParams(UserAuthenticateInfoBo curUser, StmInfoBo stmInfo, DeviceIdInfoBo deviceIdInfoBo, int[] returnCodes) {
        StringBuilder params = new StringBuilder();
        int sendStmReturnCode = returnCodes[0];
        int getAuthInfoReturnCode = returnCodes[1];
        int isConnected = returnCodes[2];
        int isControlled = returnCodes[3];
        if ((sendStmReturnCode == 0 || isTelnet) && getAuthInfoReturnCode == 0) {
            logger.info("sendStmInfoToClient & getAuthInfoFromClient all success.");
        } else if (sendStmReturnCode == 1 && getAuthInfoReturnCode == 1) {
            logger.info("sendStmInfoToClient & getAuthInfoFromClient all fail.");
            params = this.joinStmParams(curUser, deviceIdInfoBo, stmInfo, true);
            params.append("&isImport=Y").append("&sr=Y");
        } else if (!(isConnected != 0 && isControlled != 1 || sendStmReturnCode != 1 && getAuthInfoReturnCode != 0)) {
            logger.info("sendStmInfoToClient fail but getAuthInfoFromClient success.");
            params = this.joinStmParams(curUser, deviceIdInfoBo, stmInfo, true);
            params.append("&isImport=N").append("&sr=Y");
        } else {
            logger.info("sendStmInfoToClient success but getAuthInfoFromClient fail.");
            params = this.joinStmParams(curUser, deviceIdInfoBo, stmInfo, false);
            params.append("&isImport=Y").append("&sr=Y");
        }
        return params;
    }

    private Result joinQrParamsOnClient(StmInfoBo stmInfo, DeviceIdInfoBo deviceIdInfoBo, Map<String, String> controlPolicyMap, boolean isConnected, boolean isControlled) {
        logger.info("Start joinQrParamsOnClient.");
        int sendStmReturnCode = 1;
        if (isConnected) {
            sendStmReturnCode = this.sendStmInfoToClient(stmInfo, true);
        }
        int getAuthInfoReturnCode = this.commonDataDeal.getAuthInfoFromClient(deviceIdInfoBo, controlPolicyMap);
        UserAuthenticateInfoBo curUser = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        logger.info("joinQrParamsOnClient sendStmReturnCode {}, getAuthInfoReturnCode {}, curUser {}", new Object[]{sendStmReturnCode, getAuthInfoReturnCode, Objects.nonNull(curUser) ? curUser.getLoginAccountName() : null});
        if (StringUtils.equals((CharSequence)controlPolicyMap.get("controlPolicy"), (CharSequence)InitManageControlPolicyEnum.NOCONTROL_AND_STARTSCAN.getDataCode()) && !StringUtils.equals((CharSequence)controlPolicyMap.get("operatePermission"), (CharSequence)OperatePermissionEnum.SELECT.getValueEn())) {
            if (getAuthInfoReturnCode == 1 || Objects.isNull(curUser)) {
                this.createDefaultUser(InitManageControlPolicyEnum.NOCONTROL_AND_STARTSCAN.getDataCode(), null, null, OperatePermissionEnum.OPERATE.getValueEn(), null);
                this.createDefaultTask(null);
            }
            getAuthInfoReturnCode = 0;
        }
        StringBuilder verifyCode = new StringBuilder();
        ArrayList<VerifyCodeRecordBo> codeList = new ArrayList<VerifyCodeRecordBo>();
        for (int i = 0; i < 4; ++i) {
            String code = this.verifyCodeUtil.generalVerifyCode(6);
            Integer index = getAuthInfoReturnCode == 1 ? Integer.valueOf(-1) : null;
            VerifyCodeRecordBo verifyCodeRecordBo = this.buildVerifyCodeBo(code, deviceIdInfoBo, "\u767b\u5f55\u8ba4\u8bc1", String.valueOf(index));
            codeList.add(verifyCodeRecordBo);
            verifyCode.append(code).append("#");
        }
        this.verifyCodeUtil.addCodeCache(codeList);
        return this.joinQRInfo(stmInfo, deviceIdInfoBo, curUser, new int[]{sendStmReturnCode, getAuthInfoReturnCode, isConnected ? 0 : 1, isControlled ? 0 : 1}, verifyCode.toString());
    }

    private Result joinQRInfo(StmInfoBo stmInfo, DeviceIdInfoBo deviceIdInfoBo, UserAuthenticateInfoBo curUser, int[] returnCodes, String verifyCode) {
        StringBuilder params = this.joinQrParams(curUser, stmInfo, deviceIdInfoBo, returnCodes);
        if (ObjectUtils.isEmpty((Object)params)) {
            return Result.success();
        }
        String codeAndAccount = verifyCode.substring(0, verifyCode.length() - 1);
        if (Objects.nonNull(curUser) && !this.commonDataDeal.isExpired(curUser) && !StringUtils.equals((CharSequence)curUser.getLoginAccount(), (CharSequence)"Default User")) {
            codeAndAccount = codeAndAccount + "@" + curUser.getLoginAccount();
            if (Objects.nonNull(curUser.getIsPublicOmTerminal()) && curUser.getIsPublicOmTerminal().booleanValue()) {
                codeAndAccount = codeAndAccount + "@noCheckAccount";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)stmInfo.getVersionId())) {
            codeAndAccount = codeAndAccount + "@version=" + stmInfo.getVersionId();
        }
        String site = Objects.nonNull(curUser) ? curUser.getSite() : "";
        codeAndAccount = codeAndAccount + "@site=" + site + "@deviceId=" + deviceIdInfoBo.getDeviceId();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            String encryptStr = URLEncoder.encode(RsaUtil.encrypt(codeAndAccount, PropertyUtil.getString("pubkeyByEncrypt")), "UTF-8");
            String qrInfo = PropertyUtil.getScanQrUrl("toolInitializationUrl", Objects.nonNull(curUser) ? curUser.getSite() : null) + "?" + params + "&verify=" + encryptStr;
            resultMap.put("resultCode", "1");
            resultMap.put("resultMessage", qrInfo);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException ex) {
            logger.error("controlAndReportStm encrypt error {}", (Object)ex.getMessage());
            return Result.fail(ErrorCodeEnum.ENCRYPT_ERROR.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.ENCRYPT_ERROR.getErrorCode()));
        }
        return Result.success(resultMap);
    }

    private Result checkOfflineAuthUser() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        UserAuthenticateInfoBo curUser = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.nonNull(curUser) && StringUtils.equals((CharSequence)curUser.getLoginAccountName(), (CharSequence)"Offline AuthUser")) {
            logger.info("curUser is Offline AuthUser.");
            if (this.commonDataDeal.isExpired(curUser)) {
                logger.info("reportStmInfoAndInitialization, OFFLINE_AUTH_USER isExpired.");
                resultMap.put("resultCode", "3");
                resultMap.put("resultMessage", "Offline AuthUser isExpired");
            } else {
                resultMap.put("resultCode", "2");
                resultMap.put("resultMessage", "Offline AuthUser");
            }
            return Result.success(resultMap);
        }
        return null;
    }

    private Result checkRequiredParam(StmInfoBo stmInfo, boolean isControlled) {
        String toolId = stmInfo.getToolId();
        String esn = stmInfo.getEsn();
        logger.info("Start reportStmInfoAndInitialization, toolId is {}, versionIdf is {}esn is {}, isControlled is {}", new Object[]{toolId, stmInfo.getVersionId(), esn, isControlled});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{toolId, esn})) {
            logger.error("required param [toolId, esn] is empty.");
            return Result.fail(ErrorCodeEnum.PARAM_IS_EMPTY.getErrorCode(), this.internationalizeUtil.getMessage(ErrorCodeEnum.PARAM_IS_EMPTY.getErrorCode(), Collections.singletonList("[toolId, esn]")));
        }
        return null;
    }
}

