/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.service.login.impl;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.BizNesBo;
import com.huawei.netcareinsidesdk.bo.ControlPolicyConfigBo;
import com.huawei.netcareinsidesdk.bo.DatacomNetworkTiedCommandBo;
import com.huawei.netcareinsidesdk.bo.DatacomNetworkTiedDataBo;
import com.huawei.netcareinsidesdk.bo.DatacomNetworkTiedInterceptRecordBo;
import com.huawei.netcareinsidesdk.bo.ExcuteResultBo;
import com.huawei.netcareinsidesdk.bo.GigabitEthernetBo;
import com.huawei.netcareinsidesdk.bo.NeLoginCheckRecordBo;
import com.huawei.netcareinsidesdk.bo.RequestData;
import com.huawei.netcareinsidesdk.bo.TaskAccountBoundBo;
import com.huawei.netcareinsidesdk.bo.TaskInfoBo;
import com.huawei.netcareinsidesdk.bo.UserAuthenticateInfoBo;
import com.huawei.netcareinsidesdk.bo.VerifyCodeRecordBo;
import com.huawei.netcareinsidesdk.constants.BizNetCommandsEnum;
import com.huawei.netcareinsidesdk.constants.DatacomNetworkTiedPolicyEnum;
import com.huawei.netcareinsidesdk.constants.ErrorCodeEnum;
import com.huawei.netcareinsidesdk.constants.GigabitEthernetEnum;
import com.huawei.netcareinsidesdk.constants.InitManageControlPolicyEnum;
import com.huawei.netcareinsidesdk.constants.NeCheckTypeEnum;
import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dao.ControlPolicyConfigDao;
import com.huawei.netcareinsidesdk.dao.DatacomNetworkTiedCommandDao;
import com.huawei.netcareinsidesdk.dao.DatacomNetworkTiedDataDao;
import com.huawei.netcareinsidesdk.dao.DatacomNetworkTiedInterceptRecordDao;
import com.huawei.netcareinsidesdk.dao.EngineeringCommissioningNesMapper;
import com.huawei.netcareinsidesdk.dao.NeLoginCheckRecordForSdkDao;
import com.huawei.netcareinsidesdk.dao.TaskAccountBoundDao;
import com.huawei.netcareinsidesdk.dao.TaskInfoDao;
import com.huawei.netcareinsidesdk.dao.UserAuthenticateInfoDao;
import com.huawei.netcareinsidesdk.dao.VerifyCodeRecordDao;
import com.huawei.netcareinsidesdk.service.login.NELoginServiceForSdk;
import com.huawei.netcareinsidesdk.swing.pageService.AuthIdentity;
import com.huawei.netcareinsidesdk.swing.pageService.BizNetPage;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.HttpUtil;
import com.huawei.netcareinsidesdk.utils.PropertyUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.TelnetUtil;
import com.huawei.netcareinsidesdk.vo.BizNetInfoVo;
import com.huawei.netcareinsidesdk.vo.CommonCheckResult;
import com.huawei.netcareinsidesdk.vo.HandlingMethodVo;
import com.huawei.netcareinsidesdk.vo.NeLoginInfoVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NELoginServiceForSdkImpl
implements NELoginServiceForSdk {
    private static final Logger LOGGER = LoggerFactory.getLogger(NELoginServiceForSdkImpl.class);
    private static final String IP4_REGEX_EXPRESSION = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)";
    private static final String IP6_REGEX_EXPRESSION = "((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?";
    private static final String UP_STATUS = "up";
    private static final String POINT = ".";
    private static final String INVALID_ETHERNET_PORT = "0/0/0";
    private static final String INVALID_ETHERNET_PORT_REGEX = "^[0\\/]*0$";
    private static final Integer TASK_DELAY_NUM = 2;
    @Autowired
    private TaskAccountBoundDao taskAccountBoundDao;
    @Autowired
    private NeLoginCheckRecordForSdkDao neLoginCheckRecordForSdkDao;
    @Autowired
    private DatacomNetworkTiedCommandDao datacomNetworkTiedCommandDao;
    @Autowired
    private DatacomNetworkTiedDataDao tiedDataDao;
    @Autowired
    private DatacomNetworkTiedInterceptRecordDao interceptRecordDao;
    @Autowired
    private VerifyCodeRecordDao verifyCodeRecordDao;
    @Autowired
    private ControlPolicyConfigDao controlPolicyConfigDao;
    @Autowired
    private UserAuthenticateInfoDao userAuthenticateInfoDao;
    @Autowired
    private EngineeringCommissioningNesMapper nesMapper;
    @Autowired
    private TaskInfoDao taskInfoDao;
    @Autowired
    private TelnetUtil telnetUtil;
    @Autowired
    private BizNetPage bizNetPage;
    @Autowired
    private AuthIdentity authIdentity;

    @Override
    public Result loginNEaccountCheck(List<NeLoginInfoVo> accounts, String toolId) {
        if (CollectionUtils.isEmpty(accounts)) {
            LOGGER.error("The NE account verification list is empty.");
            return Result.fail(ErrorCodeEnum.PARAM_CAN_NOT_EMPTY.getErrorCode(), ErrorCodeEnum.PARAM_CAN_NOT_EMPTY.getErrorMessage());
        }
        ArrayList<NeLoginCheckRecordBo> recordBoList = new ArrayList<NeLoginCheckRecordBo>();
        ArrayList<String> illegalAccountList = new ArrayList<String>();
        CommonCheckResult neCheckResult = new CommonCheckResult("0", "", "");
        Optional<ErrorCodeEnum> sdkErrorCodeEnum = this.checkNeAccountByPolicy(accounts, recordBoList, illegalAccountList, neCheckResult);
        this.insertRecordAndJoinIllegalAccount(recordBoList, illegalAccountList, neCheckResult);
        if (sdkErrorCodeEnum.isPresent()) {
            ErrorCodeEnum errorCodeEnum = sdkErrorCodeEnum.get();
            return Result.fail(errorCodeEnum.getErrorCode(), errorCodeEnum.getErrorMessage());
        }
        return Result.success(neCheckResult);
    }

    @Override
    public Result innerNEaccountCheck(List<NeLoginInfoVo> accounts, String toolId) {
        if (CollectionUtils.isEmpty(accounts)) {
            LOGGER.error("The NE account verification list is empty.");
            return Result.fail(ErrorCodeEnum.PARAM_CAN_NOT_EMPTY.getErrorCode(), ErrorCodeEnum.PARAM_CAN_NOT_EMPTY.getErrorMessage());
        }
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            return Result.fail(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR.getErrorMessage());
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (Objects.isNull(taskInfoBo)) {
            LOGGER.error(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode());
            return Result.fail(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode(), ErrorCodeEnum.QUERY_ORDER_INFO_ERROR.getErrorCode());
        }
        ArrayList<NeLoginCheckRecordBo> recordBoList = new ArrayList<NeLoginCheckRecordBo>();
        ArrayList<String> illegalAccountList = new ArrayList<String>();
        CommonCheckResult neCheckResult = new CommonCheckResult("0", "", "");
        Optional<ErrorCodeEnum> sdkErrorCodeEnum = this.checkAccountAndRecord(accounts, recordBoList, illegalAccountList, null, taskInfoBo);
        this.insertRecordAndJoinIllegalAccount(recordBoList, illegalAccountList, neCheckResult);
        if (sdkErrorCodeEnum.isPresent()) {
            ErrorCodeEnum codeEnum = sdkErrorCodeEnum.get();
            return Result.fail(codeEnum.getErrorCode(), codeEnum.getErrorMessage());
        }
        return Result.success(neCheckResult);
    }

    private Optional<ErrorCodeEnum> checkNeAccountByPolicy(List<NeLoginInfoVo> accounts, List<NeLoginCheckRecordBo> recordBoList, List<String> illegalAccountList, CommonCheckResult neCheckResult) {
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            return Optional.of(ErrorCodeEnum.QUERY_USER_AUTH_INFO_ERROR);
        }
        TaskInfoBo taskInfoBo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (Objects.isNull(taskInfoBo)) {
            return Optional.of(ErrorCodeEnum.QUERY_ORDER_INFO_ERROR);
        }
        ControlPolicyConfigBo controlPolicyQuery = new ControlPolicyConfigBo();
        controlPolicyQuery.setRegionCode(userAuthenticateInfoBo.getRegionCode());
        controlPolicyQuery.setRepOfficeCode(userAuthenticateInfoBo.getRepOfficeCode());
        controlPolicyQuery.setOperator(userAuthenticateInfoBo.getLoginAccount());
        ControlPolicyConfigBo controlPolicyConfigBo = this.controlPolicyConfigDao.queryControlPolicyConfig(controlPolicyQuery);
        String neCheckType = controlPolicyConfigBo.getAccountCheckType();
        LOGGER.info("neCheckType is {}", (Object)neCheckType);
        if (StringUtils.isEmpty((CharSequence)neCheckType) || StringUtils.equals((CharSequence)neCheckType, (CharSequence)NeCheckTypeEnum.NO_DEAL.getNameEn())) {
            return Optional.empty();
        }
        if (StringUtils.equals((CharSequence)neCheckType, (CharSequence)NeCheckTypeEnum.ONLY_RECORD.getNameEn())) {
            return this.checkAccountAndRecord(accounts, recordBoList, illegalAccountList, neCheckType, taskInfoBo);
        }
        List<TaskAccountBoundBo> taskAccountBoundBoList = this.taskAccountBoundDao.queryCurTaskBindAccountInfo(taskInfoBo.getTaskId());
        if (CollectionUtils.isEmpty(taskAccountBoundBoList)) {
            return Optional.of(ErrorCodeEnum.NE_ACCOUNT_BOUND_ORDER_ERROR);
        }
        List<VerifyCodeRecordBo> lastRecord = this.queryVerifyCodeRecords(taskInfoBo);
        if (CollectionUtils.isEmpty(lastRecord) || this.isExpiredVerifyCode(lastRecord.get(0))) {
            if (StringUtils.equals((CharSequence)neCheckType, (CharSequence)NeCheckTypeEnum.FACE_VERIFICATION.getNameEn())) {
                return this.queryFaceResultForFront(accounts, recordBoList, illegalAccountList, taskInfoBo);
            }
        } else {
            return this.checkAccountAndRecord(accounts, recordBoList, illegalAccountList, neCheckType, taskInfoBo);
        }
        neCheckResult.setResultCode(NeCheckTypeEnum.SCAN_VERIFICATION.getCode());
        neCheckResult.setResultMessage("NE login authentication page.");
        this.authIdentity.authIdentity();
        return Optional.empty();
    }

    private Optional<ErrorCodeEnum> queryFaceResultForFront(List<NeLoginInfoVo> accounts, List<NeLoginCheckRecordBo> recordBoList, List<String> illegalAccountList, TaskInfoBo taskInfoBo) {
        Optional<ErrorCodeEnum> codeEnum;
        Map<String, Boolean> hasConnectedClient = this.telnetUtil.hasConnectedClient();
        boolean isConnected = hasConnectedClient.get("isConnected");
        if (!isConnected) {
            LOGGER.error("front disconnected!");
            return Optional.of(ErrorCodeEnum.HTTP_REQUEST_ERROR);
        }
        JSONObject responseJson = this.callFaceCheckInterFace(taskInfoBo);
        if (Objects.isNull(responseJson)) {
            return Optional.of(ErrorCodeEnum.NETCARECLIENT_ERROR);
        }
        VerifyCodeRecordBo faceCheckRecord = new VerifyCodeRecordBo();
        this.buildFaceCheckRecord(faceCheckRecord, taskInfoBo);
        LOGGER.info("FaceResultForFront responseJson {}", (Object)responseJson.toJSONString());
        if (responseJson.containsKey((Object)"status")) {
            String status = String.valueOf(responseJson.get((Object)"status"));
            if (StringUtils.equals((CharSequence)status, (CharSequence)"0")) {
                faceCheckRecord.setVerifyStatus(0);
                codeEnum = this.checkAccountAndRecord(accounts, recordBoList, illegalAccountList, NeCheckTypeEnum.FACE_VERIFICATION.getNameEn(), taskInfoBo);
            } else {
                codeEnum = this.dealExceptStatus(responseJson);
                faceCheckRecord.setVerifyStatus(1);
                faceCheckRecord.setVerifyFailCause(codeEnum.get().getErrorMessage());
            }
        } else {
            faceCheckRecord.setVerifyStatus(1);
            faceCheckRecord.setVerifyFailCause(ErrorCodeEnum.NETCARECLIENT_ERROR.getErrorMessage());
            codeEnum = Optional.of(ErrorCodeEnum.NETCARECLIENT_ERROR);
        }
        this.verifyCodeRecordDao.insertRecord(faceCheckRecord);
        return codeEnum;
    }

    private void buildFaceCheckRecord(VerifyCodeRecordBo faceCheckRecord, TaskInfoBo taskInfoBo) {
        faceCheckRecord.setVerifyType("\u8d26\u53f7\u8eab\u4efd\u9a8c\u8bc1");
        faceCheckRecord.setTaskId(taskInfoBo.getTaskId());
        faceCheckRecord.setCreateTime(DateUtil.getUtcDate(new Date()));
        faceCheckRecord.setVerifyTime(DateUtil.getUtcDate(new Date()));
        faceCheckRecord.setAccount(taskInfoBo.getTaskExecutor());
        faceCheckRecord.setOperator(taskInfoBo.getTaskExecutor());
        faceCheckRecord.setActivePeriod("30");
    }

    private JSONObject callFaceCheckInterFace(TaskInfoBo taskInfoBo) {
        String faceCheckUrl = PropertyUtil.getString("faceCheckfromClientUrl");
        RequestData requestData = new RequestData();
        requestData.setUrl(faceCheckUrl);
        requestData.setType("POST");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("account", (Object)taskInfoBo.getTaskExecutor());
        requestData.setParam(jsonObject);
        return HttpUtil.sendRest(requestData);
    }

    private Optional<ErrorCodeEnum> dealExceptStatus(JSONObject responseJson) {
        if (responseJson.containsKey((Object)"returnValue") && Objects.nonNull(responseJson.get((Object)"returnValue"))) {
            String returnValue = responseJson.get((Object)"returnValue").toString();
            LOGGER.error("Facial recognition failed, front-Machine return Vaule {}", (Object)returnValue);
            if (StringUtils.equals((CharSequence)returnValue, (CharSequence)"1001")) {
                return Optional.of(ErrorCodeEnum.NETCARECLIENT_ERROR);
            }
        }
        return Optional.of(ErrorCodeEnum.NETCARECLIENT_ERROR);
    }

    private List<VerifyCodeRecordBo> queryVerifyCodeRecords(TaskInfoBo taskInfoBo) {
        VerifyCodeRecordBo verifyCodeRecordBo = new VerifyCodeRecordBo();
        verifyCodeRecordBo.setTaskId(taskInfoBo.getTaskId());
        verifyCodeRecordBo.setVerifyType("\u8d26\u53f7\u8eab\u4efd\u9a8c\u8bc1");
        verifyCodeRecordBo.setAccount(taskInfoBo.getTaskExecutor());
        verifyCodeRecordBo.setVerifyStatus(0);
        verifyCodeRecordBo.setQueryCodeNum(1);
        return this.verifyCodeRecordDao.queryLastApplyByCondition(verifyCodeRecordBo);
    }

    private void fillNeLoginCheckRecordBo(NeLoginCheckRecordBo recordBo, NeLoginInfoVo accountVo, TaskInfoBo taskInfoBo, String checkType, String checkResult) {
        recordBo.setNeLoginAccount(accountVo.getAccount());
        recordBo.setLoginTime(DateUtil.getUtcDate(new Date()));
        recordBo.setLoginNe(accountVo.getLoginNe());
        recordBo.setTaskId(taskInfoBo.getTaskId());
        recordBo.setLoginUserAccount(taskInfoBo.getTaskExecutor());
        recordBo.setCheckType(checkType);
        recordBo.setCheckTime(DateUtil.getUtcDate(new Date()));
        recordBo.setCreateTime(DateUtil.getUtcDate(new Date()));
        recordBo.setCheckResult(checkResult);
        recordBo.setOperator(taskInfoBo.getTaskExecutor());
    }

    private Optional<ErrorCodeEnum> checkAccountAndRecord(List<NeLoginInfoVo> accounts, List<NeLoginCheckRecordBo> recordBoList, List<String> illegalAccountList, String checkType, TaskInfoBo taskInfoBo) {
        List<TaskAccountBoundBo> taskAccountBoundBoList = this.taskAccountBoundDao.queryCurTaskBindAccountInfo(taskInfoBo.getTaskId());
        if (CollectionUtils.isEmpty(taskAccountBoundBoList)) {
            LOGGER.error(ErrorCodeEnum.NE_ACCOUNT_BOUND_ORDER_ERROR.getErrorMessage());
            return Optional.of(ErrorCodeEnum.NE_ACCOUNT_BOUND_ORDER_ERROR);
        }
        List accountList = taskAccountBoundBoList.stream().map(TaskAccountBoundBo::getAccount).collect(Collectors.toList());
        for (NeLoginInfoVo accountVo : accounts) {
            NeLoginCheckRecordBo recordBo;
            String account = accountVo.getAccount();
            if (StringUtils.isEmpty((CharSequence)accountVo.getAccount())) {
                LOGGER.error("The account cannot is empty.");
                return Optional.of(ErrorCodeEnum.PARAM_CAN_NOT_EMPTY);
            }
            if (accountList.contains(account)) {
                recordBo = new NeLoginCheckRecordBo();
                this.fillNeLoginCheckRecordBo(recordBo, accountVo, taskInfoBo, checkType, "0");
                recordBoList.add(recordBo);
                continue;
            }
            recordBo = new NeLoginCheckRecordBo();
            this.fillNeLoginCheckRecordBo(recordBo, accountVo, taskInfoBo, checkType, "1");
            recordBoList.add(recordBo);
            if (StringUtils.equals((CharSequence)checkType, (CharSequence)NeCheckTypeEnum.ONLY_RECORD.getNameEn())) continue;
            illegalAccountList.add(account);
        }
        return Optional.empty();
    }

    private void insertRecordAndJoinIllegalAccount(List<NeLoginCheckRecordBo> recordBoList, List<String> illegalAccountList, CommonCheckResult neCheckResult) {
        if (!recordBoList.isEmpty()) {
            this.neLoginCheckRecordForSdkDao.batchInsertForSdk(recordBoList);
            LOGGER.info("neLoginCheckRecord insert success.");
        }
        if (!illegalAccountList.isEmpty()) {
            String errMsg = "Failed to log in because the account %s is not assigned to you. Please use your account to log in.";
            String accountListStr = JSONObject.toJSONString(illegalAccountList);
            String replace = accountListStr.replace("\"", "");
            neCheckResult.setResultCode("1");
            neCheckResult.setResultMessage(String.format(Locale.ROOT, errMsg, replace));
        }
    }

    @Override
    public Result getBizNetChkCommand() {
        LOGGER.info("start getBizNetChkCommand");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        JSONObject jsonObject = new JSONObject();
        if (ObjectUtils.isEmpty((Object)userAuthenticateInfoBo)) {
            LOGGER.error("An error occurred when initializing data.");
            return Result.fail("1", "An error occurred when initializing data.");
        }
        if (StringUtils.isNotEmpty((CharSequence)userAuthenticateInfoBo.getInitManageControlPolicy()) && !StringUtils.equals((CharSequence)userAuthenticateInfoBo.getInitManageControlPolicy(), (CharSequence)InitManageControlPolicyEnum.CONTROL_SCAN.getDataCode())) {
            jsonObject.put("resultCode", (Object)"2");
            jsonObject.put("resultMessage", (Object)"When the initial management and control policy is set to no control, the datacom network connection is not intercepted.");
            LOGGER.info("When the initial management and control policy is set to no control, the datacom network connection is not intercepted.");
            return Result.success(jsonObject);
        }
        TaskInfoBo taskInfo = this.taskInfoDao.queryCurActiveTask(DateUtil.getUtcDate(new Date()), userAuthenticateInfoBo.getLoginAccount());
        if (ObjectUtils.isEmpty((Object)taskInfo) || ObjectUtils.isNotEmpty((Object)taskInfo) && !TaskTypeEnum.PROJECT.getTaskTypeEn().equals(taskInfo.getTaskType())) {
            jsonObject.put("resultCode", (Object)"2");
            jsonObject.put("resultMessage", (Object)"The task is not project, The current policy is not blocked.");
            LOGGER.info("The task is not project, The current policy is not blocked.");
            return Result.success(jsonObject);
        }
        if (StringUtils.isBlank((CharSequence)userAuthenticateInfoBo.getDatacomNetworkTiedPolicy()) || StringUtils.contains((CharSequence)userAuthenticateInfoBo.getDatacomNetworkTiedPolicy(), (CharSequence)DatacomNetworkTiedPolicyEnum.NO_INTERCEPT.getValueEn())) {
            jsonObject.put("resultCode", (Object)"2");
            jsonObject.put("resultMessage", (Object)"The current policy is not blocked.");
            LOGGER.info("The current policy is not blocked.");
            return Result.success(jsonObject);
        }
        List<DatacomNetworkTiedCommandBo> commandBos = this.datacomNetworkTiedCommandDao.queryDatacomNetworkTiedCommand(userAuthenticateInfoBo.getLoginAccount());
        DateUtil.dbTimeTranslationWebUtc(commandBos, "createTime");
        jsonObject.put("resultCode", (Object)"0");
        jsonObject.put("resultMessage", commandBos);
        LOGGER.info("end getBizNetChkCommand");
        return Result.success(jsonObject);
    }

    @Override
    public Result checkBizNetAccess(List<ExcuteResultBo> excuteResultBos, String connectNeIp) {
        LOGGER.info("start checkBizNetAccess");
        if (ObjectUtils.isNotEmpty(excuteResultBos) && excuteResultBos.size() > 0) {
            return this.checkExeCommandResult(excuteResultBos, connectNeIp);
        }
        JSONObject jsonObject = new JSONObject();
        this.doNotIntercept(jsonObject);
        LOGGER.info("end checkBizNetAccess");
        return Result.success(jsonObject);
    }

    @Override
    public Result getBizNetChkCommandInterceptRecord(String guid) {
        LOGGER.info("start getBizNetChkCommandInterceptRecord");
        DatacomNetworkTiedInterceptRecordBo datacomNetworkTiedInterceptRecordBo = this.interceptRecordDao.selectByGuid(guid);
        JSONObject jsonObject = new JSONObject();
        if (ObjectUtils.isEmpty((Object)datacomNetworkTiedInterceptRecordBo)) {
            jsonObject.put("resultCode", (Object)"1");
            jsonObject.put("resultMessage", (Object)"Invalid guid.");
            return Result.success(jsonObject);
        }
        HandlingMethodVo handlingMethodVo = new HandlingMethodVo();
        BeanUtils.copyProperties((Object)datacomNetworkTiedInterceptRecordBo, (Object)handlingMethodVo);
        jsonObject.put("resultCode", (Object)"0");
        jsonObject.put("resultMessage", (Object)handlingMethodVo);
        LOGGER.info("end getBizNetChkCommandInterceptRecord");
        return Result.success(jsonObject);
    }

    private Result checkExeCommandResult(List<ExcuteResultBo> excuteResultBos, String connectNeIp) {
        LOGGER.info("start checkExeCommandResult");
        UserAuthenticateInfoBo userAuthenticateInfoBo = this.userAuthenticateInfoDao.queryActiveStatusUserInfo();
        if (Objects.isNull(userAuthenticateInfoBo)) {
            LOGGER.error("Initialization data does not exist.");
            return Result.fail("1", "Initialization data does not exist.");
        }
        TaskInfoBo taskInfo = this.taskInfoDao.queryCurActiveTask(null, userAuthenticateInfoBo.getLoginAccount());
        if (ObjectUtils.isEmpty((Object)taskInfo)) {
            return Result.fail("1", "There is no valid task.");
        }
        Map<String, List<String>> readLineBizNetInfo = this.resolveBizNetLine(userAuthenticateInfoBo, excuteResultBos);
        JSONObject jsonObject = new JSONObject();
        this.doNotIntercept(jsonObject);
        if (readLineBizNetInfo.isEmpty()) {
            return Result.success(jsonObject);
        }
        int upNums = this.resolvePhysicalUpNum(readLineBizNetInfo);
        if (upNums > 0) {
            BizNesBo bizNesBo = new BizNesBo();
            bizNesBo.setReadLineNes(readLineBizNetInfo);
            this.putBizNetInfo(connectNeIp, taskInfo, upNums, bizNesBo);
            Result verifyInterceptionPolicyResult = this.verifyInterceptionPolicy(userAuthenticateInfoBo, bizNesBo);
            if (verifyInterceptionPolicyResult != null) {
                LOGGER.info("end checkBizNetAccess");
                return verifyInterceptionPolicyResult;
            }
        }
        this.doNotIntercept(jsonObject);
        LOGGER.info("end checkBizNetAccess");
        return Result.success(jsonObject);
    }

    private void putBizNetInfo(String connectNeIp, TaskInfoBo taskInfo, int upNums, BizNesBo bizNesBo) {
        bizNesBo.setConnectNeIp(connectNeIp);
        bizNesBo.setUpNum(upNums);
        bizNesBo.setTaskId(taskInfo.getTaskId());
    }

    private Result verifyInterceptionPolicy(UserAuthenticateInfoBo userInfo, BizNesBo bizNesBo) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resultCode", (Object)"1");
        if (StringUtils.isBlank((CharSequence)userInfo.getDatacomNetworkTiedPolicy()) || DatacomNetworkTiedPolicyEnum.NO_INTERCEPT.getValueEn().equals(userInfo.getDatacomNetworkTiedPolicy())) {
            this.doNotIntercept(jsonObject);
            return Result.success(jsonObject);
        }
        int engineeringCommissioningNesNums = this.queryEngineeringCommissioningNesNums(bizNesBo);
        if (engineeringCommissioningNesNums > 0) {
            this.doNotIntercept(jsonObject);
            return Result.success(jsonObject);
        }
        List<String> nesFalseBos = this.checkDisplayIpInterfaceBrief(bizNesBo);
        if (ObjectUtils.isNotEmpty(nesFalseBos) && nesFalseBos.size() > 0) {
            bizNesBo.setNesNum(nesFalseBos.size());
        }
        String guid = UUID.randomUUID().toString();
        bizNesBo.setGuid(guid);
        if (DatacomNetworkTiedPolicyEnum.HINT_ONLY.getValueEn().equals(userInfo.getDatacomNetworkTiedPolicy())) {
            this.addInterceptRecord(userInfo, bizNesBo);
            this.putBizNetUri(jsonObject, bizNesBo, DatacomNetworkTiedPolicyEnum.HINT_ONLY.getCode(), guid);
            LOGGER.info("Hint only.");
            return Result.success(jsonObject);
        }
        if (DatacomNetworkTiedPolicyEnum.INTERCEPTION_SCANNING_BYPASS.getValueEn().equals(userInfo.getDatacomNetworkTiedPolicy())) {
            this.addInterceptRecord(userInfo, bizNesBo);
            this.putBizNetUri(jsonObject, bizNesBo, DatacomNetworkTiedPolicyEnum.INTERCEPTION_SCANNING_BYPASS.getCode(), guid);
            LOGGER.info("Interception scanning bypass.");
            return Result.success(jsonObject);
        }
        if (DatacomNetworkTiedPolicyEnum.INTERCEPTION_APPROVAL_BYPASS.getValueEn().equals(userInfo.getDatacomNetworkTiedPolicy())) {
            this.addInterceptRecord(userInfo, bizNesBo);
            this.putBizNetUri(jsonObject, bizNesBo, DatacomNetworkTiedPolicyEnum.INTERCEPTION_APPROVAL_BYPASS.getCode(), guid);
            LOGGER.info("Intercept approval bypass.");
            return Result.success(jsonObject);
        }
        return null;
    }

    private List<String> checkDisplayIpInterfaceBrief(BizNesBo bizNesBo) {
        Map<String, List<String>> readLineNes = bizNesBo.getReadLineNes();
        if (readLineNes.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, List<String>> nes : bizNesBo.getReadLineNes().entrySet()) {
            if (!StringUtils.equals((CharSequence)nes.getKey(), (CharSequence)BizNetCommandsEnum.DISPLAY_IP_INTERFACE_BRIEF.getCommand()) || !ObjectUtils.isNotEmpty((Object)bizNesBo.getIsMatching()) || !bizNesBo.getIsMatching().booleanValue()) continue;
            return this.nesMapper.queryEngineeringCommissioningNesByTaskIdTag(bizNesBo.getTaskId(), Boolean.FALSE);
        }
        return null;
    }

    private void putBizNetUri(JSONObject jsonObject, BizNesBo bizNesBo, String redirectCode, String guid) {
        jsonObject.put("resultMessage", (Object)"Datacom grid-tied page.");
        jsonObject.put("guid", (Object)guid);
        this.bizNetPage.drawBizNetPage(Integer.parseInt(redirectCode), bizNesBo, guid);
    }

    private int queryEngineeringCommissioningNesNums(BizNesBo bizNesBoParams) {
        BizNetInfoVo bizNetInfoVo = new BizNetInfoVo();
        bizNetInfoVo.setNesMap(bizNesBoParams.getReadLineNes());
        bizNetInfoVo.setTaskId(bizNesBoParams.getTaskId());
        return this.resolveCommissioningNes(bizNetInfoVo, bizNesBoParams);
    }

    private void doNotIntercept(JSONObject jsonObject) {
        jsonObject.put("resultCode", (Object)"0");
        jsonObject.put("resultMessage", (Object)"Don't intercept");
        LOGGER.info("the method doNotIntercept, don't intercept");
    }

    private void addInterceptRecord(UserAuthenticateInfoBo userAuthenticateInfoBo, BizNesBo bizNesBo) {
        LOGGER.info("start addInterceptRecord");
        StringJoiner commands = new StringJoiner(", ");
        for (Map.Entry<String, List<String>> entry : bizNesBo.getReadLineNes().entrySet()) {
            commands.add(entry.getKey());
        }
        DatacomNetworkTiedInterceptRecordBo interceptRecordBo = new DatacomNetworkTiedInterceptRecordBo();
        this.putDatacomNetworkTied(userAuthenticateInfoBo, bizNesBo, commands, interceptRecordBo);
        DatacomNetworkTiedInterceptRecordBo datacomNetworkTiedInterceptRecordBo = this.interceptRecordDao.selectDatacomNetworkTiedInterceptRecordByTaskId(bizNesBo.getTaskId());
        if (Objects.nonNull(datacomNetworkTiedInterceptRecordBo)) {
            LOGGER.info("Update Datacom Network-tied Interception Records to the Database");
            this.interceptRecordDao.deleteDatacomNetworkTiedInterceptRecordByTaskId(bizNesBo.getTaskId());
            this.interceptRecordDao.add(interceptRecordBo);
        } else {
            LOGGER.info("Importing Datacom Network-tied Interception Records to the Database");
            this.interceptRecordDao.add(interceptRecordBo);
        }
        this.tiedDataDao.deleteDatacomNetworkTiedData();
        DatacomNetworkTiedDataBo record = new DatacomNetworkTiedDataBo();
        record.setSourceData(JSONObject.toJSONString(bizNesBo.getReadLineNes()));
        record.setCreateTime(DateUtil.getUtcDate(new Date()));
        LOGGER.info("Importing Datacom Network-tied Data to the Database");
        this.tiedDataDao.addDatacomNetworkTiedData(record);
    }

    private void putDatacomNetworkTied(UserAuthenticateInfoBo userAuthenticateInfoBo, BizNesBo bizNesBo, StringJoiner commands, DatacomNetworkTiedInterceptRecordBo interceptRecordBo) {
        interceptRecordBo.setInterceptTime(DateUtil.getUtcDate(new Date()));
        interceptRecordBo.setCommand(commands.toString());
        interceptRecordBo.setOperator(userAuthenticateInfoBo.getLoginAccount());
        interceptRecordBo.setGuid(bizNesBo.getGuid());
        interceptRecordBo.setTaskId(bizNesBo.getTaskId());
        interceptRecordBo.setPostInterceptMode(userAuthenticateInfoBo.getDatacomNetworkTiedPolicy());
        interceptRecordBo.setProductType(bizNesBo.getConnectNeIp());
        interceptRecordBo.setAnalysisResults(String.valueOf(bizNesBo.getNesNum()));
        interceptRecordBo.setSubReason(String.valueOf(bizNesBo.getUpNum()));
    }

    private boolean isExpiredVerifyCode(VerifyCodeRecordBo verifyCodeRecord) {
        String period = StringUtils.isNotEmpty((CharSequence)verifyCodeRecord.getActivePeriod()) ? verifyCodeRecord.getActivePeriod() : "30";
        long activePeriod = Long.parseLong(period) * 60L * 1000L;
        long createTime = verifyCodeRecord.getCreateTime().getTime();
        return DateUtil.getUtcDate(new Date()).getTime() > createTime + activePeriod;
    }

    public Map<String, List<String>> resolveBizNetLine(UserAuthenticateInfoBo authenticateInfoBo, List<ExcuteResultBo> excuteResultBos) {
        LOGGER.info("start resolveBizNetLine");
        ArrayList<ExcuteResultBo> readLineBizNet = new ArrayList<ExcuteResultBo>();
        if (CollectionUtils.isEmpty(excuteResultBos)) {
            return null;
        }
        List<String> commands = this.datacomNetworkTiedCommandDao.queryDatacomNetworkTiedCommands(authenticateInfoBo.getLoginAccount());
        if (CollectionUtils.isEmpty(commands)) {
            return null;
        }
        excuteResultBos.forEach(excuteResultBo -> {
            if (commands.contains(excuteResultBo.getExeCommand())) {
                ExcuteResultBo readLine = new ExcuteResultBo();
                readLine.setExeResult(excuteResultBo.getExeResult());
                readLine.setExeCommand(excuteResultBo.getExeCommand());
                readLineBizNet.add(readLine);
            }
        });
        LOGGER.info("end resolveBizNetLine, resolveBizNetLine success.");
        return this.readStringLines(readLineBizNet);
    }

    private Map<String, List<String>> readStringLines(List<ExcuteResultBo> excuteResultBos) {
        LOGGER.info("start readStringLines");
        HashMap<String, List<String>> readLineMap = new HashMap<String, List<String>>();
        for (ExcuteResultBo excuteResultBo : excuteResultBos) {
            ArrayList readLineList = new ArrayList();
            String[] strings = excuteResultBo.getExeResult().split("\\r\\n|\\r|\\n");
            Collections.addAll(readLineList, strings);
            readLineMap.put(excuteResultBo.getExeCommand(), readLineList);
        }
        LOGGER.info("end readStringLines");
        return readLineMap;
    }

    public Integer resolvePhysicalUpNum(Map<String, List<String>> readLineBizNetInfo) {
        LOGGER.info("start resolvePhysicalUpNum");
        int upNum = 0;
        if (readLineBizNetInfo.isEmpty()) {
            return upNum;
        }
        ArrayList<String> activeUpLine = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : readLineBizNetInfo.entrySet()) {
            this.checkDisplayInterfaceBriefResult(activeUpLine, entry);
        }
        if (CollectionUtils.isEmpty(activeUpLine)) {
            return upNum;
        }
        ArrayList gigabitEthernetBos = new ArrayList();
        activeUpLine.forEach(line -> {
            GigabitEthernetBo ethernetBo = new GigabitEthernetBo();
            String[] ethernetStrs = line.trim().split("\\s+");
            if (!ethernetStrs[0].contains(POINT) && UP_STATUS.equals(ethernetStrs[1]) && this.deleteInvalidEthernetPort(ethernetStrs[0])) {
                ethernetBo.setInterfaceName(ethernetStrs[0]);
                ethernetBo.setPhy(ethernetStrs[1]);
                gigabitEthernetBos.add(ethernetBo);
            }
        });
        if (ObjectUtils.isNotEmpty(gigabitEthernetBos) && gigabitEthernetBos.size() > 0) {
            LOGGER.info("end resolvePhysicalUpNum, the up nums is {}.", (Object)gigabitEthernetBos.size());
            return gigabitEthernetBos.size();
        }
        LOGGER.info("end resolvePhysicalUpNum, the up nums is {}.", (Object)upNum);
        return upNum;
    }

    private boolean deleteInvalidEthernetPort(String ethernetPort) {
        String replace;
        String substring;
        LOGGER.info("start deleteInvalidEthernetPort");
        if (ethernetPort.contains(INVALID_ETHERNET_PORT) && (substring = (replace = ethernetPort.replace(" ", "")).substring(GigabitEthernetEnum.G_E.getValue().length())).matches(INVALID_ETHERNET_PORT_REGEX)) {
            LOGGER.info("end deleteInvalidEthernetPort return false.");
            return false;
        }
        LOGGER.info("end deleteInvalidEthernetPort return true.");
        return true;
    }

    private void checkDisplayInterfaceBriefResult(List<String> activeLine, Map.Entry<String, List<String>> readLineMap) {
        LOGGER.info("start checkDisplayInterfaceBriefResult");
        if (readLineMap.getKey().contains(BizNetCommandsEnum.DISPLAY_INTERFACE_BRIEF.getCommand())) {
            for (String line : readLineMap.getValue()) {
                if (!GigabitEthernetEnum.checkEthernet(line)) continue;
                activeLine.add(line);
            }
        }
        LOGGER.info("end checkDisplayInterfaceBriefResult");
    }

    private void checkDisplayIpInterfaceBriefResult(List<String> nesIps, Map.Entry<String, List<String>> readLineMap) {
        LOGGER.info("start checkDisplayIpInterfaceBriefResult.");
        if (readLineMap.getKey().contains(BizNetCommandsEnum.DISPLAY_IP_INTERFACE_BRIEF.getCommand())) {
            for (String line : readLineMap.getValue()) {
                String nesIp6Line;
                String nesIp4Line = this.matcherNesLine(IP4_REGEX_EXPRESSION, line);
                if (StringUtils.isNotBlank((CharSequence)nesIp4Line)) {
                    nesIps.add(nesIp4Line);
                }
                if (!StringUtils.isNotBlank((CharSequence)(nesIp6Line = this.matcherNesLine(IP6_REGEX_EXPRESSION, line)))) continue;
                nesIps.add(nesIp6Line);
            }
            LOGGER.info("end checkDisplayIpInterfaceBriefResult, ipv4 and ipv6 nums is {}.", (Object)nesIps.size());
        }
    }

    private String matcherNesLine(String ipRegex, String nesLine) {
        Pattern pattern = Pattern.compile(ipRegex);
        Matcher isMatch = pattern.matcher(nesLine);
        boolean riskFlag = isMatch.find();
        if (riskFlag) {
            return isMatch.group();
        }
        return null;
    }

    public Integer resolveCommissioningNes(BizNetInfoVo bizNetInfoVo, BizNesBo bizNesBoParams) {
        LOGGER.info("start resolveCommissioningNes.");
        int ipNum = 0;
        if (bizNetInfoVo.getNesMap().isEmpty()) {
            return ipNum;
        }
        ArrayList<String> nesIps = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : bizNetInfoVo.getNesMap().entrySet()) {
            this.checkDisplayIpInterfaceBriefResult(nesIps, entry);
        }
        if (CollectionUtils.isEmpty(nesIps)) {
            return ipNum;
        }
        List<String> nesBos = this.nesMapper.queryEngineeringCommissioningNesByTaskIdTag(bizNetInfoVo.getTaskId(), null);
        if (CollectionUtils.isEmpty(nesBos)) {
            return ipNum;
        }
        List stream = nesIps.stream().filter(nesBos::contains).collect(Collectors.toList());
        if (stream.size() > 0) {
            List<String> nesTrueBos = this.nesMapper.queryEngineeringCommissioningNesByTaskIdTag(bizNetInfoVo.getTaskId(), Boolean.TRUE);
            if (ObjectUtils.isNotEmpty(nesTrueBos) && nesTrueBos.size() > 0) {
                LOGGER.info("end resolvePhysicalUpNum, the matching true ip nums is {}.", stream);
                return nesTrueBos.size();
            }
            bizNesBoParams.setIsMatching(Boolean.TRUE);
            LOGGER.info("end resolveCommissioningNes, the matching false ip nums is {}.", stream);
            return ipNum;
        }
        LOGGER.info("end resolveCommissioningNes, the ip nums is {}.", (Object)ipNum);
        return ipNum;
    }
}

