/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.component;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TaskNameDocument
extends PlainDocument {
    private static final long serialVersionUID = -2845133006781306566L;
    private static final Pattern TASK_NAME_PATTERN = Pattern.compile("^[^~`@#$%^&*(=/\\:*?\"<>|;!]+$");
    private Integer maxLength;

    public TaskNameDocument(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (offset >= this.maxLength) {
            return;
        }
        if (this.getLength() + str.length() > this.maxLength) {
            return;
        }
        Matcher taskNameMatcher = TASK_NAME_PATTERN.matcher(str);
        if (!taskNameMatcher.matches()) {
            return;
        }
        super.insertString(offset, str, attr);
    }
}

