/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.component;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.StringUtils;

public class TaskTimeCheckDocument
extends PlainDocument {
    private static final long serialVersionUID = -9016303465693274993L;
    private String numType;
    private String maxNum;
    private String defaultString;

    public TaskTimeCheckDocument(String maxNum, String numType, String defaultString) {
        this.maxNum = maxNum;
        this.numType = numType;
        this.defaultString = defaultString;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        String input;
        String originText = super.getText(0, super.getLength());
        if (StringUtils.isEmpty((CharSequence)originText) && StringUtils.isNotBlank((CharSequence)str) && str.equals(this.defaultString)) {
            super.insertString(offset, str, attr);
            return;
        }
        String string = input = StringUtils.equals((CharSequence)this.numType, (CharSequence)"double") ? "0123456789." : "0123456789";
        if (input.indexOf(str) < 0) {
            return;
        }
        String text = "";
        text = StringUtils.isBlank((CharSequence)originText) ? str : originText.substring(0, offset) + str + originText.substring(offset);
        if (text.startsWith(".") || text.startsWith("00")) {
            return;
        }
        Integer maxLength = StringUtils.equals((CharSequence)this.numType, (CharSequence)"double") ? this.maxNum.length() + 2 : this.maxNum.length() + 1;
        if (text.length() > maxLength) {
            return;
        }
        if (StringUtils.equals((CharSequence)this.numType, (CharSequence)"double")) {
            if (!this.checkDouble(offset, text, attr).booleanValue()) {
                return;
            }
        } else {
            int max;
            int result = Integer.parseInt(text);
            if (result > (max = Integer.parseInt(this.maxNum))) {
                super.remove(0, offset);
                super.insertString(0, this.maxNum, attr);
                return;
            }
        }
        super.insertString(offset, str, attr);
    }

    private Boolean checkDouble(int offset, String text, AttributeSet attr) throws BadLocationException {
        try {
            String[] split;
            Double result = Double.parseDouble(text);
            Double max = Double.parseDouble(this.maxNum);
            if (Double.compare(result, max) > 0) {
                super.remove(0, offset);
                super.insertString(0, this.maxNum, attr);
                return false;
            }
            if (text.contains(".") && (split = text.split("\\.")).length >= 2 && split[1].length() > 1) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

