/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.filter;

import java.util.regex.Pattern;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class NumericVerifier
extends InputVerifier {
    private static final Pattern VERY_CODE_PATTERN = Pattern.compile("^[0-9]+$");
    private Integer maxLength;

    public NumericVerifier(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public boolean verify(JComponent input) {
        if (input instanceof JTextField) {
            String text = ((JTextField)input).getText();
            if (StringUtils.isBlank((CharSequence)text)) {
                return true;
            }
            if (text.length() > this.maxLength) {
                return false;
            }
            return VERY_CODE_PATTERN.matcher(text).find();
        }
        return false;
    }
}

