/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.listener;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class JTextFieldHintListener
implements FocusListener {
    private String hintText;
    private JTextField textField;

    public JTextFieldHintListener(JTextField jTextField, String hintText, Color color) {
        this.textField = jTextField;
        this.hintText = hintText;
        jTextField.setText(hintText);
        jTextField.setForeground(color);
    }

    @Override
    public void focusLost(FocusEvent event) {
        String tempText = this.textField.getText();
        if (StringUtils.isBlank((CharSequence)tempText)) {
            this.textField.setForeground(Color.GRAY);
            this.textField.setText(this.hintText);
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        String tempText = this.textField.getText();
        if (StringUtils.isNotBlank((CharSequence)tempText) && tempText.equals(this.hintText)) {
            this.textField.setText("");
            this.textField.setForeground(Color.BLACK);
        }
    }
}

