/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.listener;

import com.huawei.netcareinsidesdk.constants.TaskTypeEnum;
import com.huawei.netcareinsidesdk.dto.TaskTimeRelationDto;
import com.huawei.netcareinsidesdk.swing.component.CalendarTextField;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.SpringContextUtils;
import com.huawei.netcareinsidesdk.vo.TaskInfoVo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyDocumentListener
implements DocumentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyDocumentListener.class);
    CommonUtils commonUtils = SpringContextUtils.getBean(CommonUtils.class);
    InternationalizeUtil internationalizeBean = SpringContextUtils.getBean(InternationalizeUtil.class);
    private static final Pattern PATTERN = Pattern.compile("^\\d+(\\.\\d+)?$");
    private TaskInfoVo taskInfoVo;
    private JTextField inputField;
    private JTextField operationDurationField;
    private JTextField prepareDurationField;
    private String fieldName;
    WhiteJDialog frame;

    public MyDocumentListener(WhiteJDialog frame, TaskInfoVo taskInfoVo, JTextField inputField, String fieldName) {
        this.taskInfoVo = taskInfoVo;
        this.inputField = inputField;
        this.fieldName = fieldName;
        this.frame = frame;
    }

    public MyDocumentListener(WhiteJDialog frame, TaskTimeRelationDto taskTimeRelationDto) {
        this.taskInfoVo = taskTimeRelationDto.getTaskInfoVo();
        this.inputField = taskTimeRelationDto.getInputField();
        this.fieldName = taskTimeRelationDto.getFieldName();
        this.operationDurationField = taskTimeRelationDto.getOperationDurationField();
        this.prepareDurationField = taskTimeRelationDto.getPrepareDurationField();
        this.frame = frame;
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.updateTaskInfoVo();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.updateTaskInfoVo();
    }

    private boolean checkValidTimeFromat(String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            try {
                if (text.length() != 19) {
                    return false;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = sdf.parse(text);
            }
            catch (ParseException ex) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void updateTaskInfoVo() {
        if (this.fieldName.equals("taskName")) {
            this.taskInfoVo.setTaskName(this.inputField.getText());
            return;
        }
        if (this.fieldName.equals("operationDuration")) {
            if (PATTERN.matcher(this.inputField.getText()).matches()) {
                this.taskInfoVo.setOperationDuration(this.inputField.getText());
            } else {
                this.taskInfoVo.setOperationDuration("");
            }
            return;
        }
        if (this.checkOperationStartTime()) {
            return;
        }
        if (this.checkOperationEndTime()) {
            return;
        }
        this.checkOperationPrepareTime();
    }

    private boolean checkOperationEndTime() {
        if (this.fieldName.equals("taskEndTime") && this.inputField instanceof CalendarTextField) {
            if (!this.checkValidTimeFromat(this.inputField.getText())) {
                this.taskInfoVo.setTaskEndTime(null);
                this.setInvalidOperationDurationTip("END_TIME_TIPS");
                return true;
            }
            Date taskEndTime = DateUtil.formatToSpecificDate(((CalendarTextField)this.inputField).getDate());
            this.taskInfoVo.setTaskEndTime(taskEndTime);
            if (StringUtils.equals((CharSequence)this.taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()) && Objects.isNull(this.taskInfoVo.getOperationPreparationTime())) {
                this.setInvalidPrepareTips("SELECT_PRE");
                return true;
            }
            if (Objects.isNull(this.taskInfoVo.getTaskStartTime())) {
                this.setInvalidPreAndOpDurationTips("SELECT_START_TIME");
                return true;
            }
            if (taskEndTime.before(DateUtil.formatToSpecificDate(new Date()))) {
                this.setInvalidOperationDurationTip("END_BRFORE_CURRENT_TIP");
                return true;
            }
            if (taskEndTime.compareTo(this.taskInfoVo.getTaskStartTime()) == 0) {
                this.setInvalidOperationDurationTip("OPERATION_DUR_GREATER");
                return true;
            }
            if (taskEndTime.before(this.taskInfoVo.getTaskStartTime())) {
                this.setInvalidOperationDurationTip("END_TIME_TIP");
                return true;
            }
            if (!StringUtils.equals((CharSequence)this.taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()) && taskEndTime.compareTo(this.taskInfoVo.getTaskStartTime()) == 0) {
                this.setInvalidOperationDurationTip("OPERATION_DUR_GREATER");
                return true;
            }
            if (this.checkOperationDuration(this.taskInfoVo.getTaskStartTime(), taskEndTime) && this.checkDurationSum(this.taskInfoVo.getOperationPreparationTime(), this.taskInfoVo.getTaskEndTime(), true)) {
                String operationDuration = DateUtil.caculateTimeDiff(this.taskInfoVo.getTaskStartTime(), taskEndTime);
                this.taskInfoVo.setOperationDuration(operationDuration);
                this.operationDurationField.setText(operationDuration);
            }
            return true;
        }
        return false;
    }

    private boolean checkOperationStartTime() {
        if (this.fieldName.equals("taskStartTime") && this.inputField instanceof CalendarTextField) {
            if (!this.checkValidTimeFromat(this.inputField.getText())) {
                this.taskInfoVo.setTaskStartTime(null);
                this.setInvalidPreAndOpDurationTips("START_TIME_TIPS");
                return true;
            }
            Date taskStartTime = DateUtil.formatToSpecificDate(((CalendarTextField)this.inputField).getDate());
            this.taskInfoVo.setTaskStartTime(taskStartTime);
            if (taskStartTime.before(DateUtil.formatToSpecificDate(new Date()))) {
                this.setInvalidPreAndOpDurationTips("START_TIME_TIP");
                return true;
            }
            if (this.checkStartTimeForChangePlan(taskStartTime)) {
                return true;
            }
            if (Objects.nonNull(this.taskInfoVo.getTaskEndTime())) {
                if (this.taskInfoVo.getTaskEndTime().compareTo(taskStartTime) == 0) {
                    this.setInvalidOperationDurationTip("OPERATION_DUR_GREATER");
                    return true;
                }
                if (this.taskInfoVo.getTaskEndTime().before(taskStartTime)) {
                    this.setInvalidOperationDurationTip("START_BEFORE_COMPLETE_TIP");
                    return true;
                }
                if (!StringUtils.equals((CharSequence)this.taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()) && this.taskInfoVo.getTaskEndTime().compareTo(taskStartTime) == 0) {
                    this.setInvalidOperationDurationTip("OPERATION_DUR_GREATER");
                    return true;
                }
                if (this.checkOperationDuration(taskStartTime, this.taskInfoVo.getTaskEndTime()) && this.checkDurationSum(this.taskInfoVo.getOperationPreparationTime(), this.taskInfoVo.getTaskEndTime(), false)) {
                    String operationDuration = DateUtil.caculateTimeDiff(taskStartTime, this.taskInfoVo.getTaskEndTime());
                    this.operationDurationField.setText(operationDuration);
                    this.taskInfoVo.setOperationDuration(operationDuration);
                }
            }
            return true;
        }
        return false;
    }

    private boolean checkStartTimeForChangePlan(Date taskStartTime) {
        if (StringUtils.equals((CharSequence)this.taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode())) {
            if (Objects.isNull(this.taskInfoVo.getOperationPreparationTime())) {
                this.setInvalidPrepareTips("SELECT_PRE");
                return true;
            }
            if (taskStartTime.before(this.taskInfoVo.getOperationPreparationTime())) {
                this.setInvalidPrepareTips("START_BEFORE_PRE_TIME_TIP");
                return true;
            }
            if (DateUtil.getTimeDiff(this.taskInfoVo.getOperationPreparationTime(), taskStartTime) > 3.0) {
                this.setInvalidPrepareTips("MAX_3_HOURS_TIP");
                return true;
            }
            String prepareDuration = DateUtil.caculateTimeDiff(this.taskInfoVo.getOperationPreparationTime(), taskStartTime);
            this.taskInfoVo.setPreparationDuration(prepareDuration);
            this.prepareDurationField.setText(prepareDuration);
        }
        return false;
    }

    private void checkOperationPrepareTime() {
        if (this.fieldName.equals("operationPreparationTime") && this.inputField instanceof CalendarTextField) {
            if (!this.checkValidTimeFromat(this.inputField.getText())) {
                this.taskInfoVo.setOperationPreparationTime(null);
                this.setInvalidPrepareTips("PREPARE_TIME_TIPS");
                return;
            }
            Date prepareTime = ((CalendarTextField)this.inputField).getDate();
            this.taskInfoVo.setOperationPreparationTime(prepareTime);
            if (prepareTime.before(DateUtil.formatToSpecificDate(new Date()))) {
                this.setInvalidPrepareTips("PRE_TIME_TIP");
                return;
            }
            if (Objects.nonNull(this.taskInfoVo.getTaskStartTime())) {
                if (this.taskInfoVo.getTaskStartTime().before(prepareTime)) {
                    this.setInvalidPrepareTips("PRE_BEFOR_ESTART_TIP");
                    return;
                }
                if (this.checkOperationDuration(prepareTime, this.taskInfoVo.getTaskStartTime())) {
                    String prepareDuration = DateUtil.caculateTimeDiff(prepareTime, this.taskInfoVo.getTaskStartTime());
                    this.prepareDurationField.setText(prepareDuration);
                    this.taskInfoVo.setPreparationDuration(prepareDuration);
                }
            }
        }
    }

    private boolean checkOperationDuration(Date taskStartTime, Date taskEndTime) {
        if (StringUtils.equalsAny((CharSequence)this.taskInfoVo.getTaskTypeCode(), (CharSequence[])new CharSequence[]{TaskTypeEnum.MICRO_NETWORK_CHANGE.getTaskTypeCode(), TaskTypeEnum.QUERY.getTaskTypeCode()}) && DateUtil.getTimeDiff(taskStartTime, taskEndTime) > 999.0) {
            this.setInvalidOperationDurationTip("MAX_999_OPERATION_DURATION");
            return false;
        }
        if (StringUtils.equals((CharSequence)this.taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.PROJECT.getTaskTypeCode()) && DateUtil.getTimeDiff(taskStartTime, taskEndTime) > 16.0) {
            this.setInvalidOperationDurationTip("MAX_16_OPERATION_DURATION");
            return false;
        }
        if (StringUtils.equals((CharSequence)this.taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()) && DateUtil.getTimeDiff(taskStartTime, taskEndTime) > 24.0) {
            this.setInvalidOperationDurationTip("MAX_24_OPERATION_DURATION");
            return false;
        }
        return true;
    }

    private boolean checkDurationSum(Date taskPrepareTime, Date taskEndTime, boolean isTaskEndTime) {
        if (StringUtils.equals((CharSequence)this.taskInfoVo.getTaskTypeCode(), (CharSequence)TaskTypeEnum.NETWORK_CHANGE.getTaskTypeCode()) && DateUtil.getTimeDiff(taskPrepareTime, taskEndTime) > 24.0) {
            if (isTaskEndTime) {
                this.setInvalidOperationDurationTip("SUM_TIME_TIP");
            } else {
                this.setInvalidPreAndOpDurationTips("SUM_TIME_TIP");
            }
            return false;
        }
        return true;
    }

    private void setInvalidOperationDurationTip(String operationTips) {
        this.commonUtils.showWarnPanel(this.frame, "", this.internationalizeBean.getResource(operationTips));
        this.operationDurationField.setText("");
        this.taskInfoVo.setOperationDuration(null);
    }

    private void setInvalidPreAndOpDurationTips(String operationTips) {
        this.setInvalidPrepareTips(operationTips);
        this.operationDurationField.setText("");
        this.taskInfoVo.setOperationDuration(null);
    }

    private void setInvalidPrepareTips(String operationTips) {
        this.commonUtils.showWarnPanel(this.frame, "", this.internationalizeBean.getResource(operationTips));
        if (this.prepareDurationField != null) {
            this.prepareDurationField.setText("");
            this.taskInfoVo.setPreparationDuration(null);
        }
    }
}

