/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.BizNesBo;
import com.huawei.netcareinsidesdk.bo.DatacomNetworkTiedInterceptRecordBo;
import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.constants.CloseTypeEnum;
import com.huawei.netcareinsidesdk.constants.HandlingMethodEnum;
import com.huawei.netcareinsidesdk.constants.OperationRecordEnum;
import com.huawei.netcareinsidesdk.dao.DatacomNetworkTiedInterceptRecordDao;
import com.huawei.netcareinsidesdk.exception.NetCareInsideSdkException;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.swing.component.WhiteJFrame;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.BizNetActionListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.utils.ApplyOrderComponentUtils;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.LabelsUtils;
import com.huawei.netcareinsidesdk.swingservice.NELoginSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.vo.DatacomNetworkTiedDataVo;
import com.huawei.netcareinsidesdk.vo.DatacomNetworkTiedInterceptRecordVo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BizNetPage {
    private static final Logger log = LoggerFactory.getLogger(BizNetPage.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(BizNetPage.class);
    @Autowired
    private LabelsUtils labelsUtils;
    @Autowired
    private NELoginSwingService neLoginSwingService;
    @Autowired
    private CommonServiceForSdk commonServiceForSdk;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private DatacomNetworkTiedInterceptRecordDao interceptRecordDao;
    @Autowired
    private ApplyOrderComponentUtils applyOrderComponentUtils;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonUtils commonUtils;
    private JCheckBox checkBox;
    private JTextField verifyTextField;
    private String verifyCode = "";
    private String guid = "";

    public void drawBizNetPage(int bizNetCode, BizNesBo bizNesBo, String hintOnlyGuid) {
        log.info("drawBizNetPage");
        this.verifyCode = "";
        this.guid = hintOnlyGuid;
        this.swingPageFrameManager.closeAllPage();
        WhiteJFrame bizNetScanPageFrame = this.swingPageFrameManager.getBizNetScanPageFrame();
        JPanel screenPanel = this.swingPageFrameManager.getScreenPanel(bizNetScanPageFrame);
        WhitePanel mattePanel = this.labelsUtils.initWhitePanel(0, 0, 1000, bizNetScanPageFrame.getHeight(), null);
        mattePanel.setBackground(new Color(0, 0, 0, 100));
        mattePanel.setVisible(false);
        WhitePanel tableDataPanel = this.labelsUtils.initWhitePanel(0, 0, 1000, 480, null);
        if (bizNetCode == 2) {
            log.info("drawPromptOnly");
            this.drawPromptOnly(bizNetScanPageFrame, mattePanel, tableDataPanel, bizNesBo);
        } else {
            log.info("drawScanCodePass");
            this.drawScanCodePass(bizNetScanPageFrame, mattePanel, tableDataPanel, bizNesBo);
        }
        screenPanel.add((java.awt.Component)mattePanel, "North");
        screenPanel.add(tableDataPanel);
        this.swingPageFrameManager.addMainFrameScroll(bizNetScanPageFrame, screenPanel);
        bizNetScanPageFrame.setVisible(true);
    }

    private void drawPromptOnly(WhiteJFrame whiteJFrame, WhitePanel mattePanel, WhitePanel tableDataPanel, BizNesBo bizNesBo) {
        if (LanguageManager.isEnglish()) {
            this.drawTitleData(tableDataPanel, this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_ONE") + bizNesBo.getConnectNeIp() + " " + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_TWO"));
        } else {
            this.drawTitleData(tableDataPanel, this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_ONE") + bizNesBo.getConnectNeIp() + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_TWO"));
        }
        this.drawPromptOnlyData(whiteJFrame, mattePanel, tableDataPanel, bizNesBo);
    }

    private void drawScanCodePass(WhiteJFrame whiteJFrame, WhitePanel mattePanel, WhitePanel tableDataPanel, BizNesBo bizNesBo) {
        this.drawTitleData(tableDataPanel, this.internationalizeUtil.getResource("BIZ_NET_NES_DETAIL"));
        this.drawScanCodePassData(mattePanel, whiteJFrame, tableDataPanel, bizNesBo);
    }

    private void drawTitleData(WhitePanel whitePanel, String titleName) {
        Rectangle rectangle = new Rectangle(40, 20, 20, 50);
        JLabel jLabelImage = this.labelsUtils.getJLabelImage("warn_img.png", rectangle, null, null);
        whitePanel.add(jLabelImage);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        rectangle.setBounds(70, 20, 900, 50);
        JLabel jLabel = this.labelsUtils.getJLabel(font, titleName, rectangle, null, null);
        whitePanel.add(jLabel);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 80, whitePanel.getWidth(), 5);
        whitePanel.add(separatorLine);
    }

    private void drawScanCodePassData(WhitePanel mattePanel, WhiteJFrame whiteJFrame, WhitePanel tableDataPanel, BizNesBo bizNesBo) {
        Rectangle rectangle = new Rectangle(70, 95, 240, 25);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel jLabel = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("BIZ_NET_DETAIL_DETECTION"), rectangle, null, null);
        tableDataPanel.add(jLabel);
        this.drawPanel(mattePanel, whiteJFrame, tableDataPanel, bizNesBo, rectangle);
        Rectangle rectangleButton1 = LanguageManager.isEnglish() ? new Rectangle(70, 420, 110, 30) : new Rectangle(70, 420, 90, 30);
        String buttonName = this.internationalizeUtil.getResource("BIZ_NET_OK");
        JButton button = this.labelsUtils.getButton(font, buttonName, rectangleButton1, Color.WHITE);
        button.addActionListener(listener -> {
            this.verifyCode = this.verifyTextField.getText();
            if (!Pattern.matches("^\\d{6}$", this.verifyCode)) {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ENTER_PROPER_VER"));
                return;
            }
            DatacomNetworkTiedInterceptRecordVo interceptRecordVo = new DatacomNetworkTiedInterceptRecordVo();
            interceptRecordVo.setGuid(bizNesBo.getGuid());
            interceptRecordVo.setLockCode(this.verifyCode);
            DatacomNetworkTiedInterceptRecordBo interceptRecordBo = new DatacomNetworkTiedInterceptRecordBo();
            BeanUtils.copyProperties((Object)interceptRecordVo, (Object)interceptRecordBo);
            Result updateBizNetResult = this.neLoginSwingService.updateBizNetInterceptRecord(interceptRecordBo);
            if (Integer.parseInt(updateBizNetResult.get("code").toString()) != 0) {
                LOGGER.error("biznet operation failed.");
                this.commonUtils.showWarnPanel(whiteJFrame, "", updateBizNetResult.get("message").toString());
                return;
            }
            this.addBizNetOperationRecord();
            this.neLoginSwingService.deleteBizNetCheckData();
            LOGGER.info("biznet operation success.");
            whiteJFrame.dispose();
        });
        tableDataPanel.add(button);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(190, 420, 78, 30);
        } else {
            rectangle.setBounds(170, 420, 78, 30);
        }
        this.cancelButton(whiteJFrame, tableDataPanel, rectangle, bizNesBo);
    }

    private void addBizNetOperationRecord() {
        DatacomNetworkTiedInterceptRecordBo datacomNetworkTiedInterceptRecordBo = this.interceptRecordDao.selectByGuid(this.guid);
        if (Objects.nonNull(datacomNetworkTiedInterceptRecordBo)) {
            OperationRecordBo operationRecordBo = new OperationRecordBo();
            operationRecordBo.setMoudle(OperationRecordEnum.BIZ_NET.getOperateType());
            operationRecordBo.setInteface("checkBizNetAccess");
            operationRecordBo.setGuid(this.guid);
            if (StringUtils.equals((CharSequence)datacomNetworkTiedInterceptRecordBo.getHandlingMethod(), (CharSequence)HandlingMethodEnum.CONTINUE_OPERATION.getValue())) {
                operationRecordBo.setCloseType(CloseTypeEnum.COMPLETE.getCloseType());
            } else {
                operationRecordBo.setCloseType(CloseTypeEnum.CANCEL.getCloseType());
            }
            this.commonServiceForSdk.insertOperationRecord(operationRecordBo);
        }
    }

    private void drawPanel(WhitePanel mattePanel, WhiteJFrame whiteJFrame, WhitePanel tableDataPanel, BizNesBo bizNesBo, Rectangle rectangle) {
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        int xPoint = this.drawData(mattePanel, whiteJFrame, tableDataPanel, bizNesBo, rectangle);
        JButton jButton1 = this.labelsUtils.getButton(font1, this.internationalizeUtil.getResource("COMMON_GENERATE_CODE_REFRESH"), rectangle, Color.white);
        JLabel imageLabel = new JLabel();
        imageLabel.setBounds(xPoint, 165, 270, 270);
        jButton1.addActionListener(e -> {
            Image image = this.createImage(bizNesBo);
            if (image == null) {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("COMMON_GENERATE_CODE_ERROR"));
                return;
            }
            imageLabel.setIcon(new ImageIcon(image));
            imageLabel.setBounds(xPoint, 165, 270, 270);
        });
        Image image = this.createImage(bizNesBo);
        imageLabel.setIcon(new ImageIcon(image));
        tableDataPanel.add(imageLabel);
        tableDataPanel.add(jButton1);
        rectangle.setBounds(70, 140, 520, 180);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        this.textArea(tableDataPanel, rectangle, font, bizNesBo.getGuid());
        Rectangle rectangle3 = new Rectangle(70, 330, 240, 20);
        JLabel jLabel2 = this.labelsUtils.getJLabel(font1, this.internationalizeUtil.getResource("COMMON_ENTER_VERIFICATION_CODE"), rectangle3, null, null);
        tableDataPanel.add(jLabel2);
        this.verifyTextField = this.applyOrderComponentUtils.genVeryCodeText(this.internationalizeUtil.getResource("ENTER"));
        this.verifyTextField.addActionListener(e -> {
            this.verifyCode = this.verifyTextField.getText();
            if (StringUtils.isBlank((CharSequence)this.verifyCode) || this.verifyCode.equals(this.internationalizeUtil.getResource("COMMON_ENTER_VERIFICATION_CODE"))) {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("COMMON_ENTER_VERIFICATION_CODE"));
            }
        });
        this.verifyTextField.setBounds(70, 365, 180, 30);
        tableDataPanel.add(this.verifyTextField);
    }

    private int drawData(WhitePanel mattePanel, WhiteJFrame whiteJFrame, WhitePanel tableDataPanel, BizNesBo bizNesBo, Rectangle rectangle) {
        int xPoint;
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(430, 95, 160, 25);
        } else {
            rectangle.setBounds(465, 95, 120, 25);
        }
        JButton jButton = this.labelsUtils.getButton(font1, this.internationalizeUtil.getResource("BIZ_NET_DETAIL_BUTTON"), rectangle, Color.white);
        this.bizNetListener(mattePanel, whiteJFrame, bizNesBo, jButton);
        tableDataPanel.add(jButton);
        if (LanguageManager.isEnglish()) {
            xPoint = 620;
            rectangle.setBounds(xPoint, 98, 360, 20);
        } else {
            xPoint = 660;
            rectangle.setBounds(xPoint, 98, 150, 20);
        }
        JLabel jLabel1 = this.labelsUtils.getJLabel(font1, this.internationalizeUtil.getResource("BIZ_NET_DETAIL_TIPS"), rectangle, null, null);
        tableDataPanel.add(jLabel1);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(xPoint, 125, 130, 25);
        } else {
            rectangle.setBounds(xPoint, 125, 100, 25);
        }
        return xPoint;
    }

    private Image createImage(BizNesBo bizNesBo) {
        String codeMessage;
        try {
            String context = this.neLoginSwingService.getEncryptAccountAndCode("\u6570\u901a\u5e76\u7f51\u64cd\u4f5c\u9a8c\u8bc1", "bizNetUrl");
            String bizNetQRCode = this.neLoginSwingService.getBizNetQRCode(bizNesBo.getGuid());
            codeMessage = context + "&" + bizNetQRCode + "&lang=" + LanguageManager.getInstance().getCurLanguage() + "&timeZone=" + DateUtil.getTimeZoneId();
        }
        catch (NetCareInsideSdkException exception) {
            log.error("Failed to obtain the QR code information.");
            return null;
        }
        ImageIcon bizNetUrl = this.labelsUtils.getJLabelCodeImage(codeMessage);
        return bizNetUrl.getImage().getScaledInstance(270, 270, 4);
    }

    private void bizNetListener(WhitePanel mattePanel, WhiteJFrame whiteJFrame, BizNesBo bizNesBo, JButton jButton) {
        if (LanguageManager.isEnglish()) {
            bizNesBo.setButton(this.internationalizeUtil.getResource("BIZ_NET_DETAIL_BUTTON"));
            bizNesBo.setTitle(this.internationalizeUtil.getResource("BIZ_NET_DETAIL_TITLE"));
        } else {
            bizNesBo.setButton(this.internationalizeUtil.getResource("BIZ_NET_DETAIL_BUTTON"));
            bizNesBo.setTitle(this.internationalizeUtil.getResource("BIZ_NET_DETAIL_TITLE"));
        }
        BizNetActionListener actionListener = new BizNetActionListener(mattePanel, whiteJFrame, bizNesBo, this.labelsUtils, this.neLoginSwingService);
        jButton.addActionListener(actionListener);
    }

    private void drawPromptOnlyData(WhiteJFrame whiteJFrame, WhitePanel mattePanel, WhitePanel tableDataPanel, BizNesBo bizNesBo) {
        Rectangle rectangle = new Rectangle(70, 90, 240, 40);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        this.drawOnlydata(whiteJFrame, mattePanel, tableDataPanel, bizNesBo, rectangle);
        String checkBoxMessage = this.checkBoxMessage(bizNesBo);
        this.checkBox = this.labelsUtils.getCheckBox(font, "", rectangle, null, null);
        rectangle.setBounds(100, 370, 826, 30);
        JLabel text = this.labelsUtils.getJLabel(font, checkBoxMessage, rectangle, null, null);
        tableDataPanel.add(text);
        this.checkBox.addActionListener(e -> {
            if (this.checkBox.isSelected()) {
                this.checkBox.setSelected(true);
            } else {
                this.checkBox.setSelected(false);
            }
        });
        tableDataPanel.add(this.checkBox);
        String buttonName = this.internationalizeUtil.getResource("BIZ_NET_NES_CONTINUE");
        rectangle.setBounds(70, 420, 115, 30);
        JButton button = this.labelsUtils.getButton(font, buttonName, rectangle, Color.white);
        button.addActionListener(listener -> {
            if (!this.checkBox.isSelected()) {
                this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("BIZ_NET_NES_ERROR"));
                return;
            }
            DatacomNetworkTiedInterceptRecordBo interceptRecordBo = new DatacomNetworkTiedInterceptRecordBo();
            interceptRecordBo.setHandlingMethod(HandlingMethodEnum.CONTINUE_OPERATION.getValue());
            interceptRecordBo.setGuid(bizNesBo.getGuid());
            this.putBizNetParams(whiteJFrame, interceptRecordBo);
        });
        tableDataPanel.add(button);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(220, 420, 78, 30);
        } else {
            rectangle.setBounds(200, 420, 78, 30);
        }
        this.cancelButton(whiteJFrame, tableDataPanel, rectangle, bizNesBo);
    }

    private void drawOnlydata(WhiteJFrame whiteJFrame, WhitePanel mattePanel, WhitePanel tableDataPanel, BizNesBo bizNesBo, Rectangle rectangle) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel jLabel = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("BIZ_NET_DETAIL_DETECTION"), rectangle, null, null);
        tableDataPanel.add(jLabel);
        if (LanguageManager.isEnglish()) {
            rectangle.setBounds(630, 95, 160, 30);
        } else {
            rectangle.setBounds(650, 95, 120, 30);
        }
        JButton jButton = this.labelsUtils.getButton(font, this.internationalizeUtil.getResource("BIZ_NET_DETAIL_BUTTON"), rectangle, Color.white);
        this.bizNetListener(mattePanel, whiteJFrame, bizNesBo, jButton);
        tableDataPanel.add(jButton);
        rectangle.setBounds(70, 145, 826, 220);
        this.textArea(tableDataPanel, rectangle, font, bizNesBo.getGuid());
        rectangle.setBounds(70, 370, 30, 30);
    }

    private String checkBoxMessage(BizNesBo bizNesBo) {
        String checkBoxMessage;
        if (LanguageManager.isEnglish()) {
            checkBoxMessage = this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_THREE") + bizNesBo.getConnectNeIp() + " " + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_FOUR");
            if (bizNesBo.getNesNum() != 0) {
                checkBoxMessage = " " + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_ONE") + bizNesBo.getConnectNeIp() + " " + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_FIVE") + bizNesBo.getNesNum() + " " + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_SIX");
            }
        } else {
            checkBoxMessage = this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_THREE") + bizNesBo.getConnectNeIp() + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_FOUR");
            if (bizNesBo.getNesNum() != 0) {
                checkBoxMessage = " " + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_THREE") + bizNesBo.getConnectNeIp() + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_FIVE") + bizNesBo.getNesNum() + this.internationalizeUtil.getResource("BIZ_NET_NES_DETECTION_SIX");
            }
        }
        return checkBoxMessage;
    }

    private void textArea(WhitePanel tableDataPanel, Rectangle rectangle, Font font, String guid) {
        JTextArea textArea = this.labelsUtils.getTextArea(font, rectangle, null, null);
        textArea.setBorder(new LineBorder(Color.lightGray));
        Result checkBizNetAccessResult = this.neLoginSwingService.getCheckBizNetAccessResult(guid);
        if (Objects.nonNull(checkBizNetAccessResult)) {
            DatacomNetworkTiedDataVo networkTiedData = (DatacomNetworkTiedDataVo)JSONObject.parseObject((String)JSONObject.toJSONString(checkBizNetAccessResult.get("data")), DatacomNetworkTiedDataVo.class);
            textArea.append(networkTiedData.getUpNum() + System.lineSeparator());
            if (StringUtils.isNotEmpty((CharSequence)networkTiedData.getNesNum())) {
                textArea.append(networkTiedData.getNesNum() + System.lineSeparator());
            }
        }
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        tableDataPanel.add(textArea);
    }

    private void cancelButton(WhiteJFrame whiteJFrame, WhitePanel tableDataPanel, Rectangle rectangle, BizNesBo bizNesBo) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        String buttonName = this.internationalizeUtil.getResource("COMMON_CANCEL");
        JButton button = this.labelsUtils.getButton(font, buttonName, rectangle, Color.white);
        button.addActionListener(listener -> {
            DatacomNetworkTiedInterceptRecordBo interceptRecordBo = new DatacomNetworkTiedInterceptRecordBo();
            interceptRecordBo.setHandlingMethod(HandlingMethodEnum.CANCEL.getValue());
            interceptRecordBo.setGuid(bizNesBo.getGuid());
            this.putBizNetParams(whiteJFrame, interceptRecordBo);
        });
        tableDataPanel.add(button);
    }

    private void putBizNetParams(WhiteJFrame whiteJFrame, DatacomNetworkTiedInterceptRecordBo tiedInterceptRecordBo) {
        Result updateHandlingMethod = this.neLoginSwingService.updateHandlingMethod(tiedInterceptRecordBo);
        if (Integer.parseInt(updateHandlingMethod.get("code").toString()) != 0) {
            LOGGER.error("biznet operation failed.");
            this.commonUtils.showWarnPanel(whiteJFrame, "", updateHandlingMethod.get("message").toString());
        }
        this.addBizNetOperationRecord();
        this.neLoginSwingService.deleteBizNetCheckData();
        LOGGER.info("biznet operation success.");
        whiteJFrame.dispose();
    }
}

