/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.swing.component.RoundBorder;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.style.CustomRenderer;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.InterceptionPageUtils;
import com.huawei.netcareinsidesdk.swingservice.CommandSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.vo.CommandInfoVo;
import com.huawei.netcareinsidesdk.vo.HighRiskCommandInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.HighRiskCommandQueryVo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class HighRiskBlackCommandTable {
    private static final long serialVersionUID = -6546334664166791132L;
    @Autowired
    private CommandSwingService commandSwingService;
    @Autowired
    private InterceptionPageUtils interceptionPageUtils;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    private int currentPage = 1;
    private int pageSize = 10;
    private int lastPage;
    private int blackCommandTotal;
    private JLabel totalLabel;
    private JLabel totalPageLabel;
    private JComboBox<String> page;
    private JTextField currentPageText;
    JTable table = null;
    DefaultTableModel dtm = null;
    List<CommandInfoVo> list;

    private void showBlackCommandTable(int currentPage, int pageSize) {
        int count;
        this.dtm.setRowCount(0);
        this.currentPage = currentPage;
        HighRiskCommandInfoQueryVo query = this.query(currentPage, pageSize);
        this.list = query.getCommandInfoVos();
        this.blackCommandTotal = count = query.getTotal().intValue();
        this.totalLabel.setText(String.valueOf(count));
        this.totalPageLabel.setText(String.valueOf(this.lastPage));
        this.currentPageText.setText(String.valueOf(currentPage));
        for (int row = 0; row < this.list.size(); ++row) {
            Vector<String> rowV = new Vector<String>();
            CommandInfoVo black = this.list.get(row);
            rowV.add(black.getRegionName());
            rowV.add(black.getRepOfficeName());
            rowV.add(black.getProductLineName());
            rowV.add(black.getFullCommand());
            rowV.add(black.getCommandRegex());
            rowV.add(RiskLevelEnum.getRiskCnByCode(black.getRiskLevel()));
            this.dtm.addRow(rowV);
        }
        this.table.setSelectionMode(0);
        this.table.revalidate();
        this.table.repaint();
    }

    private void init() {
        this.currentPage = 1;
        this.pageSize = 10;
    }

    public JPanel getHighRiskJPanel(Rectangle rectangle) {
        int queryBlackCommandCount;
        this.init();
        WhitePanel highRiskCommandBlackPanel = this.interceptionPageUtils.getPublicMainPanel();
        highRiskCommandBlackPanel.getComponent(0).setBounds(rectangle);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.white);
        panel.setBounds(30, 25, 1240, 400);
        Object[] columnNames = new Object[]{this.internationalizeUtil.getResource("REGION"), this.internationalizeUtil.getResource("REPOFFICE"), this.internationalizeUtil.getResource("PRODUCTLINE"), this.internationalizeUtil.getResource("FULL_COMMAND"), this.internationalizeUtil.getResource("EXPRESSION"), this.internationalizeUtil.getResource("RISK_LEVEL")};
        HighRiskCommandInfoQueryVo query = this.query(this.currentPage, this.pageSize);
        Object[][] rowData = this.interceptionPageUtils.queryBlackList(query.getCommandInfoVos());
        this.blackCommandTotal = queryBlackCommandCount = query.getTotal().intValue();
        this.lastPage = queryBlackCommandCount == 0 ? 1 : (queryBlackCommandCount % this.pageSize == 0 ? queryBlackCommandCount / this.pageSize : queryBlackCommandCount / this.pageSize + 1);
        int[] length = new int[]{200, 200, 200, 200, 200, 200};
        this.setInterceptionTableStyle(columnNames, rowData, panel, length);
        this.table.setEnabled(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        highRiskCommandBlackPanel.add(panel);
        WhitePanel interceptionPlolicyPagePanel = this.getBlackInterceptionPlolicyPagePanel();
        highRiskCommandBlackPanel.add(interceptionPlolicyPagePanel);
        highRiskCommandBlackPanel.add(this.getBlackCommandPageButton());
        return highRiskCommandBlackPanel;
    }

    private void setInterceptionTableStyle(Object[] columnNames, Object[][] rowData, JPanel panel, int[] length) {
        this.dtm = new DefaultTableModel(rowData, columnNames);
        this.table = new JTable(this.dtm);
        this.table.setBackground(Color.white);
        if (length != null) {
            TableColumnModel model0 = this.table.getColumnModel();
            for (int i = 0; i < model0.getColumnCount(); ++i) {
                TableColumn column = model0.getColumn(i);
                column.setPreferredWidth(length[i]);
            }
        }
        CustomRenderer tcr = new CustomRenderer();
        this.table.setDefaultRenderer(Object.class, tcr);
        JTableHeader tabHeader = this.table.getTableHeader();
        tabHeader.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        tabHeader.setPreferredSize(new Dimension(tabHeader.getWidth(), 45));
        this.table.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        this.table.setRowHeight(35);
        this.table.setAutoResizeMode(4);
        this.interceptionPageUtils.setTableTextCenter(this.table);
        panel.add((Component)this.table.getTableHeader(), "North");
        panel.add((Component)this.table, "Center");
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        panel.add(scrollPane);
    }

    private WhitePanel getBlackCommandPageButton() {
        WhitePanel blackOperationPanel = new WhitePanel();
        blackOperationPanel.setLayout(null);
        blackOperationPanel.setBounds(1110, 445, 350, 50);
        blackOperationPanel.add(this.runToSpecfivPage());
        JLabel sepratorLabel = new JLabel(ImageUtils.generateImage("pageSeprator.png"));
        sepratorLabel.setBounds(95, 0, 10, 25);
        blackOperationPanel.add(sepratorLabel);
        this.totalPageLabel = new JLabel(String.valueOf(this.lastPage));
        this.totalPageLabel.setBounds(100, 0, 45, 25);
        this.totalPageLabel.setHorizontalAlignment(0);
        this.totalPageLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        blackOperationPanel.add(this.totalPageLabel);
        JButton preJbutton = this.interceptionPageUtils.genrateButtonStyle("PrePage");
        preJbutton.setBounds(15, 0, 25, 25);
        preJbutton.setIcon(ImageUtils.generateImage("prePage.png"));
        preJbutton.addActionListener(new BlackCommandButton());
        blackOperationPanel.add(preJbutton);
        JButton nextJbutton = this.interceptionPageUtils.genrateButtonStyle("NextPage");
        nextJbutton.setBounds(145, 0, 20, 25);
        nextJbutton.setIcon(ImageUtils.generateImage("nextPage.png"));
        nextJbutton.addActionListener(new BlackCommandButton());
        blackOperationPanel.add(nextJbutton);
        return blackOperationPanel;
    }

    private JTextField runToSpecfivPage() {
        this.currentPageText = new JTextField();
        this.currentPageText.setBounds(40, 0, 45, 25);
        this.currentPageText.setHorizontalAlignment(0);
        this.currentPageText.setBorder(new RoundBorder(new Insets(0, 0, 0, 0), Color.GRAY));
        this.currentPageText.addFocusListener(new JTextFieldHintListener(this.currentPageText, "1", Color.BLACK));
        this.currentPageText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                String text;
                super.keyTyped(event);
                if (!Character.isDigit(event.getKeyChar())) {
                    event.consume();
                }
                if ((text = HighRiskBlackCommandTable.this.currentPageText.getText()) == null || text.isEmpty()) {
                    return;
                }
                if (text.length() > 4) {
                    event.consume();
                }
                int inputRunToNum = Integer.parseInt(text);
                if (event.getKeyChar() == '\n') {
                    HighRiskBlackCommandTable.this.currentPage = inputRunToNum == 0 ? 1 : inputRunToNum;
                    if (HighRiskBlackCommandTable.this.currentPage < HighRiskBlackCommandTable.this.lastPage) {
                        HighRiskBlackCommandTable.this.showBlackCommandTable(HighRiskBlackCommandTable.this.currentPage, HighRiskBlackCommandTable.this.pageSize);
                    } else {
                        HighRiskBlackCommandTable.this.showBlackCommandTable(HighRiskBlackCommandTable.this.lastPage, HighRiskBlackCommandTable.this.pageSize);
                    }
                }
            }
        });
        return this.currentPageText;
    }

    private HighRiskCommandInfoQueryVo query(int currentPage, int pageSize) {
        HighRiskCommandQueryVo highRiskCommandQueryVo = new HighRiskCommandQueryVo();
        highRiskCommandQueryVo.setPageSize(String.valueOf(pageSize));
        highRiskCommandQueryVo.setPageNum(String.valueOf(currentPage));
        highRiskCommandQueryVo.setHighRiskCode("1");
        return this.commandSwingService.queryHighRiskCommandInfo(highRiskCommandQueryVo);
    }

    private WhitePanel getBlackInterceptionPlolicyPagePanel() {
        WhitePanel whitePanel = this.interceptionPageUtils.getPaginationPanel(this.blackCommandTotal);
        if (whitePanel.getComponent(1) instanceof JLabel) {
            this.totalLabel = (JLabel)whitePanel.getComponent(1);
        }
        this.page = new JComboBox();
        this.page.setBounds(110, 20, 130, 30);
        whitePanel.add(this.interceptionPageUtils.getPagination(this.page));
        this.page.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (1 == itemEvent.getStateChange()) {
                    this.pageListener();
                }
            }

            private void pageListener() {
                HighRiskBlackCommandTable.this.page.setBackground(Color.WHITE);
                HighRiskBlackCommandTable.this.page.setFocusable(false);
                String currentPageSize = HighRiskBlackCommandTable.this.interceptionPageUtils.getPageSize(String.valueOf(HighRiskBlackCommandTable.this.page.getSelectedIndex()));
                HighRiskBlackCommandTable.this.pageSize = Integer.parseInt(currentPageSize);
                if (HighRiskBlackCommandTable.this.blackCommandTotal == 0) {
                    HighRiskBlackCommandTable.this.lastPage = 1;
                } else if (HighRiskBlackCommandTable.this.blackCommandTotal % HighRiskBlackCommandTable.this.pageSize == 0) {
                    HighRiskBlackCommandTable.this.lastPage = HighRiskBlackCommandTable.this.blackCommandTotal / HighRiskBlackCommandTable.this.pageSize;
                } else {
                    HighRiskBlackCommandTable.this.lastPage = HighRiskBlackCommandTable.this.blackCommandTotal / HighRiskBlackCommandTable.this.pageSize + 1;
                }
                HighRiskBlackCommandTable.this.currentPage = 1;
                HighRiskBlackCommandTable.this.showBlackCommandTable(HighRiskBlackCommandTable.this.currentPage, Integer.parseInt(currentPageSize));
            }
        });
        return whitePanel;
    }

    class BlackCommandButton
    implements ActionListener {
        BlackCommandButton() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("PrePage")) {
                if (HighRiskBlackCommandTable.this.currentPage <= 1) {
                    HighRiskBlackCommandTable.this.currentPage = 1;
                } else {
                    HighRiskBlackCommandTable.this.showBlackCommandTable(HighRiskBlackCommandTable.this.currentPage - 1, HighRiskBlackCommandTable.this.pageSize);
                }
            }
            if (event.getActionCommand().equals("NextPage")) {
                if (HighRiskBlackCommandTable.this.currentPage < HighRiskBlackCommandTable.this.lastPage) {
                    HighRiskBlackCommandTable.this.showBlackCommandTable(HighRiskBlackCommandTable.this.currentPage + 1, HighRiskBlackCommandTable.this.pageSize);
                } else {
                    HighRiskBlackCommandTable.this.showBlackCommandTable(HighRiskBlackCommandTable.this.lastPage, HighRiskBlackCommandTable.this.pageSize);
                }
            }
        }
    }
}

