/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.HighRiskInterceptRecordBo;
import com.huawei.netcareinsidesdk.bo.ToolConfig;
import com.huawei.netcareinsidesdk.swing.component.CheckVerificationCodeKeyAdaptor;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.style.HtmlMultiLineRender;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.CommandSwingService;
import com.huawei.netcareinsidesdk.utils.DateUtil;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.JsonParseUtils;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.QRCodeUtil;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.InterceptionVerifyCodeVo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HighRiskUnlockPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighRiskUnlockPage.class);
    private static final ExecutorService SINGLE_THREAD_EXECUTOR = Executors.newSingleThreadExecutor();
    private String guid = "";
    private int hour;
    private int minute;
    private int second;
    private JLabel timeLabel;
    private JLabel currentTimeLabel;
    private JLabel imageLabel;
    @Autowired
    private CommandSwingService commandSwingService;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonUtils commonUtils;
    @Autowired
    private SwingPageFrameManager frameManager;

    public void getHighRiskUnlockFrame(boolean isMenu, boolean isWhiteCommand, String inputCommands, String fullCommands, String interceptionId) {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 1086, 719);
        frame.setUndecorated(true);
        JPanel screenPanel = this.frameManager.getScreenPanel(frame);
        String highRiskCommandTips = this.getHighRiskFullTips(isMenu, isWhiteCommand, inputCommands, fullCommands);
        String highRiskAbbreviations = this.getHighRiskAbbreviations(isMenu, isWhiteCommand, inputCommands, fullCommands);
        screenPanel.add(this.getTitle(highRiskAbbreviations, highRiskCommandTips));
        screenPanel.add(HighRiskUnlockPage.getSeparatorLine());
        screenPanel.add(this.getHighRiskTextLabel(interceptionId));
        this.addHighRiskEndLabel(screenPanel, frame, interceptionId);
        this.frameManager.addMainFrameScroll(frame, screenPanel);
        frame.setVisible(true);
    }

    private String getHighRiskFullTips(boolean isMenu, boolean isWhiteCommand, String inputCommands, String fullCommands) {
        String message = this.getCommandMessage(isMenu, isWhiteCommand, inputCommands, fullCommands);
        HtmlMultiLineRender htmlMultiLineRender = new HtmlMultiLineRender();
        if (message == null || "".equals(message)) {
            return message;
        }
        List<String> temp = JsonParseUtils.usingSubstringMethod(message, 80);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < temp.size(); ++i) {
            if (i != 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append(temp.get(i));
        }
        return htmlMultiLineRender.covertDestionString(stringBuilder.toString());
    }

    private String getHighRiskAbbreviations(boolean isMenu, boolean isWhiteCommand, String inputCommands, String fullCommands) {
        String fullCommandsTitle = Objects.nonNull(fullCommands) && fullCommands.length() > 10 ? fullCommands.substring(0, 10) + "..." : fullCommands;
        String inpuCommandsTitle = inputCommands.length() > 50 ? inputCommands.substring(0, 50) + "..." : inputCommands;
        return this.getCommandMessage(isMenu, isWhiteCommand, inpuCommandsTitle, fullCommandsTitle);
    }

    private String getCommandMessage(boolean isMenu, boolean isWhiteCommand, String inputCommands, String fullCommands) {
        String tipMsg = isMenu ? (isWhiteCommand ? this.internationalizeUtil.getResource("HIGH_RISK_NOT_TRUSTLIST_MENU_ONE") + inputCommands + this.internationalizeUtil.getResource("HIGH_RISK_NOT_TRUSTLIST_MENU_TWO") : this.internationalizeUtil.getResource("HIGH_RISK_APPLY_UNLOCK_MENU_ONE") + inputCommands + this.internationalizeUtil.getResource("HIGH_RISK_APPLY_UNLOCK_MENU_TWO")) : (isWhiteCommand ? this.internationalizeUtil.getResource("HIGH_RISK_NOT_TRUSTLIST_ONE") + inputCommands + this.internationalizeUtil.getResource("HIGH_RISK_NOT_TRUSTLIST_TWO") : this.internationalizeUtil.getResource("HIGH_RISK_APPLY_UNLOCK_ONE") + inputCommands + this.internationalizeUtil.getResource("HIGH_RISK_APPLY_UNLOCK_TWO") + fullCommands + this.internationalizeUtil.getResource("HIGH_RISK_APPLY_UNLOCK_THREE"));
        return tipMsg;
    }

    private JPanel getTitle(String highRiskAbbreviations, String highRiskCommandTips) {
        WhitePanel scenePanel = new WhitePanel();
        scenePanel.setLocation(25, 10);
        scenePanel.setSize(1010, 90);
        scenePanel.setLayout(null);
        JLabel redWarningImageLabel = new JLabel(ImageUtils.generateImage("red_waring_img.png"));
        redWarningImageLabel.setBounds(15, 0, 40, 90);
        JTextArea textArea = new JTextArea(highRiskAbbreviations);
        textArea.setBounds(70, 30, 935, 50);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setForeground(Color.black);
        textArea.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16));
        textArea.setToolTipText(highRiskCommandTips);
        scenePanel.add(textArea);
        scenePanel.add(redWarningImageLabel);
        return scenePanel;
    }

    private static JPanel getSeparatorLine() {
        WhitePanel separatorPanel = new WhitePanel();
        separatorPanel.setLocation(0, 100);
        separatorPanel.setSize(1086, 10);
        separatorPanel.setLayout(new FlowLayout(1));
        JSeparator separator = new JSeparator(0);
        separator.setPreferredSize(new Dimension(1086, 1));
        separator.setForeground(Color.lightGray);
        separatorPanel.add(separator);
        return separatorPanel;
    }

    private JPanel getHighRiskTextLabel(String interceptionId) {
        WhitePanel textPanel = new WhitePanel();
        textPanel.setLayout(null);
        textPanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        textPanel.setBounds(25, 130, 1014, 470);
        textPanel = this.getHighRiskTextPanel(textPanel, interceptionId);
        return textPanel;
    }

    private void addHighRiskEndLabel(JPanel screenPanel, WhiteJDialog frame, String interceptionId) {
        WhitePanel endPanel = new WhitePanel();
        endPanel.setLayout(null);
        endPanel.setBounds(25, 590, 1014, 60);
        endPanel = this.getHighRiskEndLabel(endPanel, frame, interceptionId);
        screenPanel.add(endPanel);
    }

    private WhitePanel getHighRiskEndLabel(WhitePanel endPanel, WhiteJDialog frame, String interceptionId) {
        JTextField inputText = new JTextField("", 18);
        inputText.setBounds(0, 30, 290, 30);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        inputText.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        HighRiskUnlockPage.addVerifyCodeListener(inputText, "");
        endPanel.add(inputText);
        this.addUnlockButton(endPanel, frame, interceptionId, inputText, font);
        JButton giveUpButton = new JButton(this.internationalizeUtil.getResource("HIGH_RISK_ABANDON_OPERATION"));
        giveUpButton.setBackground(Color.WHITE);
        if (LanguageManager.isEnglish()) {
            giveUpButton.setBounds(860, 30, 152, 30);
        } else {
            giveUpButton.setBounds(910, 30, 102, 30);
        }
        giveUpButton.setFont(font);
        giveUpButton.setFocusPainted(false);
        giveUpButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        giveUpButton.addActionListener(event -> this.abandonOperation(frame, interceptionId));
        endPanel.add(giveUpButton);
        return endPanel;
    }

    private void addUnlockButton(WhitePanel endPanel, WhiteJDialog frame, String interceptionId, JTextField inputText, Font font) {
        JButton unlockButton = new JButton(this.internationalizeUtil.getResource("HIGH_RISK_UNLOCK"));
        unlockButton.setBackground(Color.WHITE);
        unlockButton.setBounds(300, 30, 78, 30);
        unlockButton.setFont(font);
        unlockButton.setFocusPainted(false);
        unlockButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        endPanel.add(unlockButton);
        unlockButton.addActionListener(event -> {
            if (StringUtils.isBlank((CharSequence)inputText.getText())) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("HIGH_RISK_ENTER_UNLOCK_CODE"));
                return;
            }
            InterceptionVerifyCodeVo verifyCodeVo = new InterceptionVerifyCodeVo();
            verifyCodeVo.setPostInterceptMode("2");
            verifyCodeVo.setVerifyCode(inputText.getText());
            verifyCodeVo.setInterceptionId(interceptionId);
            String returnErrMsg = this.commandSwingService.checkInterceptionVerifyCode(verifyCodeVo);
            LOGGER.info(returnErrMsg);
            if (Objects.isNull(returnErrMsg)) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("HIGH_RISK_UNLOCKED_SUCCESSFULLY"));
                frame.dispose();
            } else if (StringUtils.equals((CharSequence)"Expired", (CharSequence)returnErrMsg)) {
                frame.dispose();
                this.orderExpriedWaringFrame(interceptionId);
            } else {
                this.commonUtils.showWarnPanel(frame, "", returnErrMsg);
            }
        });
        this.addTimerLabel(endPanel, interceptionId);
    }

    private void abandonOperation(WhiteJDialog frame, String interceptionId) {
        InterceptionVerifyCodeVo verifyCodeVo = new InterceptionVerifyCodeVo();
        verifyCodeVo.setPostInterceptMode("1");
        verifyCodeVo.setInterceptionId(interceptionId);
        String errorMsg = this.commandSwingService.checkInterceptionVerifyCode(verifyCodeVo);
        if (Objects.isNull(errorMsg)) {
            frame.dispose();
        } else {
            this.commonUtils.showWarnPanel(frame, "", errorMsg);
        }
    }

    private void orderExpriedWaringFrame(String interceptionId) {
        WhiteJDialog currentFrame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 600, 260);
        currentFrame.setLocationRelativeTo(null);
        currentFrame.setResizable(false);
        Container container = currentFrame.getContentPane();
        container.setLayout(null);
        currentFrame.add(this.getHints());
        this.addWarningButton(currentFrame, interceptionId);
        currentFrame.setVisible(true);
    }

    private JPanel getHints() {
        WhitePanel initInfoWarningPanel = new WhitePanel();
        initInfoWarningPanel.setBounds(25, 20, 600, 120);
        initInfoWarningPanel.setLayout(null);
        JLabel circleImageLabel = new JLabel(ImageUtils.generateImage("circle_warning.png"));
        circleImageLabel.setBounds(0, 10, 20, 35);
        JLabel label1 = new JLabel(this.internationalizeUtil.getResource("COMMON_WARNING"));
        label1.setBounds(35, 10, 100, 40);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 16);
        label1.setFont(font);
        ToolConfig toolConfig = JsonParseUtils.getToolConfig();
        String tipMsg = this.internationalizeUtil.getResource("HIGH_RISK_CHOOSE_ORDER", Collections.singletonList(toolConfig.getOrderDetailPathCn()));
        if (LanguageManager.isEnglish()) {
            tipMsg = this.internationalizeUtil.getResource("HIGH_RISK_CHOOSE_ORDER", Collections.singletonList(toolConfig.getOrderDetailPathEn()));
        }
        JLabel label3 = new JLabel(tipMsg);
        label3.setBounds(35, 40, 500, 90);
        label3.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        initInfoWarningPanel.add(circleImageLabel);
        initInfoWarningPanel.add(label1);
        initInfoWarningPanel.add((java.awt.Component)label3, "Center");
        return initInfoWarningPanel;
    }

    private void addWarningButton(WhiteJDialog currentFame, String interceptionId) {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setBounds(25, 150, 600, 40);
        jPanel.setLayout(null);
        JButton determinedButton = new JButton(this.internationalizeUtil.getResource("COMMON_OK"));
        determinedButton.setBackground(Color.WHITE);
        determinedButton.setBounds(450, 0, 70, 30);
        determinedButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        determinedButton.setFocusPainted(false);
        determinedButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        jPanel.add(determinedButton);
        currentFame.add(jPanel);
        determinedButton.addActionListener(event -> this.abandonOperation(currentFame, interceptionId));
        currentFame.setVisible(true);
    }

    private static void addVerifyCodeListener(JTextField inputText, String defaultText) {
        inputText.addFocusListener(new JTextFieldHintListener(inputText, defaultText, Color.gray));
        inputText.addKeyListener(new CheckVerificationCodeKeyAdaptor(inputText, 6));
    }

    private WhitePanel getHighRiskTextPanel(WhitePanel textPanel, String interceptionId) {
        HighRiskInterceptRecordBo highRiskInterceptRecordBo = new HighRiskInterceptRecordBo();
        highRiskInterceptRecordBo.setGuid(interceptionId);
        this.imageLabel = new JLabel();
        this.generateCodejLabel(highRiskInterceptRecordBo, this.imageLabel);
        textPanel.add(this.imageLabel);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.currentTimeLabel = new JLabel(this.internationalizeUtil.getResource("HIGH_RISK_VALID_TIME_ONE") + format.format(new Date()) + this.internationalizeUtil.getResource("HIGH_RISK_VALID_TIME_TWO"));
        if (LanguageManager.isEnglish()) {
            this.currentTimeLabel.setBounds(35, 400, 390, 30);
        } else {
            this.currentTimeLabel.setBounds(70, 400, 330, 30);
        }
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        this.currentTimeLabel.setFont(font1);
        textPanel.add(this.currentTimeLabel);
        JButton reGenerateButton = new JButton(this.internationalizeUtil.getResource("HIGH_RISK_REGENERATE"));
        reGenerateButton.setBackground(Color.WHITE);
        reGenerateButton.setBounds(150, 430, 102, 30);
        reGenerateButton.setFocusPainted(false);
        reGenerateButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        reGenerateButton.setFont(font);
        reGenerateButton.addActionListener(event -> {
            this.generateCodejLabel(highRiskInterceptRecordBo, this.imageLabel);
            this.currentTimeLabel.setText(this.internationalizeUtil.getResource("HIGH_RISK_VALID_TIME_ONE") + format.format(new Date()) + this.internationalizeUtil.getResource("HIGH_RISK_VALID_TIME_TWO"));
            this.setTime(0, 30, 0);
            this.setText();
            SINGLE_THREAD_EXECUTOR.execute(() -> this.showTimerLabel(highRiskInterceptRecordBo, this.imageLabel));
            textPanel.revalidate();
            textPanel.repaint();
        });
        textPanel.add(reGenerateButton);
        this.addHighRiskDescription(textPanel);
        return textPanel;
    }

    private void generateCodejLabel(HighRiskInterceptRecordBo highRiskInterceptRecordBo, JLabel imageLabel) {
        String context = this.commandSwingService.getInterceptionQRCode(highRiskInterceptRecordBo);
        BufferedImage bufferedImage = null;
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            bufferedImage = QRCodeUtil.createImage(context + "&lang=" + LanguageManager.getInstance().getCurLanguage() + "&timeZone=" + DateUtil.getTimeZoneId());
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            Image image = imageIcon.getImage().getScaledInstance(350, 350, 4);
            imageLabel.setIcon(new ImageIcon(image));
        }
        imageLabel.setBounds(50, 10, 380, 380);
    }

    private WhitePanel addHighRiskDescription(WhitePanel textPanel) {
        WhitePanel textRightPanel = new WhitePanel();
        textRightPanel.setBackground(new Color(253, 243, 244));
        textRightPanel.setLayout(null);
        textRightPanel.setBounds(450, 20, 520, 400);
        JLabel label1 = new JLabel(this.internationalizeUtil.getResource("HIGH_RISK_MESSAGE_ONE"));
        JLabel label2 = new JLabel(this.internationalizeUtil.getResource("HIGH_RISK_MESSAGE_TWO"));
        JLabel label3 = new JLabel(this.internationalizeUtil.getResource("HIGH_RISK_MESSAGE_THREE"));
        JLabel label4 = new JLabel(this.internationalizeUtil.getResource("HIGH_RISK_MESSAGE_FOUR"));
        JLabel label5 = new JLabel(this.internationalizeUtil.getResource("HIGH_RISK_MESSAGE_FIVE"));
        Font labelFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 16);
        label1.setBounds(20, 20, 500, 60);
        label1.setFont(labelFont);
        label2.setBounds(20, 80, 450, 60);
        label2.setFont(labelFont);
        label3.setBounds(20, 140, 450, 60);
        label3.setFont(labelFont);
        label4.setBounds(20, 200, 450, 60);
        label4.setFont(labelFont);
        label5.setBounds(20, 260, 450, 50);
        label5.setFont(labelFont);
        textRightPanel.add(label1);
        textRightPanel.add(label2);
        textRightPanel.add(label3);
        textRightPanel.add(label4);
        textRightPanel.add(label5);
        textPanel.add(textRightPanel);
        return textRightPanel;
    }

    private void addTimerLabel(WhitePanel endPanel, String interceptionId) {
        this.setTime(0, 30, 0);
        this.timeLabel = new JLabel();
        this.timeLabel.setBounds(390, 30, 78, 30);
        this.timeLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        this.timeLabel.setForeground(Color.GRAY);
        this.setText();
        endPanel.add(this.timeLabel);
        HighRiskInterceptRecordBo highRiskInterceptRecordBo = new HighRiskInterceptRecordBo();
        highRiskInterceptRecordBo.setGuid(interceptionId);
        SINGLE_THREAD_EXECUTOR.execute(() -> this.showTimerLabel(highRiskInterceptRecordBo, this.imageLabel));
    }

    private void showTimerLabel(HighRiskInterceptRecordBo highRiskInterceptRecordBo, JLabel imageLabel) {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.second;
            if (this.second < 0) {
                --this.minute;
                this.second = 59;
            }
            if (this.minute < 0) {
                --this.hour;
                this.minute = 59;
            }
            if (this.hour < 0) break;
            this.setText();
            if (this.second != 0 || this.minute != 0 || this.hour != 0) continue;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.generateCodejLabel(highRiskInterceptRecordBo, imageLabel);
            this.currentTimeLabel.setText(this.internationalizeUtil.getResource("HIGH_RISK_VALID_TIME_ONE") + format.format(new Date()) + this.internationalizeUtil.getResource("HIGH_RISK_VALID_TIME_TWO"));
            this.setTime(0, 30, 0);
            this.setText();
            SINGLE_THREAD_EXECUTOR.execute(() -> this.showTimerLabel(highRiskInterceptRecordBo, imageLabel));
        }
    }

    private void setTime(int hour, int minute, int second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    private void setText() {
        this.timeLabel.setText((this.hour < 10 ? "0" + this.hour : Integer.valueOf(this.hour)) + ":" + (this.minute < 10 ? "0" + this.minute : Integer.valueOf(this.minute)) + ":" + (this.second < 10 ? "0" + this.second : Integer.valueOf(this.second)));
    }
}

