/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.swing.component.RoundBorder;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.style.CustomRenderer;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.InterceptionPageUtils;
import com.huawei.netcareinsidesdk.swingservice.CommandSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.vo.CommandInfoVo;
import com.huawei.netcareinsidesdk.vo.HighRiskCommandInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.HighRiskCommandQueryVo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class HighRiskWhiteCommandTable {
    private static final long serialVersionUID = -6546334664166791132L;
    @Autowired
    private InterceptionPageUtils interceptionPageUtils;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommandSwingService commandSwingService;
    private int pageNum = 1;
    private int pageSize = 10;
    private int lastPage;
    private int whiteCommandTotal;
    private JLabel totalLabel;
    private JLabel whiteInterceptionTotalPageLabel;
    private JTextField whiteInterceptionCurrentPageText;
    private JComboBox<String> whiteInterceptionPlolicyPage;
    JTable jTable = null;
    DefaultTableModel defaultModel = null;
    List<CommandInfoVo> highRiskCommandListConfigs;

    private void init() {
        this.pageNum = 1;
        this.pageSize = 10;
    }

    private void showWhiteCommandTable(int currentPage, int pageSize) {
        int count;
        this.defaultModel.setRowCount(0);
        this.pageNum = currentPage;
        HighRiskCommandInfoQueryVo query = this.query(currentPage, pageSize);
        this.highRiskCommandListConfigs = query.getCommandInfoVos();
        this.whiteCommandTotal = count = query.getTotal().intValue();
        this.totalLabel.setText(String.valueOf(count));
        this.whiteInterceptionTotalPageLabel.setText(String.valueOf(this.lastPage));
        this.whiteInterceptionCurrentPageText.setText(String.valueOf(this.pageNum));
        for (int row = 0; row < this.highRiskCommandListConfigs.size(); ++row) {
            Vector<String> rowV = new Vector<String>();
            CommandInfoVo black = this.highRiskCommandListConfigs.get(row);
            rowV.add(black.getRegionName());
            rowV.add(black.getRepOfficeName());
            rowV.add(black.getProductLineName());
            rowV.add(black.getFullCommand());
            rowV.add(black.getCommandRegex());
            rowV.add(RiskLevelEnum.getRiskCnByCode(black.getRiskLevel()));
            this.defaultModel.addRow(rowV);
        }
        this.jTable.setSelectionMode(0);
        this.jTable.revalidate();
        this.jTable.repaint();
    }

    public JPanel getHighRiskWhiteList(Rectangle rectangle) {
        int queryWhiteCommandCount;
        this.init();
        WhitePanel highRiskCommandWhitePanel = this.interceptionPageUtils.getPublicMainPanel();
        highRiskCommandWhitePanel.getComponent(0).setBounds(rectangle);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.white);
        panel.setBounds(30, 25, 1240, 400);
        Object[] whiteColumnNames = new Object[]{this.internationalizeUtil.getResource("REGION"), this.internationalizeUtil.getResource("REPOFFICE"), this.internationalizeUtil.getResource("PRODUCTLINE"), this.internationalizeUtil.getResource("FULL_COMMAND"), this.internationalizeUtil.getResource("EXPRESSION"), this.internationalizeUtil.getResource("RISK_LEVEL")};
        HighRiskCommandInfoQueryVo query = this.query(this.pageNum, this.pageSize);
        Object[][] rowData = this.interceptionPageUtils.queryBlackList(query.getCommandInfoVos());
        this.whiteCommandTotal = queryWhiteCommandCount = query.getTotal().intValue();
        this.lastPage = queryWhiteCommandCount == 0 ? 1 : (queryWhiteCommandCount % this.pageSize == 0 ? queryWhiteCommandCount / this.pageSize : queryWhiteCommandCount / this.pageSize + 1);
        int[] length = new int[]{200, 200, 200, 200, 200, 200};
        this.setInterceptionTableStyle(whiteColumnNames, rowData, panel, length);
        this.jTable.setEnabled(false);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        highRiskCommandWhitePanel.add(panel);
        WhitePanel interceptionPlolicyPagePanel = this.getWhiteInterceptionPlolicyPagePanel();
        highRiskCommandWhitePanel.add(interceptionPlolicyPagePanel);
        highRiskCommandWhitePanel.add(this.getWhitePageButtonPanel());
        return highRiskCommandWhitePanel;
    }

    private void setInterceptionTableStyle(Object[] columnNames, Object[][] rowData, JPanel panel, int[] length) {
        this.defaultModel = new DefaultTableModel(rowData, columnNames);
        this.jTable = new JTable(this.defaultModel);
        this.jTable.setBackground(Color.white);
        CustomRenderer tcr = new CustomRenderer();
        this.jTable.setDefaultRenderer(Object.class, tcr);
        JTableHeader tabHeader = this.jTable.getTableHeader();
        tabHeader.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        tabHeader.setPreferredSize(new Dimension(tabHeader.getWidth(), 45));
        this.jTable.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        this.jTable.setRowHeight(35);
        this.jTable.setAutoResizeMode(4);
        if (length != null) {
            TableColumnModel model0 = this.jTable.getColumnModel();
            for (int i = 0; i < model0.getColumnCount(); ++i) {
                TableColumn column = model0.getColumn(i);
                column.setPreferredWidth(length[i]);
            }
        }
        this.interceptionPageUtils.setTableTextCenter(this.jTable);
        panel.add((Component)this.jTable.getTableHeader(), "North");
        panel.add((Component)this.jTable, "Center");
        JScrollPane scrollPane = new JScrollPane(this.jTable);
        scrollPane.getViewport().setBackground(Color.WHITE);
        panel.add(scrollPane);
    }

    private WhitePanel getWhitePageButtonPanel() {
        WhitePanel whiteOperationPanel = new WhitePanel();
        whiteOperationPanel.setLayout(null);
        whiteOperationPanel.setBounds(1110, 445, 350, 40);
        whiteOperationPanel.add(this.runToSpecfivPage());
        JLabel sepratorLabel = new JLabel(ImageUtils.generateImage("pageSeprator.png"));
        sepratorLabel.setBounds(95, 0, 10, 25);
        whiteOperationPanel.add(sepratorLabel);
        this.whiteInterceptionTotalPageLabel = new JLabel(String.valueOf(this.lastPage));
        this.whiteInterceptionTotalPageLabel.setBounds(100, 0, 45, 25);
        this.whiteInterceptionTotalPageLabel.setHorizontalAlignment(0);
        this.whiteInterceptionTotalPageLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        whiteOperationPanel.add(this.whiteInterceptionTotalPageLabel);
        JButton preJbutton = this.interceptionPageUtils.genrateButtonStyle("PrePage");
        preJbutton.setBounds(15, 0, 25, 25);
        preJbutton.setIcon(ImageUtils.generateImage("prePage.png"));
        preJbutton.addActionListener(new MyTable());
        whiteOperationPanel.add(preJbutton);
        JButton nextJbutton = this.interceptionPageUtils.genrateButtonStyle("NextPage");
        nextJbutton.setBounds(145, 0, 20, 25);
        nextJbutton.setIcon(ImageUtils.generateImage("nextPage.png"));
        nextJbutton.addActionListener(new MyTable());
        whiteOperationPanel.add(nextJbutton);
        return whiteOperationPanel;
    }

    private JTextField runToSpecfivPage() {
        this.whiteInterceptionCurrentPageText = new JTextField();
        this.whiteInterceptionCurrentPageText.setBounds(40, 0, 45, 25);
        this.whiteInterceptionCurrentPageText.setHorizontalAlignment(0);
        this.whiteInterceptionCurrentPageText.setBorder(new RoundBorder(new Insets(0, 0, 0, 0), Color.GRAY));
        this.whiteInterceptionCurrentPageText.addFocusListener(new JTextFieldHintListener(this.whiteInterceptionCurrentPageText, "1", Color.BLACK));
        this.whiteInterceptionCurrentPageText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                String text;
                super.keyTyped(event);
                if (!Character.isDigit(event.getKeyChar())) {
                    event.consume();
                }
                if ((text = HighRiskWhiteCommandTable.this.whiteInterceptionCurrentPageText.getText()) == null || text.isEmpty()) {
                    return;
                }
                if (text.length() > 4) {
                    event.consume();
                }
                int inputRunToNum = Integer.parseInt(text);
                if (event.getKeyChar() == '\n') {
                    HighRiskWhiteCommandTable.this.pageNum = inputRunToNum == 0 ? 1 : inputRunToNum;
                    if (HighRiskWhiteCommandTable.this.pageNum < HighRiskWhiteCommandTable.this.lastPage) {
                        HighRiskWhiteCommandTable.this.showWhiteCommandTable(HighRiskWhiteCommandTable.this.pageNum, HighRiskWhiteCommandTable.this.pageSize);
                    } else {
                        HighRiskWhiteCommandTable.this.showWhiteCommandTable(HighRiskWhiteCommandTable.this.lastPage, HighRiskWhiteCommandTable.this.pageSize);
                    }
                }
            }
        });
        return this.whiteInterceptionCurrentPageText;
    }

    private HighRiskCommandInfoQueryVo query(int currentPage, int pageSize) {
        HighRiskCommandQueryVo highRiskCommandQueryVo = new HighRiskCommandQueryVo();
        highRiskCommandQueryVo.setPageSize(String.valueOf(pageSize));
        highRiskCommandQueryVo.setPageNum(String.valueOf(currentPage));
        highRiskCommandQueryVo.setHighRiskCode("2");
        return this.commandSwingService.queryHighRiskCommandInfo(highRiskCommandQueryVo);
    }

    private WhitePanel getWhiteInterceptionPlolicyPagePanel() {
        WhitePanel whitePanel = this.interceptionPageUtils.getPaginationPanel(this.whiteCommandTotal);
        if (whitePanel.getComponent(1) instanceof JLabel) {
            this.totalLabel = (JLabel)whitePanel.getComponent(1);
        }
        this.whiteInterceptionPlolicyPage = new JComboBox();
        this.whiteInterceptionPlolicyPage.setBounds(110, 20, 130, 30);
        whitePanel.add(this.interceptionPageUtils.getPagination(this.whiteInterceptionPlolicyPage));
        this.whiteInterceptionPlolicyPage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (1 == itemEvent.getStateChange()) {
                    this.pageListener();
                }
            }

            private void pageListener() {
                HighRiskWhiteCommandTable.this.whiteInterceptionPlolicyPage.setBackground(Color.WHITE);
                HighRiskWhiteCommandTable.this.whiteInterceptionPlolicyPage.setFocusable(false);
                String num = HighRiskWhiteCommandTable.this.interceptionPageUtils.getPageSize(String.valueOf(HighRiskWhiteCommandTable.this.whiteInterceptionPlolicyPage.getSelectedIndex()));
                HighRiskWhiteCommandTable.this.pageSize = Integer.parseInt(num);
                if (HighRiskWhiteCommandTable.this.whiteCommandTotal == 0) {
                    HighRiskWhiteCommandTable.this.lastPage = 1;
                } else if (HighRiskWhiteCommandTable.this.whiteCommandTotal % HighRiskWhiteCommandTable.this.pageSize == 0) {
                    HighRiskWhiteCommandTable.this.lastPage = HighRiskWhiteCommandTable.this.whiteCommandTotal / HighRiskWhiteCommandTable.this.pageSize;
                } else {
                    HighRiskWhiteCommandTable.this.lastPage = HighRiskWhiteCommandTable.this.whiteCommandTotal / HighRiskWhiteCommandTable.this.pageSize + 1;
                }
                HighRiskWhiteCommandTable.this.pageNum = 1;
                HighRiskWhiteCommandTable.this.showWhiteCommandTable(HighRiskWhiteCommandTable.this.pageNum, Integer.parseInt(num));
            }
        });
        return whitePanel;
    }

    class MyTable
    implements ActionListener {
        MyTable() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("PrePage")) {
                if (HighRiskWhiteCommandTable.this.pageNum <= 1) {
                    HighRiskWhiteCommandTable.this.pageNum = 1;
                } else {
                    HighRiskWhiteCommandTable.this.showWhiteCommandTable(HighRiskWhiteCommandTable.this.pageNum - 1, HighRiskWhiteCommandTable.this.pageSize);
                }
            }
            if (event.getActionCommand().equals("NextPage")) {
                if (HighRiskWhiteCommandTable.this.pageNum < HighRiskWhiteCommandTable.this.lastPage) {
                    HighRiskWhiteCommandTable.this.showWhiteCommandTable(HighRiskWhiteCommandTable.this.pageNum + 1, HighRiskWhiteCommandTable.this.pageSize);
                } else {
                    HighRiskWhiteCommandTable.this.showWhiteCommandTable(HighRiskWhiteCommandTable.this.lastPage, HighRiskWhiteCommandTable.this.pageSize);
                }
            }
        }
    }
}

