/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.constants.RiskLevelEnum;
import com.huawei.netcareinsidesdk.swing.component.RoundBorder;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.listener.JTextFieldHintListener;
import com.huawei.netcareinsidesdk.swing.style.CustomRenderer;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.InterceptionPageUtils;
import com.huawei.netcareinsidesdk.swingservice.CommandSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.vo.HighRiskCommandQueryVo;
import com.huawei.netcareinsidesdk.vo.HighRiskMenuInfoQueryVo;
import com.huawei.netcareinsidesdk.vo.MenuInfoVo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class HighRiskWhiteMenuTable {
    private static final long serialVersionUID = -80582346270143874L;
    @Autowired
    private CommandSwingService commandSwingService;
    @Autowired
    private InterceptionPageUtils interceptionPageUtils;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    private int pageNum = 1;
    private int pageSize = 10;
    private int lastPage;
    private int whiteMenuTotal;
    private JLabel whiteMenuLabel;
    private JLabel whiteMenuPageLabel;
    private JTextField whiteMenuTextField;
    private JComboBox<String> whiteInterceptionPlolicyPage;
    JTable jTable = null;
    DefaultTableModel defaultTableModel = null;
    List<MenuInfoVo> menuInfoVos;

    private void init() {
        this.pageNum = 1;
        this.pageSize = 10;
    }

    private void showWhiteMenuTable(int currentPage, int pageSize) {
        int count;
        this.defaultTableModel.setRowCount(0);
        this.pageNum = currentPage;
        HighRiskMenuInfoQueryVo highRiskMenuInfoQueryVo = this.query(currentPage, pageSize);
        this.menuInfoVos = highRiskMenuInfoQueryVo.getMenuInfoVos();
        this.whiteMenuTotal = count = highRiskMenuInfoQueryVo.getTotal().intValue();
        this.whiteMenuLabel.setText(String.valueOf(count));
        this.whiteMenuPageLabel.setText(String.valueOf(this.lastPage));
        this.whiteMenuTextField.setText(String.valueOf(this.pageNum));
        for (int row = 0; row < this.menuInfoVos.size(); ++row) {
            Vector<String> rowV = new Vector<String>();
            MenuInfoVo whiteMenuInfo = this.menuInfoVos.get(row);
            rowV.add(whiteMenuInfo.getRegionName());
            rowV.add(whiteMenuInfo.getRepOfficeName());
            rowV.add(whiteMenuInfo.getProductLineName());
            rowV.add(whiteMenuInfo.getToolVersion());
            if (LanguageManager.isEnglish()) {
                rowV.add(whiteMenuInfo.getMenuEn());
            } else {
                rowV.add(whiteMenuInfo.getMenuCn());
            }
            rowV.add(whiteMenuInfo.getMenuCode());
            rowV.add(RiskLevelEnum.getRiskCnByCode(whiteMenuInfo.getRiskLevel()));
            this.defaultTableModel.addRow(rowV);
        }
        this.jTable.setSelectionMode(0);
        this.jTable.revalidate();
        this.jTable.repaint();
    }

    public JPanel getHighRiskWhiteMenuList(Rectangle rectangle) {
        int queryWhiteMenuCount;
        this.init();
        WhitePanel highRiskWhiteMenuPanel = this.interceptionPageUtils.getPublicMainPanel();
        highRiskWhiteMenuPanel.getComponent(0).setBounds(rectangle);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.white);
        panel.setBounds(30, 25, 1240, 400);
        Object[] whiteMenuColumnNames = new Object[]{this.internationalizeUtil.getResource("REGION"), this.internationalizeUtil.getResource("REPOFFICE"), this.internationalizeUtil.getResource("PRODUCTLINE"), this.internationalizeUtil.getResource("TOOL_VERSION"), this.internationalizeUtil.getResource("MENU_NAME"), this.internationalizeUtil.getResource("MENU_ID"), this.internationalizeUtil.getResource("RISK_LEVEL")};
        HighRiskMenuInfoQueryVo highRiskMenuInfoQueryVo = this.query(this.pageNum, this.pageSize);
        Object[][] rowData = this.interceptionPageUtils.queryMenuList(highRiskMenuInfoQueryVo.getMenuInfoVos());
        this.whiteMenuTotal = queryWhiteMenuCount = highRiskMenuInfoQueryVo.getTotal().intValue();
        this.lastPage = queryWhiteMenuCount == 0 ? 1 : (queryWhiteMenuCount % this.pageSize == 0 ? queryWhiteMenuCount / this.pageSize : queryWhiteMenuCount / this.pageSize + 1);
        int[] whiteLength = new int[]{200, 200, 200, 200, 200, 200, 200};
        this.setInterceptionTableStyle(whiteMenuColumnNames, rowData, panel, whiteLength);
        this.jTable.setEnabled(false);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        highRiskWhiteMenuPanel.add(panel);
        WhitePanel whiteMenuPagePanel = this.getWhiteMenuPagePanel();
        highRiskWhiteMenuPanel.add(whiteMenuPagePanel);
        highRiskWhiteMenuPanel.add(this.getWhitePageButtonPanel());
        return highRiskWhiteMenuPanel;
    }

    private void setInterceptionTableStyle(Object[] columnNames, Object[][] rowData, JPanel panel, int[] whiteLength) {
        this.defaultTableModel = new DefaultTableModel(rowData, columnNames);
        this.jTable = new JTable(this.defaultTableModel);
        this.jTable.setBackground(Color.white);
        CustomRenderer tcr = new CustomRenderer();
        this.jTable.setDefaultRenderer(Object.class, tcr);
        JTableHeader whiteMenuHeader = this.jTable.getTableHeader();
        whiteMenuHeader.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        whiteMenuHeader.setPreferredSize(new Dimension(whiteMenuHeader.getWidth(), 45));
        this.jTable.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        this.jTable.setRowHeight(35);
        this.jTable.setAutoResizeMode(4);
        if (whiteLength != null) {
            TableColumnModel whiteMenuModel = this.jTable.getColumnModel();
            for (int i = 0; i < whiteMenuModel.getColumnCount(); ++i) {
                TableColumn column = whiteMenuModel.getColumn(i);
                column.setPreferredWidth(whiteLength[i]);
            }
        }
        this.interceptionPageUtils.setTableTextCenter(this.jTable);
        panel.add((Component)this.jTable.getTableHeader(), "North");
        panel.add((Component)this.jTable, "Center");
        JScrollPane whiteMenuScrollPane = new JScrollPane(this.jTable);
        whiteMenuScrollPane.getViewport().setBackground(Color.WHITE);
        panel.add(whiteMenuScrollPane);
    }

    private WhitePanel getWhitePageButtonPanel() {
        WhitePanel whiteMenuPanel = new WhitePanel();
        whiteMenuPanel.setLayout(null);
        whiteMenuPanel.setBounds(1110, 445, 350, 40);
        whiteMenuPanel.add(this.runToSpecfivPage());
        JLabel sepratorLabel = new JLabel(ImageUtils.generateImage("pageSeprator.png"));
        sepratorLabel.setBounds(95, 0, 10, 25);
        whiteMenuPanel.add(sepratorLabel);
        this.whiteMenuPageLabel = new JLabel(String.valueOf(this.lastPage));
        this.whiteMenuPageLabel.setBounds(100, 0, 45, 25);
        this.whiteMenuPageLabel.setHorizontalAlignment(0);
        this.whiteMenuPageLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        whiteMenuPanel.add(this.whiteMenuPageLabel);
        JButton preJbutton = this.interceptionPageUtils.genrateButtonStyle("PrePage");
        preJbutton.setBounds(15, 0, 25, 25);
        preJbutton.setIcon(ImageUtils.generateImage("prePage.png"));
        preJbutton.addActionListener(new MyTable());
        whiteMenuPanel.add(preJbutton);
        JButton nextJbutton = this.interceptionPageUtils.genrateButtonStyle("NextPage");
        nextJbutton.setBounds(145, 0, 20, 25);
        nextJbutton.setIcon(ImageUtils.generateImage("nextPage.png"));
        nextJbutton.addActionListener(new MyTable());
        whiteMenuPanel.add(nextJbutton);
        return whiteMenuPanel;
    }

    private JTextField runToSpecfivPage() {
        this.whiteMenuTextField = new JTextField();
        this.whiteMenuTextField.setBounds(40, 0, 45, 25);
        this.whiteMenuTextField.setHorizontalAlignment(0);
        this.whiteMenuTextField.setBorder(new RoundBorder(new Insets(0, 0, 0, 0), Color.GRAY));
        this.whiteMenuTextField.addFocusListener(new JTextFieldHintListener(this.whiteMenuTextField, "1", Color.BLACK));
        this.whiteMenuTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                String whiteMenuText;
                super.keyTyped(event);
                if (!Character.isDigit(event.getKeyChar())) {
                    event.consume();
                }
                if ((whiteMenuText = HighRiskWhiteMenuTable.this.whiteMenuTextField.getText()) == null || whiteMenuText.isEmpty()) {
                    return;
                }
                if (whiteMenuText.length() > 4) {
                    event.consume();
                }
                int whiteMenuNum = Integer.parseInt(whiteMenuText);
                if (event.getKeyChar() == '\n') {
                    HighRiskWhiteMenuTable.this.pageNum = whiteMenuNum == 0 ? 1 : whiteMenuNum;
                    if (HighRiskWhiteMenuTable.this.pageNum < HighRiskWhiteMenuTable.this.lastPage) {
                        HighRiskWhiteMenuTable.this.showWhiteMenuTable(HighRiskWhiteMenuTable.this.pageNum, HighRiskWhiteMenuTable.this.pageSize);
                    } else {
                        HighRiskWhiteMenuTable.this.showWhiteMenuTable(HighRiskWhiteMenuTable.this.lastPage, HighRiskWhiteMenuTable.this.pageSize);
                    }
                }
            }
        });
        return this.whiteMenuTextField;
    }

    private HighRiskMenuInfoQueryVo query(int currentPage, int pageSize) {
        HighRiskCommandQueryVo highRiskCommandQueryVo = new HighRiskCommandQueryVo();
        highRiskCommandQueryVo.setPageSize(String.valueOf(pageSize));
        highRiskCommandQueryVo.setPageNum(String.valueOf(currentPage));
        highRiskCommandQueryVo.setHighRiskCode("2");
        return this.commandSwingService.queryHighRiskMenuInfo(highRiskCommandQueryVo);
    }

    private WhitePanel getWhiteMenuPagePanel() {
        WhitePanel whiteMenuPanel = this.interceptionPageUtils.getPaginationPanel(this.whiteMenuTotal);
        if (whiteMenuPanel.getComponent(1) instanceof JLabel) {
            this.whiteMenuLabel = (JLabel)whiteMenuPanel.getComponent(1);
        }
        this.whiteInterceptionPlolicyPage = new JComboBox();
        this.whiteInterceptionPlolicyPage.setBounds(110, 20, 130, 30);
        whiteMenuPanel.add(this.interceptionPageUtils.getPagination(this.whiteInterceptionPlolicyPage));
        this.whiteInterceptionPlolicyPage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent whiteMenuPanel) {
                if (1 == whiteMenuPanel.getStateChange()) {
                    this.pageListener();
                }
            }

            private void pageListener() {
                HighRiskWhiteMenuTable.this.whiteInterceptionPlolicyPage.setBackground(Color.WHITE);
                HighRiskWhiteMenuTable.this.whiteInterceptionPlolicyPage.setFocusable(false);
                String whiteMenuSize = HighRiskWhiteMenuTable.this.interceptionPageUtils.getPageSize(String.valueOf(HighRiskWhiteMenuTable.this.whiteInterceptionPlolicyPage.getSelectedIndex()));
                HighRiskWhiteMenuTable.this.pageSize = Integer.parseInt(whiteMenuSize);
                if (HighRiskWhiteMenuTable.this.whiteMenuTotal == 0) {
                    HighRiskWhiteMenuTable.this.lastPage = 1;
                } else if (HighRiskWhiteMenuTable.this.whiteMenuTotal % HighRiskWhiteMenuTable.this.pageSize == 0) {
                    HighRiskWhiteMenuTable.this.lastPage = HighRiskWhiteMenuTable.this.whiteMenuTotal / HighRiskWhiteMenuTable.this.pageSize;
                } else {
                    HighRiskWhiteMenuTable.this.lastPage = HighRiskWhiteMenuTable.this.whiteMenuTotal / HighRiskWhiteMenuTable.this.pageSize + 1;
                }
                HighRiskWhiteMenuTable.this.pageNum = 1;
                HighRiskWhiteMenuTable.this.showWhiteMenuTable(HighRiskWhiteMenuTable.this.pageNum, Integer.parseInt(whiteMenuSize));
            }
        });
        return whiteMenuPanel;
    }

    class MyTable
    implements ActionListener {
        MyTable() {
        }

        @Override
        public void actionPerformed(ActionEvent whiteMenuEvent) {
            if (whiteMenuEvent.getActionCommand().equals("PrePage")) {
                if (HighRiskWhiteMenuTable.this.pageNum <= 1) {
                    HighRiskWhiteMenuTable.this.pageNum = 1;
                } else {
                    HighRiskWhiteMenuTable.this.showWhiteMenuTable(HighRiskWhiteMenuTable.this.pageNum - 1, HighRiskWhiteMenuTable.this.pageSize);
                }
            }
            if (whiteMenuEvent.getActionCommand().equals("NextPage")) {
                if (HighRiskWhiteMenuTable.this.pageNum < HighRiskWhiteMenuTable.this.lastPage) {
                    HighRiskWhiteMenuTable.this.showWhiteMenuTable(HighRiskWhiteMenuTable.this.pageNum + 1, HighRiskWhiteMenuTable.this.pageSize);
                } else {
                    HighRiskWhiteMenuTable.this.showWhiteMenuTable(HighRiskWhiteMenuTable.this.lastPage, HighRiskWhiteMenuTable.this.pageSize);
                }
            }
        }
    }
}

