/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.alibaba.fastjson.JSONObject;
import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.constants.CloseTypeEnum;
import com.huawei.netcareinsidesdk.constants.OperationRecordEnum;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.utils.ApplyOrderComponentUtils;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swing.utils.LabelsUtils;
import com.huawei.netcareinsidesdk.swingservice.InitSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.utils.ZipUtils;
import com.huawei.netcareinsidesdk.vo.InitQrInfoVo;
import com.huawei.netcareinsidesdk.vo.UserInfoResultVo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Component
public class InitStmInfoPage {
    private static final Logger log = LoggerFactory.getLogger(InitStmInfoPage.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(InitStmInfoPage.class);
    private static final String ZERO = "0";
    private static String importPackage = "";
    private static final String SUCCESS = "success";
    private String verifyCode = "";
    private String guid = "";
    @Value(value="${netcareinside.tooId}")
    private String toolId;
    private JTextField jTextField;
    @Autowired
    private LabelsUtils labelsUtils;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private InitSwingService initSwingService;
    @Autowired
    private CommonServiceForSdk commonServiceForSdk;
    @Autowired
    private ApplyOrderComponentUtils applyOrderComponentUtils;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonUtils commonUtils;

    public void drawInitStmInfoPage(String initGuid, boolean hasUser, String site) {
        this.swingPageFrameManager.closeAllPage();
        this.intParams();
        this.guid = initGuid;
        WhiteJDialog initStmInfoWhiteJFrame = this.swingPageFrameManager.getInitStmInfoWhiteJFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
        WhitePanel dataPanel = this.labelsUtils.initWhitePanel(0, 0, 820, 530, null);
        this.drawTitleData(initStmInfoWhiteJFrame, dataPanel, this.internationalizeUtil.getResource("INIT_CONTROL_TITLE"));
        this.drawInitPageData(initStmInfoWhiteJFrame, dataPanel, hasUser, site);
        initStmInfoWhiteJFrame.add(dataPanel);
        initStmInfoWhiteJFrame.setVisible(true);
    }

    private void drawInitPageData(WhiteJDialog initStmInfoWhiteJFrame, WhitePanel dataPanel, boolean hasUser, String site) {
        Rectangle rectangle = new Rectangle(40, 5, 85, 30);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        rectangle.setBounds(35, 85, 400, 30);
        JLabel codeLabel = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("INIT_CONTROL_SCAN_TIP"), rectangle, null, null);
        dataPanel.add(codeLabel);
        this.drawSiteInfo(dataPanel, rectangle, font);
        InitQrInfoVo initQrInfoVo = new InitQrInfoVo();
        this.drawQrCode(initStmInfoWhiteJFrame, dataPanel, hasUser, site, rectangle, font, initQrInfoVo);
        rectangle.setBounds(35, 430, 300, 30);
        JLabel inputLabel = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("ENTER_VERIFY_CODE"), rectangle, null, null);
        dataPanel.add(inputLabel);
        rectangle.setBounds(45, 475, 200, 30);
        this.jTextField = this.applyOrderComponentUtils.genVeryCodeText(this.internationalizeUtil.getResource("ENTER"));
        this.jTextField.setBounds(rectangle);
        this.jTextField.addActionListener(event -> {
            this.verifyCode = this.jTextField.getText();
            if (StringUtils.isBlank((CharSequence)this.verifyCode) || this.verifyCode.equals(this.internationalizeUtil.getResource("VERIFICATION_TIP"))) {
                this.commonUtils.showWarnPanel(initStmInfoWhiteJFrame, "", this.internationalizeUtil.getResource("VERIFICATION_TIP"));
            }
        });
        dataPanel.add(this.jTextField);
        this.drawDeterminButton(initStmInfoWhiteJFrame, dataPanel, rectangle, initQrInfoVo);
    }

    private void drawDeterminButton(WhiteJDialog initStmInfoWhiteJFrame, WhitePanel dataPanel, Rectangle rectangle, InitQrInfoVo initQrInfoVo) {
        rectangle.setBounds(265, 475, 95, 30);
        Font buttonFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        JButton button = this.labelsUtils.getButton(buttonFont, this.internationalizeUtil.getResource("VERIFICATION"), rectangle, Color.white);
        button.addActionListener(listener -> {
            this.verifyCode = this.jTextField.getText();
            if (StringUtils.isBlank((CharSequence)this.verifyCode) || this.verifyCode.equals(this.internationalizeUtil.getResource("ENTER"))) {
                this.commonUtils.showWarnPanel(initStmInfoWhiteJFrame, "", this.internationalizeUtil.getResource("VERIFICATION_TIP"));
                return;
            }
            if (!Pattern.matches("^\\d{6}$", this.verifyCode)) {
                this.commonUtils.showWarnPanel(initStmInfoWhiteJFrame, "", this.internationalizeUtil.getResource("ENTER_PROPER_VER"));
                return;
            }
            Result checkVerifyResult = this.initSwingService.checkVerify(this.verifyCode, initQrInfoVo.getAccount());
            if (Integer.parseInt(checkVerifyResult.get("code").toString()) != 0) {
                this.commonUtils.showWarnPanel(initStmInfoWhiteJFrame, "", checkVerifyResult.get("message").toString());
                return;
            }
            JSONObject jsonObject = (JSONObject)JSONObject.toJSON(checkVerifyResult.get("data"));
            String isImport = jsonObject.getString("isImport");
            if (!StringUtils.equals((CharSequence)ZERO, (CharSequence)isImport)) {
                this.addOrderOperationRecord(CloseTypeEnum.COMPLETE.getCloseType());
            }
            this.commonUtils.showWarnPanel(initStmInfoWhiteJFrame, "", this.internationalizeUtil.getResource("VERIFY_SUCESS"));
            LOGGER.info("Init user verify success!");
            initStmInfoWhiteJFrame.dispose();
            if (StringUtils.equals((CharSequence)ZERO, (CharSequence)isImport)) {
                this.drawImportPackage(this.guid);
            }
        });
        dataPanel.add(button);
    }

    private void drawSiteInfo(WhitePanel dataPanel, Rectangle rectangle, Font font) {
        rectangle.setBounds(430, 85, 380, 30);
        JLabel siteLabel = this.labelsUtils.getJLabel(font, this.internationalizeUtil.getResource("CHOOSE_SITE"), rectangle, null, null);
        dataPanel.add(siteLabel);
        Font siteFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        rectangle.setBounds(440, 155, 380, 30);
        JLabel siteDescLabel = this.labelsUtils.getJLabel(siteFont, this.internationalizeUtil.getResource("SITE_DESC"), rectangle, null, null);
        siteDescLabel.setForeground(new Color(245, 108, 108));
        dataPanel.add(siteDescLabel);
        rectangle.setBounds(440, 185, 380, 30);
        if (LanguageManager.isEnglish()) {
            JLabel enDescLabel = this.labelsUtils.getJLabel(siteFont, this.internationalizeUtil.getResource("GER_SITE_DESC"), rectangle, null, null);
            enDescLabel.setForeground(new Color(245, 108, 108));
            dataPanel.add(enDescLabel);
        }
    }

    private void drawQrCode(WhiteJDialog initStmInfoWhiteJFrame, WhitePanel dataPanel, boolean hasUser, String site, Rectangle rectangle, Font font, InitQrInfoVo initQrInfoVo) {
        JLabel imageLabel = new JLabel();
        if (hasUser) {
            UserInfoResultVo userInfoResultVo = this.initSwingService.queryUserList();
            List<UserInfoResultVo.UserInfoVo> userList = userInfoResultVo.getUserList();
            if (userList.size() == 1 && Objects.nonNull(userInfoResultVo.getIsPublicOmTerminal()) && !userInfoResultVo.getIsPublicOmTerminal().booleanValue()) {
                JTextField userInfoText = new JTextField();
                userInfoText.setBounds(45, 125, 220, 30);
                userInfoText.setFont(font);
                userInfoText.setText(userList.get(0).getLoginAccountName());
                userInfoText.setEditable(false);
                initQrInfoVo.setAccount(this.getLoginAccountBySelectItem(userInfoText.getText(), userList));
                dataPanel.add(userInfoText);
                rectangle.setBounds(270, 125, 125, 30);
            } else {
                JComboBox<String> backReasonBox = this.userComboBox(font, initQrInfoVo, initStmInfoWhiteJFrame, imageLabel, userInfoResultVo, userList);
                rectangle.setBounds(270, 125, 125, 30);
                dataPanel.add(backReasonBox);
            }
        } else {
            rectangle.setBounds(45, 125, 125, 30);
        }
        JButton qRCodeButton = this.labelsUtils.getButton(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12), this.internationalizeUtil.getResource("REFRESH_QR_CODE"), rectangle, Color.white);
        dataPanel.add(qRCodeButton);
        this.getJRadioButtonMode(font, dataPanel, initQrInfoVo, site, initStmInfoWhiteJFrame, imageLabel);
        imageLabel.setBounds(45, 145, 300, 300);
        qRCodeButton.addActionListener(actionEvent -> {
            imageLabel.setIcon(this.createQrCodeImage(initStmInfoWhiteJFrame, initQrInfoVo));
            imageLabel.setBounds(45, 145, 300, 300);
        });
        imageLabel.setIcon(this.createQrCodeImage(initStmInfoWhiteJFrame, initQrInfoVo));
        dataPanel.add(imageLabel);
    }

    private void getJRadioButtonMode(Font font, WhitePanel dataPanel, InitQrInfoVo initQrInfoVo, String site, WhiteJDialog initStmInfoWhiteJFrame, JLabel imageLabel) {
        JRadioButton china = new JRadioButton(this.internationalizeUtil.getResource("CHINA_SITE"));
        china.setBounds(435, 125, 100, 30);
        china.setBackground(Color.white);
        china.setFocusPainted(false);
        china.setFont(font);
        this.radioAddColorChange(china);
        JRadioButton germany = new JRadioButton(this.internationalizeUtil.getResource("GERMANY_SIT"));
        germany.setBounds(535, 125, 100, 30);
        germany.setBackground(Color.white);
        germany.setFocusPainted(false);
        germany.setFont(font);
        this.radioAddColorChange(germany);
        if (StringUtils.isEmpty((CharSequence)site) || StringUtils.equals((CharSequence)site, (CharSequence)"China")) {
            initQrInfoVo.setSite("China");
            china.setSelected(true);
        } else {
            initQrInfoVo.setSite("Germany");
            germany.setSelected(true);
        }
        dataPanel.add(china);
        dataPanel.add(germany);
        china.addActionListener(e -> {
            china.setSelected(true);
            germany.setSelected(false);
            initQrInfoVo.setSite("China");
            imageLabel.setIcon(this.createQrCodeImage(initStmInfoWhiteJFrame, initQrInfoVo));
            imageLabel.setBounds(45, 145, 300, 300);
        });
        germany.addActionListener(e -> {
            germany.setSelected(true);
            china.setSelected(false);
            initQrInfoVo.setSite("Germany");
            imageLabel.setIcon(this.createQrCodeImage(initStmInfoWhiteJFrame, initQrInfoVo));
            imageLabel.setBounds(45, 145, 300, 300);
        });
    }

    private void radioAddColorChange(JRadioButton radioButton) {
        radioButton.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                radioButton.setForeground(new Color(82, 110, 204));
            } else {
                radioButton.setForeground(Color.BLACK);
            }
        });
    }

    private JComboBox<String> userComboBox(Font font, InitQrInfoVo initQrInfoVo, WhiteJDialog initStmInfoWhiteJFrame, JLabel imageLabel, UserInfoResultVo userInfoResultVo, List<UserInfoResultVo.UserInfoVo> userList) {
        JComboBox<String> userComboBox = new JComboBox<String>();
        userComboBox.setBounds(35, 125, 220, 30);
        userComboBox.setBackground(Color.white);
        userComboBox.setFont(font);
        String currentUserName = null;
        for (UserInfoResultVo.UserInfoVo userInfo : userList) {
            if (StringUtils.equals((CharSequence)userInfoResultVo.getCurrentUser(), (CharSequence)userInfo.getLoginAccount())) {
                currentUserName = userInfo.getLoginAccountName();
            }
            userComboBox.addItem(userInfo.getLoginAccountName());
        }
        userComboBox.setSelectedItem(currentUserName);
        initQrInfoVo.setAccount(userInfoResultVo.getCurrentUser());
        userComboBox.addItem(this.internationalizeUtil.getResource("ADD_USER"));
        userComboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String text = (String)userComboBox.getSelectedItem();
                text = StringUtils.isNotBlank((CharSequence)text) && StringUtils.equals((CharSequence)text, (CharSequence)this.internationalizeUtil.getResource("ADD_USER")) ? "newUser" : this.getLoginAccountBySelectItem(text, userList);
                userComboBox.setBackground(Color.WHITE);
                userComboBox.setFocusable(false);
                initQrInfoVo.setAccount(text);
                imageLabel.setIcon(this.createQrCodeImage(initStmInfoWhiteJFrame, initQrInfoVo));
                imageLabel.setBounds(35, 145, 300, 300);
            }
        });
        return userComboBox;
    }

    private String getLoginAccountBySelectItem(String selectUser, List<UserInfoResultVo.UserInfoVo> userList) {
        String loginAccount = null;
        for (UserInfoResultVo.UserInfoVo userInfo : userList) {
            if (!StringUtils.equals((CharSequence)selectUser, (CharSequence)userInfo.getLoginAccountName())) continue;
            loginAccount = userInfo.getLoginAccount();
        }
        return loginAccount;
    }

    public void drawImportPackage(String operationGuid) {
        this.swingPageFrameManager.closeAllPage();
        importPackage = "";
        this.guid = operationGuid;
        WhiteJDialog importPackagePageFrame = this.swingPageFrameManager.getInitImportPackagePageFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
        WhitePanel dataPanel = this.labelsUtils.initWhitePanel(0, 0, 820, 550, null);
        this.drawTitleData(importPackagePageFrame, dataPanel, this.internationalizeUtil.getResource("INIT_TITLE"));
        this.drawPackageData(importPackagePageFrame, dataPanel);
        importPackagePageFrame.add(dataPanel);
        importPackagePageFrame.setVisible(true);
    }

    private void importInitFile(WhiteJDialog frame, JTextField inputText, JLabel importLabel) {
        JFileChooser jFileChooser = new JFileChooser();
        int showOpenDialog = jFileChooser.showOpenDialog(frame);
        if (showOpenDialog == 0) {
            File selectedFile = jFileChooser.getSelectedFile();
            if (!selectedFile.getName().endsWith("zip")) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("FILE_TYPE"));
                return;
            }
            CommonsMultipartFile multipartFile = new CommonsMultipartFile(ZipUtils.createFileItem(selectedFile));
            long size = multipartFile.getSize();
            if (size > 0xA00000L) {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("FILE_SIZE", Collections.singletonList(selectedFile.getName().substring(0, selectedFile.getName().length() - 4))));
                return;
            }
            Result importInitAuthInfo = this.initSwingService.importInitAuthInfo((MultipartFile)multipartFile);
            if (StringUtils.equals((CharSequence)String.valueOf(importInitAuthInfo.get("code")), (CharSequence)ZERO)) {
                importLabel.setText(this.internationalizeUtil.getResource("IMPORT_INIT_SUCESS"));
                importPackage = SUCCESS;
                inputText.setText(jFileChooser.getSelectedFile().getName().split("\\.")[0]);
                LOGGER.info("Initialization package imported successfully!");
            } else {
                this.commonUtils.showWarnPanel(frame, "", String.valueOf(importInitAuthInfo.get("message")));
                inputText.setText(this.internationalizeUtil.getResource("UPLOAD"));
                LOGGER.info("Failed to import the Initialization package.");
            }
        }
    }

    private void drawPackageData(final WhiteJDialog importPackagePageFrame, WhitePanel dataPanel) {
        Rectangle rectangle = new Rectangle(40, 5, 250, 30);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        rectangle.setBounds(40, 85, 500, 30);
        String info = this.internationalizeUtil.getResource("IMPORT_INIT_PKG");
        JLabel codeLabel = this.labelsUtils.getJLabel(font, info, rectangle, null, null);
        dataPanel.add(codeLabel);
        final JTextField inputText = new JTextField(this.internationalizeUtil.getResource("UPLOAD"));
        inputText.setForeground(Color.gray);
        final JLabel importLabel = new JLabel();
        importLabel.setBounds(340, 130, 350, 30);
        importLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        importLabel.setForeground(new Color(106, 197, 151));
        inputText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                super.mouseClicked(event);
                importLabel.setText("");
                InitStmInfoPage.this.importInitFile(importPackagePageFrame, inputText, importLabel);
            }
        });
        inputText.setPreferredSize(new Dimension(120, 30));
        inputText.setBounds(40, 130, 210, 30);
        Border insideBorder = BorderFactory.createEmptyBorder(1, 5, 1, 0);
        inputText.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        inputText.setBorder(BorderFactory.createCompoundBorder(inputText.getBorder(), insideBorder));
        inputText.setMargin(new Insets(1, 5, 1, 0));
        inputText.setFocusable(false);
        dataPanel.add(inputText);
        dataPanel.add(importLabel);
        JButton importJButton = new JButton(this.internationalizeUtil.getResource("IMPORTMSG"));
        importJButton.setBackground(Color.WHITE);
        importJButton.setBounds(260, 130, 78, 30);
        importJButton.setFocusPainted(false);
        importJButton.setFont(font);
        importJButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        importJButton.addActionListener(e -> {
            importLabel.setText("");
            this.importInitFile(importPackagePageFrame, inputText, importLabel);
        });
        dataPanel.add(importJButton);
        JButton determinedJButton = new JButton(this.internationalizeUtil.getResource("COMPLETED"));
        this.determinedButton(importPackagePageFrame, determinedJButton);
        dataPanel.add(determinedJButton);
        importPackagePageFrame.revalidate();
        importPackagePageFrame.repaint();
    }

    private void determinedButton(WhiteJDialog importPackagePageFrame, JButton determinedJButton) {
        determinedJButton.setBackground(Color.WHITE);
        determinedJButton.setBounds(40, 180, 120, 30);
        determinedJButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        determinedJButton.setFocusPainted(false);
        determinedJButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        determinedJButton.addActionListener(event -> {
            if (StringUtils.equals((CharSequence)importPackage, (CharSequence)SUCCESS)) {
                this.addOrderOperationRecord(CloseTypeEnum.COMPLETE.getCloseType());
                importPackagePageFrame.dispose();
            } else {
                this.commonUtils.showWarnPanel(importPackagePageFrame, "", this.internationalizeUtil.getResource("IMPORT_INIT_PKG_TIP"));
            }
        });
    }

    private void addOrderOperationRecord(String closeType) {
        OperationRecordBo operationRecordBo = new OperationRecordBo();
        operationRecordBo.setMoudle(OperationRecordEnum.INIT.getOperateType());
        operationRecordBo.setInteface("getInitAuthInfo");
        operationRecordBo.setGuid(this.guid);
        operationRecordBo.setCloseType(closeType);
        this.commonServiceForSdk.insertOperationRecord(operationRecordBo);
    }

    private ImageIcon createQrCodeImage(WhiteJDialog initStmInfoWhiteJFrame, InitQrInfoVo initQrInfoVo) {
        try {
            BufferedImage initToolAuthQRCode = this.initSwingService.getInitToolAuthQRCode(initQrInfoVo);
            if (initToolAuthQRCode != null) {
                return new ImageIcon(initToolAuthQRCode);
            }
        }
        catch (Exception exception) {
            this.commonUtils.showWarnPanel(initStmInfoWhiteJFrame, "", this.internationalizeUtil.getResource("GENERATE_CODE_ERROR"));
        }
        return null;
    }

    private void drawTitleData(WhiteJDialog initStmInfoWhiteJFrame, WhitePanel dataPanel, String tableName) {
        Rectangle rectangle = new Rectangle(40, 30, 20, 30);
        JLabel jLabelImage = this.labelsUtils.getJLabelImage("warn_img.png", rectangle, null, null);
        dataPanel.add(jLabelImage);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        rectangle.setBounds(70, 30, 500, 30);
        JLabel jLabel = this.labelsUtils.getJLabel(font, tableName, rectangle, null, null);
        dataPanel.add(jLabel);
        if (StringUtils.equals((CharSequence)this.toolId, (CharSequence)"ON Deployment")) {
            rectangle.setBounds(dataPanel.getWidth() - 50, 0, 50, 50);
            JButton buttonImage = this.labelsUtils.getJButtonImage(rectangle, null);
            buttonImage.addActionListener(e -> {
                this.addOrderOperationRecord(CloseTypeEnum.CANCEL.getCloseType());
                initStmInfoWhiteJFrame.dispose();
            });
            dataPanel.add(buttonImage);
        }
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 80, initStmInfoWhiteJFrame.getWidth(), 5);
        dataPanel.add(separatorLine);
    }

    private void intParams() {
        this.verifyCode = "";
        this.guid = "";
    }
}

