/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.ToolConfig;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.JsonParseUtils;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderInfoWarningPage {
    @Autowired
    private InternationalizeUtil internationalizeUtil;

    public void getOrderInfoWaringFrame(boolean ishasTask) {
        String message;
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 860, 340);
        frame.setResizable(false);
        Container container = frame.getContentPane();
        container.setLayout(null);
        ToolConfig toolConfig = JsonParseUtils.getToolConfig();
        if (ishasTask) {
            message = this.internationalizeUtil.getResource("ORDER_SET_EXECUTED_ORDER_CONNECT", Collections.singletonList(toolConfig.getOrderRefreshPathCn()));
            if (LanguageManager.isEnglish()) {
                message = this.internationalizeUtil.getResource("ORDER_SET_EXECUTED_ORDER_CONNECT", Collections.singletonList(toolConfig.getOrderRefreshPathEn()));
            }
        } else {
            message = this.internationalizeUtil.getResource("ORDER_NO_ORDER", Collections.singletonList(toolConfig.getOrderRefreshPathCn()));
            if (LanguageManager.isEnglish()) {
                message = this.internationalizeUtil.getResource("ORDER_NO_ORDER", Collections.singletonList(toolConfig.getOrderRefreshPathEn()));
            }
        }
        frame.add(this.getTitle(message));
        frame.add(this.getSeparatorLine());
        this.setOrderInfoFrame(frame);
    }

    public void getTaskInfoNotMacthWaringFrame() {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 860, 340);
        frame.setResizable(false);
        Container container = frame.getContentPane();
        container.setLayout(null);
        ToolConfig toolConfig = JsonParseUtils.getToolConfig();
        String tipMsg = this.internationalizeUtil.getResource("ORDER_TASK_TYPE_TIPS", Collections.singletonList(toolConfig.getOrderRefreshPathCn()));
        if (LanguageManager.isEnglish()) {
            tipMsg = this.internationalizeUtil.getResource("ORDER_TASK_TYPE_TIPS", Collections.singletonList(toolConfig.getOrderRefreshPathEn()));
        }
        frame.add(this.getTitle(tipMsg));
        frame.add(this.getSeparatorLine());
        this.setOrderInfoFrame(frame);
    }

    private void setOrderInfoFrame(WhiteJDialog frame) {
        WhitePanel waningTextPanel = new WhitePanel();
        waningTextPanel.setBounds(25, 110, 800, 180);
        waningTextPanel.setLayout(null);
        JLabel label1 = new JLabel(this.internationalizeUtil.getResource("ORDER_SET_EXECUTED_ORDER"));
        JLabel label2 = new JLabel(this.internationalizeUtil.getResource("ORDER_APPLY_EMERGENCY"));
        Font labelFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18);
        JButton determinedButton = new JButton(this.internationalizeUtil.getResource("COMMON_OK"));
        if (LanguageManager.isEnglish()) {
            label1.setBounds(20, 20, 770, 70);
            label2.setBounds(20, 95, 770, 50);
            determinedButton.setBounds(350, 150, 78, 30);
        } else {
            label1.setBounds(20, 20, 770, 60);
            label2.setBounds(20, 75, 770, 30);
            determinedButton.setBounds(350, 130, 78, 30);
        }
        label1.setFont(labelFont);
        label1.setForeground(Color.gray);
        label2.setFont(labelFont);
        label2.setForeground(Color.gray);
        waningTextPanel.add(label1);
        waningTextPanel.add(label2);
        determinedButton.setBackground(Color.WHITE);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14);
        determinedButton.setFont(font);
        determinedButton.setFocusPainted(false);
        determinedButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        waningTextPanel.add(determinedButton);
        frame.add(waningTextPanel);
        determinedButton.addActionListener(event -> frame.dispose());
        frame.setVisible(true);
    }

    private JPanel getTitle(String message) {
        WhitePanel orderInfoWarningPanel = new WhitePanel();
        orderInfoWarningPanel.setBounds(25, 15, 840, 90);
        orderInfoWarningPanel.setLayout(null);
        JLabel imageLabel = new JLabel(ImageUtils.generateImage("warn_img.png"));
        imageLabel.setBounds(15, 5, 20, 35);
        JLabel label = new JLabel(message);
        label.setBounds(40, 0, 750, 90);
        Font font1 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        label.setFont(font1);
        orderInfoWarningPanel.add(imageLabel);
        orderInfoWarningPanel.add(label);
        return orderInfoWarningPanel;
    }

    private JPanel getSeparatorLine() {
        WhitePanel separatorPanel = new WhitePanel();
        separatorPanel.setLocation(0, 100);
        separatorPanel.setSize(860, 10);
        separatorPanel.setLayout(new FlowLayout(1));
        JSeparator separator = new JSeparator(0);
        separator.setPreferredSize(new Dimension(860, 1));
        separator.setBackground(Color.lightGray);
        separatorPanel.add(separator);
        return separatorPanel;
    }
}

