/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.bo.TaskDotFinishBo;
import com.huawei.netcareinsidesdk.bo.TaskFinishBo;
import com.huawei.netcareinsidesdk.constants.CloseTypeEnum;
import com.huawei.netcareinsidesdk.constants.OperateDelayReasonEnum;
import com.huawei.netcareinsidesdk.constants.OperationRecordEnum;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.swing.component.TextAreaDocument;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.constants.RollBackReasonEnum;
import com.huawei.netcareinsidesdk.swing.listener.JTextAreaHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.style.DefaultJScrollPane;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskCompleteSwingService;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskFinishPointVo;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RollbackComplete {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollbackComplete.class);
    private static JScrollPane jScrollPane;
    private static JPanel screenPanel;
    private static DefaultJScrollPane frameJScrollPane;
    @Autowired
    private TaskServiceSwingService taskServiceSwingService;
    @Autowired
    private TaskCompleteSwingService taskCompleteSwingService;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private CommonServiceForSdk commonServiceForSdk;
    @Autowired
    private CommonUtils commonUtils;
    @Autowired
    private InternationalizeUtil internationalizeUtil;

    public void rollbackNotContainPositionAndDelay(TaskFinishBo taskFinishBo) {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 886, 440);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        screenPanel = this.swingPageFrameManager.getScreenPanel(frame);
        this.getTotalTitle(screenPanel);
        JLabel planNum = RollbackComplete.getPlanNum(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14), taskFinishBo.getPlannedNes());
        screenPanel.add(planNum);
        this.insertComponentNotContainPositionAndDelay(frame, screenPanel, taskFinishBo);
        this.swingPageFrameManager.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setVisible(true);
    }

    private void insertComponentNotContainPositionAndDelay(WhiteJDialog jFrame, JPanel screenPanel, TaskFinishBo taskFinishBo) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel redStarOne = this.commonUtils.getRedStarLabel(50, 80, 40, 40);
        JLabel backReason = this.getBackReasonLabel(font);
        JComboBox<String> backReasonBox = this.rollbackReasonBox(font, taskFinishBo);
        screenPanel.add(redStarOne);
        screenPanel.add(backReason);
        screenPanel.add(backReasonBox);
        JLabel plan = this.getLabelPlanNum(font);
        JLabel redStarTwo = LanguageManager.isEnglish() ? this.commonUtils.getRedStarLabel(450, 130, 40, 40) : this.commonUtils.getRedStarLabel(490, 130, 40, 40);
        JLabel actual = this.getLabelActualNum(font);
        JTextField textFieldActualNum = this.getTextFieldActualNum(font);
        screenPanel.add(plan);
        screenPanel.add(redStarTwo);
        screenPanel.add(actual);
        screenPanel.add(textFieldActualNum);
        JLabel labelReasonDesc = this.getLabelReasonDesc(font);
        JTextArea textAreaReasonDesc = this.getTextAreaReasonDesc(font);
        JScrollPane currentJScrollPane = new JScrollPane(textAreaReasonDesc);
        currentJScrollPane.setBorder(BorderFactory.createLineBorder(Color.gray));
        if (LanguageManager.isEnglish()) {
            currentJScrollPane.setBounds(240, 190, 570, 100);
        } else {
            currentJScrollPane.setBounds(200, 190, 610, 100);
        }
        screenPanel.add(labelReasonDesc);
        screenPanel.add(currentJScrollPane);
        this.rollBackOperation(jFrame, screenPanel, taskFinishBo, textFieldActualNum, textAreaReasonDesc);
    }

    private void rollBackOperation(WhiteJDialog jFrame, JPanel screenPanel, TaskFinishBo taskFinishBo, JTextField textFieldActualNum, JTextArea reasonDescText) {
        JButton cancel = new JButton(this.internationalizeUtil.getResource("COMMON_CANCEL"));
        cancel.setBounds(50, 325, 80, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancel.addActionListener(e -> {
            LOGGER.info("RollbackComplete rollBackOperation cancel success.");
            this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.CANCEL.getCloseType());
            jFrame.dispose();
        });
        JButton submit = new JButton(this.internationalizeUtil.getResource("COMMON_SUBMIT"));
        submit.setBounds(160, 325, 80, 30);
        submit.setBackground(Color.WHITE);
        submit.setFocusPainted(false);
        submit.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        submit.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        screenPanel.add(cancel);
        screenPanel.add(submit);
        submit.addActionListener(e -> {
            taskFinishBo.setActualNes(textFieldActualNum.getText());
            taskFinishBo.setNote(StringUtils.equals((CharSequence)reasonDescText.getText(), (CharSequence)this.internationalizeUtil.getResource("COMMON_MAX_INPUT")) ? "" : reasonDescText.getText());
            this.clickSubmitJButton(jFrame, taskFinishBo, taskFinishBo.getInteface(), taskFinishBo.getGuid());
        });
    }

    private void addBizNetOperationRecord(String inteface, String guid, String closeType) {
        OperationRecordBo operationRecordBo = new OperationRecordBo();
        operationRecordBo.setMoudle(OperationRecordEnum.ORDER.getOperateType());
        operationRecordBo.setInteface(inteface);
        operationRecordBo.setGuid(guid);
        operationRecordBo.setCloseType(closeType);
        this.commonServiceForSdk.insertOperationRecord(operationRecordBo);
    }

    private void clickSubmitJButton(WhiteJDialog jFrame, TaskFinishBo taskFinishBo, String inteface, String guid) {
        StringBuilder errMsg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getCausaLevel1()) || StringUtils.equals((CharSequence)taskFinishBo.getCausaLevel1(), (CharSequence)this.internationalizeUtil.getResource("COMMON_SELECT"))) {
            errMsg.append(this.internationalizeUtil.getResource("BACK_REASON_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getActualNes())) {
            errMsg.append(this.internationalizeUtil.getResource("ORDER_DOT_ACTUAL_NES_TIP")).append(",");
        }
        if (!Pattern.matches("^[1-9]\\d{0,4}$", taskFinishBo.getActualNes())) {
            LOGGER.error("Enter the correct number of NEs.");
            this.commonUtils.showWarnPanel(jFrame, "", this.internationalizeUtil.getResource("COMMON_NES_ERROR"));
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            LOGGER.error("The param cannot be empty.");
            this.commonUtils.showWarnPanel(jFrame, "", errMsg.substring(0, errMsg.length() - 1) + this.internationalizeUtil.getResource("COMMON_ENTER_EMPTY"));
        } else {
            Result result = null;
            if (StringUtils.isNotEmpty((CharSequence)String.valueOf(taskFinishBo.isCrt())) && taskFinishBo.isCrt()) {
                TaskDotFinishBo taskDotFinishBo = new TaskDotFinishBo();
                BeanUtils.copyProperties((Object)taskFinishBo, (Object)taskDotFinishBo);
                result = this.taskServiceSwingService.setTaskFinish(taskDotFinishBo);
            } else {
                TaskFinishPointVo taskFinishPointVo = new TaskFinishPointVo();
                BeanUtils.copyProperties((Object)taskFinishBo, (Object)taskFinishPointVo);
                taskFinishPointVo.setDotType("1");
                result = this.taskCompleteSwingService.reportFinishPoint(taskFinishPointVo);
            }
            if (result.containsKey("code") && "0".equals(result.get("code"))) {
                LOGGER.info("RollbackComplete clickSubmitJButton success.");
                this.commonUtils.showWarnPanel(jFrame, "", this.internationalizeUtil.getResource("ORDER_DOT_FINISH"));
                this.addBizNetOperationRecord(inteface, guid, CloseTypeEnum.COMPLETE.getCloseType());
                jFrame.dispose();
            } else {
                LOGGER.info("RollbackComplete clickSubmitJButton error.");
                this.commonUtils.showWarnPanel(jFrame, "", result.get("message").toString());
            }
        }
    }

    public void rollbackNotContainPosition(TaskFinishBo taskFinishBo) {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 886, 490);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        screenPanel = this.swingPageFrameManager.getScreenPanel(frame);
        frameJScrollPane = new DefaultJScrollPane(jScrollPane);
        this.getTotalTitle(screenPanel);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel planNum = RollbackComplete.getPlanNum(font, taskFinishBo.getPlannedNes());
        screenPanel.add(planNum);
        JLabel redStarLabelThree = this.commonUtils.getRedStarLabel(50, 310, 40, 40);
        JLabel delay = this.getLabelDelay(font);
        JComboBox<String> delayBox = this.rollbackDelayBox(font);
        screenPanel.add(redStarLabelThree);
        screenPanel.add(delay);
        screenPanel.add(delayBox);
        CardLayout cardLayout = new CardLayout();
        WhitePanel jPanel = new WhitePanel();
        jPanel.setBounds(0, 360, 886, 600);
        jPanel.setLayout(cardLayout);
        screenPanel.add(jPanel);
        ArrayList<JPanel> panelList = new ArrayList<JPanel>();
        this.insertComponentNotContainPosition(frame, screenPanel, taskFinishBo, panelList, jPanel);
        this.rollBackTaskFinish(taskFinishBo, frame, delayBox, jPanel, panelList);
        frameJScrollPane.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setVisible(true);
    }

    private void rollBackTaskFinish(TaskFinishBo taskFinishBo, WhiteJDialog frame, JComboBox<String> delayBox, WhitePanel jPanel, List<JPanel> panelList) {
        delayBox.addItemListener(e -> {
            String text = null;
            if (e.getStateChange() == 1) {
                text = (String)delayBox.getSelectedItem();
                delayBox.setBackground(Color.WHITE);
                delayBox.setFocusable(false);
            }
            if (StringUtils.isNotEmpty(text) && text.equals(this.internationalizeUtil.getResource("COMMON_OPERATION_OTHER_REASON"))) {
                frame.setSize(886, 590);
                frameJScrollPane.refreshTabScroll(frame, screenPanel);
                jPanel.remove((java.awt.Component)panelList.get(0));
                jPanel.add((java.awt.Component)panelList.get(1));
                jPanel.revalidate();
                jPanel.repaint();
            } else {
                frame.setSize(886, 470);
                frameJScrollPane.refreshTabScroll(frame, screenPanel);
                jPanel.remove((java.awt.Component)panelList.get(1));
                jPanel.add((java.awt.Component)panelList.get(0));
                jPanel.revalidate();
                jPanel.repaint();
            }
            if (StringUtils.isEmpty((CharSequence)text) || StringUtils.equals((CharSequence)text, (CharSequence)this.internationalizeUtil.getResource("COMMON_SELECT"))) {
                taskFinishBo.setCauseNotimely(text);
            } else {
                taskFinishBo.setCauseNotimely(OperateDelayReasonEnum.getOperateDelayReasonCodeByCn(text));
            }
        });
    }

    private void insertComponentNotContainPosition(WhiteJDialog jFrame, JPanel screenPanel, TaskFinishBo taskFinishBo, List<JPanel> panelList, WhitePanel jPanel) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel backReasonRedStar = this.commonUtils.getRedStarLabel(50, 80, 40, 40);
        JLabel backReason = this.getBackReasonLabel(font);
        JComboBox<String> backReasonBox = this.rollbackReasonBox(font, taskFinishBo);
        screenPanel.add(backReasonRedStar);
        screenPanel.add(backReason);
        screenPanel.add(backReasonBox);
        JLabel plan = this.getLabelPlanNum(font);
        JLabel actualNumRedStar = LanguageManager.isEnglish() ? this.commonUtils.getRedStarLabel(450, 130, 40, 40) : this.commonUtils.getRedStarLabel(490, 130, 40, 40);
        JLabel actual = this.getLabelActualNum(font);
        JTextField textFieldActualNum = this.getTextFieldActualNum(font);
        screenPanel.add(plan);
        screenPanel.add(actualNumRedStar);
        screenPanel.add(actual);
        screenPanel.add(textFieldActualNum);
        JLabel reasonDesc = this.getLabelReasonDesc(font);
        JTextArea reasonDescText = this.getTextAreaReasonDesc(font);
        JScrollPane scroll = new JScrollPane(reasonDescText);
        scroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        if (LanguageManager.isEnglish()) {
            scroll.setBounds(240, 190, 570, 100);
        } else {
            scroll.setBounds(200, 190, 610, 100);
        }
        screenPanel.add(reasonDesc);
        screenPanel.add(scroll);
        JPanel notRemark = this.getNotRemark(panelList, jFrame, textFieldActualNum, reasonDescText, taskFinishBo);
        jPanel.add(notRemark);
        JPanel remark = this.getRemark(panelList, jFrame, textFieldActualNum, reasonDescText, taskFinishBo);
        jPanel.add(remark);
    }

    private JPanel getNotRemark(List<JPanel> panelList, WhiteJDialog whiteJFrame, JTextField textFieldActualNum, JTextArea reasonDescText, TaskFinishBo taskFinishBo) {
        WhitePanel whitePanel = new WhitePanel();
        whitePanel.setLayout(null);
        whitePanel.setBounds(50, 0, 886, 400);
        JButton cancelJButton = new JButton(this.internationalizeUtil.getResource("COMMON_CANCEL"));
        cancelJButton.setBounds(50, 10, 80, 30);
        cancelJButton.setBackground(Color.white);
        cancelJButton.setFocusPainted(false);
        cancelJButton.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancelJButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancelJButton.addActionListener(e -> {
            LOGGER.info("RollbackComplete getNotRemark cancel success.");
            this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.CANCEL.getCloseType());
            whiteJFrame.dispose();
        });
        JButton submit = new JButton(this.internationalizeUtil.getResource("COMMON_SUBMIT"));
        submit.setBounds(160, 10, 80, 30);
        submit.setBackground(Color.WHITE);
        submit.setFocusPainted(false);
        submit.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        submit.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        submit.addActionListener(e -> {
            taskFinishBo.setActualNes(textFieldActualNum.getText());
            taskFinishBo.setNote(StringUtils.equals((CharSequence)reasonDescText.getText(), (CharSequence)this.internationalizeUtil.getResource("COMMON_MAX_INPUT")) ? "" : reasonDescText.getText());
            String notRemark = this.getErrMsg(taskFinishBo, "notRemark");
            if (StringUtils.isNotEmpty((CharSequence)notRemark)) {
                LOGGER.error("The getNotRemark param cannot be empty.");
                this.commonUtils.showWarnPanel(whiteJFrame, "", notRemark + this.internationalizeUtil.getResource("COMMON_REMARKS_ONE"));
                return;
            }
            this.finishTask(whiteJFrame, taskFinishBo);
        });
        whitePanel.add(cancelJButton);
        whitePanel.add(submit);
        panelList.add(whitePanel);
        return whitePanel;
    }

    private void finishTask(WhiteJDialog whiteJFrame, TaskFinishBo taskFinishBo) {
        TaskDotFinishBo taskDotFinishBo = new TaskDotFinishBo();
        BeanUtils.copyProperties((Object)taskFinishBo, (Object)taskDotFinishBo);
        Result result = this.taskServiceSwingService.setTaskFinish(taskDotFinishBo);
        if (result.containsKey("code") && "0".equals(result.get("code"))) {
            LOGGER.info("RollbackComplete finishTask success.");
            this.commonUtils.showWarnPanel(whiteJFrame, "", this.internationalizeUtil.getResource("ORDER_DOT_FINISH"));
            this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.COMPLETE.getCloseType());
            whiteJFrame.dispose();
        } else {
            LOGGER.error("RollbackComplete finishTask error.");
            this.commonUtils.showWarnPanel(whiteJFrame, "", result.get("message").toString());
        }
    }

    private String getErrMsg(TaskFinishBo taskFinishBo, String isRemark) {
        StringBuilder errMsg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getCausaLevel1()) || StringUtils.isEmpty((CharSequence)taskFinishBo.getCausaLevel1())) {
            errMsg.append(this.internationalizeUtil.getResource("BACK_REASON_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getActualNes())) {
            errMsg.append(this.internationalizeUtil.getResource("ORDER_DOT_ACTUAL_NES_TIP")).append(",");
        }
        if (!Pattern.matches("^[1-9]\\d{0,4}$", taskFinishBo.getActualNes())) {
            return this.internationalizeUtil.getResource("COMMON_NES_ERROR");
        }
        if (StringUtils.isEmpty((CharSequence)taskFinishBo.getCauseNotimely()) || StringUtils.equals((CharSequence)taskFinishBo.getCauseNotimely(), (CharSequence)this.internationalizeUtil.getResource("COMMON_SELECT"))) {
            errMsg.append(this.internationalizeUtil.getResource("COMMON_OPERATION_DELAY_REASON")).append(",");
        }
        if (StringUtils.equals((CharSequence)"remark", (CharSequence)isRemark) && StringUtils.isEmpty((CharSequence)taskFinishBo.getCauseRemark())) {
            errMsg.append(this.internationalizeUtil.getResource("COMMON_REMARKS_ONE")).append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            return errMsg.substring(0, errMsg.length() - 1);
        }
        return errMsg.toString();
    }

    private JPanel getRemark(List<JPanel> panelList, WhiteJDialog whiteJFrame, JTextField textFieldActualNum, JTextArea reasonDescText, TaskFinishBo taskFinishBo) {
        WhitePanel whitePanel = new WhitePanel();
        whitePanel.setLayout(null);
        whitePanel.setBounds(50, 0, 886, 400);
        JTextArea textAreaRemark = this.getTextAreaRemark(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        this.drawRemark(whitePanel, textAreaRemark);
        JButton cancel = new JButton(this.internationalizeUtil.getResource("COMMON_CANCEL"));
        cancel.setBounds(50, 130, 80, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancel.addActionListener(e -> {
            this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.CANCEL.getCloseType());
            whiteJFrame.dispose();
        });
        JButton submit = new JButton(this.internationalizeUtil.getResource("COMMON_SUBMIT"));
        submit.setBounds(160, 130, 80, 30);
        submit.setBackground(Color.WHITE);
        submit.setFocusPainted(false);
        submit.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        submit.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        submit.addActionListener(e -> {
            taskFinishBo.setActualNes(textFieldActualNum.getText());
            taskFinishBo.setNote(StringUtils.equals((CharSequence)reasonDescText.getText(), (CharSequence)this.internationalizeUtil.getResource("COMMON_MAX_INPUT")) ? "" : reasonDescText.getText());
            taskFinishBo.setCauseRemark(StringUtils.equals((CharSequence)textAreaRemark.getText(), (CharSequence)this.internationalizeUtil.getResource("COMMON_MAX_INPUT")) ? "" : textAreaRemark.getText());
            String remarkMsg = this.getErrMsg(taskFinishBo, "remark");
            if (StringUtils.isNotEmpty((CharSequence)remarkMsg)) {
                LOGGER.error("The getRemark param cannot be empty.");
                this.commonUtils.showWarnPanel(whiteJFrame, "", remarkMsg + this.internationalizeUtil.getResource("COMMON_ENTER_EMPTY"));
                return;
            }
            this.finishTask(whiteJFrame, taskFinishBo);
        });
        whitePanel.add(cancel);
        whitePanel.add(submit);
        panelList.add(whitePanel);
        return whitePanel;
    }

    private void drawRemark(WhitePanel whitePanel, JTextArea textAreaRemark) {
        JLabel redStarFour = this.commonUtils.getRedStarLabel(50, 0, 40, 40);
        JLabel remark = this.getLabelRemark(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        JScrollPane scroll = new JScrollPane(textAreaRemark);
        scroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        if (LanguageManager.isEnglish()) {
            scroll.setBounds(240, 10, 570, 100);
        } else {
            scroll.setBounds(200, 10, 610, 100);
        }
        whitePanel.add(redStarFour);
        whitePanel.add(remark);
        whitePanel.add(scroll);
    }

    private JLabel getBackReasonLabel(Font font) {
        JLabel backReasonLabel = new JLabel(this.internationalizeUtil.getResource("BACK_REASON_TIP"));
        backReasonLabel.setBounds(60, 80, 500, 40);
        backReasonLabel.setFont(font);
        return backReasonLabel;
    }

    private JLabel getLabelPlanNum(Font font) {
        JLabel planNum = new JLabel(this.internationalizeUtil.getResource("ORDER_DOT_PLANNED_NES"));
        planNum.setBounds(50, 130, 500, 40);
        planNum.setFont(font);
        return planNum;
    }

    private static JLabel getPlanNum(Font font, String num) {
        JLabel planNum = new JLabel(num);
        if (LanguageManager.isEnglish()) {
            planNum.setBounds(240, 130, 20, 40);
        } else {
            planNum.setBounds(200, 130, 20, 40);
        }
        planNum.setFont(font);
        return planNum;
    }

    private JLabel getLabelActualNum(Font font) {
        JLabel actual = new JLabel(this.internationalizeUtil.getResource("ORDER_DOT_ACTUAL_NES"));
        if (LanguageManager.isEnglish()) {
            actual.setBounds(460, 130, 500, 40);
        } else {
            actual.setBounds(500, 130, 500, 40);
        }
        actual.setFont(font);
        return actual;
    }

    private JLabel getLabelReasonDesc(Font font) {
        JLabel reasonDesc = new JLabel(this.internationalizeUtil.getResource("ORDER_BACK_DESCRIPTION"));
        reasonDesc.setBounds(50, 180, 200, 40);
        reasonDesc.setFont(font);
        return reasonDesc;
    }

    private JLabel getLabelDelay(Font font) {
        JLabel delay = new JLabel(this.internationalizeUtil.getResource("ORDER_BACK_DELAY_REASON"));
        delay.setBounds(60, 310, 200, 40);
        delay.setFont(font);
        return delay;
    }

    private JLabel getLabelRemark(Font font) {
        JLabel remark = new JLabel(this.internationalizeUtil.getResource("COMMON_REMARKS_ONE"));
        remark.setBounds(60, 0, 200, 40);
        remark.setFont(font);
        return remark;
    }

    private JTextArea getTextAreaReasonDesc(Font font) {
        JTextArea textAreaReasonDesc = new JTextArea();
        textAreaReasonDesc.setBounds(200, 190, 610, 100);
        textAreaReasonDesc.setLineWrap(true);
        textAreaReasonDesc.setFont(font);
        textAreaReasonDesc.setDocument(new TextAreaDocument(2000, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        textAreaReasonDesc.addFocusListener(new JTextAreaHintListener(textAreaReasonDesc, this.internationalizeUtil.getResource("COMMON_MAX_INPUT"), Color.GRAY));
        return textAreaReasonDesc;
    }

    private JTextArea getTextAreaRemark(Font font) {
        JTextArea textAreaRemark = new JTextArea();
        textAreaRemark.setBounds(200, 10, 610, 100);
        textAreaRemark.setLineWrap(true);
        textAreaRemark.setFont(font);
        textAreaRemark.setDocument(new TextAreaDocument(2000, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        textAreaRemark.addFocusListener(new JTextAreaHintListener(textAreaRemark, this.internationalizeUtil.getResource("COMMON_MAX_INPUT"), Color.GRAY));
        return textAreaRemark;
    }

    private JTextField getTextFieldActualNum(Font font) {
        JTextField jTextField = new JTextField();
        jTextField.setBounds(650, 135, 85, 30);
        jTextField.setFont(font);
        this.commonUtils.checkActualNum(jTextField);
        return jTextField;
    }

    private JComboBox<String> rollbackReasonBox(Font font, TaskFinishBo taskFinishBo) {
        JComboBox<String> backComboBox = new JComboBox<String>();
        backComboBox.addItem(this.internationalizeUtil.getResource("COMMON_SELECT"));
        backComboBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_ONE"));
        backComboBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_TWO"));
        backComboBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_THREE"));
        backComboBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_FOUR"));
        backComboBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_FIVE"));
        backComboBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_SIX"));
        backComboBox.addItem(this.internationalizeUtil.getResource("ORDER_BACK_REASON_SEVEN"));
        backComboBox.setBounds(200, 85, 610, 30);
        backComboBox.setBackground(Color.white);
        backComboBox.setFont(font);
        backComboBox.addItemListener(e -> {
            String text = null;
            if (e.getStateChange() == 1) {
                text = (String)backComboBox.getSelectedItem();
                backComboBox.setBackground(Color.WHITE);
                backComboBox.setFocusable(false);
            }
            if (StringUtils.isEmpty(text) || StringUtils.equals((CharSequence)text, (CharSequence)this.internationalizeUtil.getResource("COMMON_SELECT"))) {
                taskFinishBo.setCausaLevel1(text);
            } else {
                String rollBackReasonCode = RollBackReasonEnum.getRollBackReasonCodeByCn(text);
                taskFinishBo.setCausaLevel1(rollBackReasonCode);
            }
        });
        return backComboBox;
    }

    private JComboBox<String> rollbackDelayBox(Font font) {
        JComboBox<String> delay = new JComboBox<String>();
        delay.addItem(this.internationalizeUtil.getResource("COMMON_SELECT"));
        delay.addItem(this.internationalizeUtil.getResource("ORDER_BACK_DELAY_REASON_ONE"));
        delay.addItem(this.internationalizeUtil.getResource("ORDER_BACK_DELAY_REASON_TWO"));
        delay.addItem(this.internationalizeUtil.getResource("ORDER_BACK_DELAY_REASON_THREE"));
        delay.addItem(this.internationalizeUtil.getResource("COMMON_OPERATION_OTHER_REASON"));
        if (LanguageManager.isEnglish()) {
            delay.setBounds(205, 315, 610, 30);
        } else {
            delay.setBounds(200, 315, 610, 30);
        }
        delay.setBackground(Color.white);
        delay.setFont(font);
        return delay;
    }

    private void getTotalTitle(JPanel screenPanel) {
        WhitePanel whitePanel = new WhitePanel();
        whitePanel.setBounds(0, 10, 886, 65);
        whitePanel.setLayout(null);
        JLabel rollLabel = new JLabel(this.internationalizeUtil.getResource("ORDER_BACK_COMPLETE"), 2);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        rollLabel.setFont(font);
        rollLabel.setBounds(45, 0, 800, 50);
        whitePanel.add(rollLabel);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 54, 886, 5);
        whitePanel.add(separatorLine);
        screenPanel.add((java.awt.Component)whitePanel, 0);
    }
}

