/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.bo.OperationRecordBo;
import com.huawei.netcareinsidesdk.bo.TaskDotFinishBo;
import com.huawei.netcareinsidesdk.bo.TaskFinishBo;
import com.huawei.netcareinsidesdk.constants.CloseTypeEnum;
import com.huawei.netcareinsidesdk.constants.OperateDelayReasonEnum;
import com.huawei.netcareinsidesdk.constants.OperationRecordEnum;
import com.huawei.netcareinsidesdk.service.common.CommonServiceForSdk;
import com.huawei.netcareinsidesdk.swing.component.TextAreaDocument;
import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.constants.RollBackReasonEnum;
import com.huawei.netcareinsidesdk.swing.listener.JTextAreaHintListener;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.style.DefaultJScrollPane;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.ImageUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskCompleteSwingService;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.LanguageManager;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskFinishPointVo;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RollbackCompletePosition {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollbackCompletePosition.class);
    @Autowired
    private TaskServiceSwingService taskServiceSwingService;
    @Autowired
    private TaskCompleteSwingService taskCompleteSwingService;
    @Autowired
    private CommonServiceForSdk commonServiceForSdk;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    private static JScrollPane jScrollPane;
    private static JPanel screenPanel;
    private static DefaultJScrollPane frameJScrollPane;
    @Autowired
    private InternationalizeUtil internationalize;
    @Autowired
    private CommonUtils commonUtils;

    public void rollbackNotContainDelay(TaskFinishBo taskFinishBo) {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 886, 480);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        screenPanel = this.swingPageFrameManager.getScreenPanel(frame);
        this.getTotalTitle(screenPanel);
        JLabel num = RollbackCompletePosition.getPlanNum(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14), taskFinishBo.getPlannedNes());
        screenPanel.add(num);
        this.insertComponentNotContainDelay(frame, screenPanel, taskFinishBo);
        this.swingPageFrameManager.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setVisible(true);
    }

    private void insertComponentNotContainDelay(WhiteJDialog frame, JPanel screenPanel, TaskFinishBo taskFinishBo) {
        JLabel planRedStar;
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        this.getComponentParams(screenPanel, taskFinishBo, font);
        JLabel planNum = this.getLabelPlanNum(font);
        JLabel reasonDesc = this.getLabelReasonDesc(font);
        JTextArea reasonDescText = this.getTextAreaReasonDesc(font);
        JScrollPane scroll = new JScrollPane(reasonDescText);
        JLabel actual = this.getLabelActualNum(font);
        JTextField actualNum = this.getTextFieldActualNum(font);
        scroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        if (LanguageManager.isEnglish()) {
            planRedStar = this.commonUtils.getRedStarLabel(460, 180, 40, 40);
            scroll.setBounds(240, 240, 570, 100);
        } else {
            planRedStar = this.commonUtils.getRedStarLabel(500, 180, 40, 40);
            scroll.setBounds(200, 240, 610, 100);
        }
        screenPanel.add(planNum);
        screenPanel.add(planRedStar);
        screenPanel.add(actual);
        screenPanel.add(actualNum);
        screenPanel.add(reasonDesc);
        screenPanel.add(scroll);
        JButton cancel = new JButton(this.internationalize.getResource("COMMON_CANCEL"));
        WhiteJDialog finalFrame = this.drawConcell(frame, taskFinishBo, cancel);
        JButton submit = new JButton(this.internationalize.getResource("COMMON_SUBMIT"));
        submit.setBounds(160, 370, 80, 30);
        submit.setBackground(Color.WHITE);
        submit.setFocusPainted(false);
        submit.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        submit.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        screenPanel.add(cancel);
        screenPanel.add(submit);
        submit.addActionListener(e -> {
            taskFinishBo.setActualNes(actualNum.getText());
            taskFinishBo.setNote(StringUtils.equals((CharSequence)reasonDescText.getText(), (CharSequence)this.internationalize.getResource("COMMON_MAX_INPUT")) ? "" : reasonDescText.getText());
            this.backSubmit(taskFinishBo, finalFrame);
        });
    }

    private WhiteJDialog drawConcell(WhiteJDialog frame, TaskFinishBo taskFinishBo, JButton cancel) {
        cancel.setBounds(50, 370, 80, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        WhiteJDialog finalFrame = frame;
        cancel.addActionListener(e -> {
            LOGGER.info("RollbackCompletePosition drawConcell cancel success.");
            this.addBizNetOperationRecord(taskFinishBo.getInteface(), taskFinishBo.getGuid(), CloseTypeEnum.CANCEL.getCloseType());
            finalFrame.dispose();
        });
        return finalFrame;
    }

    private void addBizNetOperationRecord(String inteface, String guid, String closeType) {
        OperationRecordBo operationRecordBo = new OperationRecordBo();
        operationRecordBo.setMoudle(OperationRecordEnum.ORDER.getOperateType());
        operationRecordBo.setInteface(inteface);
        operationRecordBo.setGuid(guid);
        operationRecordBo.setCloseType(closeType);
        this.commonServiceForSdk.insertOperationRecord(operationRecordBo);
    }

    private void backSubmit(TaskFinishBo finishBo, WhiteJDialog finalFrame) {
        Result result = null;
        StringBuilder submitErrMsg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)finishBo.getCausaLevel1()) || StringUtils.equals((CharSequence)finishBo.getCausaLevel1(), (CharSequence)this.internationalize.getResource("COMMON_SELECT"))) {
            submitErrMsg.append(this.internationalize.getResource("BACK_REASON_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)finishBo.getAllowance())) {
            submitErrMsg.append(this.internationalize.getResource("ORDER_APPLY_NES_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)finishBo.getActualNes())) {
            submitErrMsg.append(this.internationalize.getResource("ORDER_DOT_ACTUAL_NES_TIP")).append(",");
        }
        if (!Pattern.matches("^[1-9]\\d{0,4}$", finishBo.getActualNes())) {
            this.commonUtils.showWarnPanel(finalFrame, "", this.internationalize.getResource("COMMON_NES_ERROR"));
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)submitErrMsg)) {
            LOGGER.error("The backSubmit param cannot be empty.");
            this.commonUtils.showWarnPanel(finalFrame, "", submitErrMsg.substring(0, submitErrMsg.length() - 1) + this.internationalize.getResource("COMMON_ENTER_EMPTY"));
        } else {
            if (StringUtils.isNotEmpty((CharSequence)String.valueOf(finishBo.isCrt())) && finishBo.isCrt()) {
                TaskDotFinishBo taskDotFinishBo = new TaskDotFinishBo();
                BeanUtils.copyProperties((Object)finishBo, (Object)taskDotFinishBo);
                result = this.taskServiceSwingService.setTaskFinish(taskDotFinishBo);
            } else {
                TaskFinishPointVo taskFinishVo = new TaskFinishPointVo();
                taskFinishVo.setDotType("1");
                BeanUtils.copyProperties((Object)finishBo, (Object)taskFinishVo);
                result = this.taskCompleteSwingService.reportFinishPoint(taskFinishVo);
            }
            if (result.containsKey("code") && "0".equals(result.get("code"))) {
                LOGGER.info("RollbackCompletePosition backSubmit success.");
                this.commonUtils.showWarnPanel(finalFrame, "", this.internationalize.getResource("ORDER_DOT_FINISH"));
                this.addBizNetOperationRecord(finishBo.getInteface(), finishBo.getGuid(), CloseTypeEnum.CANCEL.getCloseType());
                finalFrame.dispose();
            } else {
                LOGGER.info("RollbackCompletePosition backSubmit error.");
                this.commonUtils.showWarnPanel(finalFrame, "", result.get("message").toString());
            }
        }
    }

    private void getComponentParams(JPanel screenPanel, TaskFinishBo taskFinishBo, Font font) {
        JLabel redStarLabelOne = this.commonUtils.getRedStarLabel(50, 80, 40, 40);
        JLabel backReason = this.getLabelBackReason(font);
        JComboBox<String> backReasonBox = this.rollbackReasonBox(font, taskFinishBo);
        screenPanel.add(redStarLabelOne);
        screenPanel.add(backReason);
        screenPanel.add(backReasonBox);
        JLabel redStarLabelTwo = this.commonUtils.getRedStarLabel(50, 130, 40, 40);
        JLabel position = this.getLabelPosition(font);
        this.getJRadioButtonPosition(font, screenPanel, taskFinishBo);
        screenPanel.add(redStarLabelTwo);
        screenPanel.add(position);
    }

    public void rollbackContainPositionAndDelay(TaskFinishBo finishBo) {
        WhiteJDialog frame = new WhiteJDialog(ToolMainFrameManager.getInstance().getCurMainFrame(), "NetCare Inside", Dialog.ModalityType.DOCUMENT_MODAL, 886, 540);
        frame.setLocationRelativeTo(null);
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        screenPanel = this.swingPageFrameManager.getScreenPanel(frame);
        this.getTotalTitle(screenPanel);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        JLabel num = RollbackCompletePosition.getPlanNum(font, finishBo.getPlannedNes());
        screenPanel.add(num);
        JLabel redStarLabelFive = this.commonUtils.getRedStarLabel(50, 350, 40, 40);
        JLabel delay = this.getLabelDelay(font);
        JComboBox<String> delayBox = this.rollbackDelayBox(font);
        screenPanel.add(redStarLabelFive);
        screenPanel.add(delay);
        screenPanel.add(delayBox);
        CardLayout cardLayout = new CardLayout();
        WhitePanel jPanel = new WhitePanel();
        jPanel.setBounds(0, 400, 886, 600);
        jPanel.setLayout(cardLayout);
        screenPanel.add(jPanel);
        ArrayList<JPanel> panelList = new ArrayList<JPanel>();
        this.insertComponentContainPositionAndDelay(frame, screenPanel, finishBo, jPanel, panelList);
        this.drawRollbackCompletePosition(finishBo, frame, delayBox, jPanel, panelList);
        frameJScrollPane = new DefaultJScrollPane(jScrollPane);
        frameJScrollPane.addMainFrameScroll(frame, screenPanel);
        frame.setAlwaysOnTop(false);
        frame.setVisible(true);
    }

    private void drawRollbackCompletePosition(TaskFinishBo finishBo, WhiteJDialog frame, JComboBox<String> delayBox, WhitePanel jPanel, List<JPanel> panelList) {
        delayBox.addItemListener(e -> {
            String text = null;
            if (e.getStateChange() == 1) {
                text = (String)delayBox.getSelectedItem();
                delayBox.setBackground(Color.WHITE);
                delayBox.setFocusable(false);
            }
            if (StringUtils.isNotEmpty(text) && text.equals(this.internationalize.getResource("COMMON_OPERATION_OTHER_REASON"))) {
                frame.setSize(886, 620);
                frameJScrollPane.refreshTabScroll(frame, screenPanel);
                jPanel.remove((java.awt.Component)panelList.get(0));
                jPanel.add((java.awt.Component)panelList.get(1));
                jPanel.revalidate();
                jPanel.repaint();
            } else {
                frame.setSize(886, 500);
                frameJScrollPane.refreshTabScroll(frame, screenPanel);
                jPanel.remove((java.awt.Component)panelList.get(1));
                jPanel.add((java.awt.Component)panelList.get(0));
                jPanel.revalidate();
                jPanel.repaint();
            }
            if (StringUtils.isEmpty((CharSequence)text) || StringUtils.equals((CharSequence)text, (CharSequence)this.internationalize.getResource("COMMON_SELECT"))) {
                finishBo.setCauseNotimely(text);
            } else {
                finishBo.setCauseNotimely(OperateDelayReasonEnum.getOperateDelayReasonCodeByCn(text));
            }
        });
    }

    private void insertComponentContainPositionAndDelay(WhiteJDialog frame, JPanel screenPanel, TaskFinishBo taskFinishBo, WhitePanel jPanel, List<JPanel> panelList) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        this.getComponentParams(screenPanel, taskFinishBo, font);
        JLabel planNum = this.getLabelPlanNum(font);
        JLabel redStarLabelThree = LanguageManager.isEnglish() ? this.commonUtils.getRedStarLabel(460, 180, 40, 40) : this.commonUtils.getRedStarLabel(500, 180, 40, 40);
        JLabel actual = this.getLabelActualNum(font);
        JTextField textFieldActualNum = this.getTextFieldActualNum(font);
        screenPanel.add(planNum);
        screenPanel.add(redStarLabelThree);
        screenPanel.add(actual);
        screenPanel.add(textFieldActualNum);
        JLabel reasonDesc = this.getLabelReasonDesc(font);
        JTextArea areaReasonDesc = this.getTextAreaReasonDesc(font);
        JScrollPane scrollPane = new JScrollPane(areaReasonDesc);
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.gray));
        if (LanguageManager.isEnglish()) {
            scrollPane.setBounds(240, 240, 570, 100);
        } else {
            scrollPane.setBounds(200, 240, 610, 100);
        }
        screenPanel.add(reasonDesc);
        screenPanel.add(scrollPane);
        JPanel notRemark = this.getNotRemark(panelList, frame, textFieldActualNum, areaReasonDesc, taskFinishBo);
        jPanel.add(notRemark);
        JPanel remark = this.getRemark(panelList, frame, textFieldActualNum, areaReasonDesc, taskFinishBo);
        jPanel.add(remark);
    }

    private JPanel getNotRemark(List<JPanel> panelList, WhiteJDialog frame, JTextField textFieldActualNum, JTextArea reasonDescText, TaskFinishBo taskFinishBo) {
        WhitePanel jPanel = new WhitePanel();
        jPanel.setLayout(null);
        jPanel.setBounds(50, 0, 886, 400);
        JButton cancel = new JButton(this.internationalize.getResource("COMMON_CANCEL"));
        cancel.setBounds(50, 10, 80, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancel.addActionListener(e -> {
            LOGGER.info("RollbackCompletePosition getNotRemark cancel success.");
            frame.dispose();
        });
        JButton submit = new JButton(this.internationalize.getResource("COMMON_SUBMIT"));
        submit.setBounds(160, 10, 80, 30);
        submit.setBackground(Color.WHITE);
        submit.setFocusPainted(false);
        submit.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        submit.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        submit.addActionListener(e -> {
            taskFinishBo.setActualNes(textFieldActualNum.getText());
            taskFinishBo.setNote(StringUtils.equals((CharSequence)reasonDescText.getText(), (CharSequence)this.internationalize.getResource("COMMON_MAX_INPUT")) ? "" : reasonDescText.getText());
            String notRemarkMsg = this.getErrMsg(taskFinishBo, "notRemark");
            if (StringUtils.isNotEmpty((CharSequence)notRemarkMsg)) {
                LOGGER.error("The getNotRemark param cannot be empty.");
                this.commonUtils.showWarnPanel(frame, "", notRemarkMsg + this.internationalize.getResource("COMMON_ENTER_EMPTY"));
                return;
            }
            TaskDotFinishBo taskDotFinishBo = new TaskDotFinishBo();
            BeanUtils.copyProperties((Object)taskFinishBo, (Object)taskDotFinishBo);
            Result result = this.taskServiceSwingService.setTaskFinish(taskDotFinishBo);
            if (result.containsKey("code") && "0".equals(result.get("code"))) {
                LOGGER.info("RollbackCompletePosition getNotRemark submit success.");
                this.commonUtils.showWarnPanel(frame, "", this.internationalize.getResource("ORDER_DOT_FINISH"));
                frame.dispose();
            } else {
                LOGGER.error("RollbackCompletePosition getNotRemark submit error.");
                this.commonUtils.showWarnPanel(frame, "", result.get("message").toString());
            }
        });
        jPanel.add(cancel);
        jPanel.add(submit);
        panelList.add(jPanel);
        return jPanel;
    }

    private JPanel getRemark(List<JPanel> panelList, WhiteJDialog frame, JTextField textFieldActualNum, JTextArea reasonDescText, TaskFinishBo finishBo) {
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14);
        WhitePanel whiteJPanel = new WhitePanel();
        whiteJPanel.setLayout(null);
        whiteJPanel.setBounds(50, 0, 886, 400);
        JLabel redStarLabelFour = this.commonUtils.getRedStarLabel(50, 0, 40, 40);
        JLabel remark = this.getLabelRemark(font);
        JTextArea textAreaRemark = this.getTextAreaRemark(font);
        JScrollPane scroll = new JScrollPane(textAreaRemark);
        scroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        scroll.setBounds(200, 10, 610, 100);
        whiteJPanel.add(redStarLabelFour);
        whiteJPanel.add(remark);
        whiteJPanel.add(scroll);
        JButton cancel = new JButton(this.internationalize.getResource("COMMON_CANCEL"));
        cancel.setBounds(50, 130, 80, 30);
        cancel.setBackground(Color.white);
        cancel.setFocusPainted(false);
        cancel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        cancel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        cancel.addActionListener(e -> {
            LOGGER.info("RollbackCompletePosition getRemark cancel success.");
            frame.dispose();
        });
        JButton submit = new JButton(this.internationalize.getResource("COMMON_SUBMIT"));
        submit.setBounds(160, 130, 80, 30);
        submit.setBackground(Color.WHITE);
        submit.setFocusPainted(false);
        submit.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12));
        submit.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        submit.addActionListener(e -> {
            finishBo.setActualNes(textFieldActualNum.getText());
            finishBo.setNote(StringUtils.equals((CharSequence)reasonDescText.getText(), (CharSequence)this.internationalize.getResource("COMMON_MAX_INPUT")) ? "" : reasonDescText.getText());
            finishBo.setCauseRemark(StringUtils.equals((CharSequence)textAreaRemark.getText(), (CharSequence)this.internationalize.getResource("COMMON_MAX_INPUT")) ? "" : textAreaRemark.getText());
            this.clickSubmitJButton(frame, finishBo);
        });
        whiteJPanel.add(cancel);
        whiteJPanel.add(submit);
        panelList.add(whiteJPanel);
        return whiteJPanel;
    }

    private void clickSubmitJButton(WhiteJDialog frame, TaskFinishBo finishBo) {
        String remarkMsg = this.getErrMsg(finishBo, "remark");
        if (StringUtils.isNotEmpty((CharSequence)remarkMsg)) {
            LOGGER.error("The clickSubmitJButton param cannot be empty.");
            this.commonUtils.showWarnPanel(frame, "", remarkMsg + this.internationalize.getResource("COMMON_ENTER_EMPTY"));
            return;
        }
        TaskDotFinishBo taskDotFinishBo = new TaskDotFinishBo();
        BeanUtils.copyProperties((Object)finishBo, (Object)taskDotFinishBo);
        Result result = this.taskServiceSwingService.setTaskFinish(taskDotFinishBo);
        if (result.containsKey("code") && "0".equals(result.get("code"))) {
            LOGGER.info("RollbackCompletePosition clickSubmitJButton submit success.");
            this.commonUtils.showWarnPanel(frame, "", this.internationalize.getResource("ORDER_DOT_FINISH"));
            frame.dispose();
        } else {
            LOGGER.error("RollbackCompletePosition clickSubmitJButton submit error.");
            this.commonUtils.showWarnPanel(frame, "", result.get("message").toString());
        }
    }

    private String getErrMsg(TaskFinishBo finishBo, String isRemark) {
        StringBuilder errMsg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)finishBo.getCausaLevel1()) || StringUtils.equals((CharSequence)finishBo.getCausaLevel1(), (CharSequence)this.internationalize.getResource("COMMON_SELECT"))) {
            errMsg.append(this.internationalize.getResource("BACK_REASON_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)finishBo.getAllowance())) {
            errMsg.append(this.internationalize.getResource("ORDER_APPLY_NES_TIP")).append(",");
        }
        if (StringUtils.isEmpty((CharSequence)finishBo.getActualNes())) {
            errMsg.append(this.internationalize.getResource("ORDER_DOT_ACTUAL_NES_TIP")).append(",");
        }
        if (!Pattern.matches("^[1-9]\\d{0,4}$", finishBo.getActualNes())) {
            return this.internationalize.getResource("COMMON_NES_ERROR");
        }
        if (StringUtils.isEmpty((CharSequence)finishBo.getCauseNotimely()) || StringUtils.equals((CharSequence)finishBo.getCauseNotimely(), (CharSequence)this.internationalize.getResource("COMMON_SELECT"))) {
            errMsg.append(this.internationalize.getResource("COMMON_OPERATION_DELAY_REASON")).append(",");
        }
        if (StringUtils.equals((CharSequence)"remark", (CharSequence)isRemark) && StringUtils.isEmpty((CharSequence)finishBo.getCauseRemark())) {
            errMsg.append(this.internationalize.getResource("COMMON_REMARKS_ONE")).append(",");
        }
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            return errMsg.substring(0, errMsg.length() - 1);
        }
        return errMsg.toString();
    }

    private JLabel getLabelBackReason(Font font) {
        JLabel backReason = new JLabel(this.internationalize.getResource("BACK_REASON_TIP"));
        backReason.setBounds(60, 80, 500, 40);
        backReason.setFont(font);
        return backReason;
    }

    private JLabel getLabelPlanNum(Font font) {
        JLabel plan = new JLabel(this.internationalize.getResource("ORDER_DOT_PLANNED_NES"));
        plan.setBounds(50, 180, 500, 40);
        plan.setFont(font);
        return plan;
    }

    private static JLabel getPlanNum(Font font, String num) {
        JLabel planNum = new JLabel(num);
        if (LanguageManager.isEnglish()) {
            planNum.setBounds(240, 180, 20, 40);
        } else {
            planNum.setBounds(200, 180, 20, 40);
        }
        planNum.setFont(font);
        return planNum;
    }

    private JLabel getLabelActualNum(Font font) {
        JLabel actual = new JLabel(this.internationalize.getResource("ORDER_DOT_ACTUAL_NES"));
        if (LanguageManager.isEnglish()) {
            actual.setBounds(470, 180, 500, 40);
        } else {
            actual.setBounds(510, 180, 500, 40);
        }
        actual.setFont(font);
        return actual;
    }

    private JLabel getLabelReasonDesc(Font font) {
        JLabel reasonDesc = new JLabel(this.internationalize.getResource("ORDER_BACK_DESCRIPTION"));
        reasonDesc.setBounds(50, 230, 200, 40);
        reasonDesc.setFont(font);
        return reasonDesc;
    }

    private JLabel getLabelPosition(Font font) {
        JLabel position = new JLabel(this.internationalize.getResource("ORDER_BACK_APPLY_NES"));
        position.setBounds(60, 130, 500, 40);
        position.setFont(font);
        return position;
    }

    private JLabel getLabelDelay(Font font) {
        JLabel delay = new JLabel(this.internationalize.getResource("ORDER_BACK_DELAY_REASON"));
        delay.setBounds(60, 350, 200, 40);
        delay.setFont(font);
        return delay;
    }

    private JLabel getLabelRemark(Font font) {
        JLabel remark = new JLabel(this.internationalize.getResource("COMMON_REMARKS_ONE"));
        remark.setBounds(60, 0, 200, 40);
        remark.setFont(font);
        return remark;
    }

    private void getJRadioButtonPosition(Font font, JPanel screenPanel, TaskFinishBo taskFinishBo) {
        JRadioButton apply = new JRadioButton(this.internationalize.getResource("COMMON_APPLY"));
        JRadioButton notApply = new JRadioButton(this.internationalize.getResource("COMMON_NO_APPLY"));
        if (LanguageManager.isEnglish()) {
            apply.setBounds(280, 130, 70, 40);
            notApply.setBounds(380, 130, 90, 40);
        } else {
            apply.setBounds(200, 130, 70, 40);
            notApply.setBounds(300, 130, 90, 40);
        }
        apply.setBackground(Color.white);
        apply.setFocusPainted(false);
        apply.setFont(font);
        notApply.setBackground(Color.white);
        notApply.setFocusPainted(false);
        notApply.setFont(font);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(apply);
        buttonGroup.add(notApply);
        screenPanel.add(apply);
        screenPanel.add(notApply);
        apply.addActionListener(e -> taskFinishBo.setAllowance("1"));
        notApply.addActionListener(e -> taskFinishBo.setAllowance("0"));
    }

    private JTextArea getTextAreaReasonDesc(Font font) {
        JTextArea textAreaDesc = new JTextArea();
        textAreaDesc.setBounds(200, 240, 610, 100);
        textAreaDesc.setLineWrap(true);
        textAreaDesc.setFont(font);
        textAreaDesc.setDocument(new TextAreaDocument(2000, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        textAreaDesc.addFocusListener(new JTextAreaHintListener(textAreaDesc, this.internationalize.getResource("COMMON_MAX_INPUT"), Color.GRAY));
        return textAreaDesc;
    }

    private JTextArea getTextAreaRemark(Font font) {
        JTextArea areaRemark = new JTextArea();
        if (LanguageManager.isEnglish()) {
            areaRemark.setBounds(240, 10, 570, 100);
        } else {
            areaRemark.setBounds(200, 10, 610, 100);
        }
        areaRemark.setLineWrap(true);
        areaRemark.setFont(font);
        areaRemark.setDocument(new TextAreaDocument(2000, "^[^\\u4e00-\\u9fa5A-Za-z0-9\u3002.,\uff0c\\-;\uff1b()\uff08\uff09\\u0020]+$"));
        areaRemark.addFocusListener(new JTextAreaHintListener(areaRemark, this.internationalize.getResource("COMMON_MAX_INPUT"), Color.GRAY));
        return areaRemark;
    }

    private JTextField getTextFieldActualNum(Font font) {
        JTextField jTextField = new JTextField();
        jTextField.setBounds(650, 185, 85, 30);
        jTextField.setFont(font);
        this.commonUtils.checkActualNum(jTextField);
        return jTextField;
    }

    private JComboBox<String> rollbackReasonBox(Font font, TaskFinishBo taskFinishBo) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.internationalize.getResource("COMMON_SELECT"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_REASON_ONE"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_REASON_TWO"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_REASON_THREE"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_REASON_FOUR"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_REASON_FIVE"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_REASON_SIX"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_REASON_SEVEN"));
        jComboBox.setBounds(200, 85, 610, 30);
        jComboBox.setBackground(Color.white);
        jComboBox.setFont(font);
        jComboBox.addItemListener(e -> {
            String rollBackText = null;
            if (e.getStateChange() == 1) {
                rollBackText = (String)jComboBox.getSelectedItem();
                jComboBox.setBackground(Color.WHITE);
                jComboBox.setFocusable(false);
            }
            if (StringUtils.isEmpty(rollBackText) || StringUtils.equals((CharSequence)rollBackText, (CharSequence)this.internationalize.getResource("COMMON_SELECT"))) {
                taskFinishBo.setCausaLevel1(rollBackText);
            } else {
                taskFinishBo.setCausaLevel1(RollBackReasonEnum.getRollBackReasonCodeByCn(rollBackText));
            }
        });
        return jComboBox;
    }

    private JComboBox<String> rollbackDelayBox(Font font) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.internationalize.getResource("COMMON_SELECT"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_DELAY_REASON_ONE"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_DELAY_REASON_TWO"));
        jComboBox.addItem(this.internationalize.getResource("ORDER_BACK_DELAY_REASON_THREE"));
        jComboBox.addItem(this.internationalize.getResource("COMMON_OPERATION_OTHER_REASON"));
        if (LanguageManager.isEnglish()) {
            jComboBox.setBounds(205, 360, 610, 30);
        } else {
            jComboBox.setBounds(200, 360, 610, 30);
        }
        jComboBox.setBackground(Color.white);
        jComboBox.setFont(font);
        return jComboBox;
    }

    private void getTotalTitle(JPanel screenPanel) {
        WhitePanel panel = new WhitePanel();
        panel.setBounds(0, 10, 886, 65);
        panel.setLayout(null);
        JLabel label = new JLabel(this.internationalize.getResource("ORDER_BACK_COMPLETE"), 2);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        label.setFont(font);
        label.setBounds(45, 0, 800, 50);
        panel.add(label);
        JLabel separatorLine = new JLabel(ImageUtils.generateImage("line.png"));
        separatorLine.setBounds(0, 54, 886, 5);
        panel.add(separatorLine);
        screenPanel.add((java.awt.Component)panel, 0);
    }
}

