/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.pageService;

import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.component.WhitePanel;
import com.huawei.netcareinsidesdk.swing.pageService.SwingPageFrameManager;
import com.huawei.netcareinsidesdk.swing.style.DefaultTableTips;
import com.huawei.netcareinsidesdk.swing.style.SelectWorkOrderJTable;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.swing.utils.LabelsUtils;
import com.huawei.netcareinsidesdk.swingservice.TaskServiceSwingService;
import com.huawei.netcareinsidesdk.swingservice.WorkOrderSelectSwingService;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.Result;
import com.huawei.netcareinsidesdk.utils.ToolMainFrameManager;
import com.huawei.netcareinsidesdk.vo.TaskInfoQueryListVo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Component
public class WorkOrderSelectPage {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkOrderSelectPage.class);
    @Autowired
    private LabelsUtils labelsUtils;
    @Autowired
    private WorkOrderSelectSwingService swingService;
    @Autowired
    private TaskServiceSwingService taskServiceSwingService;
    @Autowired
    private SwingPageFrameManager swingPageFrameManager;
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonUtils commonUtils;

    public void selectWorkOrder(List<Integer> taskTypes) {
        List<TaskInfoQueryListVo> tasks = this.taskServiceSwingService.getTaskList(taskTypes);
        this.drawWorkOrderSelect(tasks);
    }

    private void drawWorkOrderSelect(List<TaskInfoQueryListVo> taskInfoVos) {
        this.swingPageFrameManager.closeAllPage();
        SelectWorkOrderJTable.setTaskId("");
        WhiteJDialog selectWorkOrderPage = this.swingPageFrameManager.getSelectWorkOrderPageFrame(ToolMainFrameManager.getInstance().getCurMainFrame());
        JPanel screenPanel = this.swingPageFrameManager.getScreenPanel(selectWorkOrderPage);
        this.drawTitleData(selectWorkOrderPage, screenPanel, this.internationalizeUtil.getResource("ORDER_SELECT_TITLE"));
        this.drawData(screenPanel, taskInfoVos);
        this.drawButtonData(selectWorkOrderPage, screenPanel);
        this.swingPageFrameManager.addMainFrameScroll(selectWorkOrderPage, screenPanel);
        selectWorkOrderPage.setAlwaysOnTop(false);
        selectWorkOrderPage.setVisible(true);
    }

    private void drawButtonData(WhiteJDialog frame, JPanel screenPanel) {
        WhitePanel drawButtonPanel = this.labelsUtils.initWhitePanel(35, 285, 100, 40, null);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
        Rectangle rectangle = new Rectangle(0, 0, 78, 30);
        JButton jButton = this.labelsUtils.getButton(font, this.internationalizeUtil.getResource("COMMON_CONFIRM"), rectangle, Color.WHITE);
        drawButtonPanel.add(jButton);
        jButton.addActionListener(e -> {
            String taskId = SelectWorkOrderJTable.getTaskId();
            if (e.getActionCommand().equals(this.internationalizeUtil.getResource("COMMON_CONFIRM")) && StringUtils.isNotBlank((CharSequence)taskId)) {
                Result result = this.swingService.setCurTask(taskId);
                String code = result.get("code").toString();
                if (Integer.parseInt(code) != 0) {
                    LOGGER.error("order select failed.");
                    this.commonUtils.showWarnPanel(frame, "", result.get("message").toString());
                }
                LOGGER.info("order select success.");
                frame.dispose();
            } else {
                this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("ORDER_SELECT_EXECUTED_ORDER"));
            }
        });
        screenPanel.add(drawButtonPanel);
    }

    private void drawData(JPanel screenPanel, List<TaskInfoQueryListVo> taskInfoVos) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(this.internationalizeUtil.getResource("COMMON_SELECT_TITLE"));
        model.addColumn(this.internationalizeUtil.getResource("ORDER_ID"));
        model.addColumn(this.internationalizeUtil.getResource("ORDER_STATUS"));
        model.addColumn(this.internationalizeUtil.getResource("ORDER_NAME"));
        model.addColumn(this.internationalizeUtil.getResource("ORDER_TYPE"));
        model.addColumn(this.internationalizeUtil.getResource("EXECUTOR"));
        model.addColumn(this.internationalizeUtil.getResource("ORDER_START_TIME"));
        model.addColumn(this.internationalizeUtil.getResource("ORDER_END_TIME"));
        for (TaskInfoQueryListVo taskInfo : taskInfoVos) {
            model.addRow(new Object[]{false, taskInfo.getTaskId(), taskInfo.getTaskStatusName(), taskInfo.getTaskName(), taskInfo.getTaskTypeName(), taskInfo.getTaskExecutorName(), format.format(taskInfo.getTaskStartTime()), format.format(taskInfo.getTaskEndTime())});
        }
        JPanel orderList = this.queryWorkOrderList(model);
        screenPanel.add(orderList);
    }

    private JPanel queryWorkOrderList(DefaultTableModel model) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBounds(35, 90, 1153, 185);
        SelectWorkOrderJTable table = new SelectWorkOrderJTable();
        table.setModel(model);
        int[] length = new int[]{75, 173, 92, 183, 131, 183, 156, 156};
        this.setTableStyle(table, panel, length);
        table.getTableHeader().setReorderingAllowed(false);
        return panel;
    }

    private void setTableStyle(JTable table, JPanel panel, int[] length) {
        table.getSelectionModel().setSelectionMode(0);
        DefaultTableCellRenderer tableText = new DefaultTableCellRenderer();
        tableText.setHorizontalAlignment(0);
        table.setDefaultRenderer(Object.class, tableText);
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 14));
        tableHeader.setPreferredSize(new Dimension(tableHeader.getWidth(), 45));
        table.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        table.addMouseMotionListener(new DefaultTableTips(table, new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7))));
        table.setRowHeight(35);
        if (length != null) {
            TableColumnModel model0 = table.getColumnModel();
            for (int i = 0; i < model0.getColumnCount(); ++i) {
                TableColumn column = model0.getColumn(i);
                column.setPreferredWidth(length[i]);
            }
        }
        JScrollPane jScrollPane = new JScrollPane(table);
        jScrollPane.setVisible(true);
        jScrollPane.setVerticalScrollBarPolicy(20);
        panel.add((Component)table.getTableHeader(), "North");
        panel.add(jScrollPane);
    }

    private void drawTitleData(WhiteJDialog whiteJFrame, JPanel screenPanel, String titleName) {
        WhitePanel tableTitlePanel = this.labelsUtils.initWhitePanel(0, 0, whiteJFrame.getWidth(), 85, null);
        Rectangle rectangle = new Rectangle(30, 30, 30, 30);
        JLabel jLabel = this.labelsUtils.getJLabelImage("warn_img.png", rectangle, null, null);
        screenPanel.add(jLabel);
        rectangle.setBounds(70, 30, 300, 30);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20);
        JLabel jLabel1 = this.labelsUtils.getJLabel(font, titleName, rectangle, null, null);
        tableTitlePanel.add(jLabel1);
        JSeparator jSeparator = this.labelsUtils.getJSeparator(tableTitlePanel.getWidth(), 80);
        jSeparator.setForeground(new Color(231, 227, 227));
        tableTitlePanel.add(jSeparator);
        screenPanel.add(tableTitlePanel);
    }
}

