/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.style;

import com.huawei.netcareinsidesdk.swing.style.HtmlMultiLineRender;
import com.huawei.netcareinsidesdk.utils.JsonParseUtils;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;

public class DefaultTableTips
extends MouseAdapter {
    private JTable table;
    private List<Integer> columns;

    public DefaultTableTips(JTable table, List<Integer> columns) {
        this.table = table;
        this.columns = columns;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        int row = this.table.rowAtPoint(event.getPoint());
        int col = this.table.columnAtPoint(event.getPoint());
        boolean isSpecificColumn = false;
        for (int column : this.columns) {
            if (column != col) continue;
            isSpecificColumn = true;
            String value = this.table.getValueAt(row, col) == null ? "" : String.valueOf(this.table.getValueAt(row, col));
            boolean isNotNullValue = StringUtils.isNotBlank((CharSequence)value);
            if (row <= -1 || !isSpecificColumn || !isNotNullValue) continue;
            this.table.setToolTipText(this.getColumnTips(value));
        }
    }

    private String getColumnTips(String columnValue) {
        HtmlMultiLineRender htmlMultiLineRender = new HtmlMultiLineRender();
        List<String> temp = JsonParseUtils.usingSubstringMethod(columnValue, 80);
        StringBuilder stringBuild = new StringBuilder();
        for (int i = 0; i < temp.size(); ++i) {
            if (i != 0) {
                stringBuild.append("<br>");
            }
            stringBuild.append(temp.get(i));
        }
        return htmlMultiLineRender.covertDestionString(stringBuild.toString());
    }
}

