/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.netcareinsidesdk.swing.utils;

import com.huawei.netcareinsidesdk.swing.component.WhiteJDialog;
import com.huawei.netcareinsidesdk.swing.utils.CommonUtils;
import com.huawei.netcareinsidesdk.utils.InternationalizeUtil;
import com.huawei.netcareinsidesdk.utils.ZipUtils;
import java.io.File;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Component
public class FileCheckUtils {
    @Autowired
    private InternationalizeUtil internationalizeUtil;
    @Autowired
    private CommonUtils commonUtils;

    public Boolean checkFile(File selectedFile, WhiteJDialog frame) {
        String fileName = selectedFile.getName();
        if (!fileName.startsWith("offlineTask")) {
            this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("PACKAGE_IMPORT_TIP"));
            return false;
        }
        if (!fileName.endsWith("zip")) {
            this.commonUtils.showWarnPanel(frame, "", this.internationalizeUtil.getResource("FILE_TYPE"));
            return false;
        }
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(ZipUtils.createFileItem(selectedFile));
        long size = multipartFile.getSize();
        if (size > 0xA00000L) {
            String msg = this.internationalizeUtil.getResource("FILE_SIZE", Collections.singletonList(selectedFile.getName().substring(0, selectedFile.getName().length() - 4)));
            this.commonUtils.showWarnPanel(frame, "", msg);
            return false;
        }
        return true;
    }
}

